(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Wolfram 14.3' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       154,          7]
NotebookDataLength[   1473408,      28417]
NotebookOptionsPosition[   1441804,      27989]
NotebookOutlinePosition[   1442197,      28005]
CellTagsIndexPosition[   1442154,      28002]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell[BoxData[
 RowBox[{"<<", "VilTeX`"}]], "Input",
 CellChangeTimes->{{3.966968271457609*^9, 3.9669682779533978`*^9}},
 CellLabel->"In[18]:=",ExpressionUUID->"8649fc87-1c15-4bf9-9237-6c8c3a8bdb46"],

Cell[CellGroupData[{

Cell[BoxData[
 TagBox[GridBox[{
    {
     StyleBox["\<\"\|01f680 VilTeX cargado\"\>",
      StripOnInput->False,
      LineColor->RGBColor[0, 0, 1],
      FrontFaceColor->RGBColor[0, 0, 1],
      BackFaceColor->RGBColor[0, 0, 1],
      GraphicsColor->RGBColor[0, 0, 1],
      FontSize->16,
      FontWeight->Bold,
      FontColor->RGBColor[0, 0, 1]]},
    {
     StyleBox["\<\"\:2705 Listo para usar. Versi\[OAcute]n del \
01/10/2025.\"\>",
      StripOnInput->False,
      LineColor->GrayLevel[0],
      FrontFaceColor->GrayLevel[0],
      BackFaceColor->GrayLevel[0],
      GraphicsColor->GrayLevel[0],
      FontWeight->Bold,
      FontColor->GrayLevel[0]]}
   },
   DefaultBaseStyle->"Column",
   GridBoxAlignment->{"Columns" -> {{Left}}},
   GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
  "Column"]], "Print",
 CellChangeTimes->{3.9669682799375896`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[18]:=",ExpressionUUID->"7d0edf85-1056-4aa1-b368-607416d6ea5a"],

Cell[BoxData["\<\"Mostrando editores ya detectados...\"\>"], "Print",
 CellChangeTimes->{3.9669683052359133`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[18]:=",ExpressionUUID->"b8e35550-cdea-4e31-9f99-b818ea674802"],

Cell[BoxData["\<\"=== EDITORES LaTeX DETECTADOS ===\"\>"], "Print",
 CellChangeTimes->{3.966968305236465*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[18]:=",ExpressionUUID->"df26fdb4-de1b-48a3-8590-c57c483ca3b5"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"\[Checkmark] \"\>", "\[InvisibleSpace]", "\<\"TeXShop\"\>", 
   "\[InvisibleSpace]", "\<\" \[RightArrow] \"\>", 
   "\[InvisibleSpace]", "\<\"TeXShop\"\>"}],
  SequenceForm["\[Checkmark] ", "TeXShop", " \[RightArrow] ", "TeXShop"],
  Editable->False]], "Print",
 CellChangeTimes->{3.966968305236766*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[18]:=",ExpressionUUID->"497bbc7c-d1b6-4e6e-93fc-8bc24a7384aa"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"\[Checkmark] \"\>", "\[InvisibleSpace]", "\<\"TeXstudio\"\>", 
   "\[InvisibleSpace]", "\<\" \[RightArrow] \"\>", 
   "\[InvisibleSpace]", "\<\"texstudio-4.8.8-osx-m1\"\>"}],
  SequenceForm[
  "\[Checkmark] ", "TeXstudio", " \[RightArrow] ", "texstudio-4.8.8-osx-m1"],
  Editable->False]], "Print",
 CellChangeTimes->{3.966968305237047*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[18]:=",ExpressionUUID->"1657916b-e646-47ee-99e2-20a06aeaff31"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"\[Checkmark] \"\>", "\[InvisibleSpace]", "\<\"Texifier\"\>", 
   "\[InvisibleSpace]", "\<\" \[RightArrow] \"\>", 
   "\[InvisibleSpace]", "\<\"Texifier\"\>"}],
  SequenceForm["\[Checkmark] ", "Texifier", " \[RightArrow] ", "Texifier"],
  Editable->False]], "Print",
 CellChangeTimes->{3.966968305237317*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[18]:=",ExpressionUUID->"691ea00b-fe6f-4abf-afb2-7f17cfb8b400"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"\[Checkmark] \"\>", "\[InvisibleSpace]", "\<\"LaTeXiT\"\>", 
   "\[InvisibleSpace]", "\<\" \[RightArrow] \"\>", 
   "\[InvisibleSpace]", "\<\"LaTeXiT\"\>"}],
  SequenceForm["\[Checkmark] ", "LaTeXiT", " \[RightArrow] ", "LaTeXiT"],
  Editable->False]], "Print",
 CellChangeTimes->{3.966968305237576*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[18]:=",ExpressionUUID->"fd650dd2-ff86-4d41-a8e1-5b5b02980ff0"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["13. ExportContour2DToTikZ", "Subtitle",
 CellChangeTimes->{{3.964711967446312*^9, 3.9647120331966953`*^9}, {
   3.965828746741377*^9, 3.965828772379876*^9}, {3.966422117997758*^9, 
   3.966422160573628*^9}, {3.9664222257197533`*^9, 3.966422232684371*^9}, 
   3.9664306609167547`*^9, {3.966529948809907*^9, 3.966529956215705*^9}, {
   3.966531029355278*^9, 3.9665310324940443`*^9}},
 Background->RGBColor[
  0.4, 0.6, 1, 0.33],ExpressionUUID->"e620c90a-a47e-4279-8a06-c63909917048"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"?", "ExportContour2DToTikZ"}]], "Input",
 CellChangeTimes->{{3.9675372979547977`*^9, 3.9675373029895287`*^9}},
 CellLabel->"In[3]:=",ExpressionUUID->"b56a2495-e5bc-de40-81a5-bea435140357"],

Cell[BoxData[
 InterpretationBox[
  StyleBox[
   FrameBox[
    DynamicModuleBox[{System`InformationDump`open$$ = False, 
     System`InformationDump`mouseOver$$ = False}, 
     PaneSelectorBox[{True->
      TagBox[GridBox[{
         {
          ItemBox[
           PaneBox[
            StyleBox[
             TagBox[
              TooltipBox[
               StyleBox["\<\" Symbol\"\>", "InformationRowLabel",
                StripOnInput->False],
               "\"Symbol\"",
               TooltipStyle->"TextStyling"],
              Annotation[#, "Symbol", "Tooltip"]& ], "InformationTitleText",
             StripOnInput->False,
             BaseStyle -> None],
            FrameMargins->{{4, 0}, {-1, 1}}],
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False], 
          ItemBox["\<\"\"\>",
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False]},
         {
          ItemBox[
           PaneBox[
            
            StyleBox["\<\"ExportContour2DToTikZ[argumentos, archivo] exporta \
gr\[AAcute]ficos matem\[AAcute]ticos 2D a formato LaTeX/TikZ como archivo \
.tex compilable.\\nExportContour2DToTikZ[argumentos, archivo, rejilla] \
especifica si mostrar l\[IAcute]neas de \
rejilla.\\nExportContour2DToTikZ[argumentos, archivo, rejilla, estilos] \
define estilos de l\[IAcute]nea y colores para cada \
gr\[AAcute]fico.\\nExportContour2DToTikZ[argumentos, archivo, rejilla, \
estilos, ejes] controla la visualizaci\[OAcute]n de ejes \
coordenados.\\nExportContour2DToTikZ[argumentos, archivo, rejilla, estilos, \
ejes, texto] a\[NTilde]ade anotaciones de texto al \
gr\[AAcute]fico.\\nExportContour2DToTikZ[argumentos, archivo, rejilla, \
estilos, ejes, texto, muestras] controla el n\[UAcute]mero de puntos de \
muestreo.\\nExportContour2DToTikZ[argumentos, archivo, rejilla, estilos, \
ejes, texto, muestras, tolerancia] ajusta la precisi\[OAcute]n \
num\[EAcute]rica.\\nExportContour2DToTikZ[argumentos, archivo, rejilla, \
estilos, ejes, texto, muestras, tolerancia, opacidadRelleno] controla \
transparencia de regiones.\\nExportContour2DToTikZ[argumentos, archivo, \
rejilla, estilos, ejes, texto, muestras, tolerancia, opacidadRelleno, \
densidad] ajusta densidad de puntos.\\nExportContour2DToTikZ[argumentos, \
archivo, rejilla, estilos, ejes, texto, muestras, tolerancia, \
opacidadRelleno, densidad, xmin, xmax, ymin, ymax] especifica l\[IAcute]mites \
de ejes.\\n\\nARGUMENTOS (plotArgs):\\n\[Bullet] CURVAS \
IMPL\[CapitalIAcute]CITAS: Ecuaciones con == \\n  - C\[IAcute]rculos: x^2 + \
y^2 == r^2\\n  - Elipses: x^2/a^2 + y^2/b^2 == 1\\n  - Hip\[EAcute]rbolas: \
x^2/a^2 - y^2/b^2 == 1\\n  - Par\[AAcute]bolas: y == x^2 o x == y^2\\n  - \
Funciones: Sin[x] == y, Log[x] == y\\n\\n\[Bullet] REGIONES DE DESIGUALDAD: \
Expresiones con <=, >=, <, >, &&, ||\\n  - Discos: x^2 + y^2 <= r^2\\n  - \
Primer cuadrante: x >= 0 && y >= 0\\n  - Franjas: -1 <= x <= 1 && y >= 0\\n  \
- Anillos: r1^2 <= x^2 + y^2 <= r2^2\\n\\n\[Bullet] FUNCIONES EXPL\
\[CapitalIAcute]CITAS: Formato {funci\[OAcute]n, {variable, m\[IAcute]n, m\
\[AAcute]x}}\\n  - Par\[AAcute]bolas: {x^2, {x, -3, 3}}\\n  - Trigonom\
\[EAcute]tricas: {Sin[x], {x, 0, 2*Pi}}\\n  - Exponenciales: {Exp[x], {x, -2, \
2}}\\n  - Logar\[IAcute]tmicas: {Log[x], {x, 0.1, 5}}\\n\\n\[Bullet] CURVAS \
PARAM\[CapitalEAcute]TRICAS: Formato {{x[t], y[t]}, {t, m\[IAcute]n, m\
\[AAcute]x}}\\n  - C\[IAcute]rculos: {{Cos[t], Sin[t]}, {t, 0, 2*Pi}}\\n  - \
Elipses: {{a*Cos[t], b*Sin[t]}, {t, 0, 2*Pi}}\\n  - Espirales: {{t*Cos[t], \
t*Sin[t]}, {t, 0, 4*Pi}}\\n  - Cicloides: {{t - Sin[t], 1 - Cos[t]}, {t, 0, \
4*Pi}}\\n\\n\[Bullet] CONJUNTOS DE PUNTOS: Lista de coordenadas {{x1, y1}, \
{x2, y2}, ...}\\n  - Puntos individuales: {{0, 0}, {1, 1}, {-1, 2}}\\n\\n\
\[Bullet] M\[CapitalUAcute]LTIPLES GR\[CapitalAAcute]FICOS: Lista combinando \
cualquier formato anterior\\n  - {x^2 + y^2 == 4, x^2 + y^2 <= 1, {x^2, {x, \
-2, 2}}}\\n\\nPAR\[CapitalAAcute]METROS OBLIGATORIOS:\\narchivo (filename) - \
String terminado en \\\".tex\\\"\\n  - Ejemplos: \\\"mi_grafico.tex\\\", \
\\\"curvas.tex\\\", \\\"analisis.tex\\\"\\n\\nPAR\[CapitalAAcute]METROS \
OPCIONALES:\\nrejilla (grid) - Boolean, por defecto: True\\n  - True: Muestra \
rejilla mayor en el gr\[AAcute]fico\\n  - False: Sin rejilla\\n\\nestilos \
(styles) - Lista de estilos, por defecto: {}\\n  - Formato: {{\\\"tipo_l\
\[IAcute]nea\\\", \\\"color\\\"}, {\\\"tipo_l\[IAcute]nea\\\", \
\\\"color\\\"}, ...}\\n  - TIPOS DE L\[CapitalIAcute]NEA: \\\"solid\\\" \
(continua), \\\"dashed\\\" (discontinua), \\\"dotted\\\" (punteada), \
\\\"dashdotted\\\" (raya-punto), \\\"thick\\\" (gruesa), \\\"thin\\\" \
(delgada)\\n  - COLORES: \\\"blue\\\" (azul), \\\"red\\\" (rojo), \
\\\"green!70!black\\\" (verde oscuro), \\\"orange\\\" (naranja), \\\"purple\\\
\" (p\[UAcute]rpura), \\\"brown\\\" (caf\[EAcute]), \\\"pink\\\" (rosa), \
\\\"gray\\\" (gris), \\\"cyan\\\" (cian), \\\"magenta\\\" (magenta)\\n  - \
Ejemplo: {{\\\"solid\\\", \\\"blue\\\"}, {\\\"dashed\\\", \\\"red\\\"}, \
{\\\"thick\\\", \\\"green!70!black\\\"}}\\n\\nejes (ejes) - Boolean, por \
defecto: True\\n  - True: Muestra ejes coordenados con flechas\\n  - False: \
Sin ejes\\n\\ntexto (texto) - Lista de anotaciones, por defecto: {}\\n  - \
Formato: {{\\\"texto\\\", {x, y}, {{\\\"opci\[OAcute]n\\\", \\\"valor\\\"}, \
...}}, ...}\\n  - OPCIONES DE TEXTO:\\n    * {\\\"color\\\", \\\"color\\\"}: \
\\\"red\\\", \\\"blue\\\", \\\"black\\\", etc.\\n    * {\\\"size\\\", \
\\\"tama\[NTilde]o\\\"}: \\\"\\\\tiny\\\", \\\"\\\\small\\\", \
\\\"\\\\normalsize\\\", \\\"\\\\large\\\", \\\"\\\\Large\\\", \
\\\"\\\\huge\\\", \\\"\\\\Huge\\\"\\n    * {\\\"anchor\\\", \\\"anclaje\\\"}: \
\\\"north\\\" (arriba), \\\"south\\\" (abajo), \\\"east\\\" (derecha), \
\\\"west\\\" (izquierda), \\\"center\\\" (centro), \\\"north east\\\", \
\\\"south west\\\"\\n    * {\\\"rotate\\\", \\\"grados\\\"}: \\\"0\\\", \
\\\"45\\\", \\\"90\\\", \\\"-30\\\", etc.\\n  - Ejemplo: {{\\\"Origen\\\", \
{0, 0}, {{\\\"color\\\", \\\"red\\\"}, {\\\"size\\\", \\\"\\\\large\\\"}, {\\\
\"anchor\\\", \\\"north\\\"}}}}\\n\\nmuestras (samples) - Entero positivo, \
por defecto: 50\\n  - Rango recomendado: 25-200\\n  - 25: R\[AAcute]pido, \
menor calidad\\n  - 50: Balance calidad/velocidad  \\n  - 100: Alta \
calidad\\n  - 200: M\[AAcute]xima calidad, lento\\n\\ntolerancia (tolerance) \
- N\[UAcute]mero positivo, por defecto: 0.1\\n  - Para curvas \
impl\[IAcute]citas \[UAcute]nicamente\\n  - 0.01: Alta precisi\[OAcute]n, m\
\[AAcute]s lento\\n  - 0.1: Precisi\[OAcute]n est\[AAcute]ndar\\n  - 0.5: \
Baja precisi\[OAcute]n, m\[AAcute]s r\[AAcute]pido\\n\\nopacidadRelleno \
(fillOpacity) - N\[UAcute]mero entre 0 y 1, por defecto: 0.3\\n  - Para \
regiones de desigualdad \[UAcute]nicamente\\n  - 0.0: Completamente \
transparente\\n  - 0.3: Semi-transparente (recomendado)\\n  - 1.0: \
Completamente opaco\\n\\ndensidad (density) - N\[UAcute]mero positivo, por \
defecto: 1.0\\n  - Factor multiplicador de puntos\\n  - 0.5: Menor densidad, \
m\[AAcute]s r\[AAcute]pido\\n  - 1.0: Densidad est\[AAcute]ndar\\n  - 2.0: \
Mayor densidad, mejor calidad\\n  - 3.0: M\[AAcute]xima densidad (advertencia \
de tiempo)\\n\\nxmin, xmax, ymin, ymax - N\[UAcute]meros o Automatic, por \
defecto: Automatic\\n  - Automatic: L\[IAcute]mites autom\[AAcute]ticos \
basados en datos\\n  - N\[UAcute]meros: L\[IAcute]mites manuales espec\
\[IAcute]ficos\\n  - Ejemplo: xmin -> -5, xmax -> 5, ymin -> -3, ymax -> 3\\n\
\\nEJEMPLOS ESPEC\[CapitalIAcute]FICOS:\\n\[Bullet] C\[IAcute]rculo \
b\[AAcute]sico:\\n  ExportContour2DToTikZ[x^2 + y^2 == 4, \
\\\"circulo.tex\\\"]\\n\\n\[Bullet] M\[UAcute]ltiples curvas con estilos:\\n  \
ExportContour2DToTikZ[{x^2 + y^2 == 4, x^2 + y^2 == 1}, \\\"circulos.tex\\\", \
True, {{\\\"solid\\\", \\\"blue\\\"}, {\\\"dashed\\\", \\\"red\\\"}}]\\n\\n\
\[Bullet] Regi\[OAcute]n con texto:\\n  ExportContour2DToTikZ[x^2 + y^2 <= 4, \
\\\"disco.tex\\\", True, {}, True, {{\\\"Radio = 2\\\", {2, 0}, {{\\\"color\\\
\", \\\"blue\\\"}, {\\\"anchor\\\", \\\"west\\\"}}}}]\\n\\n\[Bullet] Funci\
\[OAcute]n param\[EAcute]trica detallada:\\n  \
ExportContour2DToTikZ[{{3*Cos[t], 2*Sin[t]}, {t, 0, 2*Pi}}, \
\\\"elipse.tex\\\", True, {{\\\"thick\\\", \\\"purple\\\"}}, True, {}, 100, \
0.1, 0.3, 1.5]\\n\\n\[Bullet] Configuraci\[OAcute]n completa:\\n  \
ExportContour2DToTikZ[{x^2 + y^2 == 9, x^2 + y^2 <= 4}, \\\"ejemplo.tex\\\", \
True, {{\\\"solid\\\", \\\"blue\\\"}, {\\\"solid\\\", \\\"red\\\"}}, True, {{\
\\\"Exterior\\\", {3, 0}, {{\\\"color\\\", \\\"blue\\\"}}}, \
{\\\"Interior\\\", {1.5, 0}, {{\\\"color\\\", \\\"red\\\"}}}}, 80, 0.05, 0.4, \
1.2, -4, 4, -4, 4]\\n\\nSALIDA:\\n\[Bullet] Ubicaci\[OAcute]n: \
$HomeDirectory/Downloads/nombre_sin_extension/archivo.tex\\n\[Bullet] Tipo: \
Documento LaTeX completo con pre\[AAcute]mbulo\\n\[Bullet] \
Compilaci\[OAcute]n: pdflatex archivo.tex\\n\[Bullet] Dependencias autom\
\[AAcute]ticas: tikz, pgfplots, amsmath, amssymb\\n\\nNOTAS IMPORTANTES:\\n\
\[Bullet] density > 3.0 puede causar tiempos de c\[AAcute]lculo muy largos\\n\
\[Bullet] tolerance menor significa mayor precisi\[OAcute]n pero m\[AAcute]s \
tiempo de c\[AAcute]lculo\\n\[Bullet] Para publicaciones acad\[EAcute]micas \
use samples >= 100 y density >= 1.5\\n\[Bullet] Los estilos se asignan en \
orden a cada elemento de argumentos\\n\[Bullet] El archivo generado es \
completamente independiente y compilable\"\>", "InformationUsageText",
             StripOnInput->False,
             LineSpacing->{1.5, 1.5, 3.}],
            FrameMargins->{{10, 10}, {8, 10}}],
           BaseStyle->"InformationUsageSubtitleBackground",
           StripOnInput->False], 
          ItemBox["\<\"\"\>",
           BaseStyle->"InformationUsageSubtitleBackground",
           StripOnInput->False]},
         {
          PaneBox[
           TagBox[GridBox[{
              {
               StyleBox[
                TagBox[
                 TooltipBox[
                  StyleBox["\<\" Definitions\"\>", "InformationRowLabel",
                   StripOnInput->False],
                  "\"Definitions\"",
                  TooltipStyle->"TextStyling"],
                 Annotation[#, "Definitions", "Tooltip"]& ], "DialogStyle",
                StripOnInput->False]},
              {
               TemplateBox[{"\"\[ThinSpace]\"", 
                 GridBox[{{
                    RowBox[{
                    RowBox[{"ExportContour2DToTikZ", "[", 
                    
                    RowBox[{
                    "VilTeX`Private`plotArgs_", ",", 
                    "VilTeX`Private`filename_", ",", 
                    RowBox[{"VilTeX`Private`grid_", ":", "True"}], ",", 
                    RowBox[{"VilTeX`Private`styles_", ":", 
                    RowBox[{"{", "}"}]}], ",", 
                    RowBox[{"VilTeX`Private`ejes_", ":", "True"}], ",", 
                    RowBox[{"VilTeX`Private`texto_", ":", 
                    RowBox[{"{", "}"}]}], ",", 
                    RowBox[{"VilTeX`Private`samples_", ":", "50"}], ",", 
                    RowBox[{"VilTeX`Private`tolerance_", ":", "0.1`"}], ",", 
                    RowBox[{"VilTeX`Private`fillOpacity_", ":", "0.3`"}], ",", 
                    RowBox[{"VilTeX`Private`density_", ":", "1.`"}], ",", 
                    RowBox[{"VilTeX`Private`xmin_", ":", "Automatic"}], ",", 
                    RowBox[{"VilTeX`Private`xmax_", ":", "Automatic"}], ",", 
                    RowBox[{"VilTeX`Private`ymin_", ":", "Automatic"}], ",", 
                    RowBox[{"VilTeX`Private`ymax_", ":", "Automatic"}]}], 
                    "]"}], ":=", 
                    RowBox[{"Module", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    
                    RowBox[{"VilTeX`Private`data", ",", 
                    "VilTeX`Private`tikzCode", ",", 
                    "VilTeX`Private`fullDocument", ",", 
                    "VilTeX`Private`downloadPath", ",", 
                    "VilTeX`Private`folderName", ",", 
                    "VilTeX`Private`folderPath", ",", 
                    "VilTeX`Private`formatNumber", ",", 
                    "VilTeX`Private`validNumber", ",", 
                    "VilTeX`Private`plotType", ",", "VilTeX`Private`func", 
                    ",", "VilTeX`Private`xRange", ",", 
                    "VilTeX`Private`yRange", ",", "VilTeX`Private`tRange", 
                    ",", "VilTeX`Private`paramFuncs", ",", 
                    "VilTeX`Private`curveData", ",", 
                    "VilTeX`Private`axisConfiguration", ",", 
                    "VilTeX`Private`equation", ",", 
                    "VilTeX`Private`targetValue", ",", 
                    "VilTeX`Private`effectiveSamples", ",", 
                    "VilTeX`Private`multipleGraphs", ",", 
                    "VilTeX`Private`graphList", ",", 
                    "VilTeX`Private`allPlotData", ",", 
                    "VilTeX`Private`globalLimits", ",", 
                    "VilTeX`Private`combinedTikzCode", ",", 
                    "VilTeX`Private`currentGraph", ",", 
                    "VilTeX`Private`currentPlotType", ",", 
                    "VilTeX`Private`currentData", ",", 
                    "VilTeX`Private`allLimits", ",", "VilTeX`Private`colors", 
                    ",", "VilTeX`Private`allValidData", ",", 
                    "VilTeX`Private`textTikzCode", ",", 
                    "VilTeX`Private`defaultStyles", ",", 
                    "VilTeX`Private`xLimits", ",", "VilTeX`Private`yLimits", 
                    ",", "VilTeX`Private`opacityStyle", ",", 
                    "VilTeX`Private`maxPoints", ",", 
                    "VilTeX`Private`effectiveDensity"}], "}"}], ",", 
                    RowBox[{
                    RowBox[{"Clear", "[", 
                    
                    RowBox[{"VilTeX`Private`generateImplicitCurve2D", ",", 
                    "VilTeX`Private`generateInequalityRegion", ",", 
                    "VilTeX`Private`calculateLimits", ",", 
                    "VilTeX`Private`combineGlobalLimits", ",", 
                    "VilTeX`Private`determineGraphType"}], "]"}], ";", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"!", 
                    
                    RowBox[{"StringQ", "[", "VilTeX`Private`filename", 
                    "]"}]}], ",", 
                    RowBox[{
                    
                    RowBox[{"Print", "[", 
                    "\"Error: filename debe ser un string\"", "]"}], ";", 
                    RowBox[{"Return", "[", "$Failed", "]"}], ";"}]}], "]"}], 
                    ";", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"!", 
                    RowBox[{"StringEndsQ", "[", 
                    RowBox[{"VilTeX`Private`filename", ",", "\".tex\""}], 
                    "]"}]}], ",", 
                    RowBox[{
                    
                    RowBox[{"Print", "[", 
                    "\"Error: filename debe terminar en .tex\"", "]"}], ";", 
                    RowBox[{"Return", "[", "$Failed", "]"}], ";"}]}], "]"}], 
                    ";", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"!", 
                    RowBox[{"BooleanQ", "[", "VilTeX`Private`grid", "]"}]}], 
                    ",", 
                    RowBox[{
                    
                    RowBox[{"Print", "[", 
                    "\"Error: grid debe ser True o False\"", "]"}], ";", 
                    RowBox[{"Return", "[", "$Failed", "]"}], ";"}]}], "]"}], 
                    ";", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"!", 
                    RowBox[{"BooleanQ", "[", "VilTeX`Private`ejes", "]"}]}], 
                    ",", 
                    RowBox[{
                    
                    RowBox[{"Print", "[", 
                    "\"Error: ejes debe ser True o False\"", "]"}], ";", 
                    RowBox[{"Return", "[", "$Failed", "]"}], ";"}]}], "]"}], 
                    ";", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"!", 
                    
                    RowBox[{"NumericQ", "[", "VilTeX`Private`tolerance", 
                    "]"}]}], "||", 
                    
                    RowBox[{"VilTeX`Private`tolerance", "\[LessEqual]", 
                    "0"}]}], ",", 
                    RowBox[{
                    
                    RowBox[{"Print", "[", 
                    "\"Error: tolerance debe ser un n\[UAcute]mero \
positivo\"", "]"}], ";", 
                    RowBox[{"Return", "[", "$Failed", "]"}], ";"}]}], "]"}], 
                    ";", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"!", 
                    RowBox[{"NumericQ", "[", "VilTeX`Private`fillOpacity", 
                    "]"}]}], "||", 
                    RowBox[{"VilTeX`Private`fillOpacity", "<", "0"}], "||", 
                    RowBox[{"VilTeX`Private`fillOpacity", ">", "1"}]}], ",", 
                    RowBox[{
                    
                    RowBox[{"Print", "[", 
                    "\"Error: fillOpacity debe ser un n\[UAcute]mero entre 0 \
y 1\"", "]"}], ";", 
                    RowBox[{"Return", "[", "$Failed", "]"}], ";"}]}], "]"}], 
                    ";", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"!", 
                    
                    RowBox[{"NumericQ", "[", "VilTeX`Private`density", 
                    "]"}]}], "||", 
                    RowBox[{"VilTeX`Private`density", "\[LessEqual]", "0"}]}],
                     ",", 
                    RowBox[{
                    
                    RowBox[{"Print", "[", 
                    "\"Error: density debe ser un n\[UAcute]mero positivo\"", 
                    "]"}], ";", 
                    RowBox[{"Return", "[", "$Failed", "]"}], ";"}]}], "]"}], 
                    ";", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`density", ">", "3.`"}], ",", 
                    RowBox[{
                    
                    RowBox[{"Print", "[", 
                    "\"Advertencia: density > 3.0 puede causar tiempo de c\
\[AAcute]lculo muy largo\"", "]"}], ";"}]}], "]"}], ";", 
                    RowBox[{"VilTeX`Private`effectiveDensity", "=", 
                    RowBox[{"Max", "[", 
                    RowBox[{"VilTeX`Private`density", ",", "0.1`"}], "]"}]}], 
                    ";", 
                    RowBox[{"VilTeX`Private`maxPoints", "=", 
                    RowBox[{"Floor", "[", 
                    RowBox[{"8000", " ", "VilTeX`Private`effectiveDensity"}], 
                    "]"}]}], ";", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"!", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"ListQ", "[", "VilTeX`Private`texto", "]"}], "||", 
                    RowBox[{"VilTeX`Private`texto", "===", 
                    RowBox[{"{", "}"}]}]}], ")"}]}], ",", 
                    RowBox[{
                    
                    RowBox[{"Print", "[", 
                    "\"Error: texto debe ser una lista\"", "]"}], ";", 
                    RowBox[{"Return", "[", "$Failed", "]"}], ";"}]}], "]"}], 
                    ";", 
                    RowBox[{"VilTeX`Private`multipleGraphs", "=", "False"}], 
                    ";", 
                    RowBox[{"VilTeX`Private`graphList", "=", 
                    RowBox[{"{", "}"}]}], ";", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"ListQ", "[", "VilTeX`Private`plotArgs", "]"}], 
                    "&&", 
                    RowBox[{
                    RowBox[{"Length", "[", "VilTeX`Private`plotArgs", "]"}], 
                    "\[GreaterEqual]", "2"}]}], ",", 
                    RowBox[{
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"AllTrue", "[", 
                    RowBox[{"VilTeX`Private`plotArgs", ",", 
                    RowBox[{"Function", "[", 
                    RowBox[{"VilTeX`Private`x", ",", 
                    RowBox[{
                    RowBox[{"ListQ", "[", "VilTeX`Private`x", "]"}], "||", 
                    RowBox[{
                    RowBox[{"Head", "[", "VilTeX`Private`x", "]"}], "===", 
                    "Equal"}], "||", 
                    RowBox[{
                    RowBox[{"Head", "[", "VilTeX`Private`x", "]"}], "===", 
                    "Unequal"}], "||", 
                    RowBox[{
                    RowBox[{"Head", "[", "VilTeX`Private`x", "]"}], "===", 
                    "Greater"}], "||", 
                    RowBox[{
                    RowBox[{"Head", "[", "VilTeX`Private`x", "]"}], "===", 
                    "GreaterEqual"}], "||", 
                    RowBox[{
                    RowBox[{"Head", "[", "VilTeX`Private`x", "]"}], "===", 
                    "Less"}], "||", 
                    RowBox[{
                    RowBox[{"Head", "[", "VilTeX`Private`x", "]"}], "===", 
                    "LessEqual"}], "||", 
                    RowBox[{
                    RowBox[{"Head", "[", "VilTeX`Private`x", "]"}], "===", 
                    "And"}], "||", 
                    RowBox[{
                    RowBox[{"Head", "[", "VilTeX`Private`x", "]"}], "===", 
                    "Or"}]}]}], "]"}]}], "]"}], "&&", 
                    RowBox[{
                    RowBox[{"Length", "[", "VilTeX`Private`plotArgs", "]"}], 
                    "\[GreaterEqual]", "2"}]}], ",", 
                    RowBox[{
                    RowBox[{"Module", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"VilTeX`Private`isMultiple", "=", "True"}], "}"}],
                     ",", 
                    RowBox[{
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    RowBox[{"Length", "[", "VilTeX`Private`plotArgs", "]"}], 
                    "\[Equal]", "2"}], "&&", 
                    RowBox[{"ListQ", "[", 
                    
                    RowBox[{"VilTeX`Private`plotArgs", "\[LeftDoubleBracket]",
                     "1", "\[RightDoubleBracket]"}], "]"}], "&&", 
                    RowBox[{
                    RowBox[{"Length", "[", 
                    
                    RowBox[{"VilTeX`Private`plotArgs", "\[LeftDoubleBracket]",
                     "1", "\[RightDoubleBracket]"}], "]"}], "\[Equal]", "2"}],
                     "&&", 
                    RowBox[{"MatchQ", "[", 
                    RowBox[{
                    
                    RowBox[{"VilTeX`Private`plotArgs", "\[LeftDoubleBracket]",
                     "2", "\[RightDoubleBracket]"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"_", ",", "_", ",", "_"}], "}"}]}], "]"}]}], ",", 
                    
                    RowBox[{
                    RowBox[{"VilTeX`Private`isMultiple", "=", "False"}], 
                    ";"}]}], "]"}], ";", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    RowBox[{"Length", "[", "VilTeX`Private`plotArgs", "]"}], 
                    "\[Equal]", "2"}], "&&", 
                    RowBox[{"!", 
                    RowBox[{"ListQ", "[", 
                    
                    RowBox[{"VilTeX`Private`plotArgs", "\[LeftDoubleBracket]",
                     "1", "\[RightDoubleBracket]"}], "]"}]}], "&&", 
                    RowBox[{"MatchQ", "[", 
                    RowBox[{
                    
                    RowBox[{"VilTeX`Private`plotArgs", "\[LeftDoubleBracket]",
                     "2", "\[RightDoubleBracket]"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"_", ",", "_", ",", "_"}], "}"}]}], "]"}]}], ",", 
                    
                    RowBox[{
                    RowBox[{"VilTeX`Private`isMultiple", "=", "False"}], 
                    ";"}]}], "]"}], ";", 
                    
                    RowBox[{"VilTeX`Private`multipleGraphs", "=", 
                    "VilTeX`Private`isMultiple"}], ";"}]}], "]"}], ";"}]}], 
                    "]"}], ";"}]}], "]"}], ";", 
                    RowBox[{"If", "[", 
                    RowBox[{"VilTeX`Private`multipleGraphs", ",", 
                    RowBox[{
                    
                    RowBox[{"VilTeX`Private`graphList", "=", 
                    "VilTeX`Private`plotArgs"}], ";"}], ",", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`graphList", "=", 
                    RowBox[{"{", "VilTeX`Private`plotArgs", "}"}]}], ";"}]}], 
                    "]"}], ";", 
                    RowBox[{"VilTeX`Private`axisConfiguration", "=", 
                    RowBox[{"If", "[", 
                    
                    RowBox[{"VilTeX`Private`ejes", ",", 
                    "\"axis lines=center, axis line style={->}\"", ",", 
                    "\"axis lines=none\""}], "]"}]}], ";", 
                    RowBox[{"VilTeX`Private`defaultStyles", "=", 
                    RowBox[{"{", 
                    RowBox[{"\"solid\"", ",", "\"blue\""}], "}"}]}], ";", 
                    RowBox[{"VilTeX`Private`opacityStyle", "=", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`fillOpacity", "<", "1.`"}], ",", 
                    RowBox[{"\", opacity=\"", "<>", 
                    
                    RowBox[{"ToString", "[", "VilTeX`Private`fillOpacity", 
                    "]"}], "<>", "\", fill opacity=\"", "<>", 
                    
                    RowBox[{"ToString", "[", "VilTeX`Private`fillOpacity", 
                    "]"}]}], ",", "\"\""}], "]"}]}], ";", 
                    RowBox[{"VilTeX`Private`colors", "=", 
                    RowBox[{"{", 
                    
                    RowBox[{"\"blue\"", ",", "\"red\"", ",", 
                    "\"green!70!black\"", ",", "\"orange\"", ",", 
                    "\"purple\"", ",", "\"brown\"", ",", "\"pink\"", ",", 
                    "\"gray\"", ",", "\"cyan\"", ",", "\"magenta\""}], 
                    "}"}]}], ";", 
                    RowBox[{
                    
                    RowBox[{"VilTeX`Private`formatNumber", "[", 
                    "VilTeX`Private`x_", "]"}], ":=", 
                    RowBox[{"Module", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    
                    RowBox[{"VilTeX`Private`result", ",", 
                    "VilTeX`Private`num"}], "}"}], ",", 
                    RowBox[{
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"NumericQ", "[", "VilTeX`Private`x", "]"}], ",", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`num", "=", 
                    RowBox[{"N", "[", "VilTeX`Private`x", "]"}]}], ";", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Abs", "[", "VilTeX`Private`num", "]"}], "<", 
                    FractionBox["1", 
                    SuperscriptBox["10", "10"]]}], ",", 
                    RowBox[{"VilTeX`Private`result", "=", "\"0\""}], ",", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Abs", "[", "VilTeX`Private`num", "]"}], ">", 
                    SuperscriptBox["10", "8"]}], ",", 
                    RowBox[{"VilTeX`Private`result", "=", 
                    RowBox[{"ToString", "[", 
                    RowBox[{
                    RowBox[{"Round", "[", 
                    RowBox[{"VilTeX`Private`num", ",", "1"}], "]"}], ",", 
                    "InputForm"}], "]"}]}], ",", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Abs", "[", "VilTeX`Private`num", "]"}], ">", 
                    "1000"}], ",", 
                    RowBox[{"VilTeX`Private`result", "=", 
                    RowBox[{"ToString", "[", 
                    RowBox[{
                    RowBox[{"Round", "[", 
                    RowBox[{"VilTeX`Private`num", ",", "0.1`"}], "]"}], ",", 
                    "InputForm"}], "]"}]}], ",", 
                    RowBox[{"VilTeX`Private`result", "=", 
                    RowBox[{"ToString", "[", 
                    RowBox[{
                    RowBox[{"Round", "[", 
                    RowBox[{"VilTeX`Private`num", ",", 
                    FractionBox["1", 
                    SuperscriptBox["10", "4"]]}], "]"}], ",", "InputForm"}], 
                    "]"}]}]}], "]"}]}], "]"}]}], "]"}], ";"}], ",", 
                    RowBox[{"VilTeX`Private`result", "=", "\"0\""}]}], "]"}], 
                    ";", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`multipleGraphs", "&&", 
                    RowBox[{"StringQ", "[", "VilTeX`Private`result", "]"}]}], 
                    ",", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`result", "=", 
                    RowBox[{"ToString", "[", 
                    RowBox[{
                    RowBox[{"Round", "[", 
                    RowBox[{
                    
                    RowBox[{"ToExpression", "[", "VilTeX`Private`result", 
                    "]"}], ",", "0.01`"}], "]"}], ",", "InputForm"}], "]"}]}],
                     ";"}]}], "]"}], ";", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"StringQ", "[", "VilTeX`Private`result", "]"}], 
                    ",", "VilTeX`Private`result", ",", 
                    RowBox[{"ToString", "[", "VilTeX`Private`result", "]"}]}],
                     "]"}]}]}], "]"}]}], ";", 
                    RowBox[{
                    
                    RowBox[{"VilTeX`Private`validNumber", "[", 
                    "VilTeX`Private`x_", "]"}], ":=", 
                    RowBox[{
                    RowBox[{"NumericQ", "[", "VilTeX`Private`x", "]"}], "&&", 
                    
                    RowBox[{"VilTeX`Private`x", "\[Element]", 
                    TemplateBox[{}, "Reals"]}], "&&", 
                    RowBox[{
                    RowBox[{"Abs", "[", "VilTeX`Private`x", "]"}], "<", 
                    SuperscriptBox["10", "10"]}]}]}], ";", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`generateImplicitCurve2D", "[", 
                    
                    RowBox[{"VilTeX`Private`equation_", ",", 
                    "VilTeX`Private`xRange_", ",", "VilTeX`Private`yRange_", 
                    ",", "VilTeX`Private`targetSamples_", ",", 
                    "VilTeX`Private`maxPointsLimit_", ",", 
                    "VilTeX`Private`toleranceLocal_", ",", 
                    "VilTeX`Private`densityLocal_"}], "]"}], ":=", 
                    RowBox[{"Module", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    
                    RowBox[{"VilTeX`Private`xVar", ",", "VilTeX`Private`xMin",
                     ",", "VilTeX`Private`xMax", ",", "VilTeX`Private`yVar", 
                    ",", "VilTeX`Private`yMin", ",", "VilTeX`Private`yMax", 
                    ",", "VilTeX`Private`leftSide", ",", 
                    "VilTeX`Private`rightSide", ",", 
                    "VilTeX`Private`implicitFunc", ",", 
                    "VilTeX`Private`surfPoints", ",", 
                    "VilTeX`Private`ySolutions", ",", 
                    "VilTeX`Private`xSolutions", ",", 
                    "VilTeX`Private`toleranceValue", ",", 
                    "VilTeX`Private`currentPoints", ",", 
                    "VilTeX`Private`adaptiveSamples", ",", 
                    "VilTeX`Private`xVals", ",", "VilTeX`Private`yVals", ",", 
                    "VilTeX`Private`effectiveSamples", ",", 
                    "VilTeX`Private`directPattern"}], "}"}], ",", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"{", 
                    
                    RowBox[{"VilTeX`Private`xVar", ",", "VilTeX`Private`xMin",
                     ",", "VilTeX`Private`xMax"}], "}"}], "=", 
                    "VilTeX`Private`xRange"}], ";", 
                    RowBox[{
                    RowBox[{"{", 
                    
                    RowBox[{"VilTeX`Private`yVar", ",", "VilTeX`Private`yMin",
                     ",", "VilTeX`Private`yMax"}], "}"}], "=", 
                    "VilTeX`Private`yRange"}], ";", 
                    RowBox[{"VilTeX`Private`leftSide", "=", 
                    
                    RowBox[{"VilTeX`Private`equation", "\[LeftDoubleBracket]",
                     "1", "\[RightDoubleBracket]"}]}], ";", 
                    RowBox[{"VilTeX`Private`rightSide", "=", 
                    
                    RowBox[{"VilTeX`Private`equation", "\[LeftDoubleBracket]",
                     "2", "\[RightDoubleBracket]"}]}], ";", 
                    RowBox[{"VilTeX`Private`implicitFunc", "=", 
                    
                    RowBox[{"VilTeX`Private`leftSide", "-", 
                    "VilTeX`Private`rightSide"}]}], ";", 
                    RowBox[{"VilTeX`Private`surfPoints", "=", 
                    RowBox[{"{", "}"}]}], ";", 
                    
                    RowBox[{"VilTeX`Private`toleranceValue", "=", 
                    "VilTeX`Private`toleranceLocal"}], ";", 
                    RowBox[{"VilTeX`Private`currentPoints", "=", "0"}], ";", 
                    RowBox[{"VilTeX`Private`effectiveSamples", "=", 
                    RowBox[{"Floor", "[", 
                    
                    RowBox[{"VilTeX`Private`targetSamples", " ", 
                    "VilTeX`Private`densityLocal"}], "]"}]}], ";", 
                    RowBox[{"VilTeX`Private`directPattern", "=", "False"}], 
                    ";", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    
                    RowBox[{"VilTeX`Private`leftSide", "===", 
                    "VilTeX`Private`xVar"}], "&&", 
                    RowBox[{"FreeQ", "[", 
                    
                    RowBox[{"VilTeX`Private`rightSide", ",", 
                    "VilTeX`Private`xVar"}], "]"}]}], ",", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`yVals", "=", 
                    RowBox[{"Table", "[", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`yMin", "+", 
                    FractionBox[
                    RowBox[{
                    RowBox[{"(", 
                    
                    RowBox[{"VilTeX`Private`yMax", "-", 
                    "VilTeX`Private`yMin"}], ")"}], " ", "VilTeX`Private`j"}], 
                    RowBox[{
                    RowBox[{"VilTeX`Private`effectiveSamples", " ", "2"}], 
                    "-", "1"}]]}], ",", 
                    RowBox[{"{", 
                    RowBox[{"VilTeX`Private`j", ",", "0", ",", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`effectiveSamples", " ", "2"}], 
                    "-", "1"}]}], "}"}]}], "]"}]}], ";", 
                    RowBox[{"Do", "[", 
                    RowBox[{
                    RowBox[{"Module", "[", 
                    RowBox[{
                    RowBox[{"{", "VilTeX`Private`xVal", "}"}], ",", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`xVal", "=", 
                    RowBox[{"Quiet", "[", 
                    RowBox[{"N", "[", 
                    
                    RowBox[{"VilTeX`Private`rightSide", "/.", 
                    "\[VeryThinSpace]", 
                    RowBox[{"VilTeX`Private`yVar", "\[Rule]", 
                    
                    RowBox[{"VilTeX`Private`yVals", "\[LeftDoubleBracket]", 
                    "VilTeX`Private`j", "\[RightDoubleBracket]"}]}]}], "]"}], 
                    "]"}]}], ";", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    
                    RowBox[{"VilTeX`Private`validNumber", "[", 
                    "VilTeX`Private`xVal", "]"}], "&&", 
                    
                    RowBox[{"VilTeX`Private`xMin", "\[LessEqual]", 
                    "VilTeX`Private`xVal", "\[LessEqual]", 
                    "VilTeX`Private`xMax"}], "&&", 
                    
                    RowBox[{"VilTeX`Private`currentPoints", "<", 
                    "VilTeX`Private`maxPointsLimit"}]}], ",", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`surfPoints", "=", 
                    RowBox[{"Append", "[", 
                    RowBox[{"VilTeX`Private`surfPoints", ",", 
                    RowBox[{"{", 
                    RowBox[{"VilTeX`Private`xVal", ",", 
                    
                    RowBox[{"VilTeX`Private`yVals", "\[LeftDoubleBracket]", 
                    "VilTeX`Private`j", "\[RightDoubleBracket]"}]}], "}"}]}], 
                    "]"}]}], ";", 
                    RowBox[{"VilTeX`Private`currentPoints", "++"}], ";"}]}], 
                    "]"}], ";"}]}], "]"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"VilTeX`Private`j", ",", 
                    RowBox[{"Length", "[", "VilTeX`Private`yVals", "]"}]}], 
                    "}"}]}], "]"}], ";", 
                    RowBox[{"VilTeX`Private`directPattern", "=", "True"}], 
                    ";"}]}], "]"}], ";", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"!", "VilTeX`Private`directPattern"}], "&&", 
                    
                    RowBox[{"VilTeX`Private`leftSide", "===", 
                    "VilTeX`Private`yVar"}], "&&", 
                    RowBox[{"FreeQ", "[", 
                    
                    RowBox[{"VilTeX`Private`rightSide", ",", 
                    "VilTeX`Private`yVar"}], "]"}]}], ",", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`xVals", "=", 
                    RowBox[{"Table", "[", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`xMin", "+", 
                    FractionBox[
                    RowBox[{
                    RowBox[{"(", 
                    
                    RowBox[{"VilTeX`Private`xMax", "-", 
                    "VilTeX`Private`xMin"}], ")"}], " ", "VilTeX`Private`i"}], 
                    RowBox[{
                    RowBox[{"VilTeX`Private`effectiveSamples", " ", "2"}], 
                    "-", "1"}]]}], ",", 
                    RowBox[{"{", 
                    RowBox[{"VilTeX`Private`i", ",", "0", ",", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`effectiveSamples", " ", "2"}], 
                    "-", "1"}]}], "}"}]}], "]"}]}], ";", 
                    RowBox[{"Do", "[", 
                    RowBox[{
                    RowBox[{"Module", "[", 
                    RowBox[{
                    RowBox[{"{", "VilTeX`Private`yVal", "}"}], ",", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`yVal", "=", 
                    RowBox[{"Quiet", "[", 
                    RowBox[{"N", "[", 
                    
                    RowBox[{"VilTeX`Private`rightSide", "/.", 
                    "\[VeryThinSpace]", 
                    RowBox[{"VilTeX`Private`xVar", "\[Rule]", 
                    
                    RowBox[{"VilTeX`Private`xVals", "\[LeftDoubleBracket]", 
                    "VilTeX`Private`i", "\[RightDoubleBracket]"}]}]}], "]"}], 
                    "]"}]}], ";", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    
                    RowBox[{"VilTeX`Private`validNumber", "[", 
                    "VilTeX`Private`yVal", "]"}], "&&", 
                    
                    RowBox[{"VilTeX`Private`yMin", "\[LessEqual]", 
                    "VilTeX`Private`yVal", "\[LessEqual]", 
                    "VilTeX`Private`yMax"}], "&&", 
                    
                    RowBox[{"VilTeX`Private`currentPoints", "<", 
                    "VilTeX`Private`maxPointsLimit"}]}], ",", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`surfPoints", "=", 
                    RowBox[{"Append", "[", 
                    RowBox[{"VilTeX`Private`surfPoints", ",", 
                    RowBox[{"{", 
                    RowBox[{
                    
                    RowBox[{"VilTeX`Private`xVals", "\[LeftDoubleBracket]", 
                    "VilTeX`Private`i", "\[RightDoubleBracket]"}], ",", 
                    "VilTeX`Private`yVal"}], "}"}]}], "]"}]}], ";", 
                    RowBox[{"VilTeX`Private`currentPoints", "++"}], ";"}]}], 
                    "]"}], ";"}]}], "]"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"VilTeX`Private`i", ",", 
                    RowBox[{"Length", "[", "VilTeX`Private`xVals", "]"}]}], 
                    "}"}]}], "]"}], ";", 
                    RowBox[{"VilTeX`Private`directPattern", "=", "True"}], 
                    ";"}]}], "]"}], ";", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"!", "VilTeX`Private`directPattern"}], "&&", 
                    
                    RowBox[{"VilTeX`Private`rightSide", "===", 
                    "VilTeX`Private`xVar"}], "&&", 
                    RowBox[{"FreeQ", "[", 
                    
                    RowBox[{"VilTeX`Private`leftSide", ",", 
                    "VilTeX`Private`xVar"}], "]"}]}], ",", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`yVals", "=", 
                    RowBox[{"Table", "[", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`yMin", "+", 
                    FractionBox[
                    RowBox[{
                    RowBox[{"(", 
                    
                    RowBox[{"VilTeX`Private`yMax", "-", 
                    "VilTeX`Private`yMin"}], ")"}], " ", "VilTeX`Private`j"}], 
                    RowBox[{
                    RowBox[{"VilTeX`Private`effectiveSamples", " ", "2"}], 
                    "-", "1"}]]}], ",", 
                    RowBox[{"{", 
                    RowBox[{"VilTeX`Private`j", ",", "0", ",", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`effectiveSamples", " ", "2"}], 
                    "-", "1"}]}], "}"}]}], "]"}]}], ";", 
                    RowBox[{"Do", "[", 
                    RowBox[{
                    RowBox[{"Module", "[", 
                    RowBox[{
                    RowBox[{"{", "VilTeX`Private`xVal", "}"}], ",", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`xVal", "=", 
                    RowBox[{"Quiet", "[", 
                    RowBox[{"N", "[", 
                    
                    RowBox[{"VilTeX`Private`leftSide", "/.", 
                    "\[VeryThinSpace]", 
                    RowBox[{"VilTeX`Private`yVar", "\[Rule]", 
                    
                    RowBox[{"VilTeX`Private`yVals", "\[LeftDoubleBracket]", 
                    "VilTeX`Private`j", "\[RightDoubleBracket]"}]}]}], "]"}], 
                    "]"}]}], ";", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"VilTeX`Private`validNumber", "[", 
                    "VilTeX`Private`xVal", "]"}], "&&", 
                    
                    RowBox[{"VilTeX`Private`xMin", "\[LessEqual]", 
                    "VilTeX`Private`xVal", "\[LessEqual]", 
                    "VilTeX`Private`xMax"}], "&&", 
                    
                    RowBox[{"VilTeX`Private`currentPoints", "<", 
                    "VilTeX`Private`maxPointsLimit"}]}], ",", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`surfPoints", "=", 
                    RowBox[{"Append", "[", 
                    RowBox[{"VilTeX`Private`surfPoints", ",", 
                    RowBox[{"{", 
                    RowBox[{"VilTeX`Private`xVal", ",", 
                    
                    RowBox[{"VilTeX`Private`yVals", "\[LeftDoubleBracket]", 
                    "VilTeX`Private`j", "\[RightDoubleBracket]"}]}], "}"}]}], 
                    "]"}]}], ";", 
                    RowBox[{"VilTeX`Private`currentPoints", "++"}], ";"}]}], 
                    "]"}], ";"}]}], "]"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"VilTeX`Private`j", ",", 
                    RowBox[{"Length", "[", "VilTeX`Private`yVals", "]"}]}], 
                    "}"}]}], "]"}], ";", 
                    RowBox[{"VilTeX`Private`directPattern", "=", "True"}], 
                    ";"}]}], "]"}], ";", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"!", "VilTeX`Private`directPattern"}], "&&", 
                    
                    RowBox[{"VilTeX`Private`rightSide", "===", 
                    "VilTeX`Private`yVar"}], "&&", 
                    RowBox[{"FreeQ", "[", 
                    
                    RowBox[{"VilTeX`Private`leftSide", ",", 
                    "VilTeX`Private`yVar"}], "]"}]}], ",", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`xVals", "=", 
                    RowBox[{"Table", "[", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`xMin", "+", 
                    FractionBox[
                    RowBox[{
                    RowBox[{"(", 
                    
                    RowBox[{"VilTeX`Private`xMax", "-", 
                    "VilTeX`Private`xMin"}], ")"}], " ", "VilTeX`Private`i"}], 
                    RowBox[{
                    RowBox[{"VilTeX`Private`effectiveSamples", " ", "2"}], 
                    "-", "1"}]]}], ",", 
                    RowBox[{"{", 
                    RowBox[{"VilTeX`Private`i", ",", "0", ",", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`effectiveSamples", " ", "2"}], 
                    "-", "1"}]}], "}"}]}], "]"}]}], ";", 
                    RowBox[{"Do", "[", 
                    RowBox[{
                    RowBox[{"Module", "[", 
                    RowBox[{
                    RowBox[{"{", "VilTeX`Private`yVal", "}"}], ",", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`yVal", "=", 
                    RowBox[{"Quiet", "[", 
                    RowBox[{"N", "[", 
                    
                    RowBox[{"VilTeX`Private`leftSide", "/.", 
                    "\[VeryThinSpace]", 
                    RowBox[{"VilTeX`Private`xVar", "\[Rule]", 
                    
                    RowBox[{"VilTeX`Private`xVals", "\[LeftDoubleBracket]", 
                    "VilTeX`Private`i", "\[RightDoubleBracket]"}]}]}], "]"}], 
                    "]"}]}], ";", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    
                    RowBox[{"VilTeX`Private`validNumber", "[", 
                    "VilTeX`Private`yVal", "]"}], "&&", 
                    
                    RowBox[{"VilTeX`Private`yMin", "\[LessEqual]", 
                    "VilTeX`Private`yVal", "\[LessEqual]", 
                    "VilTeX`Private`yMax"}], "&&", 
                    
                    RowBox[{"VilTeX`Private`currentPoints", "<", 
                    "VilTeX`Private`maxPointsLimit"}]}], ",", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`surfPoints", "=", 
                    RowBox[{"Append", "[", 
                    RowBox[{"VilTeX`Private`surfPoints", ",", 
                    RowBox[{"{", 
                    RowBox[{
                    
                    RowBox[{"VilTeX`Private`xVals", "\[LeftDoubleBracket]", 
                    "VilTeX`Private`i", "\[RightDoubleBracket]"}], ",", 
                    "VilTeX`Private`yVal"}], "}"}]}], "]"}]}], ";", 
                    RowBox[{"VilTeX`Private`currentPoints", "++"}], ";"}]}], 
                    "]"}], ";"}]}], "]"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"VilTeX`Private`i", ",", 
                    RowBox[{"Length", "[", "VilTeX`Private`xVals", "]"}]}], 
                    "}"}]}], "]"}], ";", 
                    RowBox[{"VilTeX`Private`directPattern", "=", "True"}], 
                    ";"}]}], "]"}], ";", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"!", "VilTeX`Private`directPattern"}], ",", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`ySolutions", "=", 
                    RowBox[{"Quiet", "[", 
                    RowBox[{"Solve", "[", 
                    
                    RowBox[{"VilTeX`Private`equation", ",", 
                    "VilTeX`Private`yVar", ",", 
                    TemplateBox[{}, "Reals"]}], "]"}], "]"}]}], ";", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    RowBox[{"Length", "[", "VilTeX`Private`ySolutions", "]"}],
                     ">", "0"}], "&&", 
                    RowBox[{"FreeQ", "[", 
                    RowBox[{
                    
                    RowBox[{"VilTeX`Private`ySolutions", 
                    "\[LeftDoubleBracket]", "1", "\[RightDoubleBracket]"}], 
                    ",", "Solve"}], "]"}]}], ",", 
                    RowBox[{
                    RowBox[{"Module", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"VilTeX`Private`yFunc", ",", 
                    RowBox[{"VilTeX`Private`validSolutions", "=", 
                    RowBox[{"{", "}"}]}]}], "}"}], ",", 
                    RowBox[{
                    RowBox[{"Do", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"VilTeX`Private`yFunc", "=", 
                    RowBox[{"VilTeX`Private`yVar", "/.", "\[VeryThinSpace]", 
                    
                    RowBox[{"VilTeX`Private`ySolutions", 
                    "\[LeftDoubleBracket]", "VilTeX`Private`solIdx", 
                    "\[RightDoubleBracket]"}]}]}], ";", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"FreeQ", "[", 
                    
                    RowBox[{"VilTeX`Private`yFunc", ",", 
                    "VilTeX`Private`yVar"}], "]"}], ",", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`validSolutions", "=", 
                    RowBox[{"Append", "[", 
                    
                    RowBox[{"VilTeX`Private`validSolutions", ",", 
                    "VilTeX`Private`yFunc"}], "]"}]}], ";"}]}], "]"}]}], ",", 
                    
                    RowBox[{"{", 
                    RowBox[{"VilTeX`Private`solIdx", ",", 
                    RowBox[{"Min", "[", 
                    RowBox[{
                    RowBox[{"Length", "[", "VilTeX`Private`ySolutions", "]"}],
                     ",", "3"}], "]"}]}], "}"}]}], "]"}], ";", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    
                    RowBox[{"Length", "[", "VilTeX`Private`validSolutions", 
                    "]"}], ">", "0"}], ",", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`xVals", "=", 
                    RowBox[{"Table", "[", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`xMin", "+", 
                    FractionBox[
                    RowBox[{
                    RowBox[{"(", 
                    
                    RowBox[{"VilTeX`Private`xMax", "-", 
                    "VilTeX`Private`xMin"}], ")"}], " ", "VilTeX`Private`i"}], 
                    RowBox[{
                    RowBox[{"VilTeX`Private`effectiveSamples", " ", "2"}], 
                    "-", "1"}]]}], ",", 
                    RowBox[{"{", 
                    RowBox[{"VilTeX`Private`i", ",", "0", ",", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`effectiveSamples", " ", "2"}], 
                    "-", "1"}]}], "}"}]}], "]"}]}], ";", 
                    RowBox[{"Do", "[", 
                    RowBox[{
                    RowBox[{"Do", "[", 
                    RowBox[{
                    RowBox[{"Module", "[", 
                    RowBox[{
                    RowBox[{"{", "VilTeX`Private`yVal", "}"}], ",", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`yVal", "=", 
                    RowBox[{"Quiet", "[", 
                    RowBox[{"N", "[", 
                    RowBox[{
                    
                    RowBox[{"VilTeX`Private`validSolutions", 
                    "\[LeftDoubleBracket]", "VilTeX`Private`k", 
                    "\[RightDoubleBracket]"}], "/.", "\[VeryThinSpace]", 
                    RowBox[{"VilTeX`Private`xVar", "\[Rule]", 
                    
                    RowBox[{"VilTeX`Private`xVals", "\[LeftDoubleBracket]", 
                    "VilTeX`Private`i", "\[RightDoubleBracket]"}]}]}], "]"}], 
                    "]"}]}], ";", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    
                    RowBox[{"VilTeX`Private`validNumber", "[", 
                    "VilTeX`Private`yVal", "]"}], "&&", 
                    RowBox[{
                    "VilTeX`Private`yMin", "\[LessEqual]", 
                    "VilTeX`Private`yVal", "\[LessEqual]", 
                    "VilTeX`Private`yMax"}], "&&", 
                    RowBox[{"VilTeX`Private`currentPoints", "<", 
                    "VilTeX`Private`maxPointsLimit"}]}], ",", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`surfPoints", "=", 
                    RowBox[{"Append", "[", 
                    RowBox[{"VilTeX`Private`surfPoints", ",", 
                    RowBox[{"{", 
                    RowBox[{
                    
                    RowBox[{"VilTeX`Private`xVals", "\[LeftDoubleBracket]", 
                    "VilTeX`Private`i", "\[RightDoubleBracket]"}], ",", 
                    "VilTeX`Private`yVal"}], "}"}]}], "]"}]}], ";", 
                    RowBox[{"VilTeX`Private`currentPoints", "++"}], ";"}]}], 
                    "]"}], ";"}]}], "]"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"VilTeX`Private`k", ",", 
                    
                    RowBox[{"Length", "[", "VilTeX`Private`validSolutions", 
                    "]"}]}], "}"}]}], "]"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"VilTeX`Private`i", ",", 
                    RowBox[{"Length", "[", "VilTeX`Private`xVals", "]"}]}], 
                    "}"}]}], "]"}], ";"}]}], "]"}], ";"}]}], "]"}], ";"}], 
                    ",", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`xSolutions", "=", 
                    RowBox[{"Quiet", "[", 
                    RowBox[{"Solve", "[", 
                    
                    RowBox[{"VilTeX`Private`equation", ",", 
                    "VilTeX`Private`xVar", ",", 
                    TemplateBox[{}, "Reals"]}], "]"}], "]"}]}], ";", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    RowBox[{"Length", "[", "VilTeX`Private`xSolutions", "]"}],
                     ">", "0"}], "&&", 
                    RowBox[{"FreeQ", "[", 
                    RowBox[{
                    
                    RowBox[{"VilTeX`Private`xSolutions", 
                    "\[LeftDoubleBracket]", "1", "\[RightDoubleBracket]"}], 
                    ",", "Solve"}], "]"}]}], ",", 
                    RowBox[{
                    RowBox[{"Module", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"VilTeX`Private`xFunc", ",", 
                    RowBox[{"VilTeX`Private`validSolutions", "=", 
                    RowBox[{"{", "}"}]}]}], "}"}], ",", 
                    RowBox[{
                    RowBox[{"Do", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"VilTeX`Private`xFunc", "=", 
                    RowBox[{"VilTeX`Private`xVar", "/.", "\[VeryThinSpace]", 
                    
                    RowBox[{"VilTeX`Private`xSolutions", 
                    "\[LeftDoubleBracket]", "VilTeX`Private`solIdx", 
                    "\[RightDoubleBracket]"}]}]}], ";", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"FreeQ", "[", 
                    
                    RowBox[{"VilTeX`Private`xFunc", ",", 
                    "VilTeX`Private`xVar"}], "]"}], ",", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`validSolutions", "=", 
                    RowBox[{"Append", "[", 
                    
                    RowBox[{"VilTeX`Private`validSolutions", ",", 
                    "VilTeX`Private`xFunc"}], "]"}]}], ";"}]}], "]"}]}], ",", 
                    
                    RowBox[{"{", 
                    RowBox[{"VilTeX`Private`solIdx", ",", 
                    RowBox[{"Min", "[", 
                    RowBox[{
                    RowBox[{"Length", "[", "VilTeX`Private`xSolutions", "]"}],
                     ",", "3"}], "]"}]}], "}"}]}], "]"}], ";", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    
                    RowBox[{"Length", "[", "VilTeX`Private`validSolutions", 
                    "]"}], ">", "0"}], ",", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`yVals", "=", 
                    RowBox[{"Table", "[", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`yMin", "+", 
                    FractionBox[
                    RowBox[{
                    RowBox[{"(", 
                    
                    RowBox[{"VilTeX`Private`yMax", "-", 
                    "VilTeX`Private`yMin"}], ")"}], " ", "VilTeX`Private`j"}], 
                    RowBox[{
                    RowBox[{"VilTeX`Private`effectiveSamples", " ", "2"}], 
                    "-", "1"}]]}], ",", 
                    RowBox[{"{", 
                    RowBox[{"VilTeX`Private`j", ",", "0", ",", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`effectiveSamples", " ", "2"}], 
                    "-", "1"}]}], "}"}]}], "]"}]}], ";", 
                    RowBox[{"Do", "[", 
                    RowBox[{
                    RowBox[{"Do", "[", 
                    RowBox[{
                    RowBox[{"Module", "[", 
                    RowBox[{
                    RowBox[{"{", "VilTeX`Private`xVal", "}"}], ",", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`xVal", "=", 
                    RowBox[{"Quiet", "[", 
                    RowBox[{"N", "[", 
                    RowBox[{
                    
                    RowBox[{"VilTeX`Private`validSolutions", 
                    "\[LeftDoubleBracket]", "VilTeX`Private`k", 
                    "\[RightDoubleBracket]"}], "/.", "\[VeryThinSpace]", 
                    RowBox[{"VilTeX`Private`yVar", "\[Rule]", 
                    
                    RowBox[{"VilTeX`Private`yVals", "\[LeftDoubleBracket]", 
                    "VilTeX`Private`j", "\[RightDoubleBracket]"}]}]}], "]"}], 
                    "]"}]}], ";", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    
                    RowBox[{"VilTeX`Private`validNumber", "[", 
                    "VilTeX`Private`xVal", "]"}], "&&", 
                    RowBox[{"VilTeX`Private`xMin", "\[LessEqual]", 
                    "VilTeX`Private`xVal", "\[LessEqual]", 
                    "VilTeX`Private`xMax"}], "&&", 
                    RowBox[{"VilTeX`Private`currentPoints", "<", 
                    "VilTeX`Private`maxPointsLimit"}]}], ",", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`surfPoints", "=", 
                    RowBox[{"Append", "[", 
                    RowBox[{"VilTeX`Private`surfPoints", ",", 
                    RowBox[{"{", 
                    RowBox[{"VilTeX`Private`xVal", ",", 
                    
                    RowBox[{"VilTeX`Private`yVals", "\[LeftDoubleBracket]", 
                    "VilTeX`Private`j", "\[RightDoubleBracket]"}]}], "}"}]}], 
                    "]"}]}], ";", 
                    RowBox[{"VilTeX`Private`currentPoints", "++"}], ";"}]}], 
                    "]"}], ";"}]}], "]"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"VilTeX`Private`k", ",", 
                    
                    RowBox[{"Length", "[", "VilTeX`Private`validSolutions", 
                    "]"}]}], "}"}]}], "]"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"VilTeX`Private`j", ",", 
                    RowBox[{"Length", "[", "VilTeX`Private`yVals", "]"}]}], 
                    "}"}]}], "]"}], ";"}]}], "]"}], ";"}]}], "]"}], ";"}], 
                    ",", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`adaptiveSamples", "=", 
                    RowBox[{"Min", "[", 
                    RowBox[{
                    RowBox[{"Max", "[", 
                    RowBox[{"VilTeX`Private`effectiveSamples", ",", "25"}], 
                    "]"}], ",", 
                    RowBox[{"Floor", "[", 
                    SqrtBox[
                    RowBox[{"VilTeX`Private`maxPointsLimit", " ", "0.8`"}]], 
                    "]"}]}], "]"}]}], ";", 
                    RowBox[{"VilTeX`Private`adaptiveSamples", "=", 
                    RowBox[{"Max", "[", 
                    RowBox[{"VilTeX`Private`adaptiveSamples", ",", "8"}], 
                    "]"}]}], ";", 
                    RowBox[{"VilTeX`Private`xVals", "=", 
                    RowBox[{"Table", "[", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`xMin", "+", 
                    FractionBox[
                    RowBox[{
                    RowBox[{"(", 
                    
                    RowBox[{"VilTeX`Private`xMax", "-", 
                    "VilTeX`Private`xMin"}], ")"}], " ", "VilTeX`Private`i"}], 
                    RowBox[{"VilTeX`Private`adaptiveSamples", "-", "1"}]]}], 
                    ",", 
                    RowBox[{"{", 
                    RowBox[{"VilTeX`Private`i", ",", "0", ",", 
                    RowBox[{"VilTeX`Private`adaptiveSamples", "-", "1"}]}], 
                    "}"}]}], "]"}]}], ";", 
                    RowBox[{"VilTeX`Private`yVals", "=", 
                    RowBox[{"Table", "[", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`yMin", "+", 
                    FractionBox[
                    RowBox[{
                    RowBox[{"(", 
                    
                    RowBox[{"VilTeX`Private`yMax", "-", 
                    "VilTeX`Private`yMin"}], ")"}], " ", "VilTeX`Private`j"}], 
                    RowBox[{"VilTeX`Private`adaptiveSamples", "-", "1"}]]}], 
                    ",", 
                    RowBox[{"{", 
                    RowBox[{"VilTeX`Private`j", ",", "0", ",", 
                    RowBox[{"VilTeX`Private`adaptiveSamples", "-", "1"}]}], 
                    "}"}]}], "]"}]}], ";", 
                    RowBox[{"Do", "[", 
                    RowBox[{
                    RowBox[{"Do", "[", 
                    RowBox[{
                    RowBox[{"If", "[", 
                    RowBox[{
                    
                    RowBox[{"VilTeX`Private`currentPoints", "<", 
                    "VilTeX`Private`maxPointsLimit"}], ",", 
                    RowBox[{
                    RowBox[{"Module", "[", 
                    RowBox[{
                    RowBox[{"{", "VilTeX`Private`funcVal", "}"}], ",", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`funcVal", "=", 
                    RowBox[{"Quiet", "[", 
                    RowBox[{"N", "[", 
                    
                    RowBox[{"VilTeX`Private`implicitFunc", "/.", 
                    "\[VeryThinSpace]", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`xVar", "\[Rule]", 
                    
                    RowBox[{"VilTeX`Private`xVals", "\[LeftDoubleBracket]", 
                    "VilTeX`Private`i", "\[RightDoubleBracket]"}]}], ",", 
                    RowBox[{"VilTeX`Private`yVar", "\[Rule]", 
                    
                    RowBox[{"VilTeX`Private`yVals", "\[LeftDoubleBracket]", 
                    "VilTeX`Private`j", "\[RightDoubleBracket]"}]}]}], 
                    "}"}]}], "]"}], "]"}]}], ";", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    
                    RowBox[{"VilTeX`Private`validNumber", "[", 
                    "VilTeX`Private`funcVal", "]"}], "&&", 
                    RowBox[{
                    RowBox[{"Abs", "[", "VilTeX`Private`funcVal", "]"}], "<", 
                    "VilTeX`Private`toleranceValue"}]}], ",", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`surfPoints", "=", 
                    RowBox[{"Append", "[", 
                    RowBox[{"VilTeX`Private`surfPoints", ",", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`xVals", "\[LeftDoubleBracket]", 
                    "VilTeX`Private`i", "\[RightDoubleBracket]"}], ",", 
                    
                    RowBox[{"VilTeX`Private`yVals", "\[LeftDoubleBracket]", 
                    "VilTeX`Private`j", "\[RightDoubleBracket]"}]}], "}"}]}], 
                    "]"}]}], ";", 
                    RowBox[{"VilTeX`Private`currentPoints", "++"}], ";"}]}], 
                    "]"}], ";"}]}], "]"}], ";"}]}], "]"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"VilTeX`Private`j", ",", 
                    RowBox[{"Length", "[", "VilTeX`Private`yVals", "]"}]}], 
                    "}"}]}], "]"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"VilTeX`Private`i", ",", 
                    RowBox[{"Length", "[", "VilTeX`Private`xVals", "]"}]}], 
                    "}"}]}], "]"}], ";"}]}], "]"}], ";"}]}], "]"}], ";"}]}], 
                    "]"}], ";", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Length", "[", "VilTeX`Private`surfPoints", "]"}],
                     ">", "VilTeX`Private`maxPointsLimit"}], ",", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`surfPoints", "=", 
                    RowBox[{"RandomSample", "[", 
                    
                    RowBox[{"VilTeX`Private`surfPoints", ",", 
                    "VilTeX`Private`maxPointsLimit"}], "]"}]}], ";"}]}], 
                    "]"}], ";", "VilTeX`Private`surfPoints"}]}], "]"}]}], ";", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`generateInequalityRegion", "[", 
                    
                    RowBox[{"VilTeX`Private`inequality_", ",", 
                    "VilTeX`Private`xRange_", ",", "VilTeX`Private`yRange_", 
                    ",", "VilTeX`Private`targetSamples_", ",", 
                    "VilTeX`Private`densityLocal_"}], "]"}], ":=", 
                    RowBox[{"Module", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    
                    RowBox[{"VilTeX`Private`xVar", ",", "VilTeX`Private`xMin",
                     ",", "VilTeX`Private`xMax", ",", "VilTeX`Private`yVar", 
                    ",", "VilTeX`Private`yMin", ",", "VilTeX`Private`yMax", 
                    ",", "VilTeX`Private`xVals", ",", "VilTeX`Private`yVals", 
                    ",", "VilTeX`Private`regionPoints", ",", 
                    "VilTeX`Private`evaluateInequality", ",", 
                    "VilTeX`Private`effectiveSamples"}], "}"}], ",", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"{", 
                    
                    RowBox[{"VilTeX`Private`xVar", ",", "VilTeX`Private`xMin",
                     ",", "VilTeX`Private`xMax"}], "}"}], "=", 
                    "VilTeX`Private`xRange"}], ";", 
                    RowBox[{
                    RowBox[{"{", 
                    
                    RowBox[{"VilTeX`Private`yVar", ",", "VilTeX`Private`yMin",
                     ",", "VilTeX`Private`yMax"}], "}"}], "=", 
                    "VilTeX`Private`yRange"}], ";", 
                    RowBox[{"VilTeX`Private`effectiveSamples", "=", 
                    RowBox[{"Floor", "[", 
                    
                    RowBox[{"VilTeX`Private`targetSamples", " ", 
                    "VilTeX`Private`densityLocal"}], "]"}]}], ";", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`evaluateInequality", "[", 
                    
                    RowBox[{"VilTeX`Private`expr_", ",", 
                    "VilTeX`Private`xVal_", ",", "VilTeX`Private`yVal_"}], 
                    "]"}], ":=", 
                    RowBox[{"Module", "[", 
                    RowBox[{
                    RowBox[{"{", "VilTeX`Private`result", "}"}], ",", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`result", "=", 
                    RowBox[{"Quiet", "[", 
                    RowBox[{"VilTeX`Private`expr", "/.", "\[VeryThinSpace]", 
                    RowBox[{"{", 
                    RowBox[{
                    
                    RowBox[{"VilTeX`Private`xVar", "\[Rule]", 
                    "VilTeX`Private`xVal"}], ",", 
                    
                    RowBox[{"VilTeX`Private`yVar", "\[Rule]", 
                    "VilTeX`Private`yVal"}]}], "}"}]}], "]"}]}], ";", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"BooleanQ", "[", "VilTeX`Private`result", "]"}], 
                    ",", "VilTeX`Private`result", ",", "False"}], "]"}]}]}], 
                    "]"}]}], ";", 
                    RowBox[{"VilTeX`Private`xVals", "=", 
                    RowBox[{"Table", "[", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`xMin", "+", 
                    FractionBox[
                    RowBox[{
                    RowBox[{"(", 
                    
                    RowBox[{"VilTeX`Private`xMax", "-", 
                    "VilTeX`Private`xMin"}], ")"}], " ", "VilTeX`Private`i"}], 
                    RowBox[{"VilTeX`Private`effectiveSamples", "-", "1"}]]}], 
                    ",", 
                    RowBox[{"{", 
                    RowBox[{"VilTeX`Private`i", ",", "0", ",", 
                    RowBox[{"VilTeX`Private`effectiveSamples", "-", "1"}]}], 
                    "}"}]}], "]"}]}], ";", 
                    RowBox[{"VilTeX`Private`yVals", "=", 
                    RowBox[{"Table", "[", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`yMin", "+", 
                    FractionBox[
                    RowBox[{
                    RowBox[{"(", 
                    
                    RowBox[{"VilTeX`Private`yMax", "-", 
                    "VilTeX`Private`yMin"}], ")"}], " ", "VilTeX`Private`j"}], 
                    RowBox[{"VilTeX`Private`effectiveSamples", "-", "1"}]]}], 
                    ",", 
                    RowBox[{"{", 
                    RowBox[{"VilTeX`Private`j", ",", "0", ",", 
                    RowBox[{"VilTeX`Private`effectiveSamples", "-", "1"}]}], 
                    "}"}]}], "]"}]}], ";", 
                    RowBox[{"VilTeX`Private`regionPoints", "=", 
                    RowBox[{"{", "}"}]}], ";", 
                    RowBox[{"Do", "[", 
                    RowBox[{
                    RowBox[{"Do", "[", 
                    RowBox[{
                    RowBox[{"Module", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    
                    RowBox[{"VilTeX`Private`xVal", ",", "VilTeX`Private`yVal",
                     ",", "VilTeX`Private`isInRegion"}], "}"}], ",", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`xVal", "=", 
                    
                    RowBox[{"VilTeX`Private`xVals", "\[LeftDoubleBracket]", 
                    "VilTeX`Private`i", "\[RightDoubleBracket]"}]}], ";", 
                    RowBox[{"VilTeX`Private`yVal", "=", 
                    
                    RowBox[{"VilTeX`Private`yVals", "\[LeftDoubleBracket]", 
                    "VilTeX`Private`j", "\[RightDoubleBracket]"}]}], ";", 
                    RowBox[{"VilTeX`Private`isInRegion", "=", 
                    RowBox[{"VilTeX`Private`evaluateInequality", "[", 
                    
                    RowBox[{"VilTeX`Private`inequality", ",", 
                    "VilTeX`Private`xVal", ",", "VilTeX`Private`yVal"}], 
                    "]"}]}], ";", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"TrueQ", "[", "VilTeX`Private`isInRegion", "]"}], 
                    ",", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`regionPoints", "=", 
                    RowBox[{"Append", "[", 
                    RowBox[{"VilTeX`Private`regionPoints", ",", 
                    RowBox[{"{", 
                    
                    RowBox[{"VilTeX`Private`xVal", ",", 
                    "VilTeX`Private`yVal"}], "}"}]}], "]"}]}], ";"}]}], "]"}],
                     ";"}]}], "]"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"VilTeX`Private`j", ",", 
                    RowBox[{"Length", "[", "VilTeX`Private`yVals", "]"}]}], 
                    "}"}]}], "]"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"VilTeX`Private`i", ",", 
                    RowBox[{"Length", "[", "VilTeX`Private`xVals", "]"}]}], 
                    "}"}]}], "]"}], ";", "VilTeX`Private`regionPoints"}]}], 
                    "]"}]}], ";", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`calculateLimits", "[", 
                    RowBox[{"VilTeX`Private`dataPoints_", ",", 
                    RowBox[{"VilTeX`Private`margin_", ":", "0.1`"}]}], "]"}], 
                    ":=", 
                    RowBox[{"Module", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    
                    RowBox[{"VilTeX`Private`xDataMin", ",", 
                    "VilTeX`Private`xDataMax", ",", "VilTeX`Private`yDataMin",
                     ",", "VilTeX`Private`yDataMax", ",", 
                    "VilTeX`Private`xRange", ",", "VilTeX`Private`yRange"}], 
                    "}"}], ",", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Length", "[", "VilTeX`Private`dataPoints", "]"}],
                     ">", "0"}], ",", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`xDataMin", "=", 
                    RowBox[{"Min", "[", 
                    
                    RowBox[{"VilTeX`Private`dataPoints", 
                    "\[LeftDoubleBracket]", 
                    RowBox[{"All", ",", "1"}], "\[RightDoubleBracket]"}], 
                    "]"}]}], ";", 
                    RowBox[{"VilTeX`Private`xDataMax", "=", 
                    RowBox[{"Max", "[", 
                    
                    RowBox[{"VilTeX`Private`dataPoints", 
                    "\[LeftDoubleBracket]", 
                    RowBox[{"All", ",", "1"}], "\[RightDoubleBracket]"}], 
                    "]"}]}], ";", 
                    RowBox[{"VilTeX`Private`yDataMin", "=", 
                    RowBox[{"Min", "[", 
                    
                    RowBox[{"VilTeX`Private`dataPoints", 
                    "\[LeftDoubleBracket]", 
                    RowBox[{"All", ",", "2"}], "\[RightDoubleBracket]"}], 
                    "]"}]}], ";", 
                    RowBox[{"VilTeX`Private`yDataMax", "=", 
                    RowBox[{"Max", "[", 
                    
                    RowBox[{"VilTeX`Private`dataPoints", 
                    "\[LeftDoubleBracket]", 
                    RowBox[{"All", ",", "2"}], "\[RightDoubleBracket]"}], 
                    "]"}]}], ";", 
                    RowBox[{"VilTeX`Private`xRange", "=", 
                    
                    RowBox[{"VilTeX`Private`xDataMax", "-", 
                    "VilTeX`Private`xDataMin"}]}], ";", 
                    RowBox[{"VilTeX`Private`yRange", "=", 
                    
                    RowBox[{"VilTeX`Private`yDataMax", "-", 
                    "VilTeX`Private`yDataMin"}]}], ";", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`xRange", "\[Equal]", "0"}], ",", 
                    RowBox[{"VilTeX`Private`xRange", "=", "1"}]}], "]"}], ";", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`yRange", "\[Equal]", "0"}], ",", 
                    RowBox[{"VilTeX`Private`yRange", "=", "1"}]}], "]"}], ";", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`xDataMin", "-", 
                    
                    RowBox[{"VilTeX`Private`margin", " ", 
                    "VilTeX`Private`xRange"}]}], ",", 
                    RowBox[{"VilTeX`Private`xDataMax", "+", 
                    
                    RowBox[{"VilTeX`Private`margin", " ", 
                    "VilTeX`Private`xRange"}]}], ",", 
                    RowBox[{"VilTeX`Private`yDataMin", "-", 
                    
                    RowBox[{"VilTeX`Private`margin", " ", 
                    "VilTeX`Private`yRange"}]}], ",", 
                    RowBox[{"VilTeX`Private`yDataMax", "+", 
                    
                    RowBox[{"VilTeX`Private`margin", " ", 
                    "VilTeX`Private`yRange"}]}]}], "}"}]}], ",", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"-", "5"}], ",", "5", ",", 
                    RowBox[{"-", "5"}], ",", "5"}], "}"}]}], "]"}]}], "]"}]}],
                     ";", 
                    RowBox[{
                    
                    RowBox[{"VilTeX`Private`combineGlobalLimits", "[", 
                    "VilTeX`Private`limitsList_", "]"}], ":=", 
                    RowBox[{"Module", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    
                    RowBox[{"VilTeX`Private`xMins", ",", 
                    "VilTeX`Private`xMaxs", ",", "VilTeX`Private`yMins", ",", 
                    "VilTeX`Private`yMaxs"}], "}"}], ",", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Length", "[", "VilTeX`Private`limitsList", "]"}],
                     ">", "0"}], ",", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`xMins", "=", 
                    
                    RowBox[{"VilTeX`Private`limitsList", 
                    "\[LeftDoubleBracket]", 
                    RowBox[{"All", ",", "1"}], "\[RightDoubleBracket]"}]}], 
                    ";", 
                    RowBox[{"VilTeX`Private`xMaxs", "=", 
                    
                    RowBox[{"VilTeX`Private`limitsList", 
                    "\[LeftDoubleBracket]", 
                    RowBox[{"All", ",", "2"}], "\[RightDoubleBracket]"}]}], 
                    ";", 
                    RowBox[{"VilTeX`Private`yMins", "=", 
                    
                    RowBox[{"VilTeX`Private`limitsList", 
                    "\[LeftDoubleBracket]", 
                    RowBox[{"All", ",", "3"}], "\[RightDoubleBracket]"}]}], 
                    ";", 
                    RowBox[{"VilTeX`Private`yMaxs", "=", 
                    
                    RowBox[{"VilTeX`Private`limitsList", 
                    "\[LeftDoubleBracket]", 
                    RowBox[{"All", ",", "4"}], "\[RightDoubleBracket]"}]}], 
                    ";", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"Min", "[", "VilTeX`Private`xMins", "]"}], ",", 
                    RowBox[{"Max", "[", "VilTeX`Private`xMaxs", "]"}], ",", 
                    RowBox[{"Min", "[", "VilTeX`Private`yMins", "]"}], ",", 
                    RowBox[{"Max", "[", "VilTeX`Private`yMaxs", "]"}]}], 
                    "}"}]}], ",", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"-", "5"}], ",", "5", ",", 
                    RowBox[{"-", "5"}], ",", "5"}], "}"}]}], "]"}]}], "]"}]}],
                     ";", 
                    RowBox[{
                    
                    RowBox[{"VilTeX`Private`determineGraphType", "[", 
                    "VilTeX`Private`graphArgs_", "]"}], ":=", 
                    RowBox[{"Module", "[", 
                    RowBox[{
                    RowBox[{"{", "}"}], ",", 
                    RowBox[{"Which", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Head", "[", "VilTeX`Private`graphArgs", "]"}], 
                    "===", "Equal"}], ",", "\"ImplicitCurve\"", ",", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Head", "[", "VilTeX`Private`graphArgs", "]"}], 
                    "===", "GreaterEqual"}], "||", 
                    RowBox[{
                    RowBox[{"Head", "[", "VilTeX`Private`graphArgs", "]"}], 
                    "===", "Greater"}], "||", 
                    RowBox[{
                    RowBox[{"Head", "[", "VilTeX`Private`graphArgs", "]"}], 
                    "===", "LessEqual"}], "||", 
                    RowBox[{
                    RowBox[{"Head", "[", "VilTeX`Private`graphArgs", "]"}], 
                    "===", "Less"}]}], ",", "\"InequalityRegion\"", ",", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Head", "[", "VilTeX`Private`graphArgs", "]"}], 
                    "===", "And"}], "||", 
                    RowBox[{
                    RowBox[{"Head", "[", "VilTeX`Private`graphArgs", "]"}], 
                    "===", "Or"}]}], ",", "\"InequalityRegion\"", ",", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Length", "[", "VilTeX`Private`graphArgs", "]"}], 
                    "\[Equal]", "2"}], "&&", 
                    RowBox[{"MatchQ", "[", 
                    RowBox[{
                    
                    RowBox[{"VilTeX`Private`graphArgs", 
                    "\[LeftDoubleBracket]", "2", "\[RightDoubleBracket]"}], 
                    ",", 
                    RowBox[{"{", 
                    RowBox[{"_", ",", "_", ",", "_"}], "}"}]}], "]"}], "&&", 
                    RowBox[{"!", 
                    RowBox[{"ListQ", "[", 
                    
                    RowBox[{"VilTeX`Private`graphArgs", 
                    "\[LeftDoubleBracket]", "1", "\[RightDoubleBracket]"}], 
                    "]"}]}]}], ",", "\"FunctionPlot\"", ",", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Length", "[", "VilTeX`Private`graphArgs", "]"}], 
                    "\[Equal]", "2"}], "&&", 
                    RowBox[{"ListQ", "[", 
                    RowBox[{"VilTeX`Private`graphArgs", 
                    "\[LeftDoubleBracket]", "1", "\[RightDoubleBracket]"}], 
                    "]"}], "&&", 
                    RowBox[{
                    RowBox[{"Length", "[", 
                    
                    RowBox[{"VilTeX`Private`graphArgs", 
                    "\[LeftDoubleBracket]", "1", "\[RightDoubleBracket]"}], 
                    "]"}], "\[Equal]", "2"}], "&&", 
                    RowBox[{"MatchQ", "[", 
                    RowBox[{
                    
                    RowBox[{"VilTeX`Private`graphArgs", 
                    "\[LeftDoubleBracket]", "2", "\[RightDoubleBracket]"}], 
                    ",", 
                    RowBox[{"{", 
                    RowBox[{"_", ",", "_", ",", "_"}], "}"}]}], "]"}]}], ",", 
                    "\"ParametricCurve\"", ",", 
                    RowBox[{
                    RowBox[{"ListQ", "[", "VilTeX`Private`graphArgs", "]"}], 
                    "&&", 
                    RowBox[{"AllTrue", "[", 
                    RowBox[{"VilTeX`Private`graphArgs", ",", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"ListQ", "[", "#1", "]"}], "&&", 
                    RowBox[{
                    RowBox[{"Length", "[", "#1", "]"}], "\[Equal]", "2"}]}], 
                    "&"}]}], "]"}]}], ",", "\"Points\"", ",", "True", ",", 
                    "\"Unknown\""}], "]"}]}], "]"}]}], ";", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"VilTeX`Private`xmin", "===", "Automatic"}], "||", 
                    RowBox[{"VilTeX`Private`xmax", "===", "Automatic"}], "||", 
                    RowBox[{"VilTeX`Private`ymin", "===", "Automatic"}], "||", 
                    RowBox[{"VilTeX`Private`ymax", "===", "Automatic"}]}], 
                    ",", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`xLimits", "=", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"VilTeX`Private`xmin", "===", "Automatic"}], "||", 
                    RowBox[{"VilTeX`Private`xmax", "===", "Automatic"}]}], 
                    ",", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"-", "5"}], ",", "5"}], "}"}], ",", 
                    RowBox[{"{", 
                    
                    RowBox[{"VilTeX`Private`xmin", ",", 
                    "VilTeX`Private`xmax"}], "}"}]}], "]"}]}], ";", 
                    RowBox[{"VilTeX`Private`yLimits", "=", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"VilTeX`Private`ymin", "===", "Automatic"}], "||", 
                    RowBox[{"VilTeX`Private`ymax", "===", "Automatic"}]}], 
                    ",", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"-", "5"}], ",", "5"}], "}"}], ",", 
                    RowBox[{"{", 
                    
                    RowBox[{"VilTeX`Private`ymin", ",", 
                    "VilTeX`Private`ymax"}], "}"}]}], "]"}]}], ";"}], ",", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`xLimits", "=", 
                    RowBox[{"{", 
                    
                    RowBox[{"VilTeX`Private`xmin", ",", 
                    "VilTeX`Private`xmax"}], "}"}]}], ";", 
                    RowBox[{"VilTeX`Private`yLimits", "=", 
                    RowBox[{"{", 
                    
                    RowBox[{"VilTeX`Private`ymin", ",", 
                    "VilTeX`Private`ymax"}], "}"}]}], ";"}]}], "]"}], ";", 
                    RowBox[{"VilTeX`Private`allPlotData", "=", 
                    RowBox[{"{", "}"}]}], ";", 
                    RowBox[{"VilTeX`Private`allLimits", "=", 
                    RowBox[{"{", "}"}]}], ";", 
                    RowBox[{"VilTeX`Private`allValidData", "=", 
                    RowBox[{"{", "}"}]}], ";", 
                    RowBox[{"Do", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"VilTeX`Private`currentGraph", "=", 
                    
                    RowBox[{"VilTeX`Private`graphList", 
                    "\[LeftDoubleBracket]", "VilTeX`Private`graphIdx", 
                    "\[RightDoubleBracket]"}]}], ";", 
                    RowBox[{"VilTeX`Private`currentPlotType", "=", 
                    
                    RowBox[{"VilTeX`Private`determineGraphType", "[", 
                    "VilTeX`Private`currentGraph", "]"}]}], ";", 
                    RowBox[{"VilTeX`Private`currentData", "=", 
                    RowBox[{"{", "}"}]}], ";", 
                    RowBox[{"Which", "[", 
                    RowBox[{
                    
                    RowBox[{"VilTeX`Private`currentPlotType", "\[Equal]", 
                    "\"ImplicitCurve\""}], ",", 
                    RowBox[{
                    
                    RowBox[{"VilTeX`Private`equation", "=", 
                    "VilTeX`Private`currentGraph"}], ";", 
                    RowBox[{"Module", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    
                    RowBox[{"VilTeX`Private`xVar", ",", "VilTeX`Private`yVar",
                     ",", "VilTeX`Private`vars"}], "}"}], ",", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`vars", "=", 
                    
                    RowBox[{"Variables", "[", "VilTeX`Private`equation", 
                    "]"}]}], ";", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Length", "[", "VilTeX`Private`vars", "]"}], 
                    "\[GreaterEqual]", "2"}], ",", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`xVar", "=", 
                    
                    RowBox[{"VilTeX`Private`vars", "\[LeftDoubleBracket]", 
                    "1", "\[RightDoubleBracket]"}]}], ";", 
                    RowBox[{"VilTeX`Private`yVar", "=", 
                    
                    RowBox[{"VilTeX`Private`vars", "\[LeftDoubleBracket]", 
                    "2", "\[RightDoubleBracket]"}]}], ";"}], ",", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`xVar", "=", "VilTeX`Private`x"}], 
                    ";", 
                    RowBox[{"VilTeX`Private`yVar", "=", "VilTeX`Private`y"}], 
                    ";"}]}], "]"}], ";", 
                    RowBox[{"VilTeX`Private`xRange", "=", 
                    RowBox[{"{", 
                    RowBox[{"VilTeX`Private`xVar", ",", 
                    
                    RowBox[{"VilTeX`Private`xLimits", "\[LeftDoubleBracket]", 
                    "1", "\[RightDoubleBracket]"}], ",", 
                    
                    RowBox[{"VilTeX`Private`xLimits", "\[LeftDoubleBracket]", 
                    "2", "\[RightDoubleBracket]"}]}], "}"}]}], ";", 
                    RowBox[{"VilTeX`Private`yRange", "=", 
                    RowBox[{"{", 
                    RowBox[{"VilTeX`Private`yVar", ",", 
                    
                    RowBox[{"VilTeX`Private`yLimits", "\[LeftDoubleBracket]", 
                    "1", "\[RightDoubleBracket]"}], ",", 
                    
                    RowBox[{"VilTeX`Private`yLimits", "\[LeftDoubleBracket]", 
                    "2", "\[RightDoubleBracket]"}]}], "}"}]}], ";", 
                    RowBox[{"VilTeX`Private`currentData", "=", 
                    RowBox[{"VilTeX`Private`generateImplicitCurve2D", "[", 
                    
                    RowBox[{"VilTeX`Private`equation", ",", 
                    "VilTeX`Private`xRange", ",", "VilTeX`Private`yRange", 
                    ",", "VilTeX`Private`samples", ",", 
                    "VilTeX`Private`maxPoints", ",", 
                    "VilTeX`Private`tolerance", ",", 
                    "VilTeX`Private`effectiveDensity"}], "]"}]}], ";"}]}], 
                    "]"}], ";", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    
                    RowBox[{"Length", "[", "VilTeX`Private`currentData", 
                    "]"}], ">", "0"}], ",", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`allLimits", "=", 
                    RowBox[{"Append", "[", 
                    RowBox[{"VilTeX`Private`allLimits", ",", 
                    
                    RowBox[{"VilTeX`Private`calculateLimits", "[", 
                    "VilTeX`Private`currentData", "]"}]}], "]"}]}], ";", 
                    RowBox[{"VilTeX`Private`allPlotData", "=", 
                    RowBox[{"Append", "[", 
                    RowBox[{"VilTeX`Private`allPlotData", ",", 
                    RowBox[{"{", 
                    
                    RowBox[{"VilTeX`Private`currentPlotType", ",", 
                    "VilTeX`Private`currentData", ",", 
                    "VilTeX`Private`currentGraph"}], "}"}]}], "]"}]}], ";", 
                    RowBox[{"VilTeX`Private`allValidData", "=", 
                    RowBox[{"Join", "[", 
                    
                    RowBox[{"VilTeX`Private`allValidData", ",", 
                    "VilTeX`Private`currentData"}], "]"}]}], ";"}]}], "]"}], 
                    ";"}], ",", 
                    
                    RowBox[{"VilTeX`Private`currentPlotType", "\[Equal]", 
                    "\"InequalityRegion\""}], ",", 
                    RowBox[{
                    
                    RowBox[{"VilTeX`Private`equation", "=", 
                    "VilTeX`Private`currentGraph"}], ";", 
                    RowBox[{"Module", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    
                    RowBox[{"VilTeX`Private`xVar", ",", "VilTeX`Private`yVar",
                     ",", "VilTeX`Private`vars"}], "}"}], ",", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`vars", "=", 
                    
                    RowBox[{"Variables", "[", "VilTeX`Private`equation", 
                    "]"}]}], ";", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Length", "[", "VilTeX`Private`vars", "]"}], 
                    "\[GreaterEqual]", "2"}], ",", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`xVar", "=", 
                    
                    RowBox[{"VilTeX`Private`vars", "\[LeftDoubleBracket]", 
                    "1", "\[RightDoubleBracket]"}]}], ";", 
                    RowBox[{"VilTeX`Private`yVar", "=", 
                    
                    RowBox[{"VilTeX`Private`vars", "\[LeftDoubleBracket]", 
                    "2", "\[RightDoubleBracket]"}]}], ";"}], ",", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`xVar", "=", "VilTeX`Private`x"}], 
                    ";", 
                    RowBox[{"VilTeX`Private`yVar", "=", "VilTeX`Private`y"}], 
                    ";"}]}], "]"}], ";", 
                    RowBox[{"VilTeX`Private`xRange", "=", 
                    RowBox[{"{", 
                    RowBox[{"VilTeX`Private`xVar", ",", 
                    
                    RowBox[{"VilTeX`Private`xLimits", "\[LeftDoubleBracket]", 
                    "1", "\[RightDoubleBracket]"}], ",", 
                    
                    RowBox[{"VilTeX`Private`xLimits", "\[LeftDoubleBracket]", 
                    "2", "\[RightDoubleBracket]"}]}], "}"}]}], ";", 
                    RowBox[{"VilTeX`Private`yRange", "=", 
                    RowBox[{"{", 
                    RowBox[{"VilTeX`Private`yVar", ",", 
                    
                    RowBox[{"VilTeX`Private`yLimits", "\[LeftDoubleBracket]", 
                    "1", "\[RightDoubleBracket]"}], ",", 
                    
                    RowBox[{"VilTeX`Private`yLimits", "\[LeftDoubleBracket]", 
                    "2", "\[RightDoubleBracket]"}]}], "}"}]}], ";", 
                    RowBox[{"VilTeX`Private`currentData", "=", 
                    RowBox[{"VilTeX`Private`generateInequalityRegion", "[", 
                    
                    RowBox[{"VilTeX`Private`equation", ",", 
                    "VilTeX`Private`xRange", ",", "VilTeX`Private`yRange", 
                    ",", "VilTeX`Private`samples", ",", 
                    "VilTeX`Private`effectiveDensity"}], "]"}]}], ";"}]}], 
                    "]"}], ";", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    
                    RowBox[{"Length", "[", "VilTeX`Private`currentData", 
                    "]"}], ">", "0"}], ",", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`allLimits", "=", 
                    RowBox[{"Append", "[", 
                    RowBox[{"VilTeX`Private`allLimits", ",", 
                    
                    RowBox[{"VilTeX`Private`calculateLimits", "[", 
                    "VilTeX`Private`currentData", "]"}]}], "]"}]}], ";", 
                    RowBox[{"VilTeX`Private`allPlotData", "=", 
                    RowBox[{"Append", "[", 
                    RowBox[{"VilTeX`Private`allPlotData", ",", 
                    RowBox[{"{", 
                    
                    RowBox[{"VilTeX`Private`currentPlotType", ",", 
                    "VilTeX`Private`currentData", ",", 
                    "VilTeX`Private`currentGraph"}], "}"}]}], "]"}]}], ";", 
                    RowBox[{"VilTeX`Private`allValidData", "=", 
                    RowBox[{"Join", "[", 
                    
                    RowBox[{"VilTeX`Private`allValidData", ",", 
                    "VilTeX`Private`currentData"}], "]"}]}], ";"}]}], "]"}], 
                    ";"}], ",", 
                    
                    RowBox[{"VilTeX`Private`currentPlotType", "\[Equal]", 
                    "\"FunctionPlot\""}], ",", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`func", "=", 
                    
                    RowBox[{"VilTeX`Private`currentGraph", 
                    "\[LeftDoubleBracket]", "1", "\[RightDoubleBracket]"}]}], 
                    ";", 
                    RowBox[{"VilTeX`Private`xRange", "=", 
                    
                    RowBox[{"VilTeX`Private`currentGraph", 
                    "\[LeftDoubleBracket]", "2", "\[RightDoubleBracket]"}]}], 
                    ";", 
                    RowBox[{"Module", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    
                    RowBox[{"VilTeX`Private`xVar", ",", "VilTeX`Private`xMin",
                     ",", "VilTeX`Private`xMax", ",", "VilTeX`Private`xVals", 
                    ",", "VilTeX`Private`effectiveSamples"}], "}"}], ",", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"{", 
                    
                    RowBox[{"VilTeX`Private`xVar", ",", "VilTeX`Private`xMin",
                     ",", "VilTeX`Private`xMax"}], "}"}], "=", 
                    "VilTeX`Private`xRange"}], ";", 
                    RowBox[{"VilTeX`Private`effectiveSamples", "=", 
                    RowBox[{"Floor", "[", 
                    
                    RowBox[{"VilTeX`Private`samples", " ", 
                    "VilTeX`Private`effectiveDensity"}], "]"}]}], ";", 
                    RowBox[{"VilTeX`Private`xVals", "=", 
                    RowBox[{"Table", "[", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`xMin", "+", 
                    FractionBox[
                    RowBox[{
                    RowBox[{"(", 
                    
                    RowBox[{"VilTeX`Private`xMax", "-", 
                    "VilTeX`Private`xMin"}], ")"}], " ", "VilTeX`Private`i"}], 
                    RowBox[{"VilTeX`Private`effectiveSamples", "-", "1"}]]}], 
                    ",", 
                    RowBox[{"{", 
                    RowBox[{"VilTeX`Private`i", ",", "0", ",", 
                    RowBox[{"VilTeX`Private`effectiveSamples", "-", "1"}]}], 
                    "}"}]}], "]"}]}], ";", 
                    RowBox[{"Do", "[", 
                    RowBox[{
                    RowBox[{"Module", "[", 
                    RowBox[{
                    RowBox[{"{", "VilTeX`Private`yVal", "}"}], ",", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`yVal", "=", 
                    RowBox[{"VilTeX`Private`func", "/.", "\[VeryThinSpace]", 
                    RowBox[{"VilTeX`Private`xVar", "\[Rule]", 
                    
                    RowBox[{"VilTeX`Private`xVals", "\[LeftDoubleBracket]", 
                    "VilTeX`Private`i", "\[RightDoubleBracket]"}]}]}]}], ";", 
                    
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"NumericQ", "[", "VilTeX`Private`yVal", "]"}], 
                    "&&", 
                    RowBox[{"VilTeX`Private`validNumber", "[", 
                    "VilTeX`Private`yVal", "]"}]}], ",", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`currentData", "=", 
                    RowBox[{"Append", "[", 
                    RowBox[{"VilTeX`Private`currentData", ",", 
                    RowBox[{"{", 
                    RowBox[{
                    
                    RowBox[{"VilTeX`Private`xVals", "\[LeftDoubleBracket]", 
                    "VilTeX`Private`i", "\[RightDoubleBracket]"}], ",", 
                    "VilTeX`Private`yVal"}], "}"}]}], "]"}]}], ";"}]}], "]"}],
                     ";"}]}], "]"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"VilTeX`Private`i", ",", 
                    RowBox[{"Length", "[", "VilTeX`Private`xVals", "]"}]}], 
                    "}"}]}], "]"}], ";"}]}], "]"}], ";", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    
                    RowBox[{"Length", "[", "VilTeX`Private`currentData", 
                    "]"}], ">", "0"}], ",", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`allLimits", "=", 
                    RowBox[{"Append", "[", 
                    RowBox[{"VilTeX`Private`allLimits", ",", 
                    
                    RowBox[{"VilTeX`Private`calculateLimits", "[", 
                    "VilTeX`Private`currentData", "]"}]}], "]"}]}], ";", 
                    RowBox[{"VilTeX`Private`allPlotData", "=", 
                    RowBox[{"Append", "[", 
                    RowBox[{"VilTeX`Private`allPlotData", ",", 
                    RowBox[{"{", 
                    
                    RowBox[{"VilTeX`Private`currentPlotType", ",", 
                    "VilTeX`Private`currentData", ",", 
                    "VilTeX`Private`currentGraph"}], "}"}]}], "]"}]}], ";", 
                    RowBox[{"VilTeX`Private`allValidData", "=", 
                    RowBox[{"Join", "[", 
                    
                    RowBox[{"VilTeX`Private`allValidData", ",", 
                    "VilTeX`Private`currentData"}], "]"}]}], ";"}]}], "]"}], 
                    ";"}], ",", 
                    
                    RowBox[{"VilTeX`Private`currentPlotType", "\[Equal]", 
                    "\"ParametricCurve\""}], ",", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`paramFuncs", "=", 
                    
                    RowBox[{"VilTeX`Private`currentGraph", 
                    "\[LeftDoubleBracket]", "1", "\[RightDoubleBracket]"}]}], 
                    ";", 
                    RowBox[{"VilTeX`Private`tRange", "=", 
                    
                    RowBox[{"VilTeX`Private`currentGraph", 
                    "\[LeftDoubleBracket]", "2", "\[RightDoubleBracket]"}]}], 
                    ";", 
                    RowBox[{"Module", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    
                    RowBox[{"VilTeX`Private`tVar", ",", "VilTeX`Private`tMin",
                     ",", "VilTeX`Private`tMax", ",", "VilTeX`Private`tVals", 
                    ",", "VilTeX`Private`xFunc", ",", "VilTeX`Private`yFunc", 
                    ",", "VilTeX`Private`curvePoints"}], "}"}], ",", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"{", 
                    
                    RowBox[{"VilTeX`Private`tVar", ",", "VilTeX`Private`tMin",
                     ",", "VilTeX`Private`tMax"}], "}"}], "=", 
                    "VilTeX`Private`tRange"}], ";", 
                    RowBox[{
                    RowBox[{"{", 
                    
                    RowBox[{"VilTeX`Private`xFunc", ",", 
                    "VilTeX`Private`yFunc"}], "}"}], "=", 
                    "VilTeX`Private`paramFuncs"}], ";", 
                    RowBox[{"VilTeX`Private`curvePoints", "=", 
                    RowBox[{"If", "[", 
                    RowBox[{"VilTeX`Private`multipleGraphs", ",", 
                    RowBox[{"Min", "[", 
                    RowBox[{
                    RowBox[{"Floor", "[", 
                    
                    RowBox[{"VilTeX`Private`samples", " ", "2", " ", 
                    "VilTeX`Private`effectiveDensity"}], "]"}], ",", "200"}], 
                    "]"}], ",", 
                    RowBox[{"Floor", "[", 
                    
                    RowBox[{"VilTeX`Private`samples", " ", "2", " ", 
                    "VilTeX`Private`effectiveDensity"}], "]"}]}], "]"}]}], 
                    ";", 
                    RowBox[{"VilTeX`Private`tVals", "=", 
                    RowBox[{"Table", "[", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`tMin", "+", 
                    FractionBox[
                    RowBox[{
                    RowBox[{"(", 
                    
                    RowBox[{"VilTeX`Private`tMax", "-", 
                    "VilTeX`Private`tMin"}], ")"}], " ", "VilTeX`Private`i"}], 
                    RowBox[{"VilTeX`Private`curvePoints", "-", "1"}]]}], ",", 
                    
                    RowBox[{"{", 
                    RowBox[{"VilTeX`Private`i", ",", "0", ",", 
                    RowBox[{"VilTeX`Private`curvePoints", "-", "1"}]}], 
                    "}"}]}], "]"}]}], ";", 
                    RowBox[{"Do", "[", 
                    RowBox[{
                    RowBox[{"Module", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    
                    RowBox[{"VilTeX`Private`xVal", ",", 
                    "VilTeX`Private`yVal"}], "}"}], ",", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`xVal", "=", 
                    RowBox[{"VilTeX`Private`xFunc", "/.", "\[VeryThinSpace]", 
                    
                    RowBox[{"VilTeX`Private`tVar", "\[Rule]", 
                    
                    RowBox[{"VilTeX`Private`tVals", "\[LeftDoubleBracket]", 
                    "VilTeX`Private`i", "\[RightDoubleBracket]"}]}]}]}], ";", 
                    
                    RowBox[{"VilTeX`Private`yVal", "=", 
                    
                    RowBox[{"VilTeX`Private`yFunc", "/.", "\[VeryThinSpace]", 
                    
                    RowBox[{"VilTeX`Private`tVar", "\[Rule]", 
                    
                    RowBox[{"VilTeX`Private`tVals", "\[LeftDoubleBracket]", 
                    "VilTeX`Private`i", "\[RightDoubleBracket]"}]}]}]}], ";", 
                    
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"AllTrue", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    
                    RowBox[{"VilTeX`Private`xVal", ",", 
                    "VilTeX`Private`yVal"}], "}"}], ",", "NumericQ"}], "]"}], 
                    "&&", 
                    RowBox[{"AllTrue", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    
                    RowBox[{"VilTeX`Private`xVal", ",", 
                    "VilTeX`Private`yVal"}], "}"}], ",", 
                    "VilTeX`Private`validNumber"}], "]"}]}], ",", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`currentData", "=", 
                    RowBox[{"Append", "[", 
                    RowBox[{"VilTeX`Private`currentData", ",", 
                    RowBox[{"{", 
                    
                    RowBox[{"VilTeX`Private`xVal", ",", 
                    "VilTeX`Private`yVal"}], "}"}]}], "]"}]}], ";"}]}], "]"}],
                     ";"}]}], "]"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"VilTeX`Private`i", ",", 
                    RowBox[{"Length", "[", "VilTeX`Private`tVals", "]"}]}], 
                    "}"}]}], "]"}], ";"}]}], "]"}], ";", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    
                    RowBox[{"Length", "[", "VilTeX`Private`currentData", 
                    "]"}], ">", "0"}], ",", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`allLimits", "=", 
                    RowBox[{"Append", "[", 
                    RowBox[{"VilTeX`Private`allLimits", ",", 
                    
                    RowBox[{"VilTeX`Private`calculateLimits", "[", 
                    "VilTeX`Private`currentData", "]"}]}], "]"}]}], ";", 
                    RowBox[{"VilTeX`Private`allPlotData", "=", 
                    RowBox[{"Append", "[", 
                    RowBox[{"VilTeX`Private`allPlotData", ",", 
                    RowBox[{"{", 
                    
                    RowBox[{"VilTeX`Private`currentPlotType", ",", 
                    "VilTeX`Private`currentData", ",", 
                    "VilTeX`Private`currentGraph"}], "}"}]}], "]"}]}], ";", 
                    RowBox[{"VilTeX`Private`allValidData", "=", 
                    RowBox[{"Join", "[", 
                    
                    RowBox[{"VilTeX`Private`allValidData", ",", 
                    "VilTeX`Private`currentData"}], "]"}]}], ";"}]}], "]"}], 
                    ";"}], ",", 
                    
                    RowBox[{"VilTeX`Private`currentPlotType", "\[Equal]", 
                    "\"Points\""}], ",", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`currentData", "=", 
                    RowBox[{"Select", "[", 
                    RowBox[{"VilTeX`Private`currentGraph", ",", 
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    RowBox[{"Length", "[", "#1", "]"}], "\[Equal]", "2"}], 
                    "&&", 
                    RowBox[{"AllTrue", "[", 
                    RowBox[{"#1", ",", "VilTeX`Private`validNumber"}], 
                    "]"}]}], "&"}]}], "]"}]}], ";", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    
                    RowBox[{"Length", "[", "VilTeX`Private`currentData", 
                    "]"}], ">", "0"}], ",", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`allLimits", "=", 
                    RowBox[{"Append", "[", 
                    RowBox[{"VilTeX`Private`allLimits", ",", 
                    RowBox[{"VilTeX`Private`calculateLimits", "[", 
                    "VilTeX`Private`currentData", "]"}]}], "]"}]}], ";", 
                    RowBox[{"VilTeX`Private`allPlotData", "=", 
                    RowBox[{"Append", "[", 
                    RowBox[{"VilTeX`Private`allPlotData", ",", 
                    RowBox[{"{", 
                    
                    RowBox[{"VilTeX`Private`currentPlotType", ",", 
                    "VilTeX`Private`currentData", ",", 
                    "VilTeX`Private`currentGraph"}], "}"}]}], "]"}]}], ";", 
                    RowBox[{"VilTeX`Private`allValidData", "=", 
                    RowBox[{"Join", "[", 
                    
                    RowBox[{"VilTeX`Private`allValidData", ",", 
                    "VilTeX`Private`currentData"}], "]"}]}], ";"}]}], "]"}], 
                    ";"}]}], "]"}], ";"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"VilTeX`Private`graphIdx", ",", 
                    
                    RowBox[{"Length", "[", "VilTeX`Private`graphList", 
                    "]"}]}], "}"}]}], "]"}], ";", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    
                    RowBox[{"Length", "[", "VilTeX`Private`allValidData", 
                    "]"}], "\[Equal]", "0"}], ",", 
                    RowBox[{
                    
                    RowBox[{"Print", "[", 
                    "\"Error: No se generaron datos v\[AAcute]lidos para ning\
\[UAcute]n gr\[AAcute]fico\"", "]"}], ";", 
                    RowBox[{"Return", "[", "$Failed", "]"}], ";"}]}], "]"}], 
                    ";", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Length", "[", "VilTeX`Private`allLimits", "]"}], 
                    ">", "0"}], ",", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`globalLimits", "=", 
                    
                    RowBox[{"VilTeX`Private`combineGlobalLimits", "[", 
                    "VilTeX`Private`allLimits", "]"}]}], ";"}], ",", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`globalLimits", "=", 
                    RowBox[{"{", 
                    RowBox[{
                    
                    RowBox[{"VilTeX`Private`xLimits", "\[LeftDoubleBracket]", 
                    "1", "\[RightDoubleBracket]"}], ",", 
                    
                    RowBox[{"VilTeX`Private`xLimits", "\[LeftDoubleBracket]", 
                    "2", "\[RightDoubleBracket]"}], ",", 
                    
                    RowBox[{"VilTeX`Private`yLimits", "\[LeftDoubleBracket]", 
                    "1", "\[RightDoubleBracket]"}], ",", 
                    
                    RowBox[{"VilTeX`Private`yLimits", "\[LeftDoubleBracket]", 
                    "2", "\[RightDoubleBracket]"}]}], "}"}]}], ";"}]}], "]"}],
                     ";", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`xmin", "=!=", "Automatic"}], ",", 
                    
                    RowBox[{
                    
                    RowBox[{"VilTeX`Private`globalLimits", 
                    "\[LeftDoubleBracket]", "1", "\[RightDoubleBracket]"}], 
                    "=", "VilTeX`Private`xmin"}]}], "]"}], ";", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`xmax", "=!=", "Automatic"}], ",", 
                    
                    RowBox[{
                    
                    RowBox[{"VilTeX`Private`globalLimits", 
                    "\[LeftDoubleBracket]", "2", "\[RightDoubleBracket]"}], 
                    "=", "VilTeX`Private`xmax"}]}], "]"}], ";", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`ymin", "=!=", "Automatic"}], ",", 
                    
                    RowBox[{
                    
                    RowBox[{"VilTeX`Private`globalLimits", 
                    "\[LeftDoubleBracket]", "3", "\[RightDoubleBracket]"}], 
                    "=", "VilTeX`Private`ymin"}]}], "]"}], ";", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`ymax", "=!=", "Automatic"}], ",", 
                    
                    RowBox[{
                    
                    RowBox[{"VilTeX`Private`globalLimits", 
                    "\[LeftDoubleBracket]", "4", "\[RightDoubleBracket]"}], 
                    "=", "VilTeX`Private`ymax"}]}], "]"}], ";", 
                    RowBox[{"VilTeX`Private`folderName", "=", 
                    RowBox[{"FileBaseName", "[", "VilTeX`Private`filename", 
                    "]"}]}], ";", 
                    RowBox[{"VilTeX`Private`folderPath", "=", 
                    RowBox[{"FileNameJoin", "[", 
                    RowBox[{"{", 
                    
                    RowBox[{"$HomeDirectory", ",", "\"Downloads\"", ",", 
                    "VilTeX`Private`folderName"}], "}"}], "]"}]}], ";", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"!", 
                    
                    RowBox[{"DirectoryQ", "[", "VilTeX`Private`folderPath", 
                    "]"}]}], ",", 
                    
                    RowBox[{"CreateDirectory", "[", 
                    "VilTeX`Private`folderPath", "]"}]}], "]"}], ";", 
                    RowBox[{"VilTeX`Private`downloadPath", "=", 
                    RowBox[{"FileNameJoin", "[", 
                    RowBox[{"{", 
                    
                    RowBox[{"VilTeX`Private`folderPath", ",", 
                    "VilTeX`Private`filename"}], "}"}], "]"}]}], ";", 
                    RowBox[{"VilTeX`Private`combinedTikzCode", "=", "\"\""}], 
                    ";", 
                    RowBox[{"Do", "[", 
                    RowBox[{
                    RowBox[{"Module", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    
                    RowBox[{"VilTeX`Private`plotType", ",", 
                    "VilTeX`Private`graphData", ",", 
                    "VilTeX`Private`graphArgs", ",", 
                    "VilTeX`Private`tikzPlot", ",", 
                    "VilTeX`Private`validPoints", ",", 
                    "VilTeX`Private`plotStyle", ",", 
                    "VilTeX`Private`currentColor", ",", 
                    "VilTeX`Private`currentStyle"}], "}"}], ",", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"{", 
                    
                    RowBox[{"VilTeX`Private`plotType", ",", 
                    "VilTeX`Private`graphData", ",", 
                    "VilTeX`Private`graphArgs"}], "}"}], "=", 
                    
                    RowBox[{"VilTeX`Private`allPlotData", 
                    "\[LeftDoubleBracket]", "VilTeX`Private`plotIdx", 
                    "\[RightDoubleBracket]"}]}], ";", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    RowBox[{"Length", "[", "VilTeX`Private`styles", "]"}], 
                    "\[GreaterEqual]", "VilTeX`Private`plotIdx"}], "&&", 
                    RowBox[{"ListQ", "[", 
                    
                    RowBox[{"VilTeX`Private`styles", "\[LeftDoubleBracket]", 
                    "VilTeX`Private`plotIdx", "\[RightDoubleBracket]"}], 
                    "]"}]}], ",", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`currentStyle", "=", 
                    
                    RowBox[{"VilTeX`Private`styles", "\[LeftDoubleBracket]", 
                    "VilTeX`Private`plotIdx", "\[RightDoubleBracket]"}]}], 
                    ";"}], ",", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`currentStyle", "=", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`multipleGraphs", "&&", 
                    RowBox[{"VilTeX`Private`plotIdx", "\[LessEqual]", 
                    RowBox[{"Length", "[", "VilTeX`Private`colors", "]"}]}]}],
                     ",", 
                    RowBox[{"{", 
                    RowBox[{"\"solid\"", ",", 
                    
                    RowBox[{"VilTeX`Private`colors", "\[LeftDoubleBracket]", 
                    "VilTeX`Private`plotIdx", "\[RightDoubleBracket]"}]}], 
                    "}"}], ",", "VilTeX`Private`defaultStyles"}], "]"}]}], 
                    ";"}]}], "]"}], ";", 
                    RowBox[{"VilTeX`Private`currentColor", "=", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    
                    RowBox[{"Length", "[", "VilTeX`Private`currentStyle", 
                    "]"}], "\[GreaterEqual]", "2"}], ",", 
                    
                    RowBox[{"VilTeX`Private`currentStyle", 
                    "\[LeftDoubleBracket]", "2", "\[RightDoubleBracket]"}], 
                    ",", 
                    
                    RowBox[{"VilTeX`Private`defaultStyles", 
                    "\[LeftDoubleBracket]", "2", "\[RightDoubleBracket]"}]}], 
                    "]"}]}], ";", 
                    RowBox[{"VilTeX`Private`plotStyle", "=", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    
                    RowBox[{"Length", "[", "VilTeX`Private`currentStyle", 
                    "]"}], "\[GreaterEqual]", "1"}], ",", 
                    
                    RowBox[{"VilTeX`Private`currentStyle", 
                    "\[LeftDoubleBracket]", "1", "\[RightDoubleBracket]"}], 
                    ",", 
                    
                    RowBox[{"VilTeX`Private`defaultStyles", 
                    "\[LeftDoubleBracket]", "1", "\[RightDoubleBracket]"}]}], 
                    "]"}]}], ";", 
                    RowBox[{"Which", "[", 
                    RowBox[{
                    
                    RowBox[{"VilTeX`Private`plotType", "\[Equal]", 
                    "\"ImplicitCurve\""}], ",", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`validPoints", "=", 
                    RowBox[{"Select", "[", 
                    RowBox[{"VilTeX`Private`graphData", ",", 
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    RowBox[{"Length", "[", "#1", "]"}], "\[Equal]", "2"}], 
                    "&&", 
                    RowBox[{"AllTrue", "[", 
                    RowBox[{"#1", ",", "VilTeX`Private`validNumber"}], 
                    "]"}]}], "&"}]}], "]"}]}], ";", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    
                    RowBox[{"Length", "[", "VilTeX`Private`validPoints", 
                    "]"}], ">", "0"}], ",", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`plotStyle", "=", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    
                    RowBox[{"Length", "[", "VilTeX`Private`validPoints", 
                    "]"}], ">", "2000"}], ",", 
                    "\"only marks, mark=*, mark size=0.5pt\"", ",", 
                    "\"only marks, mark=*, mark size=0.8pt\""}], "]"}]}], ";", 
                    RowBox[{"VilTeX`Private`tikzPlot", "=", 
                    
                    RowBox[{"\"\\\\addplot[\"", "<>", 
                    "VilTeX`Private`currentColor", "<>", "\", \"", "<>", 
                    "VilTeX`Private`plotStyle", "<>", 
                    "VilTeX`Private`opacityStyle", "<>", 
                    "\"] coordinates {\\n\"", "<>", 
                    RowBox[{"StringRiffle", "[", 
                    RowBox[{
                    RowBox[{"Table", "[", 
                    RowBox[{
                    RowBox[{"\"  (\"", "<>", 
                    RowBox[{"VilTeX`Private`formatNumber", "[", 
                    
                    RowBox[{"VilTeX`Private`validPoints", 
                    "\[LeftDoubleBracket]", 
                    RowBox[{"VilTeX`Private`i", ",", "1"}], 
                    "\[RightDoubleBracket]"}], "]"}], "<>", "\",\"", "<>", 
                    RowBox[{"VilTeX`Private`formatNumber", "[", 
                    
                    RowBox[{"VilTeX`Private`validPoints", 
                    "\[LeftDoubleBracket]", 
                    RowBox[{"VilTeX`Private`i", ",", "2"}], 
                    "\[RightDoubleBracket]"}], "]"}], "<>", "\")\""}], ",", 
                    RowBox[{"{", 
                    RowBox[{"VilTeX`Private`i", ",", 
                    
                    RowBox[{"Length", "[", "VilTeX`Private`validPoints", 
                    "]"}]}], "}"}]}], "]"}], ",", "\"\\n\""}], "]"}], "<>", 
                    "\"\\n};\\n\""}]}], ";", 
                    RowBox[{"VilTeX`Private`combinedTikzCode", "=", 
                    
                    RowBox[{"VilTeX`Private`combinedTikzCode", "<>", 
                    "VilTeX`Private`tikzPlot"}]}], ";"}]}], "]"}], ";"}], ",", 
                    
                    RowBox[{"VilTeX`Private`plotType", "\[Equal]", 
                    "\"InequalityRegion\""}], ",", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`validPoints", "=", 
                    RowBox[{"Select", "[", 
                    RowBox[{"VilTeX`Private`graphData", ",", 
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    RowBox[{"Length", "[", "#1", "]"}], "\[Equal]", "2"}], 
                    "&&", 
                    RowBox[{"AllTrue", "[", 
                    RowBox[{"#1", ",", "VilTeX`Private`validNumber"}], 
                    "]"}]}], "&"}]}], "]"}]}], ";", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Length", "[", "VilTeX`Private`validPoints", 
                    "]"}], ">", "0"}], ",", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`tikzPlot", "=", 
                    
                    RowBox[{"\"\\\\addplot[\"", "<>", 
                    "VilTeX`Private`currentColor", "<>", "\", \"", "<>", 
                    "VilTeX`Private`plotStyle", "<>", 
                    "\", only marks, mark=*, mark size=0.3pt, opacity=\"", 
                    "<>", 
                    RowBox[{"ToString", "[", "VilTeX`Private`fillOpacity", 
                    "]"}], "<>", "\"] coordinates {\\n\"", "<>", 
                    RowBox[{"StringRiffle", "[", 
                    RowBox[{
                    RowBox[{"Table", "[", 
                    RowBox[{
                    RowBox[{"\"  (\"", "<>", 
                    RowBox[{"VilTeX`Private`formatNumber", "[", 
                    
                    RowBox[{"VilTeX`Private`validPoints", 
                    "\[LeftDoubleBracket]", 
                    RowBox[{"VilTeX`Private`i", ",", "1"}], 
                    "\[RightDoubleBracket]"}], "]"}], "<>", "\",\"", "<>", 
                    RowBox[{"VilTeX`Private`formatNumber", "[", 
                    
                    RowBox[{"VilTeX`Private`validPoints", 
                    "\[LeftDoubleBracket]", 
                    RowBox[{"VilTeX`Private`i", ",", "2"}], 
                    "\[RightDoubleBracket]"}], "]"}], "<>", "\")\""}], ",", 
                    RowBox[{"{", 
                    RowBox[{"VilTeX`Private`i", ",", 
                    
                    RowBox[{"Length", "[", "VilTeX`Private`validPoints", 
                    "]"}]}], "}"}]}], "]"}], ",", "\"\\n\""}], "]"}], "<>", 
                    "\"\\n};\\n\""}]}], ";", 
                    RowBox[{"VilTeX`Private`combinedTikzCode", "=", 
                    
                    RowBox[{"VilTeX`Private`combinedTikzCode", "<>", 
                    "VilTeX`Private`tikzPlot"}]}], ";"}]}], "]"}], ";"}], ",", 
                    RowBox[{
                    
                    RowBox[{"VilTeX`Private`plotType", "\[Equal]", 
                    "\"FunctionPlot\""}], "||", 
                    
                    RowBox[{"VilTeX`Private`plotType", "\[Equal]", 
                    "\"ParametricCurve\""}]}], ",", 
                    RowBox[{
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Length", "[", "VilTeX`Private`graphData", "]"}], 
                    ">", "0"}], ",", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`tikzPlot", "=", 
                    
                    RowBox[{"\"\\\\addplot[\"", "<>", 
                    "VilTeX`Private`currentColor", "<>", "\", \"", "<>", 
                    "VilTeX`Private`plotStyle", "<>", 
                    "\", thick, smooth] coordinates {\\n\"", "<>", 
                    RowBox[{"StringRiffle", "[", 
                    RowBox[{
                    RowBox[{"Table", "[", 
                    RowBox[{
                    RowBox[{"\"  (\"", "<>", 
                    RowBox[{"VilTeX`Private`formatNumber", "[", 
                    
                    RowBox[{"VilTeX`Private`graphData", 
                    "\[LeftDoubleBracket]", 
                    RowBox[{"VilTeX`Private`i", ",", "1"}], 
                    "\[RightDoubleBracket]"}], "]"}], "<>", "\",\"", "<>", 
                    RowBox[{"VilTeX`Private`formatNumber", "[", 
                    
                    RowBox[{"VilTeX`Private`graphData", 
                    "\[LeftDoubleBracket]", 
                    RowBox[{"VilTeX`Private`i", ",", "2"}], 
                    "\[RightDoubleBracket]"}], "]"}], "<>", "\")\""}], ",", 
                    RowBox[{"{", 
                    RowBox[{"VilTeX`Private`i", ",", 
                    
                    RowBox[{"Length", "[", "VilTeX`Private`graphData", 
                    "]"}]}], "}"}]}], "]"}], ",", "\"\\n\""}], "]"}], "<>", 
                    "\"\\n};\\n\""}]}], ";", 
                    RowBox[{"VilTeX`Private`combinedTikzCode", "=", 
                    
                    RowBox[{"VilTeX`Private`combinedTikzCode", "<>", 
                    "VilTeX`Private`tikzPlot"}]}], ";"}]}], "]"}], ";"}], ",", 
                    
                    RowBox[{"VilTeX`Private`plotType", "\[Equal]", 
                    "\"Points\""}], ",", 
                    RowBox[{
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Length", "[", "VilTeX`Private`graphData", "]"}], 
                    ">", "0"}], ",", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`tikzPlot", "=", 
                    
                    RowBox[{"\"\\\\addplot[\"", "<>", 
                    "VilTeX`Private`currentColor", "<>", 
                    "\", only marks, mark=*, mark size=2pt] coordinates \
{\\n\"", "<>", 
                    RowBox[{"StringRiffle", "[", 
                    RowBox[{
                    RowBox[{"Table", "[", 
                    RowBox[{
                    RowBox[{"\"  (\"", "<>", 
                    RowBox[{"VilTeX`Private`formatNumber", "[", 
                    
                    RowBox[{"VilTeX`Private`graphData", 
                    "\[LeftDoubleBracket]", 
                    RowBox[{"VilTeX`Private`i", ",", "1"}], 
                    "\[RightDoubleBracket]"}], "]"}], "<>", "\",\"", "<>", 
                    RowBox[{"VilTeX`Private`formatNumber", "[", 
                    
                    RowBox[{"VilTeX`Private`graphData", 
                    "\[LeftDoubleBracket]", 
                    RowBox[{"VilTeX`Private`i", ",", "2"}], 
                    "\[RightDoubleBracket]"}], "]"}], "<>", "\")\""}], ",", 
                    RowBox[{"{", 
                    RowBox[{"VilTeX`Private`i", ",", 
                    
                    RowBox[{"Length", "[", "VilTeX`Private`graphData", 
                    "]"}]}], "}"}]}], "]"}], ",", "\"\\n\""}], "]"}], "<>", 
                    "\"\\n};\\n\""}]}], ";", 
                    RowBox[{"VilTeX`Private`combinedTikzCode", "=", 
                    
                    RowBox[{"VilTeX`Private`combinedTikzCode", "<>", 
                    "VilTeX`Private`tikzPlot"}]}], ";"}]}], "]"}], ";"}]}], 
                    "]"}], ";"}]}], "]"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"VilTeX`Private`plotIdx", ",", 
                    
                    RowBox[{"Length", "[", "VilTeX`Private`allPlotData", 
                    "]"}]}], "}"}]}], "]"}], ";", 
                    RowBox[{"VilTeX`Private`textTikzCode", "=", "\"\""}], ";", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Length", "[", "VilTeX`Private`texto", "]"}], ">",
                     "0"}], ",", 
                    RowBox[{
                    RowBox[{"Module", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"VilTeX`Private`processedAnnotations", "=", 
                    RowBox[{"{", "}"}]}], "}"}], ",", 
                    RowBox[{
                    RowBox[{"Do", "[", 
                    RowBox[{
                    RowBox[{"Module", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    
                    RowBox[{"VilTeX`Private`annotation", ",", 
                    "VilTeX`Private`text", ",", "VilTeX`Private`coords", ",", 
                    "VilTeX`Private`options", ",", "VilTeX`Private`xPos", ",",
                     "VilTeX`Private`yPos", ",", "VilTeX`Private`textOptions",
                     ",", "VilTeX`Private`validCoords"}], "}"}], ",", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`annotation", "=", 
                    
                    RowBox[{"VilTeX`Private`texto", "\[LeftDoubleBracket]", 
                    "VilTeX`Private`i", "\[RightDoubleBracket]"}]}], ";", 
                    RowBox[{"VilTeX`Private`text", "=", "\"\""}], ";", 
                    RowBox[{"VilTeX`Private`textOptions", "=", "\"\""}], ";", 
                    
                    RowBox[{"VilTeX`Private`validCoords", "=", "False"}], ";", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"ListQ", "[", "VilTeX`Private`annotation", "]"}], 
                    "&&", 
                    RowBox[{
                    RowBox[{"Length", "[", "VilTeX`Private`annotation", "]"}],
                     "\[GreaterEqual]", "2"}]}], ",", 
                    RowBox[{
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"StringQ", "[", 
                    
                    RowBox[{"VilTeX`Private`annotation", 
                    "\[LeftDoubleBracket]", "1", "\[RightDoubleBracket]"}], 
                    "]"}], ",", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`text", "=", 
                    
                    RowBox[{"VilTeX`Private`annotation", 
                    "\[LeftDoubleBracket]", "1", "\[RightDoubleBracket]"}]}], 
                    ";"}]}], "]"}], ";", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"ListQ", "[", 
                    
                    RowBox[{"VilTeX`Private`annotation", 
                    "\[LeftDoubleBracket]", "2", "\[RightDoubleBracket]"}], 
                    "]"}], "&&", 
                    RowBox[{
                    RowBox[{"Length", "[", 
                    
                    RowBox[{"VilTeX`Private`annotation", 
                    "\[LeftDoubleBracket]", "2", "\[RightDoubleBracket]"}], 
                    "]"}], "\[Equal]", "2"}]}], ",", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`coords", "=", 
                    
                    RowBox[{"VilTeX`Private`annotation", 
                    "\[LeftDoubleBracket]", "2", "\[RightDoubleBracket]"}]}], 
                    ";", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"AllTrue", "[", 
                    RowBox[{"VilTeX`Private`coords", ",", "NumericQ"}], "]"}],
                     ",", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"{", 
                    
                    RowBox[{"VilTeX`Private`xPos", ",", 
                    "VilTeX`Private`yPos"}], "}"}], "=", 
                    RowBox[{"N", "[", "VilTeX`Private`coords", "]"}]}], ";", 
                    RowBox[{"VilTeX`Private`validCoords", "=", "True"}], 
                    ";"}]}], "]"}], ";"}]}], "]"}], ";", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    RowBox[{"Length", "[", "VilTeX`Private`annotation", "]"}],
                     "\[GreaterEqual]", "3"}], "&&", 
                    RowBox[{"ListQ", "[", 
                    
                    RowBox[{"VilTeX`Private`annotation", 
                    "\[LeftDoubleBracket]", "3", "\[RightDoubleBracket]"}], 
                    "]"}]}], ",", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`options", "=", 
                    
                    RowBox[{"VilTeX`Private`annotation", 
                    "\[LeftDoubleBracket]", "3", "\[RightDoubleBracket]"}]}], 
                    ";", 
                    RowBox[{"Do", "[", 
                    RowBox[{
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"ListQ", "[", 
                    
                    RowBox[{"VilTeX`Private`options", "\[LeftDoubleBracket]", 
                    "VilTeX`Private`j", "\[RightDoubleBracket]"}], "]"}], 
                    "&&", 
                    RowBox[{
                    RowBox[{"Length", "[", 
                    
                    RowBox[{"VilTeX`Private`options", "\[LeftDoubleBracket]", 
                    "VilTeX`Private`j", "\[RightDoubleBracket]"}], "]"}], 
                    "\[GreaterEqual]", "2"}]}], ",", 
                    RowBox[{
                    RowBox[{"Module", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"VilTeX`Private`key", ",", "VilTeX`Private`val"}],
                     "}"}], ",", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`key", "=", 
                    RowBox[{"ToString", "[", 
                    RowBox[{
                    
                    RowBox[{"VilTeX`Private`options", "\[LeftDoubleBracket]", 
                    "VilTeX`Private`j", "\[RightDoubleBracket]"}], 
                    "\[LeftDoubleBracket]", "1", "\[RightDoubleBracket]"}], 
                    "]"}]}], ";", 
                    RowBox[{"VilTeX`Private`val", "=", 
                    RowBox[{"ToString", "[", 
                    RowBox[{
                    
                    RowBox[{"VilTeX`Private`options", "\[LeftDoubleBracket]", 
                    "VilTeX`Private`j", "\[RightDoubleBracket]"}], 
                    "\[LeftDoubleBracket]", "2", "\[RightDoubleBracket]"}], 
                    "]"}]}], ";", 
                    RowBox[{"Which", "[", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`key", "\[Equal]", "\"color\""}], 
                    ",", 
                    RowBox[{"VilTeX`Private`textOptions", "=", 
                    
                    RowBox[{"VilTeX`Private`textOptions", "<>", "\"text=\"", 
                    "<>", "VilTeX`Private`val", "<>", "\",\""}]}], ",", 
                    RowBox[{"VilTeX`Private`key", "\[Equal]", "\"size\""}], 
                    ",", 
                    RowBox[{"VilTeX`Private`textOptions", "=", 
                    
                    RowBox[{"VilTeX`Private`textOptions", "<>", "\"font=\"", 
                    "<>", "VilTeX`Private`val", "<>", "\",\""}]}], ",", 
                    RowBox[{"VilTeX`Private`key", "\[Equal]", "\"anchor\""}], 
                    ",", 
                    RowBox[{"VilTeX`Private`textOptions", "=", 
                    
                    RowBox[{"VilTeX`Private`textOptions", "<>", 
                    "\"anchor=\"", "<>", "VilTeX`Private`val", "<>", 
                    "\",\""}]}], ",", 
                    RowBox[{"VilTeX`Private`key", "\[Equal]", "\"rotate\""}], 
                    ",", 
                    RowBox[{"VilTeX`Private`textOptions", "=", 
                    
                    RowBox[{"VilTeX`Private`textOptions", "<>", 
                    "\"rotate=\"", "<>", "VilTeX`Private`val", "<>", 
                    "\",\""}]}], ",", "True", ",", 
                    RowBox[{"VilTeX`Private`textOptions", "=", 
                    
                    RowBox[{"VilTeX`Private`textOptions", "<>", 
                    "VilTeX`Private`key", "<>", "\"=\"", "<>", 
                    "VilTeX`Private`val", "<>", "\",\""}]}]}], "]"}], ";"}]}],
                     "]"}], ";"}]}], "]"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"VilTeX`Private`j", ",", 
                    RowBox[{"Length", "[", "VilTeX`Private`options", "]"}]}], 
                    "}"}]}], "]"}], ";"}]}], "]"}], ";"}]}], "]"}], ";", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"StringQ", "[", "VilTeX`Private`text", "]"}], 
                    "&&", 
                    RowBox[{"VilTeX`Private`text", "\[NotEqual]", "\"\""}], 
                    "&&", "VilTeX`Private`validCoords", "&&", 
                    RowBox[{"AllTrue", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    
                    RowBox[{"VilTeX`Private`xPos", ",", 
                    "VilTeX`Private`yPos"}], "}"}], ",", "NumericQ"}], 
                    "]"}]}], ",", 
                    RowBox[{
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    
                    RowBox[{"StringLength", "[", "VilTeX`Private`textOptions",
                     "]"}], ">", "0"}], "&&", 
                    RowBox[{
                    RowBox[{"StringTake", "[", 
                    RowBox[{"VilTeX`Private`textOptions", ",", 
                    RowBox[{"-", "1"}]}], "]"}], "\[Equal]", "\",\""}]}], ",", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`textOptions", "=", 
                    RowBox[{"StringDrop", "[", 
                    RowBox[{"VilTeX`Private`textOptions", ",", 
                    RowBox[{"-", "1"}]}], "]"}]}], ";"}]}], "]"}], ";", 
                    RowBox[{"AppendTo", "[", 
                    RowBox[{"VilTeX`Private`processedAnnotations", ",", 
                    RowBox[{"{", 
                    
                    RowBox[{"VilTeX`Private`text", ",", "VilTeX`Private`xPos",
                     ",", "VilTeX`Private`yPos", ",", 
                    "VilTeX`Private`textOptions"}], "}"}]}], "]"}], ";"}]}], 
                    "]"}], ";"}]}], "]"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"VilTeX`Private`i", ",", 
                    RowBox[{"Length", "[", "VilTeX`Private`texto", "]"}]}], 
                    "}"}]}], "]"}], ";", 
                    RowBox[{"Do", "[", 
                    RowBox[{
                    RowBox[{"Module", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    
                    RowBox[{"VilTeX`Private`text", ",", "VilTeX`Private`x", 
                    ",", "VilTeX`Private`y", ",", "VilTeX`Private`opts"}], 
                    "}"}], ",", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"{", 
                    
                    RowBox[{"VilTeX`Private`text", ",", "VilTeX`Private`x", 
                    ",", "VilTeX`Private`y", ",", "VilTeX`Private`opts"}], 
                    "}"}], "=", 
                    
                    RowBox[{"VilTeX`Private`processedAnnotations", 
                    "\[LeftDoubleBracket]", "VilTeX`Private`j", 
                    "\[RightDoubleBracket]"}]}], ";", 
                    RowBox[{"VilTeX`Private`textTikzCode", "=", 
                    RowBox[{"VilTeX`Private`textTikzCode", "<>", 
                    "\"\\\\node[\"", "<>", "VilTeX`Private`opts", "<>", 
                    "\"] at (axis cs:\"", "<>", 
                    
                    RowBox[{"VilTeX`Private`formatNumber", "[", 
                    "VilTeX`Private`x", "]"}], "<>", "\",\"", "<>", 
                    
                    RowBox[{"VilTeX`Private`formatNumber", "[", 
                    "VilTeX`Private`y", "]"}], "<>", "\") {\"", "<>", 
                    "VilTeX`Private`text", "<>", "\"};\\n\""}]}], ";"}]}], 
                    "]"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"VilTeX`Private`j", ",", 
                    
                    RowBox[{"Length", "[", 
                    "VilTeX`Private`processedAnnotations", "]"}]}], "}"}]}], 
                    "]"}], ";"}]}], "]"}], ";"}]}], "]"}], ";", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    
                    RowBox[{"StringLength", "[", 
                    "VilTeX`Private`combinedTikzCode", "]"}], "<", "10"}], 
                    ",", 
                    RowBox[{
                    
                    RowBox[{"Print", "[", 
                    "\"Error: No se gener\[OAcute] c\[OAcute]digo TikZ v\
\[AAcute]lido\"", "]"}], ";", 
                    RowBox[{"Return", "[", "$Failed", "]"}], ";"}]}], "]"}], 
                    ";", 
                    RowBox[{"VilTeX`Private`tikzCode", "=", 
                    
                    RowBox[{"\"\\\\begin{tikzpicture}\\n\"", "<>", 
                    "\"\\\\begin{axis}[\\n\"", "<>", "\"  xlabel={$x$},\\n\"",
                     "<>", "\"  ylabel={$y$},\\n\"", "<>", 
                    RowBox[{"If", "[", 
                    
                    RowBox[{"VilTeX`Private`grid", ",", 
                    "\"  grid=major,\\n\"", ",", "\"\""}], "]"}], "<>", 
                    "\"  \"", "<>", "VilTeX`Private`axisConfiguration", "<>", 
                    "\",\\n\"", "<>", "\"  xmin=\"", "<>", 
                    RowBox[{"VilTeX`Private`formatNumber", "[", 
                    
                    RowBox[{"VilTeX`Private`globalLimits", 
                    "\[LeftDoubleBracket]", "1", "\[RightDoubleBracket]"}], 
                    "]"}], "<>", "\", xmax=\"", "<>", 
                    RowBox[{"VilTeX`Private`formatNumber", "[", 
                    
                    RowBox[{"VilTeX`Private`globalLimits", 
                    "\[LeftDoubleBracket]", "2", "\[RightDoubleBracket]"}], 
                    "]"}], "<>", "\",\\n\"", "<>", "\"  ymin=\"", "<>", 
                    RowBox[{"VilTeX`Private`formatNumber", "[", 
                    
                    RowBox[{"VilTeX`Private`globalLimits", 
                    "\[LeftDoubleBracket]", "3", "\[RightDoubleBracket]"}], 
                    "]"}], "<>", "\", ymax=\"", "<>", 
                    RowBox[{"VilTeX`Private`formatNumber", "[", 
                    
                    RowBox[{"VilTeX`Private`globalLimits", 
                    "\[LeftDoubleBracket]", "4", "\[RightDoubleBracket]"}], 
                    "]"}], "<>", "\",\\n\"", "<>", 
                    "\"  axis equal=false,\\n\"", "<>", "\"  samples=50\\n\"",
                     "<>", "\"]\\n\"", "<>", 
                    "VilTeX`Private`combinedTikzCode", "<>", 
                    "VilTeX`Private`textTikzCode", "<>", 
                    "\"\\\\end{axis}\\n\"", "<>", 
                    "\"\\\\end{tikzpicture}\""}]}], ";", 
                    RowBox[{"VilTeX`Private`fullDocument", "=", 
                    
                    RowBox[{
                    "\"\\\\documentclass[border=5mm]{standalone}\\n\"", "<>", 
                    "\"\\\\usepackage{tikz}\\n\"", "<>", 
                    "\"\\\\usepackage{pgfplots}\\n\"", "<>", 
                    "\"\\\\usepackage{amsmath}\\n\"", "<>", 
                    "\"\\\\usepackage{amssymb}\\n\"", "<>", 
                    "\"\\\\pgfplotsset{compat=1.18}\\n\"", "<>", 
                    "\"\\\\usepgfplotslibrary{colorbrewer}\\n\"", "<>", 
                    "\"\\n\\\\begin{document}\\n\"", "<>", 
                    "VilTeX`Private`tikzCode", "<>", 
                    "\"\\n\\\\end{document}\""}]}], ";", 
                    RowBox[{"Export", "[", 
                    
                    RowBox[{"VilTeX`Private`downloadPath", ",", 
                    "VilTeX`Private`fullDocument", ",", "\"Text\""}], "]"}], 
                    ";", "VilTeX`Private`downloadPath"}]}], "]"}]}]}, {" "}}, 
                  GridBoxAlignment -> {"Columns" -> {{Left}}}, 
                  DefaultBaseStyle -> "Column", 
                  GridBoxItemSize -> {
                   "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}]},
                "RowDefault"]}
             },
             DefaultBaseStyle->"Column",
             GridBoxAlignment->{"Columns" -> {{Left}}},
             
             GridBoxItemSize->{
              "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
            "Column"],
           FrameMargins->{{6, 0}, {3, 6}}], "\<\"\"\>"},
         {
          PaneBox[GridBox[{
             {
              
              DynamicModuleBox[{System`InformationDump`open$$ = {
               False, False, False, False, False, False}}, 
               StyleBox[GridBox[{
                  {
                   TagBox[
                    TooltipBox[
                    StyleBox["\<\" Attributes\"\>", "InformationRowLabel",
                    StripOnInput->False],
                    "\"Attributes\"",
                    TooltipStyle->"TextStyling"],
                    Annotation[#, "Attributes", "Tooltip"]& ], 
                   RowBox[{"{", "Protected", "}"}]},
                  {
                   TagBox[
                    TooltipBox[
                    StyleBox["\<\" Full Name\"\>", "InformationRowLabel",
                    StripOnInput->False],
                    "\"FullName\"",
                    TooltipStyle->"TextStyling"],
                    
                    Annotation[#, "FullName", 
                    "Tooltip"]& ], "\<\"VilTeX`ExportContour2DToTikZ\"\>"}
                 },
                 AutoDelete->False,
                 GridBoxAlignment->{"Columns" -> {Right, Left}},
                 GridBoxDividers->None,
                 GridBoxItemSize->{"Columns" -> {Automatic, Automatic}},
                 GridBoxSpacings->{"Columns" -> {
                    Offset[0.27999999999999997`], {
                    Offset[0.5599999999999999]}, 
                    Offset[0.27999999999999997`]}, "Rows" -> {
                    Offset[0.2], {
                    Offset[0.8]}, 
                    Offset[0.2]}}], "DialogStyle",
                StripOnInput->False],
               DynamicModuleValues:>{}]}
            },
            DefaultBaseStyle->"Column",
            GridBoxAlignment->{"Columns" -> {{Left}}},
            GridBoxDividers->{"Columns" -> {{False}}, "Rows" -> {{False}}},
            
            GridBoxItemSize->{
             "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
            GridBoxSpacings->{"Columns" -> {
                Offset[0.27999999999999997`], {
                 Offset[0.5599999999999999]}, 
                Offset[0.27999999999999997`]}, "Rows" -> {
                Offset[0.2], {
                 Offset[3.6]}, 
                Offset[0.2]}}],
           FrameMargins->{{6, 6}, {6, 3}}], ""},
         {
          ItemBox[
           TagBox[
            ButtonBox[
             PaneSelectorBox[{False->
              
              DynamicBox[FEPrivate`FrontEndResource[
               "FEBitmaps", "UpPointerOpener"]], True->
              
              DynamicBox[FEPrivate`FrontEndResource[
               "FEBitmaps", "UpPointerOpenerHot"]]}, Dynamic[
              System`InformationDump`mouseOver$$]],
             Alignment->Left,
             Appearance->{"Default" -> None},
             
             ButtonFunction:>FEPrivate`Set[
              System`InformationDump`open$$, False],
             Evaluator->Automatic,
             FrameMargins->{{9, 0}, {0, 0}},
             ImageMargins->0,
             ImageSize->Full,
             Method->"Preemptive"],
            
            EventHandlerTag[{
             "MouseEntered" :> 
              FEPrivate`Set[System`InformationDump`mouseOver$$, True], 
              "MouseExited" :> 
              FEPrivate`Set[System`InformationDump`mouseOver$$, False], 
              Method -> "Preemptive", PassEventsDown -> Automatic, 
              PassEventsUp -> True}]],
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False], "\[SpanFromLeft]"}
        },
        AutoDelete->False,
        FrameStyle->Directive[
          LightDarkSwitched[
           GrayLevel[0.8]], 
          Thickness[Tiny]],
        GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {{Center}}},
        GridBoxDividers->{
         "Columns" -> {{None}}, "Rows" -> {False, {True}, False}},
        GridBoxItemSize->{
         "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
       "Grid"], False->
      TagBox[GridBox[{
         {
          ItemBox[
           PaneBox[
            StyleBox[
             TagBox[
              TooltipBox[
               StyleBox["\<\" Symbol\"\>", "InformationRowLabel",
                StripOnInput->False],
               "\"Symbol\"",
               TooltipStyle->"TextStyling"],
              Annotation[#, "Symbol", "Tooltip"]& ], "InformationTitleText",
             StripOnInput->False],
            FrameMargins->{{4, 0}, {-1, 1}}],
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False], 
          ItemBox["\<\"\"\>",
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False]},
         {
          ItemBox[
           PaneBox[
            
            StyleBox["\<\"ExportContour2DToTikZ[argumentos, archivo] exporta \
gr\[AAcute]ficos matem\[AAcute]ticos 2D a formato LaTeX/TikZ como archivo \
.tex compilable.\\nExportContour2DToTikZ[argumentos, archivo, rejilla] \
especifica si mostrar l\[IAcute]neas de \
rejilla.\\nExportContour2DToTikZ[argumentos, archivo, rejilla, estilos] \
define estilos de l\[IAcute]nea y colores para cada \
gr\[AAcute]fico.\\nExportContour2DToTikZ[argumentos, archivo, rejilla, \
estilos, ejes] controla la visualizaci\[OAcute]n de ejes \
coordenados.\\nExportContour2DToTikZ[argumentos, archivo, rejilla, estilos, \
ejes, texto] a\[NTilde]ade anotaciones de texto al \
gr\[AAcute]fico.\\nExportContour2DToTikZ[argumentos, archivo, rejilla, \
estilos, ejes, texto, muestras] controla el n\[UAcute]mero de puntos de \
muestreo.\\nExportContour2DToTikZ[argumentos, archivo, rejilla, estilos, \
ejes, texto, muestras, tolerancia] ajusta la precisi\[OAcute]n \
num\[EAcute]rica.\\nExportContour2DToTikZ[argumentos, archivo, rejilla, \
estilos, ejes, texto, muestras, tolerancia, opacidadRelleno] controla \
transparencia de regiones.\\nExportContour2DToTikZ[argumentos, archivo, \
rejilla, estilos, ejes, texto, muestras, tolerancia, opacidadRelleno, \
densidad] ajusta densidad de puntos.\\nExportContour2DToTikZ[argumentos, \
archivo, rejilla, estilos, ejes, texto, muestras, tolerancia, \
opacidadRelleno, densidad, xmin, xmax, ymin, ymax] especifica l\[IAcute]mites \
de ejes.\\n\\nARGUMENTOS (plotArgs):\\n\[Bullet] CURVAS \
IMPL\[CapitalIAcute]CITAS: Ecuaciones con == \\n  - C\[IAcute]rculos: x^2 + \
y^2 == r^2\\n  - Elipses: x^2/a^2 + y^2/b^2 == 1\\n  - Hip\[EAcute]rbolas: \
x^2/a^2 - y^2/b^2 == 1\\n  - Par\[AAcute]bolas: y == x^2 o x == y^2\\n  - \
Funciones: Sin[x] == y, Log[x] == y\\n\\n\[Bullet] REGIONES DE DESIGUALDAD: \
Expresiones con <=, >=, <, >, &&, ||\\n  - Discos: x^2 + y^2 <= r^2\\n  - \
Primer cuadrante: x >= 0 && y >= 0\\n  - Franjas: -1 <= x <= 1 && y >= 0\\n  \
- Anillos: r1^2 <= x^2 + y^2 <= r2^2\\n\\n\[Bullet] FUNCIONES EXPL\
\[CapitalIAcute]CITAS: Formato {funci\[OAcute]n, {variable, m\[IAcute]n, m\
\[AAcute]x}}\\n  - Par\[AAcute]bolas: {x^2, {x, -3, 3}}\\n  - Trigonom\
\[EAcute]tricas: {Sin[x], {x, 0, 2*Pi}}\\n  - Exponenciales: {Exp[x], {x, -2, \
2}}\\n  - Logar\[IAcute]tmicas: {Log[x], {x, 0.1, 5}}\\n\\n\[Bullet] CURVAS \
PARAM\[CapitalEAcute]TRICAS: Formato {{x[t], y[t]}, {t, m\[IAcute]n, m\
\[AAcute]x}}\\n  - C\[IAcute]rculos: {{Cos[t], Sin[t]}, {t, 0, 2*Pi}}\\n  - \
Elipses: {{a*Cos[t], b*Sin[t]}, {t, 0, 2*Pi}}\\n  - Espirales: {{t*Cos[t], \
t*Sin[t]}, {t, 0, 4*Pi}}\\n  - Cicloides: {{t - Sin[t], 1 - Cos[t]}, {t, 0, \
4*Pi}}\\n\\n\[Bullet] CONJUNTOS DE PUNTOS: Lista de coordenadas {{x1, y1}, \
{x2, y2}, ...}\\n  - Puntos individuales: {{0, 0}, {1, 1}, {-1, 2}}\\n\\n\
\[Bullet] M\[CapitalUAcute]LTIPLES GR\[CapitalAAcute]FICOS: Lista combinando \
cualquier formato anterior\\n  - {x^2 + y^2 == 4, x^2 + y^2 <= 1, {x^2, {x, \
-2, 2}}}\\n\\nPAR\[CapitalAAcute]METROS OBLIGATORIOS:\\narchivo (filename) - \
String terminado en \\\".tex\\\"\\n  - Ejemplos: \\\"mi_grafico.tex\\\", \
\\\"curvas.tex\\\", \\\"analisis.tex\\\"\\n\\nPAR\[CapitalAAcute]METROS \
OPCIONALES:\\nrejilla (grid) - Boolean, por defecto: True\\n  - True: Muestra \
rejilla mayor en el gr\[AAcute]fico\\n  - False: Sin rejilla\\n\\nestilos \
(styles) - Lista de estilos, por defecto: {}\\n  - Formato: {{\\\"tipo_l\
\[IAcute]nea\\\", \\\"color\\\"}, {\\\"tipo_l\[IAcute]nea\\\", \
\\\"color\\\"}, ...}\\n  - TIPOS DE L\[CapitalIAcute]NEA: \\\"solid\\\" \
(continua), \\\"dashed\\\" (discontinua), \\\"dotted\\\" (punteada), \
\\\"dashdotted\\\" (raya-punto), \\\"thick\\\" (gruesa), \\\"thin\\\" \
(delgada)\\n  - COLORES: \\\"blue\\\" (azul), \\\"red\\\" (rojo), \
\\\"green!70!black\\\" (verde oscuro), \\\"orange\\\" (naranja), \\\"purple\\\
\" (p\[UAcute]rpura), \\\"brown\\\" (caf\[EAcute]), \\\"pink\\\" (rosa), \
\\\"gray\\\" (gris), \\\"cyan\\\" (cian), \\\"magenta\\\" (magenta)\\n  - \
Ejemplo: {{\\\"solid\\\", \\\"blue\\\"}, {\\\"dashed\\\", \\\"red\\\"}, \
{\\\"thick\\\", \\\"green!70!black\\\"}}\\n\\nejes (ejes) - Boolean, por \
defecto: True\\n  - True: Muestra ejes coordenados con flechas\\n  - False: \
Sin ejes\\n\\ntexto (texto) - Lista de anotaciones, por defecto: {}\\n  - \
Formato: {{\\\"texto\\\", {x, y}, {{\\\"opci\[OAcute]n\\\", \\\"valor\\\"}, \
...}}, ...}\\n  - OPCIONES DE TEXTO:\\n    * {\\\"color\\\", \\\"color\\\"}: \
\\\"red\\\", \\\"blue\\\", \\\"black\\\", etc.\\n    * {\\\"size\\\", \
\\\"tama\[NTilde]o\\\"}: \\\"\\\\tiny\\\", \\\"\\\\small\\\", \
\\\"\\\\normalsize\\\", \\\"\\\\large\\\", \\\"\\\\Large\\\", \
\\\"\\\\huge\\\", \\\"\\\\Huge\\\"\\n    * {\\\"anchor\\\", \\\"anclaje\\\"}: \
\\\"north\\\" (arriba), \\\"south\\\" (abajo), \\\"east\\\" (derecha), \
\\\"west\\\" (izquierda), \\\"center\\\" (centro), \\\"north east\\\", \
\\\"south west\\\"\\n    * {\\\"rotate\\\", \\\"grados\\\"}: \\\"0\\\", \
\\\"45\\\", \\\"90\\\", \\\"-30\\\", etc.\\n  - Ejemplo: {{\\\"Origen\\\", \
{0, 0}, {{\\\"color\\\", \\\"red\\\"}, {\\\"size\\\", \\\"\\\\large\\\"}, {\\\
\"anchor\\\", \\\"north\\\"}}}}\\n\\nmuestras (samples) - Entero positivo, \
por defecto: 50\\n  - Rango recomendado: 25-200\\n  - 25: R\[AAcute]pido, \
menor calidad\\n  - 50: Balance calidad/velocidad  \\n  - 100: Alta \
calidad\\n  - 200: M\[AAcute]xima calidad, lento\\n\\ntolerancia (tolerance) \
- N\[UAcute]mero positivo, por defecto: 0.1\\n  - Para curvas \
impl\[IAcute]citas \[UAcute]nicamente\\n  - 0.01: Alta precisi\[OAcute]n, m\
\[AAcute]s lento\\n  - 0.1: Precisi\[OAcute]n est\[AAcute]ndar\\n  - 0.5: \
Baja precisi\[OAcute]n, m\[AAcute]s r\[AAcute]pido\\n\\nopacidadRelleno \
(fillOpacity) - N\[UAcute]mero entre 0 y 1, por defecto: 0.3\\n  - Para \
regiones de desigualdad \[UAcute]nicamente\\n  - 0.0: Completamente \
transparente\\n  - 0.3: Semi-transparente (recomendado)\\n  - 1.0: \
Completamente opaco\\n\\ndensidad (density) - N\[UAcute]mero positivo, por \
defecto: 1.0\\n  - Factor multiplicador de puntos\\n  - 0.5: Menor densidad, \
m\[AAcute]s r\[AAcute]pido\\n  - 1.0: Densidad est\[AAcute]ndar\\n  - 2.0: \
Mayor densidad, mejor calidad\\n  - 3.0: M\[AAcute]xima densidad (advertencia \
de tiempo)\\n\\nxmin, xmax, ymin, ymax - N\[UAcute]meros o Automatic, por \
defecto: Automatic\\n  - Automatic: L\[IAcute]mites autom\[AAcute]ticos \
basados en datos\\n  - N\[UAcute]meros: L\[IAcute]mites manuales espec\
\[IAcute]ficos\\n  - Ejemplo: xmin -> -5, xmax -> 5, ymin -> -3, ymax -> 3\\n\
\\nEJEMPLOS ESPEC\[CapitalIAcute]FICOS:\\n\[Bullet] C\[IAcute]rculo \
b\[AAcute]sico:\\n  ExportContour2DToTikZ[x^2 + y^2 == 4, \
\\\"circulo.tex\\\"]\\n\\n\[Bullet] M\[UAcute]ltiples curvas con estilos:\\n  \
ExportContour2DToTikZ[{x^2 + y^2 == 4, x^2 + y^2 == 1}, \\\"circulos.tex\\\", \
True, {{\\\"solid\\\", \\\"blue\\\"}, {\\\"dashed\\\", \\\"red\\\"}}]\\n\\n\
\[Bullet] Regi\[OAcute]n con texto:\\n  ExportContour2DToTikZ[x^2 + y^2 <= 4, \
\\\"disco.tex\\\", True, {}, True, {{\\\"Radio = 2\\\", {2, 0}, {{\\\"color\\\
\", \\\"blue\\\"}, {\\\"anchor\\\", \\\"west\\\"}}}}]\\n\\n\[Bullet] Funci\
\[OAcute]n param\[EAcute]trica detallada:\\n  \
ExportContour2DToTikZ[{{3*Cos[t], 2*Sin[t]}, {t, 0, 2*Pi}}, \
\\\"elipse.tex\\\", True, {{\\\"thick\\\", \\\"purple\\\"}}, True, {}, 100, \
0.1, 0.3, 1.5]\\n\\n\[Bullet] Configuraci\[OAcute]n completa:\\n  \
ExportContour2DToTikZ[{x^2 + y^2 == 9, x^2 + y^2 <= 4}, \\\"ejemplo.tex\\\", \
True, {{\\\"solid\\\", \\\"blue\\\"}, {\\\"solid\\\", \\\"red\\\"}}, True, {{\
\\\"Exterior\\\", {3, 0}, {{\\\"color\\\", \\\"blue\\\"}}}, \
{\\\"Interior\\\", {1.5, 0}, {{\\\"color\\\", \\\"red\\\"}}}}, 80, 0.05, 0.4, \
1.2, -4, 4, -4, 4]\\n\\nSALIDA:\\n\[Bullet] Ubicaci\[OAcute]n: \
$HomeDirectory/Downloads/nombre_sin_extension/archivo.tex\\n\[Bullet] Tipo: \
Documento LaTeX completo con pre\[AAcute]mbulo\\n\[Bullet] \
Compilaci\[OAcute]n: pdflatex archivo.tex\\n\[Bullet] Dependencias autom\
\[AAcute]ticas: tikz, pgfplots, amsmath, amssymb\\n\\nNOTAS IMPORTANTES:\\n\
\[Bullet] density > 3.0 puede causar tiempos de c\[AAcute]lculo muy largos\\n\
\[Bullet] tolerance menor significa mayor precisi\[OAcute]n pero m\[AAcute]s \
tiempo de c\[AAcute]lculo\\n\[Bullet] Para publicaciones acad\[EAcute]micas \
use samples >= 100 y density >= 1.5\\n\[Bullet] Los estilos se asignan en \
orden a cada elemento de argumentos\\n\[Bullet] El archivo generado es \
completamente independiente y compilable\"\>", "InformationUsageText",
             StripOnInput->False,
             LineSpacing->{1.5, 1.5, 3.}],
            FrameMargins->{{10, 10}, {8, 10}},
            ScrollPosition->{0., 0.}],
           BaseStyle->"InformationUsageSubtitleBackground",
           StripOnInput->False], 
          ItemBox["\<\"\"\>",
           BaseStyle->"InformationUsageSubtitleBackground",
           StripOnInput->False]},
         {
          ItemBox[
           TagBox[
            ButtonBox[
             PaneSelectorBox[{False->
              
              DynamicBox[FEPrivate`FrontEndResource[
               "FEBitmaps", "DownPointerOpener"],
               ImageSizeCache->{20., {2.8017578125, 17.1982421875}}], True->
              
              DynamicBox[FEPrivate`FrontEndResource[
               "FEBitmaps", "DownPointerOpenerHot"],
               ImageSizeCache->{20., {2.8017578125, 17.1982421875}}]}, 
              Dynamic[System`InformationDump`mouseOver$$]],
             Alignment->Left,
             Appearance->{"Default" -> None},
             
             ButtonFunction:>FEPrivate`Set[
              System`InformationDump`open$$, True],
             Evaluator->Automatic,
             FrameMargins->{{9, 0}, {0, 0}},
             ImageMargins->0,
             ImageSize->Full,
             Method->"Preemptive"],
            
            EventHandlerTag[{
             "MouseEntered" :> 
              FEPrivate`Set[System`InformationDump`mouseOver$$, True], 
              "MouseExited" :> 
              FEPrivate`Set[System`InformationDump`mouseOver$$, False], 
              Method -> "Preemptive", PassEventsDown -> Automatic, 
              PassEventsUp -> True}]],
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False], "\[SpanFromLeft]"}
        },
        AutoDelete->False,
        FrameStyle->Directive[
          LightDarkSwitched[
           GrayLevel[0.8]], 
          Thickness[Tiny]],
        GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {{Center}}},
        GridBoxDividers->{
         "Columns" -> {{None}}, "Rows" -> {False, {True}, False}},
        GridBoxItemSize->{
         "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
       "Grid"]}, Dynamic[System`InformationDump`open$$],
      BaselinePosition->Baseline,
      FrameMargins->0,
      ImageSize->Automatic],
     DynamicModuleValues:>{}],
    BaseStyle->"InformationGridFrame",
    StripOnInput->False], "InformationGridPlain",
   StripOnInput->False],
  InformationData[<|
   "ObjectType" -> "Symbol", "Usage" -> 
    "ExportContour2DToTikZ[argumentos, archivo] exporta gr\[AAcute]ficos \
matem\[AAcute]ticos 2D a formato LaTeX/TikZ como archivo .tex compilable.\n\
ExportContour2DToTikZ[argumentos, archivo, rejilla] especifica si mostrar l\
\[IAcute]neas de rejilla.\nExportContour2DToTikZ[argumentos, archivo, \
rejilla, estilos] define estilos de l\[IAcute]nea y colores para cada gr\
\[AAcute]fico.\nExportContour2DToTikZ[argumentos, archivo, rejilla, estilos, \
ejes] controla la visualizaci\[OAcute]n de ejes coordenados.\n\
ExportContour2DToTikZ[argumentos, archivo, rejilla, estilos, ejes, texto] a\
\[NTilde]ade anotaciones de texto al gr\[AAcute]fico.\n\
ExportContour2DToTikZ[argumentos, archivo, rejilla, estilos, ejes, texto, \
muestras] controla el n\[UAcute]mero de puntos de muestreo.\n\
ExportContour2DToTikZ[argumentos, archivo, rejilla, estilos, ejes, texto, \
muestras, tolerancia] ajusta la precisi\[OAcute]n num\[EAcute]rica.\n\
ExportContour2DToTikZ[argumentos, archivo, rejilla, estilos, ejes, texto, \
muestras, tolerancia, opacidadRelleno] controla transparencia de regiones.\n\
ExportContour2DToTikZ[argumentos, archivo, rejilla, estilos, ejes, texto, \
muestras, tolerancia, opacidadRelleno, densidad] ajusta densidad de puntos.\n\
ExportContour2DToTikZ[argumentos, archivo, rejilla, estilos, ejes, texto, \
muestras, tolerancia, opacidadRelleno, densidad, xmin, xmax, ymin, ymax] \
especifica l\[IAcute]mites de ejes.\n\nARGUMENTOS (plotArgs):\n\[Bullet] \
CURVAS IMPL\[CapitalIAcute]CITAS: Ecuaciones con == \n  - C\[IAcute]rculos: \
x^2 + y^2 == r^2\n  - Elipses: x^2/a^2 + y^2/b^2 == 1\n  - \
Hip\[EAcute]rbolas: x^2/a^2 - y^2/b^2 == 1\n  - Par\[AAcute]bolas: y == x^2 o \
x == y^2\n  - Funciones: Sin[x] == y, Log[x] == y\n\n\[Bullet] REGIONES DE \
DESIGUALDAD: Expresiones con <=, >=, <, >, &&, ||\n  - Discos: x^2 + y^2 <= \
r^2\n  - Primer cuadrante: x >= 0 && y >= 0\n  - Franjas: -1 <= x <= 1 && y \
>= 0\n  - Anillos: r1^2 <= x^2 + y^2 <= r2^2\n\n\[Bullet] FUNCIONES EXPL\
\[CapitalIAcute]CITAS: Formato {funci\[OAcute]n, {variable, m\[IAcute]n, m\
\[AAcute]x}}\n  - Par\[AAcute]bolas: {x^2, {x, -3, 3}}\n  - \
Trigonom\[EAcute]tricas: {Sin[x], {x, 0, 2*Pi}}\n  - Exponenciales: {Exp[x], \
{x, -2, 2}}\n  - Logar\[IAcute]tmicas: {Log[x], {x, 0.1, 5}}\n\n\[Bullet] \
CURVAS PARAM\[CapitalEAcute]TRICAS: Formato {{x[t], y[t]}, {t, m\[IAcute]n, m\
\[AAcute]x}}\n  - C\[IAcute]rculos: {{Cos[t], Sin[t]}, {t, 0, 2*Pi}}\n  - \
Elipses: {{a*Cos[t], b*Sin[t]}, {t, 0, 2*Pi}}\n  - Espirales: {{t*Cos[t], \
t*Sin[t]}, {t, 0, 4*Pi}}\n  - Cicloides: {{t - Sin[t], 1 - Cos[t]}, {t, 0, \
4*Pi}}\n\n\[Bullet] CONJUNTOS DE PUNTOS: Lista de coordenadas {{x1, y1}, {x2, \
y2}, ...}\n  - Puntos individuales: {{0, 0}, {1, 1}, {-1, 2}}\n\n\[Bullet] M\
\[CapitalUAcute]LTIPLES GR\[CapitalAAcute]FICOS: Lista combinando cualquier \
formato anterior\n  - {x^2 + y^2 == 4, x^2 + y^2 <= 1, {x^2, {x, -2, 2}}}\n\n\
PAR\[CapitalAAcute]METROS OBLIGATORIOS:\narchivo (filename) - String \
terminado en \".tex\"\n  - Ejemplos: \"mi_grafico.tex\", \"curvas.tex\", \
\"analisis.tex\"\n\nPAR\[CapitalAAcute]METROS OPCIONALES:\nrejilla (grid) - \
Boolean, por defecto: True\n  - True: Muestra rejilla mayor en el \
gr\[AAcute]fico\n  - False: Sin rejilla\n\nestilos (styles) - Lista de \
estilos, por defecto: {}\n  - Formato: {{\"tipo_l\[IAcute]nea\", \"color\"}, \
{\"tipo_l\[IAcute]nea\", \"color\"}, ...}\n  - TIPOS DE L\[CapitalIAcute]NEA: \
\"solid\" (continua), \"dashed\" (discontinua), \"dotted\" (punteada), \
\"dashdotted\" (raya-punto), \"thick\" (gruesa), \"thin\" (delgada)\n  - \
COLORES: \"blue\" (azul), \"red\" (rojo), \"green!70!black\" (verde oscuro), \
\"orange\" (naranja), \"purple\" (p\[UAcute]rpura), \"brown\" (caf\[EAcute]), \
\"pink\" (rosa), \"gray\" (gris), \"cyan\" (cian), \"magenta\" (magenta)\n  - \
Ejemplo: {{\"solid\", \"blue\"}, {\"dashed\", \"red\"}, {\"thick\", \
\"green!70!black\"}}\n\nejes (ejes) - Boolean, por defecto: True\n  - True: \
Muestra ejes coordenados con flechas\n  - False: Sin ejes\n\ntexto (texto) - \
Lista de anotaciones, por defecto: {}\n  - Formato: {{\"texto\", {x, y}, \
{{\"opci\[OAcute]n\", \"valor\"}, ...}}, ...}\n  - OPCIONES DE TEXTO:\n    * \
{\"color\", \"color\"}: \"red\", \"blue\", \"black\", etc.\n    * {\"size\", \
\"tama\[NTilde]o\"}: \"\\tiny\", \"\\small\", \"\\normalsize\", \"\\large\", \
\"\\Large\", \"\\huge\", \"\\Huge\"\n    * {\"anchor\", \"anclaje\"}: \"north\
\" (arriba), \"south\" (abajo), \"east\" (derecha), \"west\" (izquierda), \
\"center\" (centro), \"north east\", \"south west\"\n    * {\"rotate\", \
\"grados\"}: \"0\", \"45\", \"90\", \"-30\", etc.\n  - Ejemplo: {{\"Origen\", \
{0, 0}, {{\"color\", \"red\"}, {\"size\", \"\\large\"}, {\"anchor\", \
\"north\"}}}}\n\nmuestras (samples) - Entero positivo, por defecto: 50\n  - \
Rango recomendado: 25-200\n  - 25: R\[AAcute]pido, menor calidad\n  - 50: \
Balance calidad/velocidad  \n  - 100: Alta calidad\n  - 200: M\[AAcute]xima \
calidad, lento\n\ntolerancia (tolerance) - N\[UAcute]mero positivo, por \
defecto: 0.1\n  - Para curvas impl\[IAcute]citas \[UAcute]nicamente\n  - \
0.01: Alta precisi\[OAcute]n, m\[AAcute]s lento\n  - 0.1: Precisi\[OAcute]n \
est\[AAcute]ndar\n  - 0.5: Baja precisi\[OAcute]n, m\[AAcute]s r\[AAcute]pido\
\n\nopacidadRelleno (fillOpacity) - N\[UAcute]mero entre 0 y 1, por defecto: \
0.3\n  - Para regiones de desigualdad \[UAcute]nicamente\n  - 0.0: \
Completamente transparente\n  - 0.3: Semi-transparente (recomendado)\n  - \
1.0: Completamente opaco\n\ndensidad (density) - N\[UAcute]mero positivo, por \
defecto: 1.0\n  - Factor multiplicador de puntos\n  - 0.5: Menor densidad, m\
\[AAcute]s r\[AAcute]pido\n  - 1.0: Densidad est\[AAcute]ndar\n  - 2.0: Mayor \
densidad, mejor calidad\n  - 3.0: M\[AAcute]xima densidad (advertencia de \
tiempo)\n\nxmin, xmax, ymin, ymax - N\[UAcute]meros o Automatic, por defecto: \
Automatic\n  - Automatic: L\[IAcute]mites autom\[AAcute]ticos basados en \
datos\n  - N\[UAcute]meros: L\[IAcute]mites manuales espec\[IAcute]ficos\n  - \
Ejemplo: xmin -> -5, xmax -> 5, ymin -> -3, ymax -> 3\n\nEJEMPLOS ESPEC\
\[CapitalIAcute]FICOS:\n\[Bullet] C\[IAcute]rculo b\[AAcute]sico:\n  \
ExportContour2DToTikZ[x^2 + y^2 == 4, \"circulo.tex\"]\n\n\[Bullet] \
M\[UAcute]ltiples curvas con estilos:\n  ExportContour2DToTikZ[{x^2 + y^2 == \
4, x^2 + y^2 == 1}, \"circulos.tex\", True, {{\"solid\", \"blue\"}, {\"dashed\
\", \"red\"}}]\n\n\[Bullet] Regi\[OAcute]n con texto:\n  \
ExportContour2DToTikZ[x^2 + y^2 <= 4, \"disco.tex\", True, {}, True, \
{{\"Radio = 2\", {2, 0}, {{\"color\", \"blue\"}, {\"anchor\", \"west\"}}}}]\n\
\n\[Bullet] Funci\[OAcute]n param\[EAcute]trica detallada:\n  \
ExportContour2DToTikZ[{{3*Cos[t], 2*Sin[t]}, {t, 0, 2*Pi}}, \"elipse.tex\", \
True, {{\"thick\", \"purple\"}}, True, {}, 100, 0.1, 0.3, 1.5]\n\n\[Bullet] \
Configuraci\[OAcute]n completa:\n  ExportContour2DToTikZ[{x^2 + y^2 == 9, x^2 \
+ y^2 <= 4}, \"ejemplo.tex\", True, {{\"solid\", \"blue\"}, {\"solid\", \"red\
\"}}, True, {{\"Exterior\", {3, 0}, {{\"color\", \"blue\"}}}, {\"Interior\", \
{1.5, 0}, {{\"color\", \"red\"}}}}, 80, 0.05, 0.4, 1.2, -4, 4, -4, 4]\n\n\
SALIDA:\n\[Bullet] Ubicaci\[OAcute]n: \
$HomeDirectory/Downloads/nombre_sin_extension/archivo.tex\n\[Bullet] Tipo: \
Documento LaTeX completo con pre\[AAcute]mbulo\n\[Bullet] \
Compilaci\[OAcute]n: pdflatex archivo.tex\n\[Bullet] Dependencias autom\
\[AAcute]ticas: tikz, pgfplots, amsmath, amssymb\n\nNOTAS IMPORTANTES:\n\
\[Bullet] density > 3.0 puede causar tiempos de c\[AAcute]lculo muy largos\n\
\[Bullet] tolerance menor significa mayor precisi\[OAcute]n pero m\[AAcute]s \
tiempo de c\[AAcute]lculo\n\[Bullet] Para publicaciones acad\[EAcute]micas \
use samples >= 100 y density >= 1.5\n\[Bullet] Los estilos se asignan en \
orden a cada elemento de argumentos\n\[Bullet] El archivo generado es \
completamente independiente y compilable", "Documentation" -> None, 
    "OwnValues" -> None, "UpValues" -> None, "DownValues" -> 
    Information`InformationValueForm[
     DownValues, VilTeX`ExportContour2DToTikZ, {VilTeX`ExportContour2DToTikZ[
         Pattern[VilTeX`Private`plotArgs, 
          Blank[]], 
         Pattern[VilTeX`Private`filename, 
          Blank[]], 
         Optional[
          Pattern[VilTeX`Private`grid, 
           Blank[]], True], 
         Optional[
          Pattern[VilTeX`Private`styles, 
           Blank[]], {}], 
         Optional[
          Pattern[VilTeX`Private`ejes, 
           Blank[]], True], 
         Optional[
          Pattern[VilTeX`Private`texto, 
           Blank[]], {}], 
         Optional[
          Pattern[VilTeX`Private`samples, 
           Blank[]], 50], 
         Optional[
          Pattern[VilTeX`Private`tolerance, 
           Blank[]], 0.1], 
         Optional[
          Pattern[VilTeX`Private`fillOpacity, 
           Blank[]], 0.3], 
         Optional[
          Pattern[VilTeX`Private`density, 
           Blank[]], 1.], 
         Optional[
          Pattern[VilTeX`Private`xmin, 
           Blank[]], Automatic], 
         Optional[
          Pattern[VilTeX`Private`xmax, 
           Blank[]], Automatic], 
         Optional[
          Pattern[VilTeX`Private`ymin, 
           Blank[]], Automatic], 
         Optional[
          Pattern[VilTeX`Private`ymax, 
           Blank[]], Automatic]] :> 
       Module[{VilTeX`Private`data, VilTeX`Private`tikzCode, 
          VilTeX`Private`fullDocument, VilTeX`Private`downloadPath, 
          VilTeX`Private`folderName, VilTeX`Private`folderPath, 
          VilTeX`Private`formatNumber, VilTeX`Private`validNumber, 
          VilTeX`Private`plotType, VilTeX`Private`func, VilTeX`Private`xRange,
           VilTeX`Private`yRange, VilTeX`Private`tRange, 
          VilTeX`Private`paramFuncs, VilTeX`Private`curveData, 
          VilTeX`Private`axisConfiguration, VilTeX`Private`equation, 
          VilTeX`Private`targetValue, VilTeX`Private`effectiveSamples, 
          VilTeX`Private`multipleGraphs, VilTeX`Private`graphList, 
          VilTeX`Private`allPlotData, VilTeX`Private`globalLimits, 
          VilTeX`Private`combinedTikzCode, VilTeX`Private`currentGraph, 
          VilTeX`Private`currentPlotType, VilTeX`Private`currentData, 
          VilTeX`Private`allLimits, VilTeX`Private`colors, 
          VilTeX`Private`allValidData, VilTeX`Private`textTikzCode, 
          VilTeX`Private`defaultStyles, VilTeX`Private`xLimits, 
          VilTeX`Private`yLimits, VilTeX`Private`opacityStyle, 
          VilTeX`Private`maxPoints, VilTeX`Private`effectiveDensity}, 
         Clear[VilTeX`Private`generateImplicitCurve2D, 
           VilTeX`Private`generateInequalityRegion, 
           VilTeX`Private`calculateLimits, VilTeX`Private`combineGlobalLimits,
            VilTeX`Private`determineGraphType]; If[
           Not[
            StringQ[VilTeX`Private`filename]], 
           Print["Error: filename debe ser un string"]; Return[$Failed]; 
           Null]; If[
           Not[
            StringEndsQ[VilTeX`Private`filename, ".tex"]], 
           Print["Error: filename debe terminar en .tex"]; Return[$Failed]; 
           Null]; If[
           Not[
            BooleanQ[VilTeX`Private`grid]], 
           Print["Error: grid debe ser True o False"]; Return[$Failed]; Null]; 
         If[
           Not[
            BooleanQ[VilTeX`Private`ejes]], 
           Print["Error: ejes debe ser True o False"]; Return[$Failed]; Null]; 
         If[
           Or[
            Not[
             NumericQ[VilTeX`Private`tolerance]], VilTeX`Private`tolerance <= 
            0], Print["Error: tolerance debe ser un n\[UAcute]mero positivo"]; 
           Return[$Failed]; Null]; If[
           Or[
            Not[
             NumericQ[VilTeX`Private`fillOpacity]], 
            VilTeX`Private`fillOpacity < 0, VilTeX`Private`fillOpacity > 1], 
           Print["Error: fillOpacity debe ser un n\[UAcute]mero entre 0 y 1"]; 
           Return[$Failed]; Null]; If[
           Or[
            Not[
             NumericQ[VilTeX`Private`density]], VilTeX`Private`density <= 0], 
           Print["Error: density debe ser un n\[UAcute]mero positivo"]; 
           Return[$Failed]; Null]; 
         If[VilTeX`Private`density > 3., 
           Print["Advertencia: density > 3.0 puede causar tiempo de \
c\[AAcute]lculo muy largo"]; Null]; 
         VilTeX`Private`effectiveDensity = Max[VilTeX`Private`density, 0.1]; 
         VilTeX`Private`maxPoints = 
          Floor[8000 VilTeX`Private`effectiveDensity]; If[
           Not[
            Or[
             ListQ[VilTeX`Private`texto], VilTeX`Private`texto === {}]], 
           Print["Error: texto debe ser una lista"]; Return[$Failed]; Null]; 
         VilTeX`Private`multipleGraphs = False; VilTeX`Private`graphList = {}; 
         If[
           And[
            ListQ[VilTeX`Private`plotArgs], Length[VilTeX`Private`plotArgs] >= 
            2], If[
             And[
              AllTrue[VilTeX`Private`plotArgs, 
               Function[VilTeX`Private`x, 
                Or[
                 ListQ[VilTeX`Private`x], Head[VilTeX`Private`x] === Equal, 
                 Head[VilTeX`Private`x] === Unequal, Head[VilTeX`Private`x] === 
                 Greater, Head[VilTeX`Private`x] === GreaterEqual, 
                 Head[VilTeX`Private`x] === Less, Head[VilTeX`Private`x] === 
                 LessEqual, Head[VilTeX`Private`x] === And, 
                 Head[VilTeX`Private`x] === Or]]], 
              Length[VilTeX`Private`plotArgs] >= 2], 
             Module[{VilTeX`Private`isMultiple = True}, If[
                 And[Length[VilTeX`Private`plotArgs] == 2, 
                  ListQ[
                   Part[VilTeX`Private`plotArgs, 1]], Length[
                    Part[VilTeX`Private`plotArgs, 1]] == 2, 
                  MatchQ[
                   Part[VilTeX`Private`plotArgs, 2], {
                    Blank[], 
                    Blank[], 
                    Blank[]}]], VilTeX`Private`isMultiple = False; Null]; If[
                 And[Length[VilTeX`Private`plotArgs] == 2, 
                  Not[
                   ListQ[
                    Part[VilTeX`Private`plotArgs, 1]]], 
                  MatchQ[
                   Part[VilTeX`Private`plotArgs, 2], {
                    Blank[], 
                    Blank[], 
                    Blank[]}]], VilTeX`Private`isMultiple = False; Null]; 
               VilTeX`Private`multipleGraphs = VilTeX`Private`isMultiple; 
               Null]; Null]; Null]; 
         If[VilTeX`Private`multipleGraphs, 
           VilTeX`Private`graphList = VilTeX`Private`plotArgs; Null, 
           VilTeX`Private`graphList = {VilTeX`Private`plotArgs}; Null]; 
         VilTeX`Private`axisConfiguration = 
          If[VilTeX`Private`ejes, "axis lines=center, axis line style={->}", 
            "axis lines=none"]; 
         VilTeX`Private`defaultStyles = {"solid", "blue"}; 
         VilTeX`Private`opacityStyle = 
          If[VilTeX`Private`fillOpacity < 
            1., ((", opacity=" <> ToString[VilTeX`Private`fillOpacity]) <> 
             ", fill opacity=") <> ToString[VilTeX`Private`fillOpacity], ""]; 
         VilTeX`Private`colors = {
           "blue", "red", "green!70!black", "orange", "purple", "brown", 
            "pink", "gray", "cyan", "magenta"}; VilTeX`Private`formatNumber[
            Pattern[VilTeX`Private`x, 
             Blank[]]] := 
          Module[{VilTeX`Private`result, VilTeX`Private`num}, If[
              NumericQ[VilTeX`Private`x], 
              VilTeX`Private`num = N[VilTeX`Private`x]; 
              If[Abs[VilTeX`Private`num] < 10^(-10), VilTeX`Private`result = 
                "0", 
                If[
                Abs[VilTeX`Private`num] > 10^8, VilTeX`Private`result = 
                 ToString[
                   Round[VilTeX`Private`num, 1], InputForm], 
                 If[
                 Abs[VilTeX`Private`num] > 1000, VilTeX`Private`result = 
                  ToString[
                    Round[VilTeX`Private`num, 0.1], InputForm], 
                  VilTeX`Private`result = ToString[
                    Round[VilTeX`Private`num, 10^(-4)], InputForm]]]]; Null, 
              VilTeX`Private`result = "0"]; If[
              And[VilTeX`Private`multipleGraphs, 
               StringQ[VilTeX`Private`result]], 
              VilTeX`Private`result = ToString[
                 Round[
                  ToExpression[VilTeX`Private`result], 0.01], InputForm]; 
              Null]; If[
              StringQ[VilTeX`Private`result], VilTeX`Private`result, 
              ToString[VilTeX`Private`result]]]; VilTeX`Private`validNumber[
            Pattern[VilTeX`Private`x, 
             Blank[]]] := And[
            NumericQ[VilTeX`Private`x], 
            Element[VilTeX`Private`x, Reals], Abs[VilTeX`Private`x] < 10^10]; 
         VilTeX`Private`generateImplicitCurve2D[
            Pattern[VilTeX`Private`equation, 
             Blank[]], 
            Pattern[VilTeX`Private`xRange, 
             Blank[]], 
            Pattern[VilTeX`Private`yRange, 
             Blank[]], 
            Pattern[VilTeX`Private`targetSamples, 
             Blank[]], 
            Pattern[VilTeX`Private`maxPointsLimit, 
             Blank[]], 
            Pattern[VilTeX`Private`toleranceLocal, 
             Blank[]], 
            Pattern[VilTeX`Private`densityLocal, 
             Blank[]]] := 
          Module[{VilTeX`Private`xVar, VilTeX`Private`xMin, 
             VilTeX`Private`xMax, VilTeX`Private`yVar, VilTeX`Private`yMin, 
             VilTeX`Private`yMax, VilTeX`Private`leftSide, 
             VilTeX`Private`rightSide, VilTeX`Private`implicitFunc, 
             VilTeX`Private`surfPoints, VilTeX`Private`ySolutions, 
             VilTeX`Private`xSolutions, VilTeX`Private`toleranceValue, 
             VilTeX`Private`currentPoints, VilTeX`Private`adaptiveSamples, 
             VilTeX`Private`xVals, VilTeX`Private`yVals, 
             VilTeX`Private`effectiveSamples, 
             VilTeX`Private`directPattern}, {
              VilTeX`Private`xVar, VilTeX`Private`xMin, VilTeX`Private`xMax} = 
             VilTeX`Private`xRange; {
              VilTeX`Private`yVar, VilTeX`Private`yMin, VilTeX`Private`yMax} = 
             VilTeX`Private`yRange; 
            VilTeX`Private`leftSide = Part[VilTeX`Private`equation, 1]; 
            VilTeX`Private`rightSide = Part[VilTeX`Private`equation, 2]; 
            VilTeX`Private`implicitFunc = 
             VilTeX`Private`leftSide - VilTeX`Private`rightSide; 
            VilTeX`Private`surfPoints = {}; 
            VilTeX`Private`toleranceValue = VilTeX`Private`toleranceLocal; 
            VilTeX`Private`currentPoints = 0; 
            VilTeX`Private`effectiveSamples = 
             Floor[VilTeX`Private`targetSamples VilTeX`Private`densityLocal]; 
            VilTeX`Private`directPattern = False; If[
              And[VilTeX`Private`leftSide === VilTeX`Private`xVar, 
               FreeQ[VilTeX`Private`rightSide, VilTeX`Private`xVar]], 
              VilTeX`Private`yVals = 
               Table[VilTeX`Private`yMin + (VilTeX`Private`yMax - 
                   VilTeX`Private`yMin) (VilTeX`Private`j/(
                   VilTeX`Private`effectiveSamples 2 - 1)), {
                 VilTeX`Private`j, 0, VilTeX`Private`effectiveSamples 2 - 1}]; 
              Do[
                Module[{VilTeX`Private`xVal}, VilTeX`Private`xVal = Quiet[
                    N[
                    ReplaceAll[
                    VilTeX`Private`rightSide, VilTeX`Private`yVar -> 
                    Part[VilTeX`Private`yVals, VilTeX`Private`j]]]]; If[
                   And[
                    VilTeX`Private`validNumber[VilTeX`Private`xVal], 
                    VilTeX`Private`xMin <= VilTeX`Private`xVal <= 
                    VilTeX`Private`xMax, VilTeX`Private`currentPoints < 
                    VilTeX`Private`maxPointsLimit], 
                   VilTeX`Private`surfPoints = 
                    Append[VilTeX`Private`surfPoints, {VilTeX`Private`xVal, 
                    Part[VilTeX`Private`yVals, VilTeX`Private`j]}]; 
                   Increment[VilTeX`Private`currentPoints]; Null]; Null], {
                VilTeX`Private`j, 
                 Length[VilTeX`Private`yVals]}]; 
              VilTeX`Private`directPattern = True; Null]; If[
              And[
               Not[VilTeX`Private`directPattern], VilTeX`Private`leftSide === 
               VilTeX`Private`yVar, 
               FreeQ[VilTeX`Private`rightSide, VilTeX`Private`yVar]], 
              VilTeX`Private`xVals = 
               Table[VilTeX`Private`xMin + (VilTeX`Private`xMax - 
                   VilTeX`Private`xMin) (VilTeX`Private`i/(
                   VilTeX`Private`effectiveSamples 2 - 1)), {
                 VilTeX`Private`i, 0, VilTeX`Private`effectiveSamples 2 - 1}]; 
              Do[
                Module[{VilTeX`Private`yVal}, VilTeX`Private`yVal = Quiet[
                    N[
                    ReplaceAll[
                    VilTeX`Private`rightSide, VilTeX`Private`xVar -> 
                    Part[VilTeX`Private`xVals, VilTeX`Private`i]]]]; If[
                   And[
                    VilTeX`Private`validNumber[VilTeX`Private`yVal], 
                    VilTeX`Private`yMin <= VilTeX`Private`yVal <= 
                    VilTeX`Private`yMax, VilTeX`Private`currentPoints < 
                    VilTeX`Private`maxPointsLimit], 
                   VilTeX`Private`surfPoints = 
                    Append[VilTeX`Private`surfPoints, {
                    Part[VilTeX`Private`xVals, VilTeX`Private`i], 
                    VilTeX`Private`yVal}]; 
                   Increment[VilTeX`Private`currentPoints]; Null]; Null], {
                VilTeX`Private`i, 
                 Length[VilTeX`Private`xVals]}]; 
              VilTeX`Private`directPattern = True; Null]; If[
              And[
               Not[VilTeX`Private`directPattern], VilTeX`Private`rightSide === 
               VilTeX`Private`xVar, 
               FreeQ[VilTeX`Private`leftSide, VilTeX`Private`xVar]], 
              VilTeX`Private`yVals = 
               Table[
                VilTeX`Private`yMin + (VilTeX`Private`yMax - 
                   VilTeX`Private`yMin) (VilTeX`Private`j/(
                   VilTeX`Private`effectiveSamples 2 - 1)), {
                 VilTeX`Private`j, 0, VilTeX`Private`effectiveSamples 2 - 1}]; 
              Do[
                Module[{VilTeX`Private`xVal}, VilTeX`Private`xVal = Quiet[
                    N[
                    ReplaceAll[
                    VilTeX`Private`leftSide, VilTeX`Private`yVar -> 
                    Part[VilTeX`Private`yVals, VilTeX`Private`j]]]]; If[
                   And[
                    VilTeX`Private`validNumber[VilTeX`Private`xVal], 
                    VilTeX`Private`xMin <= VilTeX`Private`xVal <= 
                    VilTeX`Private`xMax, VilTeX`Private`currentPoints < 
                    VilTeX`Private`maxPointsLimit], 
                   VilTeX`Private`surfPoints = 
                    Append[VilTeX`Private`surfPoints, {VilTeX`Private`xVal, 
                    Part[VilTeX`Private`yVals, VilTeX`Private`j]}]; 
                   Increment[VilTeX`Private`currentPoints]; Null]; Null], {
                VilTeX`Private`j, 
                 Length[VilTeX`Private`yVals]}]; 
              VilTeX`Private`directPattern = True; Null]; If[
              And[
               Not[VilTeX`Private`directPattern], VilTeX`Private`rightSide === 
               VilTeX`Private`yVar, 
               FreeQ[VilTeX`Private`leftSide, VilTeX`Private`yVar]], 
              VilTeX`Private`xVals = 
               Table[VilTeX`Private`xMin + (VilTeX`Private`xMax - 
                   VilTeX`Private`xMin) (VilTeX`Private`i/(
                   VilTeX`Private`effectiveSamples 2 - 1)), {
                 VilTeX`Private`i, 0, VilTeX`Private`effectiveSamples 2 - 1}]; 
              Do[
                Module[{VilTeX`Private`yVal}, VilTeX`Private`yVal = Quiet[
                    N[
                    ReplaceAll[
                    VilTeX`Private`leftSide, VilTeX`Private`xVar -> 
                    Part[VilTeX`Private`xVals, VilTeX`Private`i]]]]; If[
                   And[
                    VilTeX`Private`validNumber[VilTeX`Private`yVal], 
                    VilTeX`Private`yMin <= VilTeX`Private`yVal <= 
                    VilTeX`Private`yMax, VilTeX`Private`currentPoints < 
                    VilTeX`Private`maxPointsLimit], 
                   VilTeX`Private`surfPoints = 
                    Append[VilTeX`Private`surfPoints, {
                    Part[VilTeX`Private`xVals, VilTeX`Private`i], 
                    VilTeX`Private`yVal}]; 
                   Increment[VilTeX`Private`currentPoints]; Null]; Null], {
                VilTeX`Private`i, 
                 Length[VilTeX`Private`xVals]}]; 
              VilTeX`Private`directPattern = True; Null]; If[
              Not[VilTeX`Private`directPattern], 
              VilTeX`Private`ySolutions = Quiet[
                 Solve[VilTeX`Private`equation, VilTeX`Private`yVar, Reals]]; 
              If[
                And[Length[VilTeX`Private`ySolutions] > 0, 
                 FreeQ[
                  Part[VilTeX`Private`ySolutions, 1], Solve]], 
                Module[{
                  VilTeX`Private`yFunc, VilTeX`Private`validSolutions = {}}, 
                  Do[VilTeX`Private`yFunc = ReplaceAll[VilTeX`Private`yVar, 
                    Part[VilTeX`Private`ySolutions, VilTeX`Private`solIdx]]; 
                    If[
                    FreeQ[VilTeX`Private`yFunc, VilTeX`Private`yVar], 
                    VilTeX`Private`validSolutions = 
                    Append[VilTeX`Private`validSolutions, 
                    VilTeX`Private`yFunc]; Null], {VilTeX`Private`solIdx, 
                    Min[
                    Length[VilTeX`Private`ySolutions], 3]}]; 
                  If[Length[VilTeX`Private`validSolutions] > 0, 
                    VilTeX`Private`xVals = 
                    Table[VilTeX`Private`xMin + (VilTeX`Private`xMax - 
                    VilTeX`Private`xMin) (VilTeX`Private`i/(
                    VilTeX`Private`effectiveSamples 2 - 1)), {
                    VilTeX`Private`i, 0, VilTeX`Private`effectiveSamples 2 - 
                    1}]; Do[
                    Do[
                    
                    Module[{VilTeX`Private`yVal}, 
                    VilTeX`Private`yVal = Quiet[
                    N[
                    ReplaceAll[
                    Part[VilTeX`Private`validSolutions, VilTeX`Private`k], 
                    VilTeX`Private`xVar -> 
                    Part[VilTeX`Private`xVals, VilTeX`Private`i]]]]; If[
                    And[
                    VilTeX`Private`validNumber[VilTeX`Private`yVal], 
                    VilTeX`Private`yMin <= VilTeX`Private`yVal <= 
                    VilTeX`Private`yMax, VilTeX`Private`currentPoints < 
                    VilTeX`Private`maxPointsLimit], 
                    VilTeX`Private`surfPoints = 
                    Append[VilTeX`Private`surfPoints, {
                    Part[VilTeX`Private`xVals, VilTeX`Private`i], 
                    VilTeX`Private`yVal}]; 
                    Increment[VilTeX`Private`currentPoints]; Null]; Null], {
                    VilTeX`Private`k, 
                    Length[VilTeX`Private`validSolutions]}], {
                    VilTeX`Private`i, 
                    Length[VilTeX`Private`xVals]}]; Null]; Null]; Null, 
                VilTeX`Private`xSolutions = Quiet[
                   Solve[
                   VilTeX`Private`equation, VilTeX`Private`xVar, Reals]]; If[
                  And[Length[VilTeX`Private`xSolutions] > 0, 
                   FreeQ[
                    Part[VilTeX`Private`xSolutions, 1], Solve]], 
                  Module[{
                    VilTeX`Private`xFunc, VilTeX`Private`validSolutions = {}},
                     Do[VilTeX`Private`xFunc = ReplaceAll[VilTeX`Private`xVar, 
                    Part[VilTeX`Private`xSolutions, VilTeX`Private`solIdx]]; 
                    If[
                    FreeQ[VilTeX`Private`xFunc, VilTeX`Private`xVar], 
                    VilTeX`Private`validSolutions = 
                    Append[VilTeX`Private`validSolutions, 
                    VilTeX`Private`xFunc]; Null], {VilTeX`Private`solIdx, 
                    Min[
                    Length[VilTeX`Private`xSolutions], 3]}]; 
                    If[Length[VilTeX`Private`validSolutions] > 0, 
                    VilTeX`Private`yVals = 
                    Table[VilTeX`Private`yMin + (VilTeX`Private`yMax - 
                    VilTeX`Private`yMin) (VilTeX`Private`j/(
                    VilTeX`Private`effectiveSamples 2 - 1)), {
                    VilTeX`Private`j, 0, VilTeX`Private`effectiveSamples 2 - 
                    1}]; Do[
                    Do[
                    
                    Module[{VilTeX`Private`xVal}, 
                    VilTeX`Private`xVal = Quiet[
                    N[
                    ReplaceAll[
                    Part[VilTeX`Private`validSolutions, VilTeX`Private`k], 
                    VilTeX`Private`yVar -> 
                    Part[VilTeX`Private`yVals, VilTeX`Private`j]]]]; If[
                    And[
                    VilTeX`Private`validNumber[VilTeX`Private`xVal], 
                    VilTeX`Private`xMin <= VilTeX`Private`xVal <= 
                    VilTeX`Private`xMax, VilTeX`Private`currentPoints < 
                    VilTeX`Private`maxPointsLimit], 
                    VilTeX`Private`surfPoints = 
                    Append[VilTeX`Private`surfPoints, {VilTeX`Private`xVal, 
                    Part[VilTeX`Private`yVals, VilTeX`Private`j]}]; 
                    Increment[VilTeX`Private`currentPoints]; Null]; Null], {
                    VilTeX`Private`k, 
                    Length[VilTeX`Private`validSolutions]}], {
                    VilTeX`Private`j, 
                    Length[VilTeX`Private`yVals]}]; Null]; Null]; Null, 
                  VilTeX`Private`adaptiveSamples = Min[
                    Max[VilTeX`Private`effectiveSamples, 25], 
                    Floor[(VilTeX`Private`maxPointsLimit 0.8)^(1/2)]]; 
                  VilTeX`Private`adaptiveSamples = 
                   Max[VilTeX`Private`adaptiveSamples, 8]; 
                  VilTeX`Private`xVals = 
                   Table[VilTeX`Private`xMin + (VilTeX`Private`xMax - 
                    VilTeX`Private`xMin) (VilTeX`Private`i/(
                    VilTeX`Private`adaptiveSamples - 1)), {
                    VilTeX`Private`i, 0, VilTeX`Private`adaptiveSamples - 1}]; 
                  VilTeX`Private`yVals = 
                   Table[VilTeX`Private`yMin + (VilTeX`Private`yMax - 
                    VilTeX`Private`yMin) (VilTeX`Private`j/(
                    VilTeX`Private`adaptiveSamples - 1)), {
                    VilTeX`Private`j, 0, VilTeX`Private`adaptiveSamples - 1}]; 
                  Do[
                    Do[
                    If[
                    VilTeX`Private`currentPoints < 
                    VilTeX`Private`maxPointsLimit, 
                    Module[{VilTeX`Private`funcVal}, 
                    VilTeX`Private`funcVal = Quiet[
                    N[
                    ReplaceAll[
                    VilTeX`Private`implicitFunc, {
                    VilTeX`Private`xVar -> 
                    Part[VilTeX`Private`xVals, VilTeX`Private`i], 
                    VilTeX`Private`yVar -> 
                    Part[VilTeX`Private`yVals, VilTeX`Private`j]}]]]; If[
                    And[
                    VilTeX`Private`validNumber[VilTeX`Private`funcVal], 
                    Abs[VilTeX`Private`funcVal] < 
                    VilTeX`Private`toleranceValue], 
                    VilTeX`Private`surfPoints = 
                    Append[VilTeX`Private`surfPoints, {
                    Part[VilTeX`Private`xVals, VilTeX`Private`i], 
                    Part[VilTeX`Private`yVals, VilTeX`Private`j]}]; 
                    Increment[VilTeX`Private`currentPoints]; Null]; Null]; 
                    Null], {VilTeX`Private`j, 
                    Length[VilTeX`Private`yVals]}], {VilTeX`Private`i, 
                    Length[VilTeX`Private`xVals]}]; Null]; Null]; Null]; 
            If[Length[VilTeX`Private`surfPoints] > 
              VilTeX`Private`maxPointsLimit, 
              VilTeX`Private`surfPoints = 
               RandomSample[
                VilTeX`Private`surfPoints, VilTeX`Private`maxPointsLimit]; 
              Null]; VilTeX`Private`surfPoints]; 
         VilTeX`Private`generateInequalityRegion[
            Pattern[VilTeX`Private`inequality, 
             Blank[]], 
            Pattern[VilTeX`Private`xRange, 
             Blank[]], 
            Pattern[VilTeX`Private`yRange, 
             Blank[]], 
            Pattern[VilTeX`Private`targetSamples, 
             Blank[]], 
            Pattern[VilTeX`Private`densityLocal, 
             Blank[]]] := 
          Module[{VilTeX`Private`xVar, VilTeX`Private`xMin, 
             VilTeX`Private`xMax, VilTeX`Private`yVar, VilTeX`Private`yMin, 
             VilTeX`Private`yMax, VilTeX`Private`xVals, VilTeX`Private`yVals, 
             VilTeX`Private`regionPoints, VilTeX`Private`evaluateInequality, 
             VilTeX`Private`effectiveSamples}, {
              VilTeX`Private`xVar, VilTeX`Private`xMin, VilTeX`Private`xMax} = 
             VilTeX`Private`xRange; {
              VilTeX`Private`yVar, VilTeX`Private`yMin, VilTeX`Private`yMax} = 
             VilTeX`Private`yRange; 
            VilTeX`Private`effectiveSamples = 
             Floor[VilTeX`Private`targetSamples VilTeX`Private`densityLocal]; 
            VilTeX`Private`evaluateInequality[
               Pattern[VilTeX`Private`expr, 
                Blank[]], 
               Pattern[VilTeX`Private`xVal, 
                Blank[]], 
               Pattern[VilTeX`Private`yVal, 
                Blank[]]] := 
             Module[{VilTeX`Private`result}, VilTeX`Private`result = Quiet[
                  ReplaceAll[
                  VilTeX`Private`expr, {
                   VilTeX`Private`xVar -> VilTeX`Private`xVal, 
                    VilTeX`Private`yVar -> VilTeX`Private`yVal}]]; If[
                 BooleanQ[VilTeX`Private`result], VilTeX`Private`result, 
                 False]]; 
            VilTeX`Private`xVals = 
             Table[VilTeX`Private`xMin + (VilTeX`Private`xMax - 
                 VilTeX`Private`xMin) (VilTeX`Private`i/(
                 VilTeX`Private`effectiveSamples - 1)), {
               VilTeX`Private`i, 0, VilTeX`Private`effectiveSamples - 1}]; 
            VilTeX`Private`yVals = 
             Table[VilTeX`Private`yMin + (VilTeX`Private`yMax - 
                 VilTeX`Private`yMin) (VilTeX`Private`j/(
                 VilTeX`Private`effectiveSamples - 1)), {
               VilTeX`Private`j, 0, VilTeX`Private`effectiveSamples - 1}]; 
            VilTeX`Private`regionPoints = {}; Do[
              Do[
               
               Module[{
                VilTeX`Private`xVal, VilTeX`Private`yVal, 
                 VilTeX`Private`isInRegion}, 
                VilTeX`Private`xVal = 
                 Part[VilTeX`Private`xVals, VilTeX`Private`i]; 
                VilTeX`Private`yVal = 
                 Part[VilTeX`Private`yVals, VilTeX`Private`j]; 
                VilTeX`Private`isInRegion = 
                 VilTeX`Private`evaluateInequality[
                  VilTeX`Private`inequality, VilTeX`Private`xVal, 
                   VilTeX`Private`yVal]; If[
                  TrueQ[VilTeX`Private`isInRegion], 
                  VilTeX`Private`regionPoints = 
                   Append[VilTeX`Private`regionPoints, {
                    VilTeX`Private`xVal, VilTeX`Private`yVal}]; Null]; 
                Null], {VilTeX`Private`j, 
                Length[VilTeX`Private`yVals]}], {VilTeX`Private`i, 
               Length[VilTeX`Private`xVals]}]; VilTeX`Private`regionPoints]; 
         VilTeX`Private`calculateLimits[
            Pattern[VilTeX`Private`dataPoints, 
             Blank[]], 
            Optional[
             Pattern[VilTeX`Private`margin, 
              Blank[]], 0.1]] := 
          Module[{VilTeX`Private`xDataMin, VilTeX`Private`xDataMax, 
             VilTeX`Private`yDataMin, VilTeX`Private`yDataMax, 
             VilTeX`Private`xRange, VilTeX`Private`yRange}, 
            If[
            Length[VilTeX`Private`dataPoints] > 0, 
             VilTeX`Private`xDataMin = Min[
                Part[VilTeX`Private`dataPoints, All, 1]]; 
             VilTeX`Private`xDataMax = Max[
                Part[VilTeX`Private`dataPoints, All, 1]]; 
             VilTeX`Private`yDataMin = Min[
                Part[VilTeX`Private`dataPoints, All, 2]]; 
             VilTeX`Private`yDataMax = Max[
                Part[VilTeX`Private`dataPoints, All, 2]]; 
             VilTeX`Private`xRange = 
              VilTeX`Private`xDataMax - VilTeX`Private`xDataMin; 
             VilTeX`Private`yRange = 
              VilTeX`Private`yDataMax - VilTeX`Private`yDataMin; 
             If[VilTeX`Private`xRange == 0, VilTeX`Private`xRange = 1]; 
             If[VilTeX`Private`yRange == 0, VilTeX`Private`yRange = 1]; {
              VilTeX`Private`xDataMin - VilTeX`Private`margin 
               VilTeX`Private`xRange, VilTeX`Private`xDataMax + 
               VilTeX`Private`margin VilTeX`Private`xRange, 
               VilTeX`Private`yDataMin - VilTeX`Private`margin 
               VilTeX`Private`yRange, VilTeX`Private`yDataMax + 
               VilTeX`Private`margin VilTeX`Private`yRange}, {-5, 5, -5, 5}]]; 
         VilTeX`Private`combineGlobalLimits[
            Pattern[VilTeX`Private`limitsList, 
             Blank[]]] := 
          Module[{VilTeX`Private`xMins, VilTeX`Private`xMaxs, 
             VilTeX`Private`yMins, VilTeX`Private`yMaxs}, 
            If[
            Length[VilTeX`Private`limitsList] > 0, 
             VilTeX`Private`xMins = Part[VilTeX`Private`limitsList, All, 1]; 
             VilTeX`Private`xMaxs = Part[VilTeX`Private`limitsList, All, 2]; 
             VilTeX`Private`yMins = Part[VilTeX`Private`limitsList, All, 3]; 
             VilTeX`Private`yMaxs = Part[VilTeX`Private`limitsList, All, 4]; {
              
               Min[VilTeX`Private`xMins], 
               Max[VilTeX`Private`xMaxs], 
               Min[VilTeX`Private`yMins], 
               Max[VilTeX`Private`yMaxs]}, {-5, 5, -5, 5}]]; 
         VilTeX`Private`determineGraphType[
            Pattern[VilTeX`Private`graphArgs, 
             Blank[]]] := Module[{}, 
            Which[Head[VilTeX`Private`graphArgs] === Equal, "ImplicitCurve", 
             Or[
             Head[VilTeX`Private`graphArgs] === GreaterEqual, 
              Head[VilTeX`Private`graphArgs] === Greater, 
              Head[VilTeX`Private`graphArgs] === LessEqual, 
              Head[VilTeX`Private`graphArgs] === Less], "InequalityRegion", 
             Or[
             Head[VilTeX`Private`graphArgs] === And, 
              Head[VilTeX`Private`graphArgs] === Or], "InequalityRegion", 
             And[Length[VilTeX`Private`graphArgs] == 2, 
              MatchQ[
               Part[VilTeX`Private`graphArgs, 2], {
                Blank[], 
                Blank[], 
                Blank[]}], 
              Not[
               ListQ[
                Part[VilTeX`Private`graphArgs, 1]]]], "FunctionPlot", 
             And[Length[VilTeX`Private`graphArgs] == 2, 
              ListQ[
               Part[VilTeX`Private`graphArgs, 1]], Length[
                Part[VilTeX`Private`graphArgs, 1]] == 2, 
              MatchQ[
               Part[VilTeX`Private`graphArgs, 2], {
                Blank[], 
                Blank[], 
                Blank[]}]], "ParametricCurve", 
             And[
              ListQ[VilTeX`Private`graphArgs], 
              AllTrue[VilTeX`Private`graphArgs, And[
                ListQ[#], Length[#] == 2]& ]], "Points", True, "Unknown"]]; If[
           Or[
           VilTeX`Private`xmin === Automatic, VilTeX`Private`xmax === 
            Automatic, VilTeX`Private`ymin === Automatic, VilTeX`Private`ymax === 
            Automatic], VilTeX`Private`xLimits = If[
              Or[
              VilTeX`Private`xmin === Automatic, VilTeX`Private`xmax === 
               Automatic], {-5, 5}, {
              VilTeX`Private`xmin, VilTeX`Private`xmax}]; 
           VilTeX`Private`yLimits = If[
              Or[
              VilTeX`Private`ymin === Automatic, VilTeX`Private`ymax === 
               Automatic], {-5, 5}, {
              VilTeX`Private`ymin, VilTeX`Private`ymax}]; Null, 
           VilTeX`Private`xLimits = {
             VilTeX`Private`xmin, VilTeX`Private`xmax}; 
           VilTeX`Private`yLimits = {
             VilTeX`Private`ymin, VilTeX`Private`ymax}; Null]; 
         VilTeX`Private`allPlotData = {}; VilTeX`Private`allLimits = {}; 
         VilTeX`Private`allValidData = {}; 
         Do[VilTeX`Private`currentGraph = 
            Part[VilTeX`Private`graphList, VilTeX`Private`graphIdx]; 
           VilTeX`Private`currentPlotType = 
            VilTeX`Private`determineGraphType[VilTeX`Private`currentGraph]; 
           VilTeX`Private`currentData = {}; 
           Which[VilTeX`Private`currentPlotType == "ImplicitCurve", 
             VilTeX`Private`equation = VilTeX`Private`currentGraph; 
             Module[{VilTeX`Private`xVar, VilTeX`Private`yVar, 
                VilTeX`Private`vars}, 
               VilTeX`Private`vars = Variables[VilTeX`Private`equation]; 
               If[Length[VilTeX`Private`vars] >= 2, 
                 VilTeX`Private`xVar = Part[VilTeX`Private`vars, 1]; 
                 VilTeX`Private`yVar = Part[VilTeX`Private`vars, 2]; Null, 
                 VilTeX`Private`xVar = VilTeX`Private`x; 
                 VilTeX`Private`yVar = VilTeX`Private`y; Null]; 
               VilTeX`Private`xRange = {VilTeX`Private`xVar, 
                  Part[VilTeX`Private`xLimits, 1], 
                  Part[VilTeX`Private`xLimits, 2]}; 
               VilTeX`Private`yRange = {VilTeX`Private`yVar, 
                  Part[VilTeX`Private`yLimits, 1], 
                  Part[VilTeX`Private`yLimits, 2]}; 
               VilTeX`Private`currentData = 
                VilTeX`Private`generateImplicitCurve2D[
                 VilTeX`Private`equation, VilTeX`Private`xRange, 
                  VilTeX`Private`yRange, VilTeX`Private`samples, 
                  VilTeX`Private`maxPoints, VilTeX`Private`tolerance, 
                  VilTeX`Private`effectiveDensity]; Null]; 
             If[Length[VilTeX`Private`currentData] > 0, 
               VilTeX`Private`allLimits = Append[VilTeX`Private`allLimits, 
                  VilTeX`Private`calculateLimits[VilTeX`Private`currentData]]; 
               VilTeX`Private`allPlotData = 
                Append[VilTeX`Private`allPlotData, {
                  VilTeX`Private`currentPlotType, VilTeX`Private`currentData, 
                   VilTeX`Private`currentGraph}]; 
               VilTeX`Private`allValidData = 
                Join[VilTeX`Private`allValidData, VilTeX`Private`currentData]; 
               Null]; Null, VilTeX`Private`currentPlotType == 
             "InequalityRegion", 
             VilTeX`Private`equation = VilTeX`Private`currentGraph; 
             Module[{VilTeX`Private`xVar, VilTeX`Private`yVar, 
                VilTeX`Private`vars}, 
               VilTeX`Private`vars = Variables[VilTeX`Private`equation]; 
               If[Length[VilTeX`Private`vars] >= 2, 
                 VilTeX`Private`xVar = Part[VilTeX`Private`vars, 1]; 
                 VilTeX`Private`yVar = Part[VilTeX`Private`vars, 2]; Null, 
                 VilTeX`Private`xVar = VilTeX`Private`x; 
                 VilTeX`Private`yVar = VilTeX`Private`y; Null]; 
               VilTeX`Private`xRange = {VilTeX`Private`xVar, 
                  Part[VilTeX`Private`xLimits, 1], 
                  Part[VilTeX`Private`xLimits, 2]}; 
               VilTeX`Private`yRange = {VilTeX`Private`yVar, 
                  Part[VilTeX`Private`yLimits, 1], 
                  Part[VilTeX`Private`yLimits, 2]}; 
               VilTeX`Private`currentData = 
                VilTeX`Private`generateInequalityRegion[
                 VilTeX`Private`equation, VilTeX`Private`xRange, 
                  VilTeX`Private`yRange, VilTeX`Private`samples, 
                  VilTeX`Private`effectiveDensity]; Null]; 
             If[Length[VilTeX`Private`currentData] > 0, 
               VilTeX`Private`allLimits = Append[VilTeX`Private`allLimits, 
                  VilTeX`Private`calculateLimits[VilTeX`Private`currentData]]; 
               VilTeX`Private`allPlotData = 
                Append[VilTeX`Private`allPlotData, {
                  VilTeX`Private`currentPlotType, VilTeX`Private`currentData, 
                   VilTeX`Private`currentGraph}]; 
               VilTeX`Private`allValidData = 
                Join[VilTeX`Private`allValidData, VilTeX`Private`currentData]; 
               Null]; Null, VilTeX`Private`currentPlotType == "FunctionPlot", 
             VilTeX`Private`func = Part[VilTeX`Private`currentGraph, 1]; 
             VilTeX`Private`xRange = Part[VilTeX`Private`currentGraph, 2]; 
             Module[{VilTeX`Private`xVar, VilTeX`Private`xMin, 
                VilTeX`Private`xMax, VilTeX`Private`xVals, 
                VilTeX`Private`effectiveSamples}, {
                 VilTeX`Private`xVar, VilTeX`Private`xMin, 
                  VilTeX`Private`xMax} = VilTeX`Private`xRange; 
               VilTeX`Private`effectiveSamples = 
                Floor[VilTeX`Private`samples VilTeX`Private`effectiveDensity]; 
               VilTeX`Private`xVals = 
                Table[VilTeX`Private`xMin + (VilTeX`Private`xMax - 
                    VilTeX`Private`xMin) (VilTeX`Private`i/(
                    VilTeX`Private`effectiveSamples - 1)), {
                  VilTeX`Private`i, 0, VilTeX`Private`effectiveSamples - 1}]; 
               Do[
                 
                 Module[{VilTeX`Private`yVal}, 
                  VilTeX`Private`yVal = 
                   ReplaceAll[
                    VilTeX`Private`func, VilTeX`Private`xVar -> 
                    Part[VilTeX`Private`xVals, VilTeX`Private`i]]; If[
                    And[
                    NumericQ[VilTeX`Private`yVal], 
                    VilTeX`Private`validNumber[VilTeX`Private`yVal]], 
                    VilTeX`Private`currentData = 
                    Append[VilTeX`Private`currentData, {
                    Part[VilTeX`Private`xVals, VilTeX`Private`i], 
                    VilTeX`Private`yVal}]; Null]; Null], {VilTeX`Private`i, 
                  Length[VilTeX`Private`xVals]}]; Null]; 
             If[
              Length[VilTeX`Private`currentData] > 0, 
               VilTeX`Private`allLimits = Append[VilTeX`Private`allLimits, 
                  VilTeX`Private`calculateLimits[VilTeX`Private`currentData]]; 
               VilTeX`Private`allPlotData = 
                Append[VilTeX`Private`allPlotData, {
                  VilTeX`Private`currentPlotType, VilTeX`Private`currentData, 
                   VilTeX`Private`currentGraph}]; 
               VilTeX`Private`allValidData = 
                Join[VilTeX`Private`allValidData, VilTeX`Private`currentData]; 
               Null]; Null, VilTeX`Private`currentPlotType == 
             "ParametricCurve", 
             VilTeX`Private`paramFuncs = Part[VilTeX`Private`currentGraph, 1]; 
             VilTeX`Private`tRange = Part[VilTeX`Private`currentGraph, 2]; 
             Module[{VilTeX`Private`tVar, VilTeX`Private`tMin, 
                VilTeX`Private`tMax, VilTeX`Private`tVals, 
                VilTeX`Private`xFunc, VilTeX`Private`yFunc, 
                VilTeX`Private`curvePoints}, {
                 VilTeX`Private`tVar, VilTeX`Private`tMin, 
                  VilTeX`Private`tMax} = 
                VilTeX`Private`tRange; {
                 VilTeX`Private`xFunc, VilTeX`Private`yFunc} = 
                VilTeX`Private`paramFuncs; 
               VilTeX`Private`curvePoints = 
                If[VilTeX`Private`multipleGraphs, 
                  Min[
                   Floor[
                   VilTeX`Private`samples 2 VilTeX`Private`effectiveDensity], 
                   200], 
                  Floor[
                  VilTeX`Private`samples 2 VilTeX`Private`effectiveDensity]]; 
               VilTeX`Private`tVals = 
                Table[VilTeX`Private`tMin + (VilTeX`Private`tMax - 
                    VilTeX`Private`tMin) (VilTeX`Private`i/(
                    VilTeX`Private`curvePoints - 1)), {
                  VilTeX`Private`i, 0, VilTeX`Private`curvePoints - 1}]; Do[
                 
                 Module[{VilTeX`Private`xVal, VilTeX`Private`yVal}, 
                  VilTeX`Private`xVal = 
                   ReplaceAll[
                    VilTeX`Private`xFunc, VilTeX`Private`tVar -> 
                    Part[VilTeX`Private`tVals, VilTeX`Private`i]]; 
                  VilTeX`Private`yVal = 
                   ReplaceAll[
                    VilTeX`Private`yFunc, VilTeX`Private`tVar -> 
                    Part[VilTeX`Private`tVals, VilTeX`Private`i]]; If[
                    And[
                    
                    AllTrue[{VilTeX`Private`xVal, VilTeX`Private`yVal}, 
                    NumericQ], 
                    
                    AllTrue[{VilTeX`Private`xVal, VilTeX`Private`yVal}, 
                    VilTeX`Private`validNumber]], 
                    VilTeX`Private`currentData = 
                    Append[VilTeX`Private`currentData, {
                    VilTeX`Private`xVal, VilTeX`Private`yVal}]; Null]; 
                  Null], {VilTeX`Private`i, 
                  Length[VilTeX`Private`tVals]}]; Null]; 
             If[Length[VilTeX`Private`currentData] > 0, 
               VilTeX`Private`allLimits = Append[VilTeX`Private`allLimits, 
                  VilTeX`Private`calculateLimits[VilTeX`Private`currentData]]; 
               VilTeX`Private`allPlotData = 
                Append[VilTeX`Private`allPlotData, {
                  VilTeX`Private`currentPlotType, VilTeX`Private`currentData, 
                   VilTeX`Private`currentGraph}]; 
               VilTeX`Private`allValidData = 
                Join[VilTeX`Private`allValidData, VilTeX`Private`currentData]; 
               Null]; Null, VilTeX`Private`currentPlotType == "Points", 
             VilTeX`Private`currentData = 
              Select[VilTeX`Private`currentGraph, And[Length[#] == 2, 
                 AllTrue[#, VilTeX`Private`validNumber]]& ]; 
             If[Length[VilTeX`Private`currentData] > 0, 
               VilTeX`Private`allLimits = Append[VilTeX`Private`allLimits, 
                  VilTeX`Private`calculateLimits[VilTeX`Private`currentData]]; 
               VilTeX`Private`allPlotData = 
                Append[VilTeX`Private`allPlotData, {
                  VilTeX`Private`currentPlotType, VilTeX`Private`currentData, 
                   VilTeX`Private`currentGraph}]; 
               VilTeX`Private`allValidData = 
                Join[VilTeX`Private`allValidData, VilTeX`Private`currentData]; 
               Null]; Null]; Null, {VilTeX`Private`graphIdx, 
            Length[VilTeX`Private`graphList]}]; 
         If[Length[VilTeX`Private`allValidData] == 0, 
           Print["Error: No se generaron datos v\[AAcute]lidos para ning\
\[UAcute]n gr\[AAcute]fico"]; Return[$Failed]; Null]; 
         If[Length[VilTeX`Private`allLimits] > 0, 
           VilTeX`Private`globalLimits = 
            VilTeX`Private`combineGlobalLimits[VilTeX`Private`allLimits]; 
           Null, VilTeX`Private`globalLimits = {
              Part[VilTeX`Private`xLimits, 1], 
              Part[VilTeX`Private`xLimits, 2], 
              Part[VilTeX`Private`yLimits, 1], 
              Part[VilTeX`Private`yLimits, 2]}; Null]; 
         If[
          VilTeX`Private`xmin =!= Automatic, 
           Part[VilTeX`Private`globalLimits, 1] = VilTeX`Private`xmin]; 
         If[VilTeX`Private`xmax =!= Automatic, 
           Part[VilTeX`Private`globalLimits, 2] = VilTeX`Private`xmax]; 
         If[VilTeX`Private`ymin =!= Automatic, 
           Part[VilTeX`Private`globalLimits, 3] = VilTeX`Private`ymin]; 
         If[VilTeX`Private`ymax =!= Automatic, 
           Part[VilTeX`Private`globalLimits, 4] = VilTeX`Private`ymax]; 
         VilTeX`Private`folderName = FileBaseName[VilTeX`Private`filename]; 
         VilTeX`Private`folderPath = 
          FileNameJoin[{$HomeDirectory, "Downloads", 
             VilTeX`Private`folderName}]; If[
           Not[
            DirectoryQ[VilTeX`Private`folderPath]], 
           CreateDirectory[VilTeX`Private`folderPath]]; 
         VilTeX`Private`downloadPath = 
          FileNameJoin[{VilTeX`Private`folderPath, VilTeX`Private`filename}]; 
         VilTeX`Private`combinedTikzCode = ""; Do[
           
           Module[{VilTeX`Private`plotType, VilTeX`Private`graphData, 
             VilTeX`Private`graphArgs, VilTeX`Private`tikzPlot, 
             VilTeX`Private`validPoints, VilTeX`Private`plotStyle, 
             VilTeX`Private`currentColor, 
             VilTeX`Private`currentStyle}, {
              VilTeX`Private`plotType, VilTeX`Private`graphData, 
               VilTeX`Private`graphArgs} = 
             Part[VilTeX`Private`allPlotData, VilTeX`Private`plotIdx]; If[
              And[Length[VilTeX`Private`styles] >= VilTeX`Private`plotIdx, 
               ListQ[
                Part[VilTeX`Private`styles, VilTeX`Private`plotIdx]]], 
              VilTeX`Private`currentStyle = 
               Part[VilTeX`Private`styles, VilTeX`Private`plotIdx]; Null, 
              VilTeX`Private`currentStyle = If[
                 And[
                 VilTeX`Private`multipleGraphs, VilTeX`Private`plotIdx <= 
                  Length[VilTeX`Private`colors]], {"solid", 
                  Part[VilTeX`Private`colors, VilTeX`Private`plotIdx]}, 
                 VilTeX`Private`defaultStyles]; Null]; 
            VilTeX`Private`currentColor = 
             If[Length[VilTeX`Private`currentStyle] >= 2, 
               Part[VilTeX`Private`currentStyle, 2], 
               Part[VilTeX`Private`defaultStyles, 2]]; 
            VilTeX`Private`plotStyle = 
             If[Length[VilTeX`Private`currentStyle] >= 1, 
               Part[VilTeX`Private`currentStyle, 1], 
               Part[VilTeX`Private`defaultStyles, 1]]; 
            Which[VilTeX`Private`plotType == "ImplicitCurve", 
              VilTeX`Private`validPoints = 
               Select[VilTeX`Private`graphData, And[Length[#] == 2, 
                  AllTrue[#, VilTeX`Private`validNumber]]& ]; 
              If[Length[VilTeX`Private`validPoints] > 0, 
                VilTeX`Private`plotStyle = 
                 If[Length[VilTeX`Private`validPoints] > 2000, 
                   "only marks, mark=*, mark size=0.5pt", 
                   "only marks, mark=*, mark size=0.8pt"]; 
                VilTeX`Private`tikzPlot = (((((("\\addplot[" <> 
                    VilTeX`Private`currentColor) <> ", ") <> 
                    VilTeX`Private`plotStyle) <> VilTeX`Private`opacityStyle) <> 
                    "] coordinates {\n") <> StringRiffle[
                    Table[((("  (" <> VilTeX`Private`formatNumber[
                    Part[VilTeX`Private`validPoints, VilTeX`Private`i, 1]]) <> 
                    ",") <> VilTeX`Private`formatNumber[
                    Part[VilTeX`Private`validPoints, VilTeX`Private`i, 2]]) <> 
                    ")", {VilTeX`Private`i, 
                    Length[VilTeX`Private`validPoints]}], "\n"]) <> "\n};\n"; 
                VilTeX`Private`combinedTikzCode = 
                 VilTeX`Private`combinedTikzCode <> VilTeX`Private`tikzPlot; 
                Null]; Null, VilTeX`Private`plotType == "InequalityRegion", 
              VilTeX`Private`validPoints = 
               Select[VilTeX`Private`graphData, And[Length[#] == 2, 
                  AllTrue[#, VilTeX`Private`validNumber]]& ]; 
              If[Length[VilTeX`Private`validPoints] > 0, 
                VilTeX`Private`tikzPlot = ((((((("\\addplot[" <> 
                    VilTeX`Private`currentColor) <> ", ") <> 
                    VilTeX`Private`plotStyle) <> 
                    ", only marks, mark=*, mark size=0.3pt, opacity=") <> 
                    ToString[VilTeX`Private`fillOpacity]) <> 
                    "] coordinates {\n") <> StringRiffle[
                    Table[((("  (" <> VilTeX`Private`formatNumber[
                    Part[VilTeX`Private`validPoints, VilTeX`Private`i, 1]]) <> 
                    ",") <> VilTeX`Private`formatNumber[
                    Part[VilTeX`Private`validPoints, VilTeX`Private`i, 2]]) <> 
                    ")", {VilTeX`Private`i, 
                    Length[VilTeX`Private`validPoints]}], "\n"]) <> "\n};\n"; 
                VilTeX`Private`combinedTikzCode = 
                 VilTeX`Private`combinedTikzCode <> VilTeX`Private`tikzPlot; 
                Null]; Null, 
              Or[
              VilTeX`Private`plotType == "FunctionPlot", 
               VilTeX`Private`plotType == "ParametricCurve"], 
              If[Length[VilTeX`Private`graphData] > 0, 
                VilTeX`Private`tikzPlot = ((((("\\addplot[" <> 
                    VilTeX`Private`currentColor) <> ", ") <> 
                    VilTeX`Private`plotStyle) <> 
                    ", thick, smooth] coordinates {\n") <> StringRiffle[
                    Table[((("  (" <> VilTeX`Private`formatNumber[
                    Part[VilTeX`Private`graphData, VilTeX`Private`i, 1]]) <> 
                    ",") <> VilTeX`Private`formatNumber[
                    Part[VilTeX`Private`graphData, VilTeX`Private`i, 2]]) <> 
                    ")", {VilTeX`Private`i, 
                    Length[VilTeX`Private`graphData]}], "\n"]) <> "\n};\n"; 
                VilTeX`Private`combinedTikzCode = 
                 VilTeX`Private`combinedTikzCode <> VilTeX`Private`tikzPlot; 
                Null]; Null, VilTeX`Private`plotType == "Points", 
              If[Length[VilTeX`Private`graphData] > 0, 
                VilTeX`Private`tikzPlot = ((("\\addplot[" <> 
                    VilTeX`Private`currentColor) <> 
                    ", only marks, mark=*, mark size=2pt] coordinates {\n") <> 
                   StringRiffle[
                    Table[((("  (" <> VilTeX`Private`formatNumber[
                    Part[VilTeX`Private`graphData, VilTeX`Private`i, 1]]) <> 
                    ",") <> VilTeX`Private`formatNumber[
                    Part[VilTeX`Private`graphData, VilTeX`Private`i, 2]]) <> 
                    ")", {VilTeX`Private`i, 
                    Length[VilTeX`Private`graphData]}], "\n"]) <> "\n};\n"; 
                VilTeX`Private`combinedTikzCode = 
                 VilTeX`Private`combinedTikzCode <> VilTeX`Private`tikzPlot; 
                Null]; Null]; Null], {VilTeX`Private`plotIdx, 
            Length[VilTeX`Private`allPlotData]}]; 
         VilTeX`Private`textTikzCode = ""; 
         If[Length[VilTeX`Private`texto] > 0, 
           Module[{VilTeX`Private`processedAnnotations = {}}, Do[
               
               Module[{
                VilTeX`Private`annotation, VilTeX`Private`text, 
                 VilTeX`Private`coords, VilTeX`Private`options, 
                 VilTeX`Private`xPos, VilTeX`Private`yPos, 
                 VilTeX`Private`textOptions, VilTeX`Private`validCoords}, 
                VilTeX`Private`annotation = 
                 Part[VilTeX`Private`texto, VilTeX`Private`i]; 
                VilTeX`Private`text = ""; VilTeX`Private`textOptions = ""; 
                VilTeX`Private`validCoords = False; If[
                  And[
                   ListQ[VilTeX`Private`annotation], 
                   Length[VilTeX`Private`annotation] >= 2], If[
                    StringQ[
                    Part[VilTeX`Private`annotation, 1]], 
                    VilTeX`Private`text = Part[VilTeX`Private`annotation, 1]; 
                    Null]; If[
                    And[
                    ListQ[
                    Part[VilTeX`Private`annotation, 2]], Length[
                    Part[VilTeX`Private`annotation, 2]] == 2], 
                    VilTeX`Private`coords = 
                    Part[VilTeX`Private`annotation, 2]; If[
                    AllTrue[
                    VilTeX`Private`coords, 
                    NumericQ], {VilTeX`Private`xPos, VilTeX`Private`yPos} = 
                    N[VilTeX`Private`coords]; 
                    VilTeX`Private`validCoords = True; Null]; Null]; If[
                    And[Length[VilTeX`Private`annotation] >= 3, 
                    ListQ[
                    Part[VilTeX`Private`annotation, 3]]], 
                    VilTeX`Private`options = 
                    Part[VilTeX`Private`annotation, 3]; Do[
                    If[
                    And[
                    ListQ[
                    Part[VilTeX`Private`options, VilTeX`Private`j]], Length[
                    Part[VilTeX`Private`options, VilTeX`Private`j]] >= 2], 
                    Module[{VilTeX`Private`key, VilTeX`Private`val}, 
                    VilTeX`Private`key = ToString[
                    Part[
                    Part[VilTeX`Private`options, VilTeX`Private`j], 1]]; 
                    VilTeX`Private`val = ToString[
                    Part[
                    Part[VilTeX`Private`options, VilTeX`Private`j], 2]]; 
                    Which[VilTeX`Private`key == "color", 
                    VilTeX`Private`textOptions = ((VilTeX`Private`textOptions <> 
                    "text=") <> VilTeX`Private`val) <> ",", 
                    VilTeX`Private`key == "size", 
                    VilTeX`Private`textOptions = ((VilTeX`Private`textOptions <> 
                    "font=") <> VilTeX`Private`val) <> ",", 
                    VilTeX`Private`key == "anchor", 
                    VilTeX`Private`textOptions = ((VilTeX`Private`textOptions <> 
                    "anchor=") <> VilTeX`Private`val) <> ",", 
                    VilTeX`Private`key == "rotate", 
                    VilTeX`Private`textOptions = ((VilTeX`Private`textOptions <> 
                    "rotate=") <> VilTeX`Private`val) <> ",", True, 
                    VilTeX`Private`textOptions = (((
                    VilTeX`Private`textOptions <> VilTeX`Private`key) <> "=") <> 
                    VilTeX`Private`val) <> ","]; Null]; Null], {
                    VilTeX`Private`j, 
                    Length[VilTeX`Private`options]}]; Null]; Null]; If[
                  And[
                   StringQ[VilTeX`Private`text], VilTeX`Private`text != "", 
                   VilTeX`Private`validCoords, 
                   
                   AllTrue[{VilTeX`Private`xPos, VilTeX`Private`yPos}, 
                    NumericQ]], If[
                    And[
                    StringLength[VilTeX`Private`textOptions] > 0, 
                    StringTake[VilTeX`Private`textOptions, -1] == ","], 
                    VilTeX`Private`textOptions = 
                    StringDrop[VilTeX`Private`textOptions, -1]; Null]; 
                  AppendTo[
                   VilTeX`Private`processedAnnotations, {
                    VilTeX`Private`text, VilTeX`Private`xPos, 
                    VilTeX`Private`yPos, VilTeX`Private`textOptions}]; Null]; 
                Null], {VilTeX`Private`i, 
                Length[VilTeX`Private`texto]}]; Do[
               
               Module[{
                VilTeX`Private`text, VilTeX`Private`x, VilTeX`Private`y, 
                 VilTeX`Private`opts}, {
                  VilTeX`Private`text, VilTeX`Private`x, VilTeX`Private`y, 
                   VilTeX`Private`opts} = 
                 Part[VilTeX`Private`processedAnnotations, VilTeX`Private`j]; 
                VilTeX`Private`textTikzCode = ((((((((
                    VilTeX`Private`textTikzCode <> "\\node[") <> 
                    VilTeX`Private`opts) <> "] at (axis cs:") <> 
                    VilTeX`Private`formatNumber[VilTeX`Private`x]) <> ",") <> 
                    VilTeX`Private`formatNumber[VilTeX`Private`y]) <> ") {") <> 
                   VilTeX`Private`text) <> "};\n"; Null], {VilTeX`Private`j, 
                Length[VilTeX`Private`processedAnnotations]}]; Null]; Null]; 
         If[StringLength[VilTeX`Private`combinedTikzCode] < 10, 
           Print["Error: No se gener\[OAcute] c\[OAcute]digo TikZ \
v\[AAcute]lido"]; Return[$Failed]; Null]; 
         VilTeX`Private`tikzCode = (((((((((((((((((((((((
                    "\\begin{tikzpicture}\n" <> "\\begin{axis}[\n") <> 
                    "  xlabel={$x$},\n") <> "  ylabel={$y$},\n") <> 
                    If[VilTeX`Private`grid, "  grid=major,\n", ""]) <> "  ") <> 
                    VilTeX`Private`axisConfiguration) <> ",\n") <> "  xmin=") <> 
                    VilTeX`Private`formatNumber[
                    Part[VilTeX`Private`globalLimits, 1]]) <> ", xmax=") <> 
                    VilTeX`Private`formatNumber[
                    Part[VilTeX`Private`globalLimits, 2]]) <> ",\n") <> 
                    "  ymin=") <> VilTeX`Private`formatNumber[
                    Part[VilTeX`Private`globalLimits, 3]]) <> ", ymax=") <> 
                   VilTeX`Private`formatNumber[
                    Part[VilTeX`Private`globalLimits, 4]]) <> ",\n") <> 
                 "  axis equal=false,\n") <> "  samples=50\n") <> "]\n") <> 
              VilTeX`Private`combinedTikzCode) <> 
             VilTeX`Private`textTikzCode) <> "\\end{axis}\n") <> 
           "\\end{tikzpicture}"; 
         VilTeX`Private`fullDocument = ((((((((
                   "\\documentclass[border=5mm]{standalone}\n" <> 
                   "\\usepackage{tikz}\n") <> "\\usepackage{pgfplots}\n") <> 
                 "\\usepackage{amsmath}\n") <> "\\usepackage{amssymb}\n") <> 
               "\\pgfplotsset{compat=1.18}\n") <> 
              "\\usepgfplotslibrary{colorbrewer}\n") <> 
             "\n\\begin{document}\n") <> VilTeX`Private`tikzCode) <> 
           "\n\\end{document}"; 
         Export[VilTeX`Private`downloadPath, VilTeX`Private`fullDocument, 
           "Text"]; VilTeX`Private`downloadPath]}], "SubValues" -> None, 
    "DefaultValues" -> None, "NValues" -> None, "FormatValues" -> None, 
    "Options" -> None, "Attributes" -> {Protected}, "FullName" -> 
    "VilTeX`ExportContour2DToTikZ"|>, False]]], "Output",
 CellChangeTimes->{3.9675540090228214`*^9, 3.96755435941131*^9},
 CellLabel->"Out[3]=",ExpressionUUID->"d31347cc-8319-ff4a-ad2b-63116068b9a5"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Ejemplo 1: c\[IAcute]rculo", "Subsection",
 CellChangeTimes->{{3.9675372440640697`*^9, 3.967537246104553*^9}, {
  3.967537520944647*^9, 3.9675375259382935`*^9}, {3.967573704248801*^9, 
  3.967573717898753*^9}, {3.967574224840391*^9, 
  3.967574238149569*^9}},ExpressionUUID->"aedbc735-ffe0-524f-b550-\
513b77f9af12"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"ContourPlot", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"x", "^", "2"}], "-", 
      RowBox[{"2.0", " ", "x"}], "+", 
      RowBox[{"y", "^", "2"}], "+", "y", "-", "2.75"}], "==", "0"}], ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", 
      RowBox[{"-", "2"}], ",", "4"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"y", ",", 
      RowBox[{"-", "3"}], ",", "2"}], "}"}], ",", 
    RowBox[{"Frame", "->", "False"}], ",", 
    RowBox[{"Axes", "->", "True"}]}], "]"}], "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"line", "[", "]"}], ":=", 
  RowBox[{"RandomChoice", "[", 
   RowBox[{"{", 
    RowBox[{"\"\<solid\>\"", ",", "\"\<dashed\>\"", ",", "\"\<dotted\>\"", 
     ",", "\"\<thick\>\"", ",", "\"\<thin\>\""}], "}"}], "]"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"color", "[", "]"}], ":=", 
  RowBox[{"RandomChoice", "[", 
   RowBox[{"{", 
    RowBox[{"\"\<blue\>\"", ",", "\"\<red\>\"", ",", "\"\<green\>\"", 
     ",", "\"\<purple\>\"", ",", "\"\<yellow\>\"", ",", "\"\<orange\>\"", 
     ",", "\"\<cyan\>\"", ",", "\"\<magenta\>\"", ",", "\"\<black\>\""}], 
    "}"}], "]"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"sizetexto", "[", "]"}], ":=", 
  RowBox[{"RandomChoice", "[", 
   RowBox[{"{", 
    RowBox[{"\"\<\\\\tiny\>\"", ",", "\"\<\\\\scriptsize\>\"", 
     ",", "\"\<\\\\footnotesize\>\"", ",", "\"\<\\\\small\>\"", 
     ",", "\"\<\\\\normalsize\>\"", ",", "\"\<\\\\large\>\"", 
     ",", "\"\<\\\\Large\>\"", ",", "\"\<\\\\huge\>\"", 
     ",", "\"\<\\\\Huge\>\""}], "}"}], "]"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"anclajetexto", "[", "]"}], ":=", 
  RowBox[{"RandomChoice", "[", 
   RowBox[{"{", 
    RowBox[{"\"\<north\>\"", ",", "\"\<south\>\"", ",", "\"\<east\>\"", 
     ",", "\"\<west\>\"", ",", "\"\<north east\>\"", ",", "\"\<north west\>\"",
      ",", "\"\<south east\>\"", ",", "\"\<south west\>\"", 
     ",", "\"\<center\>\""}], "}"}], "]"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"rotatexto", "[", "]"}], ":=", 
  RowBox[{"RandomReal", "[", 
   RowBox[{"{", 
    RowBox[{"0", ",", "360"}], "}"}], "]"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"estilotext", "[", "n_", "]"}], ":=", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"\"\<color\>\"", ",", 
        RowBox[{"color", "[", "]"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"\"\<size\>\"", ",", 
        RowBox[{"sizetexto", "[", "]"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"\"\<anchor\>\"", ",", 
        RowBox[{"anclajetexto", "[", "]"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"\"\<rotate\>\"", ",", 
        RowBox[{"rotatexto", "[", "]"}]}], "}"}]}], "}"}], ",", "n"}], 
   "]"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"vectorestilos", "=", 
   RowBox[{"estilotext", "[", "1", "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Row", "[", 
    RowBox[{"{", 
     RowBox[{"\"\<grid=\>\"", ",", 
      RowBox[{"grid", "=", "True"}]}], "}"}], "]"}], ",", 
   RowBox[{"Row", "[", 
    RowBox[{"{", 
     RowBox[{"\"\<estilos=\>\"", ",", 
      RowBox[{"estilos", "=", 
       RowBox[{"Table", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"line", "[", "]"}], ",", 
           RowBox[{"color", "[", "]"}]}], "}"}], ",", "1"}], "]"}]}]}], "}"}],
     "]"}], ",", 
   RowBox[{"Row", "[", 
    RowBox[{"{", 
     RowBox[{"\"\<ejes=\>\"", ",", 
      RowBox[{"ejes", "=", "True"}]}], "}"}], "]"}], ",", 
   RowBox[{"Row", "[", 
    RowBox[{"{", 
     RowBox[{"\"\<texto=\>\"", ",", 
      RowBox[{"texto", "=", 
       RowBox[{"{", 
        RowBox[{"{", 
         RowBox[{"\"\<C\[IAcute]rculo\>\"", ",", 
          RowBox[{"{", 
           RowBox[{"0.5", ",", "0.5"}], "}"}], ",", 
          RowBox[{"vectorestilos", "[", 
           RowBox[{"[", "1", "]"}], "]"}]}], "}"}], "}"}]}]}], "}"}], "]"}], ",", 
   RowBox[{"Row", "[", 
    RowBox[{"{", 
     RowBox[{"\"\<muestras=\>\"", ",", 
      RowBox[{"muestras", "=", "1500"}]}], "}"}], "]"}], ",", 
   RowBox[{"Row", "[", 
    RowBox[{"{", 
     RowBox[{"\"\<tolerancia=\>\"", ",", 
      RowBox[{"tolerancia", "=", "0.01"}]}], "}"}], "]"}], ",", 
   RowBox[{"Row", "[", 
    RowBox[{"{", 
     RowBox[{"\"\<opacidad=\>\"", ",", 
      RowBox[{"opacidad", "=", "0.8"}]}], "}"}], "]"}], ",", 
   RowBox[{"Row", "[", 
    RowBox[{"{", 
     RowBox[{"\"\<densidad=\>\"", ",", 
      RowBox[{"densidad", "=", "3"}]}], "}"}], "]"}], ",", 
   RowBox[{"Row", "[", 
    RowBox[{"{", 
     RowBox[{"\"\<xmin=\>\"", ",", 
      RowBox[{"xmin", "=", "Automatic"}]}], "}"}], "]"}], ",", 
   RowBox[{"Row", "[", 
    RowBox[{"{", 
     RowBox[{"\"\<xmax=\>\"", ",", 
      RowBox[{"xmax", "=", "Automatic"}]}], "}"}], "]"}], ",", 
   RowBox[{"Row", "[", 
    RowBox[{"{", 
     RowBox[{"\"\<ymin=\>\"", ",", 
      RowBox[{"ymin", "=", "Automatic"}]}], "}"}], "]"}], ",", 
   RowBox[{"Row", "[", 
    RowBox[{"{", 
     RowBox[{"\"\<ymax=\>\"", ",", 
      RowBox[{"ymax", "=", "Automatic"}]}], "}"}], "]"}]}], "}"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ExportContour2DToTikZ", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"x", "^", "2"}], "-", 
      RowBox[{"2.0", " ", "x"}], "+", 
      RowBox[{"y", "^", "2"}], "+", "y", "-", "2.75"}], "==", "0"}], 
    ",", "\"\<Contour2D1.tex\>\"", ",", "grid", ",", "estilos", ",", "ejes", ",",
     "texto", ",", "muestras", ",", "tolerancia", ",", "opacidad", ",", 
    "densidad", ",", "xmin", ",", "xmax", ",", "ymin", ",", "ymax"}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"CompiladorTex", "[", 
  RowBox[{"%", ",", 
   RowBox[{"\"\<PreferredEditor\>\"", " ", "->", "\"\<TeXstudio\>\""}]}], 
  "]"}]}], "Input",
 CellChangeTimes->{{3.9675375194196777`*^9, 3.9675375301276264`*^9}, {
   3.9675382830313473`*^9, 3.967538283385248*^9}, {3.967545063135708*^9, 
   3.9675450781144104`*^9}, {3.9675451238366413`*^9, 3.967545129861538*^9}, {
   3.967554373336567*^9, 3.967554373818041*^9}, 3.9675544086215553`*^9, {
   3.9675545483811226`*^9, 3.967554596819788*^9}, {3.967571356868919*^9, 
   3.967571357228691*^9}, {3.967571485678443*^9, 3.967571487103242*^9}, {
   3.96757163921257*^9, 3.967571639540188*^9}, {3.967571709854518*^9, 
   3.967571882486472*^9}, {3.967571962042383*^9, 3.96757216265941*^9}, {
   3.967572198241742*^9, 3.967572242971116*^9}, {3.967572273414727*^9, 
   3.9675722767709293`*^9}, {3.967572335182097*^9, 3.967572350933379*^9}, {
   3.967572490575357*^9, 3.967572543283812*^9}, {3.967573487433752*^9, 
   3.967573554677144*^9}, {3.9675736138581743`*^9, 3.967573686959343*^9}, {
   3.9675737299830093`*^9, 3.9675737411396313`*^9}, {3.967574132860317*^9, 
   3.96757417398822*^9}, {3.967574206416132*^9, 3.967574209554451*^9}, 
   3.9676342308058653`*^9, {3.967635130587928*^9, 3.967635131096423*^9}},
 CellLabel->
  "In[1917]:=",ExpressionUUID->"ce12c71b-428c-e144-9d71-f38477a56818"],

Cell[BoxData[
 GraphicsBox[{GraphicsComplexBox[CompressedData["
1:eJxdV3s8lGkbZl4z08eqTdvZSkm1qs/XWSX3i8rmkA5fbWjTYTtQOumgJEmr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    "], {{}, {}, 
     TagBox[
      TooltipBox[
       {RGBColor[0.24, 0.6, 0.8], AbsoluteThickness[2], 
        LineBox[{1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 
         18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 
         35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 
         52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 64, 65, 66, 67, 68, 
         69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 
         86, 87, 88, 89, 90, 91, 92, 93, 94, 95, 96, 97, 98, 99, 100, 101, 
         102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115,
          116, 117, 118, 119, 120, 121, 122, 123, 124, 125, 126, 127, 128, 
         129, 130, 131, 132, 133, 134, 135, 136, 137, 138, 139, 140, 141, 142,
          143, 144, 145, 146, 147, 148, 149, 150, 151, 152, 153, 154, 155, 
         156, 157, 158, 159, 160, 161, 162, 163, 164, 165, 166, 167, 168, 169,
          170, 171, 172, 173, 174, 175, 176, 177, 178, 179, 180, 181, 182, 
         183, 184, 185, 186, 187, 188, 189, 190, 191, 192, 193, 194, 195, 196,
          197, 198, 199, 200, 201, 202, 203, 204, 205, 206, 207, 208, 209, 
         210, 211, 212, 213, 214, 215, 216, 217, 218, 219, 220, 221, 222, 223,
          224, 225, 226, 227}]},
       RowBox[{
         RowBox[{
           RowBox[{"-", "2.75`"}], "-", 
           RowBox[{"2.`", " ", 
             TagBox["x", HoldForm]}], "+", 
           SuperscriptBox[
            TagBox["x", HoldForm], "2"], "+", 
           TagBox["y", HoldForm], "+", 
           SuperscriptBox[
            TagBox["y", HoldForm], "2"]}], "\[Equal]", "0"}]],
      Annotation[#, -2.75 - 2. HoldForm[$CellContext`x] + 
        HoldForm[$CellContext`x]^2 + HoldForm[$CellContext`y] + 
        HoldForm[$CellContext`y]^2 == 0, "Tooltip"]& ]}], {}},
  AspectRatio->1,
  Axes->True,
  AxesLabel->{None, None},
  AxesOrigin->{0., 0.},
  DefaultBaseStyle->{"PlotGraphics", "Graphics"},
  DisplayFunction->Identity,
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  Method->{
   "DefaultBoundaryStyle" -> Automatic, 
    "DefaultGraphicsInteraction" -> {
     "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
      "Effects" -> {
       "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
        "Droplines" -> {
         "freeformCursorMode" -> True, 
          "placement" -> {"x" -> "All", "y" -> "None"}}}}, "GridLinesInFront" -> 
    True},
  PlotInteractivity:>True,
  PlotRange->{{-2, 4}, {-3, 2}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.02], 
     Scaled[0.02]}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{
  3.967572183743313*^9, {3.9675722191077023`*^9, 3.967572244821638*^9}, 
   3.967572281505775*^9, {3.967572337959147*^9, 3.967572351342558*^9}, 
   3.9675725095413322`*^9, {3.967573488662796*^9, 3.9675735551341*^9}, {
   3.9675736168216476`*^9, 3.967573687406411*^9}, {3.967573730438876*^9, 
   3.967573741670952*^9}, {3.967574180262212*^9, 3.967574210475676*^9}, 
   3.967574243465581*^9, 3.967635131443644*^9, 3.967635190001656*^9},
 CellLabel->
  "Out[1917]=",ExpressionUUID->"db6dc775-0929-4db8-8c2e-74642a265c38"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TemplateBox[{"\"grid=\"", "True"},
    "RowDefault"], ",", 
   TemplateBox[{"\"estilos=\"", 
     RowBox[{"{", 
       RowBox[{"{", 
         RowBox[{"\"dashed\"", ",", "\"purple\""}], "}"}], "}"}]},
    "RowDefault"], ",", 
   TemplateBox[{"\"ejes=\"", "True"},
    "RowDefault"], ",", 
   TemplateBox[{"\"texto=\"", 
     RowBox[{"{", 
       RowBox[{"{", 
         RowBox[{"\"C\[IAcute]rculo\"", ",", 
           RowBox[{"{", 
             RowBox[{"0.5`", ",", "0.5`"}], "}"}], ",", 
           RowBox[{"{", 
             RowBox[{
               RowBox[{"{", 
                 RowBox[{"\"color\"", ",", "\"red\""}], "}"}], ",", 
               RowBox[{"{", 
                 RowBox[{"\"size\"", ",", "\"\\\\small\""}], "}"}], ",", 
               RowBox[{"{", 
                 RowBox[{"\"anchor\"", ",", "\"south\""}], "}"}], ",", 
               RowBox[{"{", 
                 RowBox[{"\"rotate\"", ",", "302.3688862150393`"}], "}"}]}], 
             "}"}]}], "}"}], "}"}]},
    "RowDefault"], ",", 
   TemplateBox[{"\"muestras=\"", "1500"},
    "RowDefault"], ",", 
   TemplateBox[{"\"tolerancia=\"", "0.01`"},
    "RowDefault"], ",", 
   TemplateBox[{"\"opacidad=\"", "0.8`"},
    "RowDefault"], ",", 
   TemplateBox[{"\"densidad=\"", "3"},
    "RowDefault"], ",", 
   TemplateBox[{"\"xmin=\"", "Automatic"},
    "RowDefault"], ",", 
   TemplateBox[{"\"xmax=\"", "Automatic"},
    "RowDefault"], ",", 
   TemplateBox[{"\"ymin=\"", "Automatic"},
    "RowDefault"], ",", 
   TemplateBox[{"\"ymax=\"", "Automatic"},
    "RowDefault"]}], "}"}]], "Output",
 CellChangeTimes->{
  3.967572183743313*^9, {3.9675722191077023`*^9, 3.967572244821638*^9}, 
   3.967572281505775*^9, {3.967572337959147*^9, 3.967572351342558*^9}, 
   3.9675725095413322`*^9, {3.967573488662796*^9, 3.9675735551341*^9}, {
   3.9675736168216476`*^9, 3.967573687406411*^9}, {3.967573730438876*^9, 
   3.967573741670952*^9}, {3.967574180262212*^9, 3.967574210475676*^9}, 
   3.967574243465581*^9, 3.967635131443644*^9, 3.9676351900048*^9},
 CellLabel->
  "Out[1925]=",ExpressionUUID->"e8a58309-5da6-4fa5-83b8-7570729d9608"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Usando editores ya detectados: \"\>", "\[InvisibleSpace]", "4",
    "\[InvisibleSpace]", "\<\" disponibles\"\>"}],
  SequenceForm["Usando editores ya detectados: ", 4, " disponibles"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.967572183804584*^9, {3.9675722191513577`*^9, 3.967572244861312*^9}, 
   3.967572281548574*^9, {3.967572338000333*^9, 3.9675723513826437`*^9}, 
   3.967572509581525*^9, {3.967573488674449*^9, 3.9675735551475477`*^9}, {
   3.967573616837818*^9, 3.967573687410324*^9}, {3.967573730442685*^9, 
   3.96757374167479*^9}, {3.967574180589888*^9, 3.967574210803865*^9}, 
   3.967574243796587*^9, 3.967635131775442*^9, 3.967635190335713*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[1917]:=",ExpressionUUID->"aa89fdfd-7b4a-4e21-83de-54fc414462be"],

Cell[BoxData["\<\"Buscando pdflatex...\"\>"], "Print",
 CellChangeTimes->{
  3.967572183804584*^9, {3.9675722191513577`*^9, 3.967572244861312*^9}, 
   3.967572281548574*^9, {3.967572338000333*^9, 3.9675723513826437`*^9}, 
   3.967572509581525*^9, {3.967573488674449*^9, 3.9675735551475477`*^9}, {
   3.967573616837818*^9, 3.967573687410324*^9}, {3.967573730442685*^9, 
   3.96757374167479*^9}, {3.967574180589888*^9, 3.967574210803865*^9}, 
   3.967574243796587*^9, 3.967635131775442*^9, 3.967635190336514*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[1917]:=",ExpressionUUID->"57be25ca-71e3-4686-b4af-e704cc709ac8"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"pdflatex encontrado: \"\>", 
   "\[InvisibleSpace]", "\<\"/Library/TeX/texbin/pdflatex\"\>"}],
  SequenceForm["pdflatex encontrado: ", "/Library/TeX/texbin/pdflatex"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.967572183804584*^9, {3.9675722191513577`*^9, 3.967572244861312*^9}, 
   3.967572281548574*^9, {3.967572338000333*^9, 3.9675723513826437`*^9}, 
   3.967572509581525*^9, {3.967573488674449*^9, 3.9675735551475477`*^9}, {
   3.967573616837818*^9, 3.967573687410324*^9}, {3.967573730442685*^9, 
   3.96757374167479*^9}, {3.967574180589888*^9, 3.967574210803865*^9}, 
   3.967574243796587*^9, 3.967635131775442*^9, 3.967635190337201*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[1917]:=",ExpressionUUID->"486e0db5-37d0-49bf-9a48-b137dc0ffa19"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Editor '\"\>", "\[InvisibleSpace]", "\<\"TeXstudio\"\>", 
   "\[InvisibleSpace]", "\<\"' encontrado (match exacto)\"\>"}],
  SequenceForm["Editor '", "TeXstudio", "' encontrado (match exacto)"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.967572183804584*^9, {3.9675722191513577`*^9, 3.967572244861312*^9}, 
   3.967572281548574*^9, {3.967572338000333*^9, 3.9675723513826437`*^9}, 
   3.967572509581525*^9, {3.967573488674449*^9, 3.9675735551475477`*^9}, {
   3.967573616837818*^9, 3.967573687410324*^9}, {3.967573730442685*^9, 
   3.96757374167479*^9}, {3.967574180589888*^9, 3.967574210803865*^9}, 
   3.967574243796587*^9, 3.967635131775442*^9, 3.96763519033762*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[1917]:=",ExpressionUUID->"9714fff8-edc7-49d7-ab6d-587d39dd9d2e"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Abriendo archivo en \"\>", 
   "\[InvisibleSpace]", "\<\"TeXstudio\"\>", 
   "\[InvisibleSpace]", "\<\"...\"\>"}],
  SequenceForm["Abriendo archivo en ", "TeXstudio", "..."],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.967572183804584*^9, {3.9675722191513577`*^9, 3.967572244861312*^9}, 
   3.967572281548574*^9, {3.967572338000333*^9, 3.9675723513826437`*^9}, 
   3.967572509581525*^9, {3.967573488674449*^9, 3.9675735551475477`*^9}, {
   3.967573616837818*^9, 3.967573687410324*^9}, {3.967573730442685*^9, 
   3.96757374167479*^9}, {3.967574180589888*^9, 3.967574210803865*^9}, 
   3.967574243796587*^9, 3.967635131775442*^9, 3.967635190338024*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[1917]:=",ExpressionUUID->"1adf1dde-4e19-4b6a-89b0-b447f7c153fd"],

Cell[BoxData["\<\"Editor abierto correctamente\"\>"], "Print",
 CellChangeTimes->{
  3.967572183804584*^9, {3.9675722191513577`*^9, 3.967572244861312*^9}, 
   3.967572281548574*^9, {3.967572338000333*^9, 3.9675723513826437`*^9}, 
   3.967572509581525*^9, {3.967573488674449*^9, 3.9675735551475477`*^9}, {
   3.967573616837818*^9, 3.967573687410324*^9}, {3.967573730442685*^9, 
   3.96757374167479*^9}, {3.967574180589888*^9, 3.967574210803865*^9}, 
   3.967574243796587*^9, 3.967635131775442*^9, 3.967635190431548*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[1917]:=",ExpressionUUID->"ecaac28a-c1d4-414f-920d-ff4bb5d3308e"],

Cell[BoxData["\<\"Compilando documento LaTeX...\"\>"], "Print",
 CellChangeTimes->{
  3.967572183804584*^9, {3.9675722191513577`*^9, 3.967572244861312*^9}, 
   3.967572281548574*^9, {3.967572338000333*^9, 3.9675723513826437`*^9}, 
   3.967572509581525*^9, {3.967573488674449*^9, 3.9675735551475477`*^9}, {
   3.967573616837818*^9, 3.967573687410324*^9}, {3.967573730442685*^9, 
   3.96757374167479*^9}, {3.967574180589888*^9, 3.967574210803865*^9}, 
   3.967574243796587*^9, 3.967635131775442*^9, 3.967635191438057*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[1917]:=",ExpressionUUID->"197a98f1-49a1-4cee-99a7-d271fb1bc402"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Directorio de trabajo: \"\>", 
   "\[InvisibleSpace]", \
"\<\"/Users/enriquevilchezquesada/Downloads/Contour2D1/\"\>"}],
  SequenceForm[
  "Directorio de trabajo: ", 
   "/Users/enriquevilchezquesada/Downloads/Contour2D1/"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.967572183804584*^9, {3.9675722191513577`*^9, 3.967572244861312*^9}, 
   3.967572281548574*^9, {3.967572338000333*^9, 3.9675723513826437`*^9}, 
   3.967572509581525*^9, {3.967573488674449*^9, 3.9675735551475477`*^9}, {
   3.967573616837818*^9, 3.967573687410324*^9}, {3.967573730442685*^9, 
   3.96757374167479*^9}, {3.967574180589888*^9, 3.967574210803865*^9}, 
   3.967574243796587*^9, 3.967635131775442*^9, 3.967635191441515*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[1917]:=",ExpressionUUID->"1f4bd14a-eda3-49ab-bcfe-31f9cc3fc636"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Archivo: \"\>", "\[InvisibleSpace]", "\<\"Contour2D1\"\>"}],
  SequenceForm["Archivo: ", "Contour2D1"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.967572183804584*^9, {3.9675722191513577`*^9, 3.967572244861312*^9}, 
   3.967572281548574*^9, {3.967572338000333*^9, 3.9675723513826437`*^9}, 
   3.967572509581525*^9, {3.967573488674449*^9, 3.9675735551475477`*^9}, {
   3.967573616837818*^9, 3.967573687410324*^9}, {3.967573730442685*^9, 
   3.96757374167479*^9}, {3.967574180589888*^9, 3.967574210803865*^9}, 
   3.967574243796587*^9, 3.967635131775442*^9, 3.967635191444029*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[1917]:=",ExpressionUUID->"0fa7265b-14cb-457d-9b42-3e8980050c1f"],

Cell[BoxData["\<\"Compilaci\[OAcute]n exitosa\"\>"], "Print",
 CellChangeTimes->{
  3.967572183804584*^9, {3.9675722191513577`*^9, 3.967572244861312*^9}, 
   3.967572281548574*^9, {3.967572338000333*^9, 3.9675723513826437`*^9}, 
   3.967572509581525*^9, {3.967573488674449*^9, 3.9675735551475477`*^9}, {
   3.967573616837818*^9, 3.967573687410324*^9}, {3.967573730442685*^9, 
   3.96757374167479*^9}, {3.967574180589888*^9, 3.967574210803865*^9}, 
   3.967574243796587*^9, 3.967635131775442*^9, 3.967635195452235*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[1917]:=",ExpressionUUID->"659e3ad8-cfa2-4b74-b69e-76690dc09622"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"PDF generado: \"\>", 
   "\[InvisibleSpace]", \
"\<\"/Users/enriquevilchezquesada/Downloads/Contour2D1/Contour2D1.pdf\"\>"}],
  SequenceForm[
  "PDF generado: ", 
   "/Users/enriquevilchezquesada/Downloads/Contour2D1/Contour2D1.pdf"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.967572183804584*^9, {3.9675722191513577`*^9, 3.967572244861312*^9}, 
   3.967572281548574*^9, {3.967572338000333*^9, 3.9675723513826437`*^9}, 
   3.967572509581525*^9, {3.967573488674449*^9, 3.9675735551475477`*^9}, {
   3.967573616837818*^9, 3.967573687410324*^9}, {3.967573730442685*^9, 
   3.96757374167479*^9}, {3.967574180589888*^9, 3.967574210803865*^9}, 
   3.967574243796587*^9, 3.967635131775442*^9, 3.9676351954530087`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[1917]:=",ExpressionUUID->"4d27f3c5-1905-4ce5-bdfc-0d63b47aedc1"]
}, Open  ]],

Cell[BoxData["\<\"/Users/enriquevilchezquesada/Downloads/Contour2D1/\
Contour2D1.pdf\"\>"], "Output",
 CellChangeTimes->{
  3.967572183743313*^9, {3.9675722191077023`*^9, 3.967572244821638*^9}, 
   3.967572281505775*^9, {3.967572337959147*^9, 3.967572351342558*^9}, 
   3.9675725095413322`*^9, {3.967573488662796*^9, 3.9675735551341*^9}, {
   3.9675736168216476`*^9, 3.967573687406411*^9}, {3.967573730438876*^9, 
   3.967573741670952*^9}, {3.967574180262212*^9, 3.967574210475676*^9}, 
   3.967574243465581*^9, 3.967635131443644*^9, 3.967635195466894*^9},
 CellLabel->
  "Out[1927]=",ExpressionUUID->"d51e2200-fc8f-4efa-aa7c-71e5226b1bbc"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Ejemplo 2: elipse", "Subsection",
 CellChangeTimes->{{3.9675372440640697`*^9, 3.96753726323666*^9}, {
  3.9675375332433357`*^9, 
  3.967537536148617*^9}},ExpressionUUID->"896ca620-2681-8c44-9a07-\
6b27937a3581"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"ContourPlot", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"0.111111", " ", 
       RowBox[{"x", "^", "2"}]}], "-", 
      RowBox[{"0.444444", " ", "x"}], "+", 
      RowBox[{"0.444444", " ", 
       RowBox[{"y", "^", "2"}]}], "+", 
      RowBox[{"0.888889", " ", "y"}], "-", "0.111111"}], "==", "0"}], ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", 
      RowBox[{"-", "2.5"}], ",", "6.5"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"y", ",", 
      RowBox[{"-", "3"}], ",", "1"}], "}"}], ",", 
    RowBox[{"Frame", "->", "False"}], ",", 
    RowBox[{"Axes", "->", "True"}]}], "]"}], "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"line", "[", "]"}], ":=", 
  RowBox[{"RandomChoice", "[", 
   RowBox[{"{", 
    RowBox[{"\"\<solid\>\"", ",", "\"\<dashed\>\"", ",", "\"\<dotted\>\"", 
     ",", "\"\<thick\>\"", ",", "\"\<thin\>\""}], "}"}], "]"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"color", "[", "]"}], ":=", 
  RowBox[{"RandomChoice", "[", 
   RowBox[{"{", 
    RowBox[{"\"\<blue\>\"", ",", "\"\<red\>\"", ",", "\"\<green\>\"", 
     ",", "\"\<purple\>\"", ",", "\"\<yellow\>\"", ",", "\"\<orange\>\"", 
     ",", "\"\<cyan\>\"", ",", "\"\<magenta\>\"", ",", "\"\<black\>\""}], 
    "}"}], "]"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"sizetexto", "[", "]"}], ":=", 
  RowBox[{"RandomChoice", "[", 
   RowBox[{"{", 
    RowBox[{"\"\<\\\\tiny\>\"", ",", "\"\<\\\\scriptsize\>\"", 
     ",", "\"\<\\\\footnotesize\>\"", ",", "\"\<\\\\small\>\"", 
     ",", "\"\<\\\\normalsize\>\"", ",", "\"\<\\\\large\>\"", 
     ",", "\"\<\\\\Large\>\"", ",", "\"\<\\\\huge\>\"", 
     ",", "\"\<\\\\Huge\>\""}], "}"}], "]"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"anclajetexto", "[", "]"}], ":=", 
  RowBox[{"RandomChoice", "[", 
   RowBox[{"{", 
    RowBox[{"\"\<north\>\"", ",", "\"\<south\>\"", ",", "\"\<east\>\"", 
     ",", "\"\<west\>\"", ",", "\"\<north east\>\"", ",", "\"\<north west\>\"",
      ",", "\"\<south east\>\"", ",", "\"\<south west\>\"", 
     ",", "\"\<center\>\""}], "}"}], "]"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"rotatexto", "[", "]"}], ":=", 
  RowBox[{"RandomReal", "[", 
   RowBox[{"{", 
    RowBox[{"0", ",", "360"}], "}"}], "]"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"estilotext", "[", "n_", "]"}], ":=", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"\"\<color\>\"", ",", 
        RowBox[{"color", "[", "]"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"\"\<size\>\"", ",", 
        RowBox[{"sizetexto", "[", "]"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"\"\<anchor\>\"", ",", 
        RowBox[{"anclajetexto", "[", "]"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"\"\<rotate\>\"", ",", 
        RowBox[{"rotatexto", "[", "]"}]}], "}"}]}], "}"}], ",", "n"}], 
   "]"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"vectorestilos", "=", 
   RowBox[{"estilotext", "[", "1", "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Row", "[", 
    RowBox[{"{", 
     RowBox[{"\"\<grid=\>\"", ",", 
      RowBox[{"grid", "=", "True"}]}], "}"}], "]"}], ",", 
   RowBox[{"Row", "[", 
    RowBox[{"{", 
     RowBox[{"\"\<estilos=\>\"", ",", 
      RowBox[{"estilos", "=", 
       RowBox[{"Table", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"line", "[", "]"}], ",", 
           RowBox[{"color", "[", "]"}]}], "}"}], ",", "1"}], "]"}]}]}], "}"}],
     "]"}], ",", 
   RowBox[{"Row", "[", 
    RowBox[{"{", 
     RowBox[{"\"\<ejes=\>\"", ",", 
      RowBox[{"ejes", "=", "True"}]}], "}"}], "]"}], ",", 
   RowBox[{"Row", "[", 
    RowBox[{"{", 
     RowBox[{"\"\<texto=\>\"", ",", 
      RowBox[{"texto", "=", 
       RowBox[{"{", 
        RowBox[{"{", 
         RowBox[{"\"\<Elipse\>\"", ",", 
          RowBox[{"{", 
           RowBox[{"1", ",", 
            RowBox[{"-", "1"}]}], "}"}], ",", 
          RowBox[{"vectorestilos", "[", 
           RowBox[{"[", "1", "]"}], "]"}]}], "}"}], "}"}]}]}], "}"}], "]"}], ",", 
   RowBox[{"Row", "[", 
    RowBox[{"{", 
     RowBox[{"\"\<muestras=\>\"", ",", 
      RowBox[{"muestras", "=", "1700"}]}], "}"}], "]"}], ",", 
   RowBox[{"Row", "[", 
    RowBox[{"{", 
     RowBox[{"\"\<tolerancia=\>\"", ",", 
      RowBox[{"tolerancia", "=", "0.01"}]}], "}"}], "]"}], ",", 
   RowBox[{"Row", "[", 
    RowBox[{"{", 
     RowBox[{"\"\<opacidad=\>\"", ",", 
      RowBox[{"opacidad", "=", "0.8"}]}], "}"}], "]"}], ",", 
   RowBox[{"Row", "[", 
    RowBox[{"{", 
     RowBox[{"\"\<densidad=\>\"", ",", 
      RowBox[{"densidad", "=", "1.4"}]}], "}"}], "]"}], ",", 
   RowBox[{"Row", "[", 
    RowBox[{"{", 
     RowBox[{"\"\<xmin=\>\"", ",", 
      RowBox[{"xmin", "=", 
       RowBox[{"-", "2.5"}]}]}], "}"}], "]"}], ",", 
   RowBox[{"Row", "[", 
    RowBox[{"{", 
     RowBox[{"\"\<xmax=\>\"", ",", 
      RowBox[{"xmax", "=", "6.5"}]}], "}"}], "]"}], ",", 
   RowBox[{"Row", "[", 
    RowBox[{"{", 
     RowBox[{"\"\<ymin=\>\"", ",", 
      RowBox[{"ymin", "=", 
       RowBox[{"-", "3"}]}]}], "}"}], "]"}], ",", 
   RowBox[{"Row", "[", 
    RowBox[{"{", 
     RowBox[{"\"\<ymax=\>\"", ",", 
      RowBox[{"ymax", "=", "1"}]}], "}"}], "]"}]}], "}"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ExportContour2DToTikZ", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"0.111111", " ", 
       RowBox[{"x", "^", "2"}]}], "-", 
      RowBox[{"0.444444", " ", "x"}], "+", 
      RowBox[{"0.444444", " ", 
       RowBox[{"y", "^", "2"}]}], "+", 
      RowBox[{"0.888889", " ", "y"}], "-", "0.111111"}], "==", "0"}], 
    ",", "\"\<Contour2D2.tex\>\"", ",", "grid", ",", "estilos", ",", "ejes", ",",
     "texto", ",", "muestras", ",", "tolerancia", ",", "opacidad", ",", 
    "densidad", ",", "xmin", ",", "xmax", ",", "ymin", ",", "ymax"}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"CompiladorTex", "[", 
  RowBox[{"%", ",", 
   RowBox[{"\"\<PreferredEditor\>\"", " ", "->", "\"\<TeXstudio\>\""}]}], 
  "]"}]}], "Input",
 CellChangeTimes->{{3.9675375392458973`*^9, 3.9675375409414043`*^9}, {
   3.9675382806607704`*^9, 3.9675382809512615`*^9}, {3.9675451404781227`*^9, 
   3.967545153538784*^9}, {3.967573775644644*^9, 3.9675737760654078`*^9}, {
   3.9675739353409033`*^9, 3.967573936887575*^9}, {3.967627305186019*^9, 
   3.9676274737297583`*^9}, {3.967627553970385*^9, 3.967627657769099*^9}, {
   3.967627688685264*^9, 3.9676277968377132`*^9}, 3.967634224414747*^9, {
   3.9676351208039637`*^9, 3.967635121273364*^9}},
 CellLabel->
  "In[1928]:=",ExpressionUUID->"bd1b282a-801a-ed4e-8a8b-155aa64fc966"],

Cell[BoxData[
 GraphicsBox[{GraphicsComplexBox[CompressedData["
1:eJxdV3lYjdse3oMGlYa9xe1kSqFQN0O4RWu5dZocxZZwOCinaCRD5pQhGpBK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    "], {{}, {}, 
     TagBox[
      TooltipBox[
       {RGBColor[0.24, 0.6, 0.8], AbsoluteThickness[2], 
        LineBox[{1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 
         18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 
         35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 
         52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 64, 65, 66, 67, 68, 
         69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 
         86, 87, 88, 89, 90, 91, 92, 93, 94, 95, 96, 97, 98, 99, 100, 101, 
         102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115,
          116, 117, 118, 119, 120, 121, 122, 123, 124, 125, 126, 127, 128, 
         129, 130, 131, 132, 133, 134, 135, 136, 137, 138, 139, 140, 141, 142,
          143, 144, 145, 146, 147, 148, 149, 150, 151, 152, 153, 154, 155, 
         156, 157, 158, 159, 160, 161, 162, 163, 164, 165, 166, 167, 168, 169,
          170, 171, 172, 173, 174, 175, 176, 177, 178, 179, 180, 181, 182, 
         183, 184, 185, 186, 187, 188, 189, 190, 191, 192, 193, 194, 195, 196,
          197, 198, 199, 200, 201, 202, 203}]},
       RowBox[{
         RowBox[{
           RowBox[{"-", "0.111111`"}], "-", 
           RowBox[{"0.444444`", " ", 
             TagBox["x", HoldForm]}], "+", 
           RowBox[{"0.111111`", " ", 
             SuperscriptBox[
              TagBox["x", HoldForm], "2"]}], "+", 
           RowBox[{"0.888889`", " ", 
             TagBox["y", HoldForm]}], "+", 
           RowBox[{"0.444444`", " ", 
             SuperscriptBox[
              TagBox["y", HoldForm], "2"]}]}], "\[Equal]", "0"}]],
      Annotation[#, -0.111111 - 0.444444 HoldForm[$CellContext`x] + 
        0.111111 HoldForm[$CellContext`x]^2 + 
        0.888889 HoldForm[$CellContext`y] + 
        0.444444 HoldForm[$CellContext`y]^2 == 0, "Tooltip"]& ]}], {}},
  AspectRatio->1,
  Axes->True,
  AxesLabel->{None, None},
  AxesOrigin->{0., 0.},
  DefaultBaseStyle->{"PlotGraphics", "Graphics"},
  DisplayFunction->Identity,
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  Method->{
   "DefaultBoundaryStyle" -> Automatic, 
    "DefaultGraphicsInteraction" -> {
     "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
      "Effects" -> {
       "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
        "Droplines" -> {
         "freeformCursorMode" -> True, 
          "placement" -> {"x" -> "All", "y" -> "None"}}}}, "GridLinesInFront" -> 
    True},
  PlotInteractivity:>True,
  PlotRange->{{-2.5, 6.5}, {-3, 1}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.02], 
     Scaled[0.02]}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{{3.9676273950717163`*^9, 3.967627423763946*^9}, 
   3.967627484268976*^9, {3.967627525536902*^9, 3.9676275548099737`*^9}, 
   3.9676275879221478`*^9, {3.9676276199205027`*^9, 3.967627745753772*^9}, 
   3.9676277972765636`*^9, 3.967635121577819*^9, 3.9676352180814667`*^9},
 CellLabel->
  "Out[1928]=",ExpressionUUID->"0b2218ea-3869-4698-b89b-b37b9e686a5e"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TemplateBox[{"\"grid=\"", "True"},
    "RowDefault"], ",", 
   TemplateBox[{"\"estilos=\"", 
     RowBox[{"{", 
       RowBox[{"{", 
         RowBox[{"\"thin\"", ",", "\"magenta\""}], "}"}], "}"}]},
    "RowDefault"], ",", 
   TemplateBox[{"\"ejes=\"", "True"},
    "RowDefault"], ",", 
   TemplateBox[{"\"texto=\"", 
     RowBox[{"{", 
       RowBox[{"{", 
         RowBox[{"\"Elipse\"", ",", 
           RowBox[{"{", 
             RowBox[{"1", ",", 
               RowBox[{"-", "1"}]}], "}"}], ",", 
           RowBox[{"{", 
             RowBox[{
               RowBox[{"{", 
                 RowBox[{"\"color\"", ",", "\"magenta\""}], "}"}], ",", 
               RowBox[{"{", 
                 RowBox[{"\"size\"", ",", "\"\\\\normalsize\""}], "}"}], ",", 
               
               RowBox[{"{", 
                 RowBox[{"\"anchor\"", ",", "\"south east\""}], "}"}], ",", 
               RowBox[{"{", 
                 RowBox[{"\"rotate\"", ",", "176.5917402242043`"}], "}"}]}], 
             "}"}]}], "}"}], "}"}]},
    "RowDefault"], ",", 
   TemplateBox[{"\"muestras=\"", "1700"},
    "RowDefault"], ",", 
   TemplateBox[{"\"tolerancia=\"", "0.01`"},
    "RowDefault"], ",", 
   TemplateBox[{"\"opacidad=\"", "0.8`"},
    "RowDefault"], ",", 
   TemplateBox[{"\"densidad=\"", "1.4`"},
    "RowDefault"], ",", 
   TemplateBox[{"\"xmin=\"", 
     RowBox[{"-", "2.5`"}]},
    "RowDefault"], ",", 
   TemplateBox[{"\"xmax=\"", "6.5`"},
    "RowDefault"], ",", 
   TemplateBox[{"\"ymin=\"", 
     RowBox[{"-", "3"}]},
    "RowDefault"], ",", 
   TemplateBox[{"\"ymax=\"", "1"},
    "RowDefault"]}], "}"}]], "Output",
 CellChangeTimes->{{3.9676273950717163`*^9, 3.967627423763946*^9}, 
   3.967627484268976*^9, {3.967627525536902*^9, 3.9676275548099737`*^9}, 
   3.9676275879221478`*^9, {3.9676276199205027`*^9, 3.967627745753772*^9}, 
   3.9676277972765636`*^9, 3.967635121577819*^9, 3.967635218083859*^9},
 CellLabel->
  "Out[1936]=",ExpressionUUID->"0a5a9e51-cff4-466f-a3c9-a4134ff76e6d"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Usando editores ya detectados: \"\>", "\[InvisibleSpace]", "4",
    "\[InvisibleSpace]", "\<\" disponibles\"\>"}],
  SequenceForm["Usando editores ya detectados: ", 4, " disponibles"],
  Editable->False]], "Print",
 CellChangeTimes->{{3.967627395311263*^9, 3.967627423991187*^9}, 
   3.96762748455304*^9, {3.967627525821415*^9, 3.9676275550336246`*^9}, 
   3.96762758812157*^9, {3.96762762011977*^9, 3.9676277460228233`*^9}, 
   3.967627797518695*^9, 3.967635121816244*^9, 3.967635218319213*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[1928]:=",ExpressionUUID->"fc0ee832-18e5-462d-93df-6c8291e0506c"],

Cell[BoxData["\<\"Buscando pdflatex...\"\>"], "Print",
 CellChangeTimes->{{3.967627395311263*^9, 3.967627423991187*^9}, 
   3.96762748455304*^9, {3.967627525821415*^9, 3.9676275550336246`*^9}, 
   3.96762758812157*^9, {3.96762762011977*^9, 3.9676277460228233`*^9}, 
   3.967627797518695*^9, 3.967635121816244*^9, 3.967635218320025*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[1928]:=",ExpressionUUID->"27e544b1-3dc8-42fb-ab27-e37657082819"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"pdflatex encontrado: \"\>", 
   "\[InvisibleSpace]", "\<\"/Library/TeX/texbin/pdflatex\"\>"}],
  SequenceForm["pdflatex encontrado: ", "/Library/TeX/texbin/pdflatex"],
  Editable->False]], "Print",
 CellChangeTimes->{{3.967627395311263*^9, 3.967627423991187*^9}, 
   3.96762748455304*^9, {3.967627525821415*^9, 3.9676275550336246`*^9}, 
   3.96762758812157*^9, {3.96762762011977*^9, 3.9676277460228233`*^9}, 
   3.967627797518695*^9, 3.967635121816244*^9, 3.9676352183207083`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[1928]:=",ExpressionUUID->"b7b98ac6-d5d3-49f2-b18c-c1eaf69c031f"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Editor '\"\>", "\[InvisibleSpace]", "\<\"TeXstudio\"\>", 
   "\[InvisibleSpace]", "\<\"' encontrado (match exacto)\"\>"}],
  SequenceForm["Editor '", "TeXstudio", "' encontrado (match exacto)"],
  Editable->False]], "Print",
 CellChangeTimes->{{3.967627395311263*^9, 3.967627423991187*^9}, 
   3.96762748455304*^9, {3.967627525821415*^9, 3.9676275550336246`*^9}, 
   3.96762758812157*^9, {3.96762762011977*^9, 3.9676277460228233`*^9}, 
   3.967627797518695*^9, 3.967635121816244*^9, 3.9676352183211308`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[1928]:=",ExpressionUUID->"6755a706-07dc-4e6c-87fb-962aff60d3ed"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Abriendo archivo en \"\>", 
   "\[InvisibleSpace]", "\<\"TeXstudio\"\>", 
   "\[InvisibleSpace]", "\<\"...\"\>"}],
  SequenceForm["Abriendo archivo en ", "TeXstudio", "..."],
  Editable->False]], "Print",
 CellChangeTimes->{{3.967627395311263*^9, 3.967627423991187*^9}, 
   3.96762748455304*^9, {3.967627525821415*^9, 3.9676275550336246`*^9}, 
   3.96762758812157*^9, {3.96762762011977*^9, 3.9676277460228233`*^9}, 
   3.967627797518695*^9, 3.967635121816244*^9, 3.9676352183215437`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[1928]:=",ExpressionUUID->"ec00764d-7806-4a3d-86cd-535f2b2e8fde"],

Cell[BoxData["\<\"Editor abierto correctamente\"\>"], "Print",
 CellChangeTimes->{{3.967627395311263*^9, 3.967627423991187*^9}, 
   3.96762748455304*^9, {3.967627525821415*^9, 3.9676275550336246`*^9}, 
   3.96762758812157*^9, {3.96762762011977*^9, 3.9676277460228233`*^9}, 
   3.967627797518695*^9, 3.967635121816244*^9, 3.9676352184064417`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[1928]:=",ExpressionUUID->"326d75f8-29aa-4808-826e-31d1f1462527"],

Cell[BoxData["\<\"Compilando documento LaTeX...\"\>"], "Print",
 CellChangeTimes->{{3.967627395311263*^9, 3.967627423991187*^9}, 
   3.96762748455304*^9, {3.967627525821415*^9, 3.9676275550336246`*^9}, 
   3.96762758812157*^9, {3.96762762011977*^9, 3.9676277460228233`*^9}, 
   3.967627797518695*^9, 3.967635121816244*^9, 3.967635219408391*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[1928]:=",ExpressionUUID->"a2f76b34-f6d6-4ff9-badc-37c242cd173b"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Directorio de trabajo: \"\>", 
   "\[InvisibleSpace]", \
"\<\"/Users/enriquevilchezquesada/Downloads/Contour2D2/\"\>"}],
  SequenceForm[
  "Directorio de trabajo: ", 
   "/Users/enriquevilchezquesada/Downloads/Contour2D2/"],
  Editable->False]], "Print",
 CellChangeTimes->{{3.967627395311263*^9, 3.967627423991187*^9}, 
   3.96762748455304*^9, {3.967627525821415*^9, 3.9676275550336246`*^9}, 
   3.96762758812157*^9, {3.96762762011977*^9, 3.9676277460228233`*^9}, 
   3.967627797518695*^9, 3.967635121816244*^9, 3.9676352194106092`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[1928]:=",ExpressionUUID->"8b03ea7c-ea35-47db-9402-45200bc49548"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Archivo: \"\>", "\[InvisibleSpace]", "\<\"Contour2D2\"\>"}],
  SequenceForm["Archivo: ", "Contour2D2"],
  Editable->False]], "Print",
 CellChangeTimes->{{3.967627395311263*^9, 3.967627423991187*^9}, 
   3.96762748455304*^9, {3.967627525821415*^9, 3.9676275550336246`*^9}, 
   3.96762758812157*^9, {3.96762762011977*^9, 3.9676277460228233`*^9}, 
   3.967627797518695*^9, 3.967635121816244*^9, 3.967635219412575*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[1928]:=",ExpressionUUID->"0532b45a-1595-4c63-bde8-47a82784b225"],

Cell[BoxData["\<\"Compilaci\[OAcute]n exitosa\"\>"], "Print",
 CellChangeTimes->{{3.967627395311263*^9, 3.967627423991187*^9}, 
   3.96762748455304*^9, {3.967627525821415*^9, 3.9676275550336246`*^9}, 
   3.96762758812157*^9, {3.96762762011977*^9, 3.9676277460228233`*^9}, 
   3.967627797518695*^9, 3.967635121816244*^9, 3.96763522301658*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[1928]:=",ExpressionUUID->"8fa3f8dd-7e14-43a6-aa8a-85354e08d7b4"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"PDF generado: \"\>", 
   "\[InvisibleSpace]", \
"\<\"/Users/enriquevilchezquesada/Downloads/Contour2D2/Contour2D2.pdf\"\>"}],
  SequenceForm[
  "PDF generado: ", 
   "/Users/enriquevilchezquesada/Downloads/Contour2D2/Contour2D2.pdf"],
  Editable->False]], "Print",
 CellChangeTimes->{{3.967627395311263*^9, 3.967627423991187*^9}, 
   3.96762748455304*^9, {3.967627525821415*^9, 3.9676275550336246`*^9}, 
   3.96762758812157*^9, {3.96762762011977*^9, 3.9676277460228233`*^9}, 
   3.967627797518695*^9, 3.967635121816244*^9, 3.967635223017367*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[1928]:=",ExpressionUUID->"e2314148-e0a8-4a02-a6cd-e1fc7991534a"]
}, Open  ]],

Cell[BoxData["\<\"/Users/enriquevilchezquesada/Downloads/Contour2D2/\
Contour2D2.pdf\"\>"], "Output",
 CellChangeTimes->{{3.9676273950717163`*^9, 3.967627423763946*^9}, 
   3.967627484268976*^9, {3.967627525536902*^9, 3.9676275548099737`*^9}, 
   3.9676275879221478`*^9, {3.9676276199205027`*^9, 3.967627745753772*^9}, 
   3.9676277972765636`*^9, 3.967635121577819*^9, 3.967635223031218*^9},
 CellLabel->
  "Out[1938]=",ExpressionUUID->"98ad1ebb-774d-4a43-8bba-d0d3f292cd39"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Ejemplo 3: elipse rotada 30\[Degree] (con xy)", "Subsection",
 CellChangeTimes->{{3.9675372440640697`*^9, 3.9675372648550014`*^9}, {
  3.967537550489973*^9, 
  3.967537554709467*^9}},ExpressionUUID->"8eee4314-5964-3a42-8038-\
65922d6bd262"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"ContourPlot", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"0.333333", " ", 
       RowBox[{"x", "^", "2"}]}], "-", 
      RowBox[{"0.769800", " ", "x", " ", "y"}], "-", 
      RowBox[{"1.051570", " ", "x"}], "+", 
      RowBox[{"0.777778", " ", 
       RowBox[{"y", "^", "2"}]}], "+", 
      RowBox[{"1.547580", " ", "y"}], "-", "0.087322"}], "==", "0"}], ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", 
      RowBox[{"-", "3"}], ",", "6"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"y", ",", 
      RowBox[{"-", "4"}], ",", "4"}], "}"}], ",", 
    RowBox[{"Frame", "->", "False"}], ",", 
    RowBox[{"Axes", "->", "True"}]}], "]"}], "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"line", "[", "]"}], ":=", 
  RowBox[{"RandomChoice", "[", 
   RowBox[{"{", 
    RowBox[{"\"\<solid\>\"", ",", "\"\<dashed\>\"", ",", "\"\<dotted\>\"", 
     ",", "\"\<thick\>\"", ",", "\"\<thin\>\""}], "}"}], "]"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"color", "[", "]"}], ":=", 
  RowBox[{"RandomChoice", "[", 
   RowBox[{"{", 
    RowBox[{"\"\<blue\>\"", ",", "\"\<red\>\"", ",", "\"\<green\>\"", 
     ",", "\"\<purple\>\"", ",", "\"\<yellow\>\"", ",", "\"\<orange\>\"", 
     ",", "\"\<cyan\>\"", ",", "\"\<magenta\>\"", ",", "\"\<black\>\""}], 
    "}"}], "]"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"sizetexto", "[", "]"}], ":=", 
  RowBox[{"RandomChoice", "[", 
   RowBox[{"{", 
    RowBox[{"\"\<\\\\tiny\>\"", ",", "\"\<\\\\scriptsize\>\"", 
     ",", "\"\<\\\\footnotesize\>\"", ",", "\"\<\\\\small\>\"", 
     ",", "\"\<\\\\normalsize\>\"", ",", "\"\<\\\\large\>\"", 
     ",", "\"\<\\\\Large\>\"", ",", "\"\<\\\\huge\>\"", 
     ",", "\"\<\\\\Huge\>\""}], "}"}], "]"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"anclajetexto", "[", "]"}], ":=", 
  RowBox[{"RandomChoice", "[", 
   RowBox[{"{", 
    RowBox[{"\"\<north\>\"", ",", "\"\<south\>\"", ",", "\"\<east\>\"", 
     ",", "\"\<west\>\"", ",", "\"\<north east\>\"", ",", "\"\<north west\>\"",
      ",", "\"\<south east\>\"", ",", "\"\<south west\>\"", 
     ",", "\"\<center\>\""}], "}"}], "]"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"rotatexto", "[", "]"}], ":=", 
  RowBox[{"RandomReal", "[", 
   RowBox[{"{", 
    RowBox[{"0", ",", "360"}], "}"}], "]"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"estilotext", "[", "n_", "]"}], ":=", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"\"\<color\>\"", ",", 
        RowBox[{"color", "[", "]"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"\"\<size\>\"", ",", 
        RowBox[{"sizetexto", "[", "]"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"\"\<anchor\>\"", ",", 
        RowBox[{"anclajetexto", "[", "]"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"\"\<rotate\>\"", ",", 
        RowBox[{"rotatexto", "[", "]"}]}], "}"}]}], "}"}], ",", "n"}], 
   "]"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"vectorestilos", "=", 
   RowBox[{"estilotext", "[", "1", "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Row", "[", 
    RowBox[{"{", 
     RowBox[{"\"\<grid=\>\"", ",", 
      RowBox[{"grid", "=", "True"}]}], "}"}], "]"}], ",", 
   RowBox[{"Row", "[", 
    RowBox[{"{", 
     RowBox[{"\"\<estilos=\>\"", ",", 
      RowBox[{"estilos", "=", 
       RowBox[{"Table", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"line", "[", "]"}], ",", 
           RowBox[{"color", "[", "]"}]}], "}"}], ",", "1"}], "]"}]}]}], "}"}],
     "]"}], ",", 
   RowBox[{"Row", "[", 
    RowBox[{"{", 
     RowBox[{"\"\<ejes=\>\"", ",", 
      RowBox[{"ejes", "=", "True"}]}], "}"}], "]"}], ",", 
   RowBox[{"Row", "[", 
    RowBox[{"{", 
     RowBox[{"\"\<texto=\>\"", ",", 
      RowBox[{"texto", "=", 
       RowBox[{"{", 
        RowBox[{"{", 
         RowBox[{"\"\<Elipse rotada\>\"", ",", 
          RowBox[{"{", 
           RowBox[{"1", ",", "1"}], "}"}], ",", 
          RowBox[{"vectorestilos", "[", 
           RowBox[{"[", "1", "]"}], "]"}]}], "}"}], "}"}]}]}], "}"}], "]"}], ",", 
   RowBox[{"Row", "[", 
    RowBox[{"{", 
     RowBox[{"\"\<muestras=\>\"", ",", 
      RowBox[{"muestras", "=", "1500"}]}], "}"}], "]"}], ",", 
   RowBox[{"Row", "[", 
    RowBox[{"{", 
     RowBox[{"\"\<tolerancia=\>\"", ",", 
      RowBox[{"tolerancia", "=", "0.01"}]}], "}"}], "]"}], ",", 
   RowBox[{"Row", "[", 
    RowBox[{"{", 
     RowBox[{"\"\<opacidad=\>\"", ",", 
      RowBox[{"opacidad", "=", "0.8"}]}], "}"}], "]"}], ",", 
   RowBox[{"Row", "[", 
    RowBox[{"{", 
     RowBox[{"\"\<densidad=\>\"", ",", 
      RowBox[{"densidad", "=", "2"}]}], "}"}], "]"}], ",", 
   RowBox[{"Row", "[", 
    RowBox[{"{", 
     RowBox[{"\"\<xmin=\>\"", ",", 
      RowBox[{"xmin", "=", 
       RowBox[{"-", "3"}]}]}], "}"}], "]"}], ",", 
   RowBox[{"Row", "[", 
    RowBox[{"{", 
     RowBox[{"\"\<xmax=\>\"", ",", 
      RowBox[{"xmax", "=", "6"}]}], "}"}], "]"}], ",", 
   RowBox[{"Row", "[", 
    RowBox[{"{", 
     RowBox[{"\"\<ymin=\>\"", ",", 
      RowBox[{"ymin", "=", 
       RowBox[{"-", "4"}]}]}], "}"}], "]"}], ",", 
   RowBox[{"Row", "[", 
    RowBox[{"{", 
     RowBox[{"\"\<ymax=\>\"", ",", 
      RowBox[{"ymax", "=", "4"}]}], "}"}], "]"}]}], "}"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ExportContour2DToTikZ", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"0.333333", " ", 
       RowBox[{"x", "^", "2"}]}], "-", 
      RowBox[{"0.769800", " ", "x", " ", "y"}], "-", 
      RowBox[{"1.051570", " ", "x"}], "+", 
      RowBox[{"0.777778", " ", 
       RowBox[{"y", "^", "2"}]}], "+", 
      RowBox[{"1.547580", " ", "y"}], "-", "0.087322"}], "==", "0"}], 
    ",", "\"\<Contour2D3.tex\>\"", ",", "grid", ",", "estilos", ",", "ejes", ",",
     "texto", ",", "muestras", ",", "tolerancia", ",", "opacidad", ",", 
    "densidad", ",", "xmin", ",", "xmax", ",", "ymin", ",", "ymax"}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"CompiladorTex", "[", 
  RowBox[{"%", ",", 
   RowBox[{"\"\<PreferredEditor\>\"", " ", "->", "\"\<TeXstudio\>\""}]}], 
  "]"}]}], "Input",
 CellChangeTimes->{{3.967537548980524*^9, 3.967537558635433*^9}, {
   3.9675382781239204`*^9, 3.967538278431097*^9}, {3.967545159858923*^9, 
   3.967545175182001*^9}, {3.967573781308367*^9, 3.9675737817359343`*^9}, {
   3.967573949113323*^9, 3.967573950237995*^9}, {3.9676278241009483`*^9, 
   3.967627933245995*^9}, 3.967634218760043*^9, {3.967635109914304*^9, 
   3.967635110456883*^9}},
 CellLabel->
  "In[1939]:=",ExpressionUUID->"94ba00e7-d380-1342-8145-6e317311b985"],

Cell[BoxData[
 GraphicsBox[{GraphicsComplexBox[CompressedData["
1:eJxdWHk8lPv3n2GsM7pXWrTcVqWFSgi59flU7i2FXNEibtplCxU3ihSyJCW5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    "], {{}, {}, 
     TagBox[
      TooltipBox[
       {RGBColor[0.24, 0.6, 0.8], AbsoluteThickness[2], 
        LineBox[CompressedData["
1:eJwl1FV4EAQUBeANNhpGL4htIB3SDSKNdAjSSJeUNAgC0o2idDdS0h0GHUoq
SId0h4LAv4+H/9zX83JudIsutTsHBgQEZBQxNxaxCSKYOMQlHvFJQEISkZgk
hJCUZCQnBSlJRWpCCSOcCNKQlnSkJ5IooskQ04UPyERmspCVbGQnBznJRW4+
JA95yUd+ClCQQhSmCEUpRnFKUJJSfERpPqYMZSlHeSpQkUpU5hOqUJVqVKcG
NalFbepQl0+pR30+owENaURjmtCUZjTnc1rQkla0pg1taUd7OtCRTnxBZ7rQ
lW5050t60JNe9KYPfelHfwbwFQMZxNcMZghD+YZhDGcEIxnFaMYwlnGMZwIT
mcRkvuU7pvA9PzCVaUxnBjOZxWzmMJd5zGcBC1nEYpawlGUsZwU/spJVrGYN
a/mJdaxnAxvZxGa2sJVtbGcHO9nFbvawl5/5hV/5jX3s5wAHOcRhjnCUYxzn
d/7gBCc5xWnOcJY/+YtznOdvLnCRS1zmCle5xnVucJN/uMVt7nCXe9znAQ95
xGOe8JRnPOcFL/mX/3jFa/7nDW+JGX8gsYhNEMHEIS7xiE8CEpKIxCQhhKQk
IzkpSEkqUhNKGOFEkIa0pCM9kUQRTYbA97/oHWlBg/I=
         "]]},
       RowBox[{
         RowBox[{
           RowBox[{"-", "0.087322`"}], "-", 
           RowBox[{"1.05157`", " ", 
             TagBox["x", HoldForm]}], "+", 
           RowBox[{"0.333333`", " ", 
             SuperscriptBox[
              TagBox["x", HoldForm], "2"]}], "+", 
           RowBox[{"1.54758`", " ", 
             TagBox["y", HoldForm]}], "-", 
           RowBox[{"0.7698`", " ", 
             TagBox["x", HoldForm], " ", 
             TagBox["y", HoldForm]}], "+", 
           RowBox[{"0.777778`", " ", 
             SuperscriptBox[
              TagBox["y", HoldForm], "2"]}]}], "\[Equal]", "0"}]],
      Annotation[#, -0.087322 - 1.05157 HoldForm[$CellContext`x] + 
        0.333333 HoldForm[$CellContext`x]^2 + 
        1.54758 HoldForm[$CellContext`y] - 0.7698 HoldForm[$CellContext`x] 
        HoldForm[$CellContext`y] + 0.777778 HoldForm[$CellContext`y]^2 == 0, 
       "Tooltip"]& ]}], {}},
  AspectRatio->1,
  Axes->True,
  AxesLabel->{None, None},
  AxesOrigin->{0., 0.},
  DefaultBaseStyle->{"PlotGraphics", "Graphics"},
  DisplayFunction->Identity,
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  Method->{
   "DefaultBoundaryStyle" -> Automatic, 
    "DefaultGraphicsInteraction" -> {
     "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
      "Effects" -> {
       "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
        "Droplines" -> {
         "freeformCursorMode" -> True, 
          "placement" -> {"x" -> "All", "y" -> "None"}}}}, "GridLinesInFront" -> 
    True},
  PlotInteractivity:>True,
  PlotRange->{{-3, 6}, {-4, 4}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.02], 
     Scaled[0.02]}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{{3.967627917685728*^9, 3.967627933679468*^9}, 
   3.9676279720336523`*^9, 3.9676351108129263`*^9, 3.9676352405448637`*^9},
 CellLabel->
  "Out[1939]=",ExpressionUUID->"2380dc71-4ef9-4807-a8e5-3335bcd2b181"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TemplateBox[{"\"grid=\"", "True"},
    "RowDefault"], ",", 
   TemplateBox[{"\"estilos=\"", 
     RowBox[{"{", 
       RowBox[{"{", 
         RowBox[{"\"thin\"", ",", "\"blue\""}], "}"}], "}"}]},
    "RowDefault"], ",", 
   TemplateBox[{"\"ejes=\"", "True"},
    "RowDefault"], ",", 
   TemplateBox[{"\"texto=\"", 
     RowBox[{"{", 
       RowBox[{"{", 
         RowBox[{"\"Elipse rotada\"", ",", 
           RowBox[{"{", 
             RowBox[{"1", ",", "1"}], "}"}], ",", 
           RowBox[{"{", 
             RowBox[{
               RowBox[{"{", 
                 RowBox[{"\"color\"", ",", "\"orange\""}], "}"}], ",", 
               RowBox[{"{", 
                 RowBox[{"\"size\"", ",", "\"\\\\large\""}], "}"}], ",", 
               RowBox[{"{", 
                 RowBox[{"\"anchor\"", ",", "\"south east\""}], "}"}], ",", 
               RowBox[{"{", 
                 RowBox[{"\"rotate\"", ",", "172.9746380303456`"}], "}"}]}], 
             "}"}]}], "}"}], "}"}]},
    "RowDefault"], ",", 
   TemplateBox[{"\"muestras=\"", "1500"},
    "RowDefault"], ",", 
   TemplateBox[{"\"tolerancia=\"", "0.01`"},
    "RowDefault"], ",", 
   TemplateBox[{"\"opacidad=\"", "0.8`"},
    "RowDefault"], ",", 
   TemplateBox[{"\"densidad=\"", "2"},
    "RowDefault"], ",", 
   TemplateBox[{"\"xmin=\"", 
     RowBox[{"-", "3"}]},
    "RowDefault"], ",", 
   TemplateBox[{"\"xmax=\"", "6"},
    "RowDefault"], ",", 
   TemplateBox[{"\"ymin=\"", 
     RowBox[{"-", "4"}]},
    "RowDefault"], ",", 
   TemplateBox[{"\"ymax=\"", "4"},
    "RowDefault"]}], "}"}]], "Output",
 CellChangeTimes->{{3.967627917685728*^9, 3.967627933679468*^9}, 
   3.9676279720336523`*^9, 3.9676351108129263`*^9, 3.9676352405469437`*^9},
 CellLabel->
  "Out[1947]=",ExpressionUUID->"7d996fc1-e2fd-4d26-8bb9-ca0a5aaeeb88"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Usando editores ya detectados: \"\>", "\[InvisibleSpace]", "4",
    "\[InvisibleSpace]", "\<\" disponibles\"\>"}],
  SequenceForm["Usando editores ya detectados: ", 4, " disponibles"],
  Editable->False]], "Print",
 CellChangeTimes->{{3.967627917690332*^9, 3.967627933970014*^9}, 
   3.967627972328065*^9, 3.967635111112215*^9, 3.967635240837531*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[1939]:=",ExpressionUUID->"70bfa210-7a8d-4dfe-8b66-6ac6c4b4d863"],

Cell[BoxData["\<\"Buscando pdflatex...\"\>"], "Print",
 CellChangeTimes->{{3.967627917690332*^9, 3.967627933970014*^9}, 
   3.967627972328065*^9, 3.967635111112215*^9, 3.9676352408383427`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[1939]:=",ExpressionUUID->"08ec3d9c-c17f-45e9-9ca0-80589be3a4ce"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"pdflatex encontrado: \"\>", 
   "\[InvisibleSpace]", "\<\"/Library/TeX/texbin/pdflatex\"\>"}],
  SequenceForm["pdflatex encontrado: ", "/Library/TeX/texbin/pdflatex"],
  Editable->False]], "Print",
 CellChangeTimes->{{3.967627917690332*^9, 3.967627933970014*^9}, 
   3.967627972328065*^9, 3.967635111112215*^9, 3.967635240839027*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[1939]:=",ExpressionUUID->"7cad4811-275a-4ff9-bc59-82335d7f8d57"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Editor '\"\>", "\[InvisibleSpace]", "\<\"TeXstudio\"\>", 
   "\[InvisibleSpace]", "\<\"' encontrado (match exacto)\"\>"}],
  SequenceForm["Editor '", "TeXstudio", "' encontrado (match exacto)"],
  Editable->False]], "Print",
 CellChangeTimes->{{3.967627917690332*^9, 3.967627933970014*^9}, 
   3.967627972328065*^9, 3.967635111112215*^9, 3.967635240839444*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[1939]:=",ExpressionUUID->"d1fe6b92-4d4b-42e3-b9c5-54546273427d"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Abriendo archivo en \"\>", 
   "\[InvisibleSpace]", "\<\"TeXstudio\"\>", 
   "\[InvisibleSpace]", "\<\"...\"\>"}],
  SequenceForm["Abriendo archivo en ", "TeXstudio", "..."],
  Editable->False]], "Print",
 CellChangeTimes->{{3.967627917690332*^9, 3.967627933970014*^9}, 
   3.967627972328065*^9, 3.967635111112215*^9, 3.9676352408398438`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[1939]:=",ExpressionUUID->"bcf4a099-2698-4613-b043-8799903161e4"],

Cell[BoxData["\<\"Editor abierto correctamente\"\>"], "Print",
 CellChangeTimes->{{3.967627917690332*^9, 3.967627933970014*^9}, 
   3.967627972328065*^9, 3.967635111112215*^9, 3.967635240928829*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[1939]:=",ExpressionUUID->"f188ca78-24af-425d-8dc1-a367e34fa9db"],

Cell[BoxData["\<\"Compilando documento LaTeX...\"\>"], "Print",
 CellChangeTimes->{{3.967627917690332*^9, 3.967627933970014*^9}, 
   3.967627972328065*^9, 3.967635111112215*^9, 3.967635241934029*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[1939]:=",ExpressionUUID->"eac64c7f-adff-4f4e-991e-cfbb617b59bb"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Directorio de trabajo: \"\>", 
   "\[InvisibleSpace]", \
"\<\"/Users/enriquevilchezquesada/Downloads/Contour2D3/\"\>"}],
  SequenceForm[
  "Directorio de trabajo: ", 
   "/Users/enriquevilchezquesada/Downloads/Contour2D3/"],
  Editable->False]], "Print",
 CellChangeTimes->{{3.967627917690332*^9, 3.967627933970014*^9}, 
   3.967627972328065*^9, 3.967635111112215*^9, 3.967635241937521*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[1939]:=",ExpressionUUID->"d0421334-1844-4512-ab18-57a26e8ed980"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Archivo: \"\>", "\[InvisibleSpace]", "\<\"Contour2D3\"\>"}],
  SequenceForm["Archivo: ", "Contour2D3"],
  Editable->False]], "Print",
 CellChangeTimes->{{3.967627917690332*^9, 3.967627933970014*^9}, 
   3.967627972328065*^9, 3.967635111112215*^9, 3.967635241940024*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[1939]:=",ExpressionUUID->"07c110df-1873-4a2e-a926-2ccc16570f0b"],

Cell[BoxData["\<\"Compilaci\[OAcute]n exitosa\"\>"], "Print",
 CellChangeTimes->{{3.967627917690332*^9, 3.967627933970014*^9}, 
   3.967627972328065*^9, 3.967635111112215*^9, 3.967635245848879*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[1939]:=",ExpressionUUID->"686d47db-142f-405b-896a-81f4642cf674"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"PDF generado: \"\>", 
   "\[InvisibleSpace]", \
"\<\"/Users/enriquevilchezquesada/Downloads/Contour2D3/Contour2D3.pdf\"\>"}],
  SequenceForm[
  "PDF generado: ", 
   "/Users/enriquevilchezquesada/Downloads/Contour2D3/Contour2D3.pdf"],
  Editable->False]], "Print",
 CellChangeTimes->{{3.967627917690332*^9, 3.967627933970014*^9}, 
   3.967627972328065*^9, 3.967635111112215*^9, 3.967635245849658*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[1939]:=",ExpressionUUID->"1af69953-42d4-4a14-8d4f-51fd791d9b60"]
}, Open  ]],

Cell[BoxData["\<\"/Users/enriquevilchezquesada/Downloads/Contour2D3/\
Contour2D3.pdf\"\>"], "Output",
 CellChangeTimes->{{3.967627917685728*^9, 3.967627933679468*^9}, 
   3.9676279720336523`*^9, 3.9676351108129263`*^9, 3.967635245864173*^9},
 CellLabel->
  "Out[1949]=",ExpressionUUID->"31bd7859-c4ec-4a67-8451-2512c5a97842"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Ejemplo 4: regi\[OAcute]n hiperb\[OAcute]lica desplazada (sin rotaci\
\[OAcute]n)", "Subsection",
 CellChangeTimes->{{3.9675372440640697`*^9, 3.967537266110834*^9}, {
  3.9675375625962696`*^9, 3.9675375714626007`*^9}, {3.967627993600337*^9, 
  3.967627994350466*^9}, {3.967629606364395*^9, 
  3.967629609539606*^9}},ExpressionUUID->"9d4f8127-0a6b-1643-b0b3-\
40bc372e25c3"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"RegionPlot", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"0.25", " ", 
       RowBox[{"x", "^", "2"}]}], "-", 
      RowBox[{"0.5", " ", "x"}], "-", 
      RowBox[{"y", "^", "2"}], "-", 
      RowBox[{"2.0", " ", "y"}], "-", "1.75"}], "<=", "0"}], ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", 
      RowBox[{"-", "6"}], ",", "8"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"y", ",", 
      RowBox[{"-", "5"}], ",", "3"}], "}"}], ",", 
    RowBox[{"Frame", "->", "False"}], ",", 
    RowBox[{"Axes", "->", "True"}]}], "]"}], "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"line", "[", "]"}], ":=", 
  RowBox[{"RandomChoice", "[", 
   RowBox[{"{", 
    RowBox[{"\"\<solid\>\"", ",", "\"\<dashed\>\"", ",", "\"\<dotted\>\"", 
     ",", "\"\<thick\>\"", ",", "\"\<thin\>\""}], "}"}], "]"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"color", "[", "]"}], ":=", 
  RowBox[{"RandomChoice", "[", 
   RowBox[{"{", 
    RowBox[{"\"\<blue\>\"", ",", "\"\<red\>\"", ",", "\"\<green\>\"", 
     ",", "\"\<purple\>\"", ",", "\"\<yellow\>\"", ",", "\"\<orange\>\"", 
     ",", "\"\<cyan\>\"", ",", "\"\<magenta\>\"", ",", "\"\<black\>\""}], 
    "}"}], "]"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"sizetexto", "[", "]"}], ":=", 
  RowBox[{"RandomChoice", "[", 
   RowBox[{"{", 
    RowBox[{"\"\<\\\\tiny\>\"", ",", "\"\<\\\\scriptsize\>\"", 
     ",", "\"\<\\\\footnotesize\>\"", ",", "\"\<\\\\small\>\"", 
     ",", "\"\<\\\\normalsize\>\"", ",", "\"\<\\\\large\>\"", 
     ",", "\"\<\\\\Large\>\"", ",", "\"\<\\\\huge\>\"", 
     ",", "\"\<\\\\Huge\>\""}], "}"}], "]"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"anclajetexto", "[", "]"}], ":=", 
  RowBox[{"RandomChoice", "[", 
   RowBox[{"{", 
    RowBox[{"\"\<north\>\"", ",", "\"\<south\>\"", ",", "\"\<east\>\"", 
     ",", "\"\<west\>\"", ",", "\"\<north east\>\"", ",", "\"\<north west\>\"",
      ",", "\"\<south east\>\"", ",", "\"\<south west\>\"", 
     ",", "\"\<center\>\""}], "}"}], "]"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"rotatexto", "[", "]"}], ":=", 
  RowBox[{"RandomReal", "[", 
   RowBox[{"{", 
    RowBox[{"0", ",", "360"}], "}"}], "]"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"estilotext", "[", "n_", "]"}], ":=", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"\"\<color\>\"", ",", 
        RowBox[{"color", "[", "]"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"\"\<size\>\"", ",", 
        RowBox[{"sizetexto", "[", "]"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"\"\<anchor\>\"", ",", 
        RowBox[{"anclajetexto", "[", "]"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"\"\<rotate\>\"", ",", 
        RowBox[{"rotatexto", "[", "]"}]}], "}"}]}], "}"}], ",", "n"}], 
   "]"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"vectorestilos", "=", 
   RowBox[{"estilotext", "[", "1", "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Row", "[", 
    RowBox[{"{", 
     RowBox[{"\"\<grid=\>\"", ",", 
      RowBox[{"grid", "=", 
       RowBox[{"RandomChoice", "[", 
        RowBox[{"{", 
         RowBox[{"True", ",", "False"}], "}"}], "]"}]}]}], "}"}], "]"}], ",", 
   
   RowBox[{"Row", "[", 
    RowBox[{"{", 
     RowBox[{"\"\<estilos=\>\"", ",", 
      RowBox[{"estilos", "=", 
       RowBox[{"Table", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"line", "[", "]"}], ",", 
           RowBox[{"color", "[", "]"}]}], "}"}], ",", "1"}], "]"}]}]}], "}"}],
     "]"}], ",", 
   RowBox[{"Row", "[", 
    RowBox[{"{", 
     RowBox[{"\"\<ejes=\>\"", ",", 
      RowBox[{"ejes", "=", "True"}]}], "}"}], "]"}], ",", 
   RowBox[{"Row", "[", 
    RowBox[{"{", 
     RowBox[{"\"\<texto=\>\"", ",", 
      RowBox[{"texto", "=", 
       RowBox[{"{", 
        RowBox[{"{", 
         RowBox[{"\"\<Regi\[OAcute]n hiperb\[OAcute]lica\>\"", ",", 
          RowBox[{"{", 
           RowBox[{"0", ",", "0"}], "}"}], ",", 
          RowBox[{"vectorestilos", "[", 
           RowBox[{"[", "1", "]"}], "]"}]}], "}"}], "}"}]}]}], "}"}], "]"}], ",", 
   RowBox[{"Row", "[", 
    RowBox[{"{", 
     RowBox[{"\"\<muestras=\>\"", ",", 
      RowBox[{"muestras", "=", "50"}]}], "}"}], "]"}], ",", 
   RowBox[{"Row", "[", 
    RowBox[{"{", 
     RowBox[{"\"\<tolerancia=\>\"", ",", 
      RowBox[{"tolerancia", "=", "0.01"}]}], "}"}], "]"}], ",", 
   RowBox[{"Row", "[", 
    RowBox[{"{", 
     RowBox[{"\"\<opacidad=\>\"", ",", 
      RowBox[{"opacidad", "=", "0.8"}]}], "}"}], "]"}], ",", 
   RowBox[{"Row", "[", 
    RowBox[{"{", 
     RowBox[{"\"\<densidad=\>\"", ",", 
      RowBox[{"densidad", "=", "1.5"}]}], "}"}], "]"}], ",", 
   RowBox[{"Row", "[", 
    RowBox[{"{", 
     RowBox[{"\"\<xmin=\>\"", ",", 
      RowBox[{"xmin", "=", 
       RowBox[{"-", "6"}]}]}], "}"}], "]"}], ",", 
   RowBox[{"Row", "[", 
    RowBox[{"{", 
     RowBox[{"\"\<xmax=\>\"", ",", 
      RowBox[{"xmax", "=", "8"}]}], "}"}], "]"}], ",", 
   RowBox[{"Row", "[", 
    RowBox[{"{", 
     RowBox[{"\"\<ymin=\>\"", ",", 
      RowBox[{"ymin", "=", 
       RowBox[{"-", "5"}]}]}], "}"}], "]"}], ",", 
   RowBox[{"Row", "[", 
    RowBox[{"{", 
     RowBox[{"\"\<ymax=\>\"", ",", 
      RowBox[{"ymax", "=", "3"}]}], "}"}], "]"}]}], "}"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ExportContour2DToTikZ", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"0.25", " ", 
       RowBox[{"x", "^", "2"}]}], "-", 
      RowBox[{"0.5", " ", "x"}], "-", 
      RowBox[{"y", "^", "2"}], "-", 
      RowBox[{"2.0", " ", "y"}], "-", "1.75"}], "<=", "0"}], 
    ",", "\"\<Contour2D4.tex\>\"", ",", "grid", ",", "estilos", ",", "ejes", ",",
     "texto", ",", "muestras", ",", "tolerancia", ",", "opacidad", ",", 
    "densidad", ",", "xmin", ",", "xmax", ",", "ymin", ",", "ymax"}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"CompiladorTex", "[", 
  RowBox[{"%", ",", 
   RowBox[{"\"\<PreferredEditor\>\"", " ", "->", "\"\<TeXstudio\>\""}]}], 
  "]"}]}], "Input",
 CellChangeTimes->{{3.967537568224848*^9, 3.9675375755020065`*^9}, {
   3.9675382755605583`*^9, 3.9675382758663445`*^9}, {3.9675451958444824`*^9, 
   3.9675451981976604`*^9}, {3.967573784908856*^9, 3.967573785305917*^9}, {
   3.967573959073801*^9, 3.967573960091888*^9}, {3.9676280092259274`*^9, 
   3.967628138364764*^9}, {3.967628175796938*^9, 3.967628176251771*^9}, {
   3.967628228490942*^9, 3.967628228501574*^9}, {3.9676296158305063`*^9, 
   3.96762961874256*^9}, 3.9676342124101267`*^9, {3.967635096250352*^9, 
   3.967635096729878*^9}},
 CellLabel->
  "In[1950]:=",ExpressionUUID->"069a02d5-db69-de45-88f9-546de92b82cb"],

Cell[BoxData[
 GraphicsBox[{GraphicsComplexBox[CompressedData["
1:eJxdmnlclNUax9kEQQaGHUfFJfUSkderTSlp88YYci29o+aWSmplyHj1ppRM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    "], {{
      {RGBColor[0.24, 0.6, 0.8], AbsoluteThickness[2.], Opacity[0.3], 
       EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxNmgfY39MVx3/3UsTeVaMkaFTM2CQ1QowYkSAICQkhRghi1EqMWEXMmDFS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          "]], PolygonBox[CompressedData["
1:eJwtlXmwiGUYxb/nqahUqjHZFYUiS5SS1JWLXBmlpEhyI0Xc9mnaZlpmXErG
GEkipoSJVm1kaZmWS2NpUTNaDNr3faH6nTnfH2fec77tfb/nPed5W1fXDJ2c
RVHcCfYFCxDzQdsoihPB2fCPwAL4YaAb/F0wE76B579mfB49lLEXug18E5iK
noOuhu8Cb6Cbg7PgH4J58IagFfwC0FH3wI/gZXQ140W8Xx9+M2iMnoEeDn8T
3IRuAr4EK9GDGY/j/i+M69ATGMehm8D3A53RjUBj+DngWHhvMBL+NrgF3gx8
B15Cj2AcxPvt4JvBPehF6PHw3eAtdEvVCD4XdIcfA2bDa0Cb8LVJ8M/A0/A6
3u8A3wKmo1eg68EfAT3Rd6GvgH8KVqBXoYfBF4PT0B3AZfBPwDL4cu73gD8I
OqHbgX/AdHS3cE0vgX+sb8AX8vwy+FJwW+E5r4J/DurgR6rm8O1gEfz+wrX7
U7UN11Df/pfx+PAcQ1Qb0DVc06nwaela38j798LPT6/9BHCeagEGwKvAKPhO
8Dq8qfYYfl96bs1xDfwLsBHeOjzXYNA+POee8Bz6tjzSGb4VzICv5ht/ad/Q
J4f/uRY+RXtU+Bu/g1fR14avyZsDwOTCHt0G7wvGouein9DegFp0X/Sj8Bag
Uv4PZ6M7OCqckffhvUAVz89GPwn/u9zrytK7J8mjYQ/r28+ma6M5noE/ns7n
wDBfnp5b15S9U8H+4Qy+Bj8indUbwHv6dz3Ds7PQz8G/KrMypPz3KnBouAav
wH8rs1PD+AL6EHAAfBhYr71NZ3dSOOtHp7OozC9RL0ivtQ94B75PuldMCWdB
DUd7qUyoN4xJe1k9Qt6/Mu1FZUBZuzydBWVuB/w6zal/AR/AzwAXcn9O2EsX
p70uTykrY9NZVWbUywalvametgEe6SzegX4q3ZPUi/qHe8N/4V6mHqHes7fs
RepBdegi3RtuD2dtdLrXLS57UX/VMNyTNsIz7c27w1kbkfa+MleZ9py8djBY
C/853AvHM76I/jbca4eHe4M8KO+pR7RM/4PWrowthD8MeoQz0Az+mGoGrwDn
pq9VlBnvl55Tc2nNelc9U71S3/gJrEGPC9f819IT8oIy8kfpQXlPGapI75H2
poHWmM6EsiBPDUx7Tl6TB5WFW0GXcCYuTddYtW0hX6b3THvVCpyS9ri8XT/c
e+U5eU09WF55IH2WyTP69+Zpb6oG16e/oXfVQ9U7uqS/rR6i3jgx3bvVI3U2
nQkOCp9Rq5Sd9L+NCp8dp4MDw2fIavgP4bNktDKW9rC8u51rvdN7qr3UO9+U
mVPWlNme6cwqq8r4hLSH5B31mIfg80C9cM10tnRM10pnzPflGrU29SDt3eFp
b2kPdba1T599OuP6pNesteof1XuvTq9VPfh/D6T1rQ==
          "]]}]}, {}, {}, {}, {}}, 
     {RGBColor[0.24, 0.6, 0.8], AbsoluteThickness[2.], LineBox[CompressedData["
1:eJwl1HV4VXUcwOE7NhgbG2xso6V0lCKOkBJEQULJKQgqAlNJ3SiRRkIplZCS
blBQECkFBQXEplHESTciOWLUe5/98d7Peb6/c+4997m/e0qkpCWnhgQCgSQv
2TR4nEAOBzMMZjKAgVRhNaetDdIzukarE00N1nLWfIie1/VaizzU5mv+Mx+q
/+sGfYpYnmYjF82H62X9Tp8hjvps4or5e3pNv9dGJPAsP5BhPlJH0ZSjNGEs
zfib5uRnDnOZx03XLdVPmc8CcnDLfIUWYSGLaMlBXuADbjvnRy1Gf8K5Y7Zd
X6Q4D7KDkuTknvWf9WUeojQ7KUVE8MfgF9pThofZRTkiCeFX3uARKrCbR8lF
Nn6jK49RiT1UJIpQfieNyUziEyoH78e9pbuFS1zmCle5RgbXucFNbpHJbe5w
l3uBrM0UEtxXhBLGReNEneUzZjOVafTiCD2ZQndO0YMkUjnMW3xMN07yJuXp
wiE6M5GOnKATZXmdf3mNCXTgOCkk0o50XmU8r3CMtpTgJf6hDR8xjtb8xF3f
50PN1G3aiqKs5AG+5Hm+4nO+4DOWs4xVJLOEwiymEC3Yyg3vm10L8AcFGcNo
nuMAjelHPrZw3TXvawP+oiF9iWczV62P0Lr8ST3eIS/fcsn6MH2S/dShDzF8
wwXr72pN9vEEb5ObdZyzPlirspdq9CaM6TxOKeeUsR/iiSMvscSQh9xEE0Uu
IokgJ+HBZxTZCSM06+8SuA9X4ZU8
       "]]}}], {}},
  AspectRatio->1,
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{0, 0},
  DefaultBaseStyle->{"PlotGraphics", "Graphics"},
  DisplayFunction->Identity,
  Frame->{{False, False}, {False, False}},
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImagePadding->All,
  Method->{
   "DefaultGraphicsInteraction" -> {
     "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
      "Effects" -> {
       "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
        "Droplines" -> {
         "freeformCursorMode" -> True, 
          "placement" -> {"x" -> "All", "y" -> "None"}}}}, "ScalingFunctions" -> 
    None, "TransparentPolygonMesh" -> True, "AxesInFront" -> True},
  PlotInteractivity:>True,
  PlotRange->{{-6, 8}, {-5, 3}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.02], 
     Scaled[0.02]}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{{3.9676281181164303`*^9, 3.967628177596051*^9}, 
   3.967635097283124*^9, 3.967635261376346*^9},
 CellLabel->
  "Out[1950]=",ExpressionUUID->"ffab2153-c45f-4091-922d-12000bbfa83f"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TemplateBox[{"\"grid=\"", "False"},
    "RowDefault"], ",", 
   TemplateBox[{"\"estilos=\"", 
     RowBox[{"{", 
       RowBox[{"{", 
         RowBox[{"\"dashed\"", ",", "\"purple\""}], "}"}], "}"}]},
    "RowDefault"], ",", 
   TemplateBox[{"\"ejes=\"", "True"},
    "RowDefault"], ",", 
   TemplateBox[{"\"texto=\"", 
     RowBox[{"{", 
       RowBox[{"{", 
         RowBox[{"\"Regi\[OAcute]n hiperb\[OAcute]lica\"", ",", 
           RowBox[{"{", 
             RowBox[{"0", ",", "0"}], "}"}], ",", 
           RowBox[{"{", 
             RowBox[{
               RowBox[{"{", 
                 RowBox[{"\"color\"", ",", "\"magenta\""}], "}"}], ",", 
               RowBox[{"{", 
                 RowBox[{"\"size\"", ",", "\"\\\\small\""}], "}"}], ",", 
               RowBox[{"{", 
                 RowBox[{"\"anchor\"", ",", "\"center\""}], "}"}], ",", 
               RowBox[{"{", 
                 RowBox[{"\"rotate\"", ",", "97.07584531301382`"}], "}"}]}], 
             "}"}]}], "}"}], "}"}]},
    "RowDefault"], ",", 
   TemplateBox[{"\"muestras=\"", "50"},
    "RowDefault"], ",", 
   TemplateBox[{"\"tolerancia=\"", "0.01`"},
    "RowDefault"], ",", 
   TemplateBox[{"\"opacidad=\"", "0.8`"},
    "RowDefault"], ",", 
   TemplateBox[{"\"densidad=\"", "1.5`"},
    "RowDefault"], ",", 
   TemplateBox[{"\"xmin=\"", 
     RowBox[{"-", "6"}]},
    "RowDefault"], ",", 
   TemplateBox[{"\"xmax=\"", "8"},
    "RowDefault"], ",", 
   TemplateBox[{"\"ymin=\"", 
     RowBox[{"-", "5"}]},
    "RowDefault"], ",", 
   TemplateBox[{"\"ymax=\"", "3"},
    "RowDefault"]}], "}"}]], "Output",
 CellChangeTimes->{{3.9676281181164303`*^9, 3.967628177596051*^9}, 
   3.967635097283124*^9, 3.96763526137885*^9},
 CellLabel->
  "Out[1958]=",ExpressionUUID->"61668a5c-ff12-4c08-89e1-166e3682cfda"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Usando editores ya detectados: \"\>", "\[InvisibleSpace]", "4",
    "\[InvisibleSpace]", "\<\" disponibles\"\>"}],
  SequenceForm["Usando editores ya detectados: ", 4, " disponibles"],
  Editable->False]], "Print",
 CellChangeTimes->{{3.9676281182578793`*^9, 3.967628177732724*^9}, 
   3.967635097420444*^9, 3.9676352615146027`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[1950]:=",ExpressionUUID->"9cb2f702-76a4-4c20-b687-cc56ae298bfc"],

Cell[BoxData["\<\"Buscando pdflatex...\"\>"], "Print",
 CellChangeTimes->{{3.9676281182578793`*^9, 3.967628177732724*^9}, 
   3.967635097420444*^9, 3.967635261515415*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[1950]:=",ExpressionUUID->"908be9d4-ef1d-4bf0-893f-d21d2432f3f6"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"pdflatex encontrado: \"\>", 
   "\[InvisibleSpace]", "\<\"/Library/TeX/texbin/pdflatex\"\>"}],
  SequenceForm["pdflatex encontrado: ", "/Library/TeX/texbin/pdflatex"],
  Editable->False]], "Print",
 CellChangeTimes->{{3.9676281182578793`*^9, 3.967628177732724*^9}, 
   3.967635097420444*^9, 3.9676352615160933`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[1950]:=",ExpressionUUID->"29de6026-4441-4e8b-9c40-9217a6d47813"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Editor '\"\>", "\[InvisibleSpace]", "\<\"TeXstudio\"\>", 
   "\[InvisibleSpace]", "\<\"' encontrado (match exacto)\"\>"}],
  SequenceForm["Editor '", "TeXstudio", "' encontrado (match exacto)"],
  Editable->False]], "Print",
 CellChangeTimes->{{3.9676281182578793`*^9, 3.967628177732724*^9}, 
   3.967635097420444*^9, 3.96763526151651*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[1950]:=",ExpressionUUID->"fd8cb7ee-9181-4dc8-b047-62768c664195"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Abriendo archivo en \"\>", 
   "\[InvisibleSpace]", "\<\"TeXstudio\"\>", 
   "\[InvisibleSpace]", "\<\"...\"\>"}],
  SequenceForm["Abriendo archivo en ", "TeXstudio", "..."],
  Editable->False]], "Print",
 CellChangeTimes->{{3.9676281182578793`*^9, 3.967628177732724*^9}, 
   3.967635097420444*^9, 3.967635261516934*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[1950]:=",ExpressionUUID->"dac5b705-2a3e-4eca-bd24-e25f3fdc5df9"],

Cell[BoxData["\<\"Editor abierto correctamente\"\>"], "Print",
 CellChangeTimes->{{3.9676281182578793`*^9, 3.967628177732724*^9}, 
   3.967635097420444*^9, 3.967635261609318*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[1950]:=",ExpressionUUID->"d33ff909-516d-4603-8034-82d2b319c77c"],

Cell[BoxData["\<\"Compilando documento LaTeX...\"\>"], "Print",
 CellChangeTimes->{{3.9676281182578793`*^9, 3.967628177732724*^9}, 
   3.967635097420444*^9, 3.967635262616262*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[1950]:=",ExpressionUUID->"4cca5888-51fd-47e3-bfd9-f7bd55ed8cc8"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Directorio de trabajo: \"\>", 
   "\[InvisibleSpace]", \
"\<\"/Users/enriquevilchezquesada/Downloads/Contour2D4/\"\>"}],
  SequenceForm[
  "Directorio de trabajo: ", 
   "/Users/enriquevilchezquesada/Downloads/Contour2D4/"],
  Editable->False]], "Print",
 CellChangeTimes->{{3.9676281182578793`*^9, 3.967628177732724*^9}, 
   3.967635097420444*^9, 3.967635262620275*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[1950]:=",ExpressionUUID->"da93e7fa-713f-4abc-b372-f59ac8b66e71"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Archivo: \"\>", "\[InvisibleSpace]", "\<\"Contour2D4\"\>"}],
  SequenceForm["Archivo: ", "Contour2D4"],
  Editable->False]], "Print",
 CellChangeTimes->{{3.9676281182578793`*^9, 3.967628177732724*^9}, 
   3.967635097420444*^9, 3.967635262622821*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[1950]:=",ExpressionUUID->"f45c890f-24b4-4bab-947d-1bfee29f6d72"],

Cell[BoxData["\<\"Compilaci\[OAcute]n exitosa\"\>"], "Print",
 CellChangeTimes->{{3.9676281182578793`*^9, 3.967628177732724*^9}, 
   3.967635097420444*^9, 3.967635264899519*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[1950]:=",ExpressionUUID->"73240396-bce6-4b72-aa9a-16a457083d3b"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"PDF generado: \"\>", 
   "\[InvisibleSpace]", \
"\<\"/Users/enriquevilchezquesada/Downloads/Contour2D4/Contour2D4.pdf\"\>"}],
  SequenceForm[
  "PDF generado: ", 
   "/Users/enriquevilchezquesada/Downloads/Contour2D4/Contour2D4.pdf"],
  Editable->False]], "Print",
 CellChangeTimes->{{3.9676281182578793`*^9, 3.967628177732724*^9}, 
   3.967635097420444*^9, 3.967635264900279*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[1950]:=",ExpressionUUID->"f7b53c3e-8d17-4931-b485-50772eccd6d0"]
}, Open  ]],

Cell[BoxData["\<\"/Users/enriquevilchezquesada/Downloads/Contour2D4/\
Contour2D4.pdf\"\>"], "Output",
 CellChangeTimes->{{3.9676281181164303`*^9, 3.967628177596051*^9}, 
   3.967635097283124*^9, 3.967635264913086*^9},
 CellLabel->
  "Out[1960]=",ExpressionUUID->"d3e40642-2465-4cf7-a855-27363fe9a8b3"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
Ejemplo 5: hip\[EAcute]rbola rotada 45\[Degree] (con xy), en este caso s\
\[IAcute] la grafica pero deja dos secciones discontinuas, la herramienta no \
es perfecta\
\>", "Subsection",
 CellChangeTimes->{{3.9675372440640697`*^9, 3.9675372675999336`*^9}, {
  3.9675375901084404`*^9, 
  3.967537607213772*^9}},ExpressionUUID->"5cc50824-c872-b945-b342-\
8b74b49f389e"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"ContourPlot", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"-", "0.069444"}], " ", 
       RowBox[{"x", "^", "2"}]}], "+", 
      RowBox[{"0.361111", " ", "x", " ", "y"}], "+", 
      RowBox[{"0.430556", " ", "x"}], "-", 
      RowBox[{"0.069444", " ", 
       RowBox[{"y", "^", "2"}]}], "-", 
      RowBox[{"0.319444", " ", "y"}], "-", "1.267360"}], "==", "0"}], ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", 
      RowBox[{"-", "10"}], ",", "10"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"y", ",", 
      RowBox[{"-", "10"}], ",", "10"}], "}"}], ",", 
    RowBox[{"Frame", "->", "False"}], ",", 
    RowBox[{"Axes", "->", "True"}]}], "]"}], "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"line", "[", "]"}], ":=", 
  RowBox[{"RandomChoice", "[", 
   RowBox[{"{", 
    RowBox[{"\"\<solid\>\"", ",", "\"\<dashed\>\"", ",", "\"\<dotted\>\"", 
     ",", "\"\<thick\>\"", ",", "\"\<thin\>\""}], "}"}], "]"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"color", "[", "]"}], ":=", 
  RowBox[{"RandomChoice", "[", 
   RowBox[{"{", 
    RowBox[{"\"\<blue\>\"", ",", "\"\<red\>\"", ",", "\"\<green\>\"", 
     ",", "\"\<purple\>\"", ",", "\"\<yellow\>\"", ",", "\"\<orange\>\"", 
     ",", "\"\<cyan\>\"", ",", "\"\<magenta\>\"", ",", "\"\<black\>\""}], 
    "}"}], "]"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"sizetexto", "[", "]"}], ":=", 
  RowBox[{"RandomChoice", "[", 
   RowBox[{"{", 
    RowBox[{"\"\<\\\\tiny\>\"", ",", "\"\<\\\\scriptsize\>\"", 
     ",", "\"\<\\\\footnotesize\>\"", ",", "\"\<\\\\small\>\"", 
     ",", "\"\<\\\\normalsize\>\"", ",", "\"\<\\\\large\>\"", 
     ",", "\"\<\\\\Large\>\"", ",", "\"\<\\\\huge\>\"", 
     ",", "\"\<\\\\Huge\>\""}], "}"}], "]"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"anclajetexto", "[", "]"}], ":=", 
  RowBox[{"RandomChoice", "[", 
   RowBox[{"{", 
    RowBox[{"\"\<north\>\"", ",", "\"\<south\>\"", ",", "\"\<east\>\"", 
     ",", "\"\<west\>\"", ",", "\"\<north east\>\"", ",", "\"\<north west\>\"",
      ",", "\"\<south east\>\"", ",", "\"\<south west\>\"", 
     ",", "\"\<center\>\""}], "}"}], "]"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"rotatexto", "[", "]"}], ":=", 
  RowBox[{"RandomReal", "[", 
   RowBox[{"{", 
    RowBox[{"0", ",", "360"}], "}"}], "]"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"estilotext", "[", "n_", "]"}], ":=", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"\"\<color\>\"", ",", 
        RowBox[{"color", "[", "]"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"\"\<size\>\"", ",", 
        RowBox[{"sizetexto", "[", "]"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"\"\<anchor\>\"", ",", 
        RowBox[{"anclajetexto", "[", "]"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"\"\<rotate\>\"", ",", 
        RowBox[{"rotatexto", "[", "]"}]}], "}"}]}], "}"}], ",", "n"}], 
   "]"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"vectorestilos", "=", 
   RowBox[{"estilotext", "[", "1", "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Row", "[", 
    RowBox[{"{", 
     RowBox[{"\"\<grid=\>\"", ",", 
      RowBox[{"grid", "=", 
       RowBox[{"RandomChoice", "[", 
        RowBox[{"{", 
         RowBox[{"True", ",", "False"}], "}"}], "]"}]}]}], "}"}], "]"}], ",", 
   
   RowBox[{"Row", "[", 
    RowBox[{"{", 
     RowBox[{"\"\<estilos=\>\"", ",", 
      RowBox[{"estilos", "=", 
       RowBox[{"Table", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"line", "[", "]"}], ",", 
           RowBox[{"color", "[", "]"}]}], "}"}], ",", "1"}], "]"}]}]}], "}"}],
     "]"}], ",", 
   RowBox[{"Row", "[", 
    RowBox[{"{", 
     RowBox[{"\"\<ejes=\>\"", ",", 
      RowBox[{"ejes", "=", "True"}]}], "}"}], "]"}], ",", 
   RowBox[{"Row", "[", 
    RowBox[{"{", 
     RowBox[{"\"\<texto=\>\"", ",", 
      RowBox[{"texto", "=", 
       RowBox[{"{", 
        RowBox[{"{", 
         RowBox[{"\"\<Hip\[EAcute]rbola rotada\>\"", ",", 
          RowBox[{"{", 
           RowBox[{"0", ",", "0"}], "}"}], ",", 
          RowBox[{"vectorestilos", "[", 
           RowBox[{"[", "1", "]"}], "]"}]}], "}"}], "}"}]}]}], "}"}], "]"}], ",", 
   RowBox[{"Row", "[", 
    RowBox[{"{", 
     RowBox[{"\"\<muestras=\>\"", ",", 
      RowBox[{"muestras", "=", "1650"}]}], "}"}], "]"}], ",", 
   RowBox[{"Row", "[", 
    RowBox[{"{", 
     RowBox[{"\"\<tolerancia=\>\"", ",", 
      RowBox[{"tolerancia", "=", "0.01"}]}], "}"}], "]"}], ",", 
   RowBox[{"Row", "[", 
    RowBox[{"{", 
     RowBox[{"\"\<opacidad=\>\"", ",", 
      RowBox[{"opacidad", "=", "1"}]}], "}"}], "]"}], ",", 
   RowBox[{"Row", "[", 
    RowBox[{"{", 
     RowBox[{"\"\<densidad=\>\"", ",", 
      RowBox[{"densidad", "=", "2.5"}]}], "}"}], "]"}], ",", 
   RowBox[{"Row", "[", 
    RowBox[{"{", 
     RowBox[{"\"\<xmin=\>\"", ",", 
      RowBox[{"xmin", "=", 
       RowBox[{"-", "10"}]}]}], "}"}], "]"}], ",", 
   RowBox[{"Row", "[", 
    RowBox[{"{", 
     RowBox[{"\"\<xmax=\>\"", ",", 
      RowBox[{"xmax", "=", "10"}]}], "}"}], "]"}], ",", 
   RowBox[{"Row", "[", 
    RowBox[{"{", 
     RowBox[{"\"\<ymin=\>\"", ",", 
      RowBox[{"ymin", "=", 
       RowBox[{"-", "10"}]}]}], "}"}], "]"}], ",", 
   RowBox[{"Row", "[", 
    RowBox[{"{", 
     RowBox[{"\"\<ymax=\>\"", ",", 
      RowBox[{"ymax", "=", "10"}]}], "}"}], "]"}]}], "}"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ExportContour2DToTikZ", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"-", "0.069444"}], " ", 
       RowBox[{"x", "^", "2"}]}], "+", 
      RowBox[{"0.361111", " ", "x", " ", "y"}], "+", 
      RowBox[{"0.430556", " ", "x"}], "-", 
      RowBox[{"0.069444", " ", 
       RowBox[{"y", "^", "2"}]}], "-", 
      RowBox[{"0.319444", " ", "y"}], "-", "1.267360"}], "==", "0"}], 
    ",", "\"\<Contour2D5.tex\>\"", ",", "grid", ",", "estilos", ",", "ejes", ",",
     "texto", ",", "muestras", ",", "tolerancia", ",", "opacidad", ",", 
    "densidad", ",", "xmin", ",", "xmax", ",", "ymin", ",", "ymax"}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"CompiladorTex", "[", 
  RowBox[{"%", ",", 
   RowBox[{"\"\<PreferredEditor\>\"", " ", "->", "\"\<TeXstudio\>\""}]}], 
  "]"}]}], "Input",
 CellChangeTimes->{{3.9675375884318047`*^9, 3.9675376161683826`*^9}, {
   3.967538272964987*^9, 3.967538273273798*^9}, {3.9675452028944187`*^9, 
   3.967545204227705*^9}, {3.967573788091482*^9, 3.9675737885787582`*^9}, {
   3.967573966552184*^9, 3.967573966796664*^9}, {3.96762826547955*^9, 
   3.967628289304*^9}, {3.9676283393059273`*^9, 3.967628408295429*^9}, {
   3.967628446863935*^9, 3.9676284952232027`*^9}, {3.967628538681134*^9, 
   3.967628539215554*^9}, 3.9676342064862223`*^9, {3.967635079303788*^9, 
   3.967635079780068*^9}},
 CellLabel->
  "In[1961]:=",ExpressionUUID->"c8c58c27-48d3-ea4a-8772-f0f20cacd133"],

Cell[BoxData[
 GraphicsBox[{GraphicsComplexBox[CompressedData["
1:eJxFVgs4VPkbnhlzcVuGXJpxN3TRxaYL1bbnU225JuEfSrU2QiuUSFYlutiy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    "], {{}, {}, 
     TagBox[
      TooltipBox[
       {RGBColor[0.24, 0.6, 0.8], AbsoluteThickness[2], 
        LineBox[{1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 
         18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 
         35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 
         52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 64, 65, 66, 67, 68, 
         69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 
         86, 87, 88, 89, 90, 91, 92, 93, 94, 95, 96, 97, 98, 99, 100, 101, 
         102, 103, 104}], 
        LineBox[{105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 
         117, 118, 119, 120, 121, 122, 123, 124, 125, 126, 127, 128, 129, 130,
          131, 132, 133, 134, 135, 136, 137, 138, 139, 140, 141, 142, 143, 
         144, 145, 146, 147, 148, 149, 150, 151, 152, 153, 154, 155, 156, 157,
          158, 159, 160, 161, 162, 163, 164, 165, 166, 167, 168, 169, 170, 
         171, 172, 173, 174, 175, 176, 177, 178, 179, 180, 181, 182, 183, 184,
          185, 186, 187, 188, 189, 190, 191, 192, 193, 194, 195, 196, 197, 
         198, 199, 200, 201, 202, 203, 204, 205, 206, 207, 208, 209, 210, 211,
          212, 213, 214, 215}]},
       RowBox[{
         RowBox[{
           RowBox[{"-", "1.26736`"}], "+", 
           RowBox[{"0.430556`", " ", 
             TagBox["x", HoldForm]}], "-", 
           RowBox[{"0.069444`", " ", 
             SuperscriptBox[
              TagBox["x", HoldForm], "2"]}], "-", 
           RowBox[{"0.319444`", " ", 
             TagBox["y", HoldForm]}], "+", 
           RowBox[{"0.361111`", " ", 
             TagBox["x", HoldForm], " ", 
             TagBox["y", HoldForm]}], "-", 
           RowBox[{"0.069444`", " ", 
             SuperscriptBox[
              TagBox["y", HoldForm], "2"]}]}], "\[Equal]", "0"}]],
      Annotation[#, -1.26736 + 0.430556 HoldForm[$CellContext`x] - 0.069444 
        HoldForm[$CellContext`x]^2 - 0.319444 HoldForm[$CellContext`y] + 
        0.361111 HoldForm[$CellContext`x] HoldForm[$CellContext`y] - 0.069444 
        HoldForm[$CellContext`y]^2 == 0, "Tooltip"]& ]}], {}},
  AspectRatio->1,
  Axes->True,
  AxesLabel->{None, None},
  AxesOrigin->{0., 0.},
  DefaultBaseStyle->{"PlotGraphics", "Graphics"},
  DisplayFunction->Identity,
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  Method->{
   "DefaultBoundaryStyle" -> Automatic, 
    "DefaultGraphicsInteraction" -> {
     "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
      "Effects" -> {
       "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
        "Droplines" -> {
         "freeformCursorMode" -> True, 
          "placement" -> {"x" -> "All", "y" -> "None"}}}}, "GridLinesInFront" -> 
    True},
  PlotInteractivity:>True,
  PlotRange->{{-10, 10}, {-10, 10}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.02], 
     Scaled[0.02]}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{
  3.967628410335979*^9, {3.967628471727461*^9, 3.967628542267878*^9}, 
   3.967635080176948*^9, 3.967635278581934*^9},
 CellLabel->
  "Out[1961]=",ExpressionUUID->"3d26ad86-1fbc-486c-a41a-f580ff60689b"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TemplateBox[{"\"grid=\"", "True"},
    "RowDefault"], ",", 
   TemplateBox[{"\"estilos=\"", 
     RowBox[{"{", 
       RowBox[{"{", 
         RowBox[{"\"dotted\"", ",", "\"orange\""}], "}"}], "}"}]},
    "RowDefault"], ",", 
   TemplateBox[{"\"ejes=\"", "True"},
    "RowDefault"], ",", 
   TemplateBox[{"\"texto=\"", 
     RowBox[{"{", 
       RowBox[{"{", 
         RowBox[{"\"Hip\[EAcute]rbola rotada\"", ",", 
           RowBox[{"{", 
             RowBox[{"0", ",", "0"}], "}"}], ",", 
           RowBox[{"{", 
             RowBox[{
               RowBox[{"{", 
                 RowBox[{"\"color\"", ",", "\"magenta\""}], "}"}], ",", 
               RowBox[{"{", 
                 RowBox[{"\"size\"", ",", "\"\\\\scriptsize\""}], "}"}], ",", 
               
               RowBox[{"{", 
                 RowBox[{"\"anchor\"", ",", "\"north west\""}], "}"}], ",", 
               RowBox[{"{", 
                 RowBox[{"\"rotate\"", ",", "264.57511612779956`"}], "}"}]}], 
             "}"}]}], "}"}], "}"}]},
    "RowDefault"], ",", 
   TemplateBox[{"\"muestras=\"", "1650"},
    "RowDefault"], ",", 
   TemplateBox[{"\"tolerancia=\"", "0.01`"},
    "RowDefault"], ",", 
   TemplateBox[{"\"opacidad=\"", "1"},
    "RowDefault"], ",", 
   TemplateBox[{"\"densidad=\"", "2.5`"},
    "RowDefault"], ",", 
   TemplateBox[{"\"xmin=\"", 
     RowBox[{"-", "10"}]},
    "RowDefault"], ",", 
   TemplateBox[{"\"xmax=\"", "10"},
    "RowDefault"], ",", 
   TemplateBox[{"\"ymin=\"", 
     RowBox[{"-", "10"}]},
    "RowDefault"], ",", 
   TemplateBox[{"\"ymax=\"", "10"},
    "RowDefault"]}], "}"}]], "Output",
 CellChangeTimes->{
  3.967628410335979*^9, {3.967628471727461*^9, 3.967628542267878*^9}, 
   3.967635080176948*^9, 3.967635278584135*^9},
 CellLabel->
  "Out[1969]=",ExpressionUUID->"8ba78b43-f83c-409e-b531-e063ea5dca1c"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Usando editores ya detectados: \"\>", "\[InvisibleSpace]", "4",
    "\[InvisibleSpace]", "\<\" disponibles\"\>"}],
  SequenceForm["Usando editores ya detectados: ", 4, " disponibles"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.967628410712947*^9, {3.967628472170102*^9, 3.967628542623658*^9}, 
   3.9676350805337553`*^9, 3.967635278937505*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[1961]:=",ExpressionUUID->"2655f223-d271-4c25-a46e-8484c6a63ed4"],

Cell[BoxData["\<\"Buscando pdflatex...\"\>"], "Print",
 CellChangeTimes->{
  3.967628410712947*^9, {3.967628472170102*^9, 3.967628542623658*^9}, 
   3.9676350805337553`*^9, 3.967635278938332*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[1961]:=",ExpressionUUID->"6de790ca-1ccf-4fd1-913d-a090b17bc4fa"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"pdflatex encontrado: \"\>", 
   "\[InvisibleSpace]", "\<\"/Library/TeX/texbin/pdflatex\"\>"}],
  SequenceForm["pdflatex encontrado: ", "/Library/TeX/texbin/pdflatex"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.967628410712947*^9, {3.967628472170102*^9, 3.967628542623658*^9}, 
   3.9676350805337553`*^9, 3.967635278939012*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[1961]:=",ExpressionUUID->"a82b3b78-4abf-4186-8e69-3c450c77898e"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Editor '\"\>", "\[InvisibleSpace]", "\<\"TeXstudio\"\>", 
   "\[InvisibleSpace]", "\<\"' encontrado (match exacto)\"\>"}],
  SequenceForm["Editor '", "TeXstudio", "' encontrado (match exacto)"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.967628410712947*^9, {3.967628472170102*^9, 3.967628542623658*^9}, 
   3.9676350805337553`*^9, 3.967635278939435*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[1961]:=",ExpressionUUID->"7aa7105f-343a-4a30-848c-d8fc792a1bba"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Abriendo archivo en \"\>", 
   "\[InvisibleSpace]", "\<\"TeXstudio\"\>", 
   "\[InvisibleSpace]", "\<\"...\"\>"}],
  SequenceForm["Abriendo archivo en ", "TeXstudio", "..."],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.967628410712947*^9, {3.967628472170102*^9, 3.967628542623658*^9}, 
   3.9676350805337553`*^9, 3.967635278939831*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[1961]:=",ExpressionUUID->"541395d9-755d-4dda-858e-f52820af5cdc"],

Cell[BoxData["\<\"Editor abierto correctamente\"\>"], "Print",
 CellChangeTimes->{
  3.967628410712947*^9, {3.967628472170102*^9, 3.967628542623658*^9}, 
   3.9676350805337553`*^9, 3.967635279027318*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[1961]:=",ExpressionUUID->"25d009df-3acd-434f-bb45-5eaecb88e903"],

Cell[BoxData["\<\"Compilando documento LaTeX...\"\>"], "Print",
 CellChangeTimes->{
  3.967628410712947*^9, {3.967628472170102*^9, 3.967628542623658*^9}, 
   3.9676350805337553`*^9, 3.967635280032548*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[1961]:=",ExpressionUUID->"2acde3b3-cbfd-4e3a-a03a-fd3fc63fd3ac"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Directorio de trabajo: \"\>", 
   "\[InvisibleSpace]", \
"\<\"/Users/enriquevilchezquesada/Downloads/Contour2D5/\"\>"}],
  SequenceForm[
  "Directorio de trabajo: ", 
   "/Users/enriquevilchezquesada/Downloads/Contour2D5/"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.967628410712947*^9, {3.967628472170102*^9, 3.967628542623658*^9}, 
   3.9676350805337553`*^9, 3.967635280036057*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[1961]:=",ExpressionUUID->"b7f6359c-3a25-49d0-8dd9-3652bc35e788"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Archivo: \"\>", "\[InvisibleSpace]", "\<\"Contour2D5\"\>"}],
  SequenceForm["Archivo: ", "Contour2D5"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.967628410712947*^9, {3.967628472170102*^9, 3.967628542623658*^9}, 
   3.9676350805337553`*^9, 3.96763528003855*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[1961]:=",ExpressionUUID->"e54ec161-6220-4f6d-9277-26a21e1e7849"],

Cell[BoxData["\<\"Compilaci\[OAcute]n exitosa\"\>"], "Print",
 CellChangeTimes->{
  3.967628410712947*^9, {3.967628472170102*^9, 3.967628542623658*^9}, 
   3.9676350805337553`*^9, 3.967635284228373*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[1961]:=",ExpressionUUID->"d8a14a38-3459-4aa4-8f16-da2601185923"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"PDF generado: \"\>", 
   "\[InvisibleSpace]", \
"\<\"/Users/enriquevilchezquesada/Downloads/Contour2D5/Contour2D5.pdf\"\>"}],
  SequenceForm[
  "PDF generado: ", 
   "/Users/enriquevilchezquesada/Downloads/Contour2D5/Contour2D5.pdf"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.967628410712947*^9, {3.967628472170102*^9, 3.967628542623658*^9}, 
   3.9676350805337553`*^9, 3.967635284229138*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[1961]:=",ExpressionUUID->"f555d097-ac3d-4d61-9f16-55750ba57ee0"]
}, Open  ]],

Cell[BoxData["\<\"/Users/enriquevilchezquesada/Downloads/Contour2D5/\
Contour2D5.pdf\"\>"], "Output",
 CellChangeTimes->{
  3.967628410335979*^9, {3.967628471727461*^9, 3.967628542267878*^9}, 
   3.967635080176948*^9, 3.9676352842430468`*^9},
 CellLabel->
  "Out[1971]=",ExpressionUUID->"24e57d39-aea2-44ae-93a7-99fbfa546058"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Ejemplo 6: regi\[OAcute]n parab\[OAcute]lica vertical desplazada", \
"Subsection",
 CellChangeTimes->{{3.9675372440640697`*^9, 3.9675372698764057`*^9}, {
  3.9675376260516205`*^9, 3.967537629531061*^9}, {3.967628695062319*^9, 
  3.9676287030875196`*^9}, {3.9676296354777737`*^9, 
  3.967629638195204*^9}},ExpressionUUID->"0991d975-d991-ce49-b8c4-\
b24f482151e6"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"RegionPlot", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"-", "0.5"}], " ", 
       RowBox[{"x", "^", "2"}]}], "+", "x", "+", "y"}], "<=", "0"}], ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", 
      RowBox[{"-", "3"}], ",", "6"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"y", ",", 
      RowBox[{"-", "4"}], ",", "6"}], "}"}], ",", 
    RowBox[{"Frame", "->", "False"}], ",", 
    RowBox[{"Axes", "->", "True"}]}], "]"}], "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"line", "[", "]"}], ":=", 
  RowBox[{"RandomChoice", "[", 
   RowBox[{"{", 
    RowBox[{"\"\<solid\>\"", ",", "\"\<dashed\>\"", ",", "\"\<dotted\>\"", 
     ",", "\"\<thick\>\"", ",", "\"\<thin\>\""}], "}"}], "]"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"color", "[", "]"}], ":=", 
  RowBox[{"RandomChoice", "[", 
   RowBox[{"{", 
    RowBox[{"\"\<blue\>\"", ",", "\"\<red\>\"", ",", "\"\<green\>\"", 
     ",", "\"\<purple\>\"", ",", "\"\<yellow\>\"", ",", "\"\<orange\>\"", 
     ",", "\"\<cyan\>\"", ",", "\"\<magenta\>\"", ",", "\"\<black\>\""}], 
    "}"}], "]"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"sizetexto", "[", "]"}], ":=", 
  RowBox[{"RandomChoice", "[", 
   RowBox[{"{", 
    RowBox[{"\"\<\\\\tiny\>\"", ",", "\"\<\\\\scriptsize\>\"", 
     ",", "\"\<\\\\footnotesize\>\"", ",", "\"\<\\\\small\>\"", 
     ",", "\"\<\\\\normalsize\>\"", ",", "\"\<\\\\large\>\"", 
     ",", "\"\<\\\\Large\>\"", ",", "\"\<\\\\huge\>\"", 
     ",", "\"\<\\\\Huge\>\""}], "}"}], "]"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"anclajetexto", "[", "]"}], ":=", 
  RowBox[{"RandomChoice", "[", 
   RowBox[{"{", 
    RowBox[{"\"\<north\>\"", ",", "\"\<south\>\"", ",", "\"\<east\>\"", 
     ",", "\"\<west\>\"", ",", "\"\<north east\>\"", ",", "\"\<north west\>\"",
      ",", "\"\<south east\>\"", ",", "\"\<south west\>\"", 
     ",", "\"\<center\>\""}], "}"}], "]"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"rotatexto", "[", "]"}], ":=", 
  RowBox[{"RandomReal", "[", 
   RowBox[{"{", 
    RowBox[{"0", ",", "360"}], "}"}], "]"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"estilotext", "[", "n_", "]"}], ":=", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"\"\<color\>\"", ",", 
        RowBox[{"color", "[", "]"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"\"\<size\>\"", ",", 
        RowBox[{"sizetexto", "[", "]"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"\"\<anchor\>\"", ",", 
        RowBox[{"anclajetexto", "[", "]"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"\"\<rotate\>\"", ",", 
        RowBox[{"rotatexto", "[", "]"}]}], "}"}]}], "}"}], ",", "n"}], 
   "]"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"vectorestilos", "=", 
   RowBox[{"estilotext", "[", "1", "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Row", "[", 
    RowBox[{"{", 
     RowBox[{"\"\<grid=\>\"", ",", 
      RowBox[{"grid", "=", 
       RowBox[{"RandomChoice", "[", 
        RowBox[{"{", 
         RowBox[{"True", ",", "False"}], "}"}], "]"}]}]}], "}"}], "]"}], ",", 
   
   RowBox[{"Row", "[", 
    RowBox[{"{", 
     RowBox[{"\"\<estilos=\>\"", ",", 
      RowBox[{"estilos", "=", 
       RowBox[{"Table", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"line", "[", "]"}], ",", 
           RowBox[{"color", "[", "]"}]}], "}"}], ",", "2"}], "]"}]}]}], "}"}],
     "]"}], ",", 
   RowBox[{"Row", "[", 
    RowBox[{"{", 
     RowBox[{"\"\<ejes=\>\"", ",", 
      RowBox[{"ejes", "=", "True"}]}], "}"}], "]"}], ",", 
   RowBox[{"Row", "[", 
    RowBox[{"{", 
     RowBox[{"\"\<texto=\>\"", ",", 
      RowBox[{"texto", "=", 
       RowBox[{"{", 
        RowBox[{"{", 
         RowBox[{"\"\<Regi\[OAcute]n parab\[OAcute]lica\>\"", ",", 
          RowBox[{"{", 
           RowBox[{"1", ",", 
            RowBox[{"-", "1"}]}], "}"}], ",", 
          RowBox[{"vectorestilos", "[", 
           RowBox[{"[", "1", "]"}], "]"}]}], "}"}], "}"}]}]}], "}"}], "]"}], ",", 
   RowBox[{"Row", "[", 
    RowBox[{"{", 
     RowBox[{"\"\<muestras=\>\"", ",", 
      RowBox[{"muestras", "=", "60"}]}], "}"}], "]"}], ",", 
   RowBox[{"Row", "[", 
    RowBox[{"{", 
     RowBox[{"\"\<tolerancia=\>\"", ",", 
      RowBox[{"tolerancia", "=", "0.01"}]}], "}"}], "]"}], ",", 
   RowBox[{"Row", "[", 
    RowBox[{"{", 
     RowBox[{"\"\<opacidad=\>\"", ",", 
      RowBox[{"opacidad", "=", "0.8"}]}], "}"}], "]"}], ",", 
   RowBox[{"Row", "[", 
    RowBox[{"{", 
     RowBox[{"\"\<densidad=\>\"", ",", 
      RowBox[{"densidad", "=", "1.5"}]}], "}"}], "]"}], ",", 
   RowBox[{"Row", "[", 
    RowBox[{"{", 
     RowBox[{"\"\<xmin=\>\"", ",", 
      RowBox[{"xmin", "=", 
       RowBox[{"-", "3"}]}]}], "}"}], "]"}], ",", 
   RowBox[{"Row", "[", 
    RowBox[{"{", 
     RowBox[{"\"\<xmax=\>\"", ",", 
      RowBox[{"xmax", "=", "6"}]}], "}"}], "]"}], ",", 
   RowBox[{"Row", "[", 
    RowBox[{"{", 
     RowBox[{"\"\<ymin=\>\"", ",", 
      RowBox[{"ymin", "=", 
       RowBox[{"-", "4"}]}]}], "}"}], "]"}], ",", 
   RowBox[{"Row", "[", 
    RowBox[{"{", 
     RowBox[{"\"\<ymax=\>\"", ",", 
      RowBox[{"ymax", "=", "6"}]}], "}"}], "]"}]}], "}"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ExportContour2DToTikZ", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{"-", "0.5"}], " ", 
         RowBox[{"x", "^", "2"}]}], "+", "x", "+", "y"}], "<=", "0"}], ",", 
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{"-", "0.5"}], " ", 
         RowBox[{"x", "^", "2"}]}], "+", "x", "+", "y"}], "==", "0"}]}], 
     "}"}], ",", "\"\<Contour2D6.tex\>\"", ",", "grid", ",", "estilos", ",", 
    "ejes", ",", "texto", ",", "muestras", ",", "tolerancia", ",", "opacidad",
     ",", "densidad", ",", "xmin", ",", "xmax", ",", "ymin", ",", "ymax"}], 
   "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"CompiladorTex", "[", 
  RowBox[{"%", ",", 
   RowBox[{"\"\<PreferredEditor\>\"", " ", "->", "\"\<TeXstudio\>\""}]}], 
  "]"}]}], "Input",
 CellChangeTimes->{{3.96753762433317*^9, 3.9675376327909737`*^9}, {
   3.96753827039962*^9, 3.9675382707032223`*^9}, {3.9675448750587845`*^9, 
   3.9675449148614216`*^9}, {3.9675449472672176`*^9, 3.967544953908106*^9}, {
   3.967544993495119*^9, 3.9675450192931137`*^9}, {3.967573791707624*^9, 
   3.967573792145026*^9}, {3.9675739742245483`*^9, 3.967573975513865*^9}, {
   3.967628637648999*^9, 3.967628676898172*^9}, {3.9676287123960123`*^9, 
   3.967628757814683*^9}, 3.967628792304384*^9, {3.96762964567028*^9, 
   3.9676296617639837`*^9}, 3.967634200607779*^9, {3.9676350632141*^9, 
   3.967635063652564*^9}},
 CellLabel->
  "In[1972]:=",ExpressionUUID->"0cd4e8f7-3fce-9642-8192-212b1fd5220f"],

Cell[BoxData[
 GraphicsBox[{GraphicsComplexBox[CompressedData["
1:eJxdmHtczNn/x7tM03Uy3Zmwwmpc1w9jXbKfw/jR+i5Gm9zWrHJZzFqkqHWp
dZnIdRnKLYbWXYVkafw+I4rGumTTFLaimUolNVQq9fmm9Trzoz94PPtM57zP
83PO+7zf4xOyNGC+lYWFxU9t/3z4/8jUn7UcZ6ud9WrWVY7roJ3+975cg4RH
2XXKjfJshQXluMP6xtnSRhbssL9fd3FyLeUmsfVeg8RAOToqdV+J5BblsEdT
9hgluQw40NQaIZe+pHxlbR93o+Qt5bHrH1eKdM2UF0q1weJkSwJOytw7URpp
Q/nteMVwudSe8ggd+TJSIKBMem210ymElOeWha/Ty1wpK0/NeWuQuFM+veg/
i00iT8oP+gwt5jgvyvDXmwRcEukcqT8w/IHhDwx/YPgDwx8Y/sDwB4Y/MPyB
4Q8Mf2D4A8MfGP7A8AeGPzD8geEPDH8Nu/3PS1S21B8Y/sDwB4Y/MPyB4Q8M
f2D4A8MfGP7A8AeGPzD8geEPDH9g+APDHxj+wPAHhr9M4zcnZXJr6g8Mf2D4
A8MfGP7A8AeGPzD8geEPDH9g+APDHxj+wPAHhj8w/IHhDwx/YPgDw1+v5YvH
6GWtLPyB4Q8Mf2D4A8MfGP7A8AeGPzD8geEPDH9g+APDHxj+wPAHhj8w/IHh
Dwx/YPjL8Jw2VGCso/7A8AeGPzD8geEPDH9g+APDHxj+wPAHhj8w/IHhDwx/
YPgDwx8Y/sDwB4Y/MPxpImIClaYK6g8Mf2D4A8MfGP7A8AeGPzD8geEPDH9g
+APDHxj+wPAHhj8w/IHhDwx/YPgDw195zI0IgySX+gPDHxj+wPAHhj8w/IHh
Dww/YPgBww8YfsDwA4YfMPyA4QcMP2D4AcOP7KbX0hiTjoEfMPyA4QcMP2D4
AWO9YKwXjPWCsV4w1gvGesFYLxjrBWO9YKz30B9VbySqMrpeMNYLxnrBWC8Y
6wVjfWCsD4z1gbE+MNYHxvrAWB8Y6wNjfYPO2/M/nFOsD4z1gbE+MNYHRvxg
xA9G/GDED0b8YMQPRvxgxL/Ptotrsvo9jR+M+MGIH4x4wYgXjHjBiBeMeMGI
F4x4wYi3ZWDHnRqlFUG8YMQLRrxgxAdGfGDEB0Z8YMQHRnxgxPdVoc9etYZP
4wMjPjDiASMeMOIBIx4w4gEjHjDiCd7a96DS5EDjASMeMOYHY34w5gdjfjDm
B2P+PcMkaoW4A50fjPnBmB+M+cGYH4z5wZgfjPlfhB75XpzsQucHY3wwxgdj
fDDGB2P81d8m5ol0bnR8MMYHY3wwxgdjfDDGd+92eobA6EHHB2N8MMYHY3ww
xgdj/KT6888+/B5/D8bfg/H34NuvvleLk58z07uG+WuUL9hlzYFinaKGciv3
4aeB8hP/lF9nSwtYi/15vA2mM2ws76xeouIY8NZ2tibL9l18oJcVMjH9k34W
6SpZi/afGiZHGX1TJrclYJm3lbM0so6dN9PNSad4R/Mp+NPnFsTLPihZIXYk
4MIvzhsjBC0f8xmPfJrfePT5ndReHVV6OzK7fV87E7DE9ZxcL7P6mB+F5NN8
KaTPB7SfR1fyqD1+F4LnYDxfo/ptgknE/3gePSnD97/51o3gORjPUT/CN+pH
MOon+Mb7wH0Nv7gf4A/5F/6Q7+AH+QaM8w9fYPjA+fn0fjD7wHPw5+cJ63de
1nu7NNLIfPcid2OS+hk7cazNcd/kHFbY5cX5Ukkq03+mV7xE9eZj/m9irskz
lirEzey/49uQxAtpx2VyS63fqMKLCrELqRi8badCbKO1u1E1UhrpRZ584xFr
EtXT8e8nb5guUb1m725w3qKX1TNhz6o2yOQN7IRDBx5+2Ld/tZ8PwcfzZU+2
5NksEBiFBOOfi6t5KtK5EowPxvvD/OBP9+s7et+C4Rf79dP7l0f9NQUP7Prh
9/ANrq7sFiQwdiDj7l380SRypvvp3/3tTn2DRV83d1PpXcgvFWV/yuQeZOGX
r3eWtXnG/gKj3o0viDxcJElk7Wb9UDBEdZu9f3Diqh+l2QwY5xvnHfUdOPVE
/9PZimLWye/ITYHxMeXF7168kslLmJD2+OwI3gfe97/7sZU51Z6/nAjeD97/
mvb9ZEv3I3zg/IItn8fNUpra+vr29+FIGb7gD8/xvje351HzeYY/5G9wVqi6
k1xqre0eNX+VXmb2C0Z/A7+W+veLvXVP6X5E/gXj/WK/IZ7P7zvsP+RfjI/+
CexzoyJcYGyk4+PzeL8/tfcbLfR9In8jv6AfAee90J1QaywIzic+T/uZ45c7
J6utCN438hH2A+p9cOf5R3drlDyC/YD9ROv9s/nRHFfG3g+ob2z7PR3v036A
T/Ac5+3T+tSBYD/hvCHf4bxjP+F9437Feb42dXFTtqKtT/qYT3F/4b4CI7+0
6xKZGORT3Fe4n8DIPyntXizp/LhPsN/A2G+5biWSD+cc7wPvDz7hHz4QH/jT
fsOBnj/4QXxg3BfwhfOI/IT7FIz7AvsX5wv5CesB435APsX5Qf2xa9HEgR88
g/F9BfZ37N21k9SaUrq/8XkwPo/9js9j/+K8gOn3Fx/3M/zS+uXjeQB/2n/z
qf/EbJ9z6rRGet6GOGTsKLl8h97XyA+nBg2ocLLJoed31frf+0dMvMfm3ghf
Kthu/j4A57Gps3O68fI9JoyYrin28sjn/fW8FX3fi2Ir6Hlb0sLcUIa8YoIn
DPARMyZaD8zJ6jZe6mPu/3A/JSx53zdyVAsjDpuQZpjdSOsD6dOk39UpTvT8
OIyNs5T+9p7WC7i/pO7WCtNFWxLEtvaXp3eg9XznqwuGiTtZmuuHxDnztv/t
Qj6vjxf/M+mgstCTjEgZPFOfz6P3qau35U19tJGJS9fU5O16xpYcWNzquCmL
zfxnUVFy8B0mI3TITYPAxJ73UKYqhr1nFiRK49X1diQl6lSQuKGZ6Z4dGi0L
amRbM3fniy7yifhq8eCEBU6kM69ms581n1hcmV6XVGmhjd9Z8ES00IXcnDsm
i7vA047oqAgSpHuR9cq7XS12VTOy+EQb9fsidtfZKSkXfC4ww3t/H+doTGEl
a1ZvGbs/iyHbu+RMTrjFliT8WLopoIBNX3pgZFu1yiScvXjMKaqAzU/KOSHe
U8hU9bsQaQrhmB1F/KfVokTWN27u0MgZ1qTP8ck/RvYvZqoTk67sWVVG80vA
iVtn9tyuZoVbLqQoM+qZDaVVAyOX88nvV01/y5xNzC/5PR6G623JpcnPxSp5
A81Pad+/OqAOa2b6/WP4O3tkDa2vd8xecc1g1cBaLx9cyWVZk4iU3LHSXxyI
tu5pgnqEJfFJHCdSHXckonv56/QdzfV1p5jKGM2+Nn+OXV5HXG6g9Xa8VUqE
LL2F5Rvqyg3nnIi9yeZO0t5W9nqeuI+8TEB6+EQWcs3OJPtbdbDJynxfW8bK
t2qOCUlI3tw/ZP+v/l5x+FKAaaWltnl8ameV1JUMGO5VNNPShexonp1c2aOt
/3rH14ietd3/Gfrbklh3snFUT/fk1S4k++XXi0xp7qTw+5lfSkfzaD2O+nqN
4nRR7YFCev8+fLW2vPZAAa23rQ7GVOc9/Ifmm8LvRvA1/Hxaf8fkHE+30GYy
PS69kqaqzzKf1+P8b9efFH9VyIzjbFOU3c39EfLR5is1xweoDrKmqoFjC3ub
+yXkn9d7e/kaw58z15QmTUSXKvr9Eu5HHneoUlTxhhnW1DdL9tSG5vfO02XT
xbbm+h/5qf5I8T3ZujomYWWgWtRUR79PwX3mNC36b0mNJTH18rTSuTnQ/L/u
2eAYTasDzf+4P8q6J1dxr839w7SJt1JlaY7kumEJI10roPfBYOnUK7Ix5v4B
90mJQ5NQVeZEtBsq7HQSc/+QVd7VW66wov036rsdryryRMfcSGyRxXTxEHM/
gftmhOP5x6Igd6Jsqu0f6WPuLwKPdC5ULzIyq1znltSue8b267FguajrS3bS
yzkt3Opapru7ZqJpHE/r274vPQn/evZ3P1vkMY51pcMUwx6xjSeuWlsY6hjh
hZXqiPNP2XXDVwxTba9nlk5uGitJfMLKGgt26O2aGUNObUPtk4dsv8O34zQH
LYnuGf+u7j9/MQHL9X9FdClhzy0/66u7W86sO3KoY/IbHrFoYjoajS+Zd8XX
k/bEVLHeR47OFR95y2z3O3RIHd2WV0ePnyn91sQop/R2Se5rT2Kjy7WyvLZ8
fcIxifupnr0fHDRK7mhNtplCrj/MdSBRzWPW63tbkSEnn+WK/nIiIhudVGpj
S5yTpzRnlwvITO9fwvSt9qRy95MZgmwBydyTU8ydtCd8T9NO0SOOVSg3tSZd
7UAuzuKH6BdbaOeMWzNV3PY+hH75xSJrITnwU/BJpZ2QvO3Z3X6Cp5BI791y
TR4jJPK4PmGmDUIyqC6elalcyLQdUx8bsq2173ozMwQ+niRAxo4srHUh8aG7
PFSTPEk3P01FlIMryVhV+ZU80ZPMnORdcWS+KzlUcNS/vNyLXD4l95cuMfdT
+D4C+XY3OyhD5m1H+6cbp40vuQ125M++4T8JPJoY/nPeRc73La2vJpSeLEja
/5YtWPW/NVyZBbHyO3ZU+cSR9lcOB79rzR7mRJJKO5Rz221I55g7LuKGJvp9
wbHmQvbb3c1sxZ016/3O2JNHzOrVsl7v2W/mvckRhTqQP+rnNWZzzrQfO6P2
+0pu24EMjsvZou4pILyMB0GC9R2Ia2yN3LTZmcwZuu9X9S1LWs+lHQv6VV1u
qR1ZMuSYst6VnL7Tr1CkdKH9Wm6rU6Eo3oXMuJPxPtvLg+z7MvudIc2FGFpG
7lKv9yB51w7MUN2uZM6ElMwzhBfR/i1C0in9mvISyzu6qGVKQjbzV+jdOb5f
3War3joHJAUX0P4s0OvXNWOeF7Glg3x/E5eVMB2la4qT0mtYb399luzXRlrP
Oi38IdK0u4FpTv/dX59rYjfWLSvjylqY8V6Gp0lT37D5a23yRVYcM/iEYKZ6
4Dv2h9KvtbIRNrS+zRNaZ8iG8sjQ8Jxp6rBG1r1LtpHT88lOz6qtkogmduWZ
ZSVcXzsi3FrWScC1sPC5MDV8sP5OKxtlFXhXNMiZ3g//s3DJMlPb/qzqXGOp
Ulhq93vtO64c0NbnVu6cLi4R0vqyesnhgZEJQjJpyMM+kWUuJHDCyibDTSEZ
snbqZs1MV7Jt0u5ofVcXssA3SqTa4EZ61jzYpHSwpv3d1nU/y/VhVtrQhug8
UaEb2W+/snXPXGvtjj2jsyTLPMiuS1m7FYHW2lOBB8L1gR7kWO2KKPlB8/cZ
6+2yXK/XFzEbhw/wk7XqWXnwapd8YQGtB9EPRns07kq68Zg9teXNOU1CLbO2
RXp5zNUidqi/U09dvol5MenKfENLIXtfXvKFbnAdHb/4+u1Y7scXtF9Cf52r
P18pSzAwk/wqqmev4FjUX+h/h7ssuS5Z5kxcJSsya6RCMm3Tsvt194T0+4WH
m7aWc+Pb8uyuUZmyEHM/GnZRFGbaZu5HNzZE1ySdtqb90g8W00fK+7mSjac2
TRN4e9F+1d/taJDgsBc5PEU8Uj7e3L/uXz7XN3nvO+Z+9OpHvg/y2JvHqkSS
sEds4dj533g7PGbO/F9xrN6/hSkdOPZQOv8W+3PcnFTlOQviOtprxubQNMZ5
vmbztCgrEt+Y+8UUTz3z5UpnztCbR9LODTpgajIwWRNevPbtXcp22dQzRPr4
FRMqjg83pdqQ4IQNxzX11czCAVn71Pftyb/3C8eMWd16jDv9ng3RiRqzezsS
8dweE8WzBGRxdZ/R0t/sSJdFBi85w9P6cyV+0leepOf4AL/fQs+z9ceduiwV
JzGnnuwx+nKVbPiiogxFx7fM6+qeo+S+tuRh5p8NXPJbhjdhUKTiYR2bdiMg
UxZkRTLHLzFyjo5kV2TmLdkJK5IjmuyhWuFMtj0Id1NFOZI5/tvk+hArbbTp
cp5I60bmGBfMFzAuZHInzwh9lRv5L1EksSU=
    "], {{
      {RGBColor[0.24, 0.6, 0.8], AbsoluteThickness[2.], Opacity[0.3], 
       EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxNmQv81+MVx7/Pl1wSkUsuWVKUCF10c01SSaHJPVkuIRKZW0ZolGtMNRXL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          "]], PolygonBox[CompressedData["
1:eJwtlfdvzlEUh997VYhZraqtlZhFxVa1R1GttEbVKkolIkQiIiISiaT/AP8A
aobEjK1IxN5BjdojRhQhIoTnk3N+eHLOufd+3zvO55w3c9HK4hUxkUiUQxIc
CYlEGQMbsPXgHSwk3ohNgVr4BznQDHZACfMrsVV8fwy7DbrDQHgEf2AoZEJX
1naByfj5sBWmEy/DbuH75vjN4Ct+X8YewnDiMuwCeBZsD/12N9gFpcyvxh7m
myvY4zAI0uAtJDE/DFvN/GF9F23vJDgInYknBtszFT8l2lx/+AEjou39l/kn
2DHE5djFupd+G+bhZ8BtnY24FDsb+uHfwraBXO0B8xlbj20Hn2Eu8TpsOpyE
/dALBsNpOATZMERvyNoMyAt2Zt11L/T0O3+EBtH2us95K6LdQWevxN7z39Rv
dYDXMIs1q7AtoHG0M+psw6EJcdNoa+v4jW/YRtHm+sBU/GQYgV8BJ6A18Vjs
NdbnK9fRvp3D2Ez8Ks/1ctfOK2xyMA0pl2/8LKv9bDtdWzrjNOKiaLlZCi3x
i6P5I11Lta5NaSot2hrNjVJO8C+6ltfAGTgKo12j7Zi/oXPCeOhI3Al647eF
F3Aeil3jp6B9tLXPOeNZjUvj2KbQA78aWwgFkEV8QfeAIpgk7cGhhI2l41/W
PYK9YV/iNtAKf4bnOjuar5zXueaktd6unf7Ml7iGBih30c5e4tq8EywX0ugc
4j3BamcttjyahqSdTdicaDlWbqXxGvglXcNCmKC7R7trV+kK/77ezTX7M5gG
K33sLnx37cyVZe5qsFpVjb73M+ksqbDbc6Zc6Y226946E3ZzwnKhNy3ynOit
nwfrDXrzl6655a6xT35H3U1v2hD/erDay4Jc4gfBall3POc5VO60p7TxxddK
I6rFu34X1aRq+4BrQTWu2t4XrBZU4+qt6onqheqx6q3qUepN6rGFxFOi9b4l
UB//kr9FD2lYWo7Wm9UTH0u7xAOCaU7a+eBrpaGbwXqKeol60O9gPUy9S9+o
dgui7aUaHqfajfa26nHq1TWea/XsPOKnnmv9B/wH/nqogw==
          "]]}]}, {}, {}, {}, {}}, 
     {RGBColor[0.24, 0.6, 0.8], AbsoluteThickness[2.], LineBox[CompressedData["
1:eJwl1FVTlGEYgGFKkRCRsAsssDuxuwG7FetMT/U/6F/QGbvATuwCW8EWbDDB
xo7rGw6uvZ/nnR3Y2X13U3JWZC8PDQkJifQQpsGcTDoDyGIJq1jDOvI4RiHF
lFJOJVX8JswfqkUqQzjICX7zgPn+2QGtq5kMYjADuOd8oH7VpVqlrbQld8x9
dJ8e5xa97be1tsYylnH0osh5T72pH5hr3q3NtRlN6UF38pznc52u9hvaTa9o
pL7VRfpOG2lDutCZHc6OcImO9svaSQs0Qst1ob7UX1xgln1b8L7raMbQgbPO
2usZfcpU8wY9zGMW2J/oKdLNp7WdbtQ/DDMPZygl9p8cCj4H+0NN05NaT0cw
klL7KP2r/3jEFPv64ELoJp2mz/Qcz5lu36yhukVn6As9Txkz7Vs1XLfrbH2l
hdQwv9YcfaMXqW9uwFHzTmqac3WOVujV4E6ZK3WxvtdrNDY34Zh5F1HmPTpP
P2qMRvPJvEQ/azEtzCmkstcep3X4Yh6vE5lAPJPoR3/6ctdzMvSbLtPvep/W
5ja0Zb89QRP5Yc7SyWSTRHJw54O7HbxmooPXGlr9XQwN7om3/isVlFFCEQXk
k8taVrOSxWSSQRpJJJJAXeKpQxy1iSWGaKKoFfwOUJMaRBBe/fGH/AdoBnsS

       "]]}}], {}},
  AspectRatio->1,
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{0, 0},
  DefaultBaseStyle->{"PlotGraphics", "Graphics"},
  DisplayFunction->Identity,
  Frame->{{False, False}, {False, False}},
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImagePadding->All,
  Method->{
   "DefaultGraphicsInteraction" -> {
     "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
      "Effects" -> {
       "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
        "Droplines" -> {
         "freeformCursorMode" -> True, 
          "placement" -> {"x" -> "All", "y" -> "None"}}}}, "ScalingFunctions" -> 
    None, "TransparentPolygonMesh" -> True, "AxesInFront" -> True},
  PlotInteractivity:>True,
  PlotRange->{{-3, 6}, {-4, 6}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.02], 
     Scaled[0.02]}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{
  3.9675449179595795`*^9, 3.967545020597431*^9, {3.967628795133193*^9, 
   3.96762881547219*^9}, 3.967629664947152*^9, 3.967635064615396*^9, 
   3.967635298949594*^9},
 CellLabel->
  "Out[1972]=",ExpressionUUID->"fd32299e-1751-4530-84a3-ffb09d480383"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TemplateBox[{"\"grid=\"", "True"},
    "RowDefault"], ",", 
   TemplateBox[{"\"estilos=\"", 
     RowBox[{"{", 
       RowBox[{
         RowBox[{"{", 
           RowBox[{"\"thick\"", ",", "\"black\""}], "}"}], ",", 
         RowBox[{"{", 
           RowBox[{"\"thin\"", ",", "\"purple\""}], "}"}]}], "}"}]},
    "RowDefault"], ",", 
   TemplateBox[{"\"ejes=\"", "True"},
    "RowDefault"], ",", 
   TemplateBox[{"\"texto=\"", 
     RowBox[{"{", 
       RowBox[{"{", 
         RowBox[{"\"Regi\[OAcute]n parab\[OAcute]lica\"", ",", 
           RowBox[{"{", 
             RowBox[{"1", ",", 
               RowBox[{"-", "1"}]}], "}"}], ",", 
           RowBox[{"{", 
             RowBox[{
               RowBox[{"{", 
                 RowBox[{"\"color\"", ",", "\"orange\""}], "}"}], ",", 
               RowBox[{"{", 
                 RowBox[{"\"size\"", ",", "\"\\\\scriptsize\""}], "}"}], ",", 
               
               RowBox[{"{", 
                 RowBox[{"\"anchor\"", ",", "\"north east\""}], "}"}], ",", 
               RowBox[{"{", 
                 RowBox[{"\"rotate\"", ",", "345.15445984124125`"}], "}"}]}], 
             "}"}]}], "}"}], "}"}]},
    "RowDefault"], ",", 
   TemplateBox[{"\"muestras=\"", "60"},
    "RowDefault"], ",", 
   TemplateBox[{"\"tolerancia=\"", "0.01`"},
    "RowDefault"], ",", 
   TemplateBox[{"\"opacidad=\"", "0.8`"},
    "RowDefault"], ",", 
   TemplateBox[{"\"densidad=\"", "1.5`"},
    "RowDefault"], ",", 
   TemplateBox[{"\"xmin=\"", 
     RowBox[{"-", "3"}]},
    "RowDefault"], ",", 
   TemplateBox[{"\"xmax=\"", "6"},
    "RowDefault"], ",", 
   TemplateBox[{"\"ymin=\"", 
     RowBox[{"-", "4"}]},
    "RowDefault"], ",", 
   TemplateBox[{"\"ymax=\"", "6"},
    "RowDefault"]}], "}"}]], "Output",
 CellChangeTimes->{
  3.9675449179595795`*^9, 3.967545020597431*^9, {3.967628795133193*^9, 
   3.96762881547219*^9}, 3.967629664947152*^9, 3.967635064615396*^9, 
   3.9676352989519653`*^9},
 CellLabel->
  "Out[1980]=",ExpressionUUID->"856d32f6-82c5-4037-8753-35bdadb2cca7"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Usando editores ya detectados: \"\>", "\[InvisibleSpace]", "4",
    "\[InvisibleSpace]", "\<\" disponibles\"\>"}],
  SequenceForm["Usando editores ya detectados: ", 4, " disponibles"],
  Editable->False]], "Print",
 CellChangeTimes->{{3.9676287953840847`*^9, 3.967628815725651*^9}, 
   3.9676296652014112`*^9, 3.967635064868011*^9, 3.967635299201275*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[1972]:=",ExpressionUUID->"b965de00-cfd7-4a7b-9287-f3700cb27ba2"],

Cell[BoxData["\<\"Buscando pdflatex...\"\>"], "Print",
 CellChangeTimes->{{3.9676287953840847`*^9, 3.967628815725651*^9}, 
   3.9676296652014112`*^9, 3.967635064868011*^9, 3.967635299202063*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[1972]:=",ExpressionUUID->"546630cc-f0a8-44ea-ba9b-92e2265aded9"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"pdflatex encontrado: \"\>", 
   "\[InvisibleSpace]", "\<\"/Library/TeX/texbin/pdflatex\"\>"}],
  SequenceForm["pdflatex encontrado: ", "/Library/TeX/texbin/pdflatex"],
  Editable->False]], "Print",
 CellChangeTimes->{{3.9676287953840847`*^9, 3.967628815725651*^9}, 
   3.9676296652014112`*^9, 3.967635064868011*^9, 3.967635299202744*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[1972]:=",ExpressionUUID->"fb750d71-d6b9-4c96-b53d-b13ffd59ce99"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Editor '\"\>", "\[InvisibleSpace]", "\<\"TeXstudio\"\>", 
   "\[InvisibleSpace]", "\<\"' encontrado (match exacto)\"\>"}],
  SequenceForm["Editor '", "TeXstudio", "' encontrado (match exacto)"],
  Editable->False]], "Print",
 CellChangeTimes->{{3.9676287953840847`*^9, 3.967628815725651*^9}, 
   3.9676296652014112`*^9, 3.967635064868011*^9, 3.967635299203164*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[1972]:=",ExpressionUUID->"ed7fdac2-7718-42f9-b852-63ca9857ca59"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Abriendo archivo en \"\>", 
   "\[InvisibleSpace]", "\<\"TeXstudio\"\>", 
   "\[InvisibleSpace]", "\<\"...\"\>"}],
  SequenceForm["Abriendo archivo en ", "TeXstudio", "..."],
  Editable->False]], "Print",
 CellChangeTimes->{{3.9676287953840847`*^9, 3.967628815725651*^9}, 
   3.9676296652014112`*^9, 3.967635064868011*^9, 3.9676352992035627`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[1972]:=",ExpressionUUID->"319f3e50-ad51-4bf3-b11a-4cf6ae974eea"],

Cell[BoxData["\<\"Editor abierto correctamente\"\>"], "Print",
 CellChangeTimes->{{3.9676287953840847`*^9, 3.967628815725651*^9}, 
   3.9676296652014112`*^9, 3.967635064868011*^9, 3.9676352992760363`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[1972]:=",ExpressionUUID->"7931328d-affe-4473-9cd1-8b6a49848827"],

Cell[BoxData["\<\"Compilando documento LaTeX...\"\>"], "Print",
 CellChangeTimes->{{3.9676287953840847`*^9, 3.967628815725651*^9}, 
   3.9676296652014112`*^9, 3.967635064868011*^9, 3.967635300281662*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[1972]:=",ExpressionUUID->"eaeb9059-bc1a-4b26-b749-c70a9ddcce51"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Directorio de trabajo: \"\>", 
   "\[InvisibleSpace]", \
"\<\"/Users/enriquevilchezquesada/Downloads/Contour2D6/\"\>"}],
  SequenceForm[
  "Directorio de trabajo: ", 
   "/Users/enriquevilchezquesada/Downloads/Contour2D6/"],
  Editable->False]], "Print",
 CellChangeTimes->{{3.9676287953840847`*^9, 3.967628815725651*^9}, 
   3.9676296652014112`*^9, 3.967635064868011*^9, 3.9676353002848663`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[1972]:=",ExpressionUUID->"1a83260c-4721-46fa-a177-08b52f5686c0"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Archivo: \"\>", "\[InvisibleSpace]", "\<\"Contour2D6\"\>"}],
  SequenceForm["Archivo: ", "Contour2D6"],
  Editable->False]], "Print",
 CellChangeTimes->{{3.9676287953840847`*^9, 3.967628815725651*^9}, 
   3.9676296652014112`*^9, 3.967635064868011*^9, 3.967635300286242*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[1972]:=",ExpressionUUID->"ecd2e976-12ab-4195-9fbb-e49dd985b6be"],

Cell[BoxData["\<\"Compilaci\[OAcute]n exitosa\"\>"], "Print",
 CellChangeTimes->{{3.9676287953840847`*^9, 3.967628815725651*^9}, 
   3.9676296652014112`*^9, 3.967635064868011*^9, 3.967635302567738*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[1972]:=",ExpressionUUID->"1b56c286-d454-4dac-8a96-95cd48854625"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"PDF generado: \"\>", 
   "\[InvisibleSpace]", \
"\<\"/Users/enriquevilchezquesada/Downloads/Contour2D6/Contour2D6.pdf\"\>"}],
  SequenceForm[
  "PDF generado: ", 
   "/Users/enriquevilchezquesada/Downloads/Contour2D6/Contour2D6.pdf"],
  Editable->False]], "Print",
 CellChangeTimes->{{3.9676287953840847`*^9, 3.967628815725651*^9}, 
   3.9676296652014112`*^9, 3.967635064868011*^9, 3.9676353025688047`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[1972]:=",ExpressionUUID->"5f52cbfe-c63d-4f12-bc58-41ec4b611ffc"]
}, Open  ]],

Cell[BoxData["\<\"/Users/enriquevilchezquesada/Downloads/Contour2D6/\
Contour2D6.pdf\"\>"], "Output",
 CellChangeTimes->{
  3.9675449179595795`*^9, 3.967545020597431*^9, {3.967628795133193*^9, 
   3.96762881547219*^9}, 3.967629664947152*^9, 3.967635064615396*^9, 
   3.9676353025816603`*^9},
 CellLabel->
  "Out[1982]=",ExpressionUUID->"b98ba954-2910-4931-8acb-894aaf17a829"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
Ejemplo 7: regi\[OAcute]n parab\[OAcute]lica rotada 30\[Degree] (con xy), \
tampoco se ve perfecta\
\>", "Subsection",
 CellChangeTimes->{{3.9675372440640697`*^9, 3.9675372712449093`*^9}, {
  3.967537640164583*^9, 3.9675376467075577`*^9}, {3.967628848704393*^9, 
  3.9676288495121117`*^9}, {3.967629681335269*^9, 
  3.9676296838736887`*^9}},ExpressionUUID->"b2b63969-3242-a046-8a8f-\
9fa5887946c3"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"RegionPlot", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"-", "0.45"}], " ", 
       RowBox[{"x", "^", "2"}]}], "-", 
      RowBox[{"0.519615", " ", "x", " ", "y"}], "+", 
      RowBox[{"0.919615", " ", "x"}], "-", 
      RowBox[{"0.15", " ", 
       RowBox[{"y", "^", "2"}]}], "+", 
      RowBox[{"1.685640", " ", "y"}], "-", "1.485640"}], ">=", "0"}], ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", 
      RowBox[{"-", "8"}], ",", "6"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"y", ",", 
      RowBox[{"-", "1"}], ",", "7"}], "}"}], ",", 
    RowBox[{"Frame", "->", "False"}], ",", 
    RowBox[{"Axes", "->", "True"}]}], "]"}], "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"line", "[", "]"}], ":=", 
  RowBox[{"RandomChoice", "[", 
   RowBox[{"{", 
    RowBox[{"\"\<solid\>\"", ",", "\"\<dashed\>\"", ",", "\"\<dotted\>\"", 
     ",", "\"\<thick\>\"", ",", "\"\<thin\>\""}], "}"}], "]"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"color", "[", "]"}], ":=", 
  RowBox[{"RandomChoice", "[", 
   RowBox[{"{", 
    RowBox[{"\"\<blue\>\"", ",", "\"\<red\>\"", ",", "\"\<green\>\"", 
     ",", "\"\<purple\>\"", ",", "\"\<yellow\>\"", ",", "\"\<orange\>\"", 
     ",", "\"\<cyan\>\"", ",", "\"\<magenta\>\"", ",", "\"\<black\>\""}], 
    "}"}], "]"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"sizetexto", "[", "]"}], ":=", 
  RowBox[{"RandomChoice", "[", 
   RowBox[{"{", 
    RowBox[{"\"\<\\\\tiny\>\"", ",", "\"\<\\\\scriptsize\>\"", 
     ",", "\"\<\\\\footnotesize\>\"", ",", "\"\<\\\\small\>\"", 
     ",", "\"\<\\\\normalsize\>\"", ",", "\"\<\\\\large\>\"", 
     ",", "\"\<\\\\Large\>\"", ",", "\"\<\\\\huge\>\"", 
     ",", "\"\<\\\\Huge\>\""}], "}"}], "]"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"anclajetexto", "[", "]"}], ":=", 
  RowBox[{"RandomChoice", "[", 
   RowBox[{"{", 
    RowBox[{"\"\<north\>\"", ",", "\"\<south\>\"", ",", "\"\<east\>\"", 
     ",", "\"\<west\>\"", ",", "\"\<north east\>\"", ",", "\"\<north west\>\"",
      ",", "\"\<south east\>\"", ",", "\"\<south west\>\"", 
     ",", "\"\<center\>\""}], "}"}], "]"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"rotatexto", "[", "]"}], ":=", 
  RowBox[{"RandomReal", "[", 
   RowBox[{"{", 
    RowBox[{"0", ",", "360"}], "}"}], "]"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"estilotext", "[", "n_", "]"}], ":=", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"\"\<color\>\"", ",", 
        RowBox[{"color", "[", "]"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"\"\<size\>\"", ",", 
        RowBox[{"sizetexto", "[", "]"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"\"\<anchor\>\"", ",", 
        RowBox[{"anclajetexto", "[", "]"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"\"\<rotate\>\"", ",", 
        RowBox[{"rotatexto", "[", "]"}]}], "}"}]}], "}"}], ",", "n"}], 
   "]"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"vectorestilos", "=", 
   RowBox[{"estilotext", "[", "1", "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Row", "[", 
    RowBox[{"{", 
     RowBox[{"\"\<grid=\>\"", ",", 
      RowBox[{"grid", "=", 
       RowBox[{"RandomChoice", "[", 
        RowBox[{"{", 
         RowBox[{"True", ",", "False"}], "}"}], "]"}]}]}], "}"}], "]"}], ",", 
   
   RowBox[{"Row", "[", 
    RowBox[{"{", 
     RowBox[{"\"\<estilos=\>\"", ",", 
      RowBox[{"estilos", "=", 
       RowBox[{"Table", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"line", "[", "]"}], ",", 
           RowBox[{"color", "[", "]"}]}], "}"}], ",", "2"}], "]"}]}]}], "}"}],
     "]"}], ",", 
   RowBox[{"Row", "[", 
    RowBox[{"{", 
     RowBox[{"\"\<ejes=\>\"", ",", 
      RowBox[{"ejes", "=", "True"}]}], "}"}], "]"}], ",", 
   RowBox[{"Row", "[", 
    RowBox[{"{", 
     RowBox[{"\"\<texto=\>\"", ",", 
      RowBox[{"texto", "=", 
       RowBox[{"{", 
        RowBox[{"{", 
         RowBox[{"\"\<Regi\[OAcute]n parab\[OAcute]lica rotada\>\"", ",", 
          RowBox[{"{", 
           RowBox[{"0", ",", "0"}], "}"}], ",", 
          RowBox[{"vectorestilos", "[", 
           RowBox[{"[", "1", "]"}], "]"}]}], "}"}], "}"}]}]}], "}"}], "]"}], ",", 
   RowBox[{"Row", "[", 
    RowBox[{"{", 
     RowBox[{"\"\<muestras=\>\"", ",", 
      RowBox[{"muestras", "=", "70"}]}], "}"}], "]"}], ",", 
   RowBox[{"Row", "[", 
    RowBox[{"{", 
     RowBox[{"\"\<tolerancia=\>\"", ",", 
      RowBox[{"tolerancia", "=", "0.01"}]}], "}"}], "]"}], ",", 
   RowBox[{"Row", "[", 
    RowBox[{"{", 
     RowBox[{"\"\<opacidad=\>\"", ",", 
      RowBox[{"opacidad", "=", "0.8"}]}], "}"}], "]"}], ",", 
   RowBox[{"Row", "[", 
    RowBox[{"{", 
     RowBox[{"\"\<densidad=\>\"", ",", 
      RowBox[{"densidad", "=", "2"}]}], "}"}], "]"}], ",", 
   RowBox[{"Row", "[", 
    RowBox[{"{", 
     RowBox[{"\"\<xmin=\>\"", ",", 
      RowBox[{"xmin", "=", "Automatic"}]}], "}"}], "]"}], ",", 
   RowBox[{"Row", "[", 
    RowBox[{"{", 
     RowBox[{"\"\<xmax=\>\"", ",", 
      RowBox[{"xmax", "=", "Automatic"}]}], "}"}], "]"}], ",", 
   RowBox[{"Row", "[", 
    RowBox[{"{", 
     RowBox[{"\"\<ymin=\>\"", ",", 
      RowBox[{"ymin", "=", "Automatic"}]}], "}"}], "]"}], ",", 
   RowBox[{"Row", "[", 
    RowBox[{"{", 
     RowBox[{"\"\<ymax=\>\"", ",", 
      RowBox[{"ymax", "=", "Automatic"}]}], "}"}], "]"}]}], "}"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ExportContour2DToTikZ", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{"-", "0.45"}], " ", 
         RowBox[{"x", "^", "2"}]}], "-", 
        RowBox[{"0.519615", " ", "x", " ", "y"}], "+", 
        RowBox[{"0.919615", " ", "x"}], "-", 
        RowBox[{"0.15", " ", 
         RowBox[{"y", "^", "2"}]}], "+", 
        RowBox[{"1.685640", " ", "y"}], "-", "1.485640"}], ">=", "0"}], ",", 
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{"-", "0.45"}], " ", 
         RowBox[{"x", "^", "2"}]}], "-", 
        RowBox[{"0.519615", " ", "x", " ", "y"}], "+", 
        RowBox[{"0.919615", " ", "x"}], "-", 
        RowBox[{"0.15", " ", 
         RowBox[{"y", "^", "2"}]}], "+", 
        RowBox[{"1.685640", " ", "y"}], "-", "1.485640"}], "==", "0"}]}], 
     "}"}], ",", "\"\<Contour2D7.tex\>\"", ",", "grid", ",", "estilos", ",", 
    "ejes", ",", "texto", ",", "muestras", ",", "tolerancia", ",", "opacidad",
     ",", "densidad", ",", "xmin", ",", "xmax", ",", "ymin", ",", "ymax"}], 
   "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"CompiladorTex", "[", 
  RowBox[{"%", ",", 
   RowBox[{"\"\<PreferredEditor\>\"", " ", "->", "\"\<TeXstudio\>\""}]}], 
  "]"}]}], "Input",
 CellChangeTimes->{{3.967537638406229*^9, 3.9675376506559925`*^9}, {
   3.9675382673381996`*^9, 3.967538267631815*^9}, {3.9675452105015144`*^9, 
   3.967545211930353*^9}, {3.967573796232294*^9, 3.967573796677865*^9}, {
   3.96757398335922*^9, 3.967573983855142*^9}, {3.967628873279643*^9, 
   3.967629004056188*^9}, {3.96762906798009*^9, 3.967629076528953*^9}, {
   3.96762915501512*^9, 3.967629178890977*^9}, {3.967629230112273*^9, 
   3.9676292437172832`*^9}, {3.967629690403739*^9, 3.9676297656466293`*^9}, 
   3.9676341935711613`*^9, {3.967635051428341*^9, 3.96763505187469*^9}},
 CellLabel->
  "In[1983]:=",ExpressionUUID->"331ca111-7ded-0049-9d17-6670bc5b1137"],

Cell[BoxData[
 GraphicsBox[{GraphicsComplexBox[CompressedData["
1:eJxlmXlYjGsfx5P2mlTT+mRfBwnVJJT7PiJLluFYO4wtWyPHdmjEETLIejS2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    "], {{
      {RGBColor[0.24, 0.6, 0.8], AbsoluteThickness[2.], Opacity[0.3], 
       EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxNl3u8z/Udxz8fQkZGrieXGEeUOsJIjhC5hYqinLFymZRLmjFG1KGbFUuS
isK6KdoUW8vS3Jq1NmW1Vm2WbUq6KNnlsVuvl/fz9zjnj9fj/f3c3p/35315
fT7fVuOmD59WJaV0OKdUVfIGQZ/pJOEUoYZwslBbqE77A+GvwnvCt1OsK8yr
yto6tGsC91UT1gtLhdlCA/bw3FOFWuzzuvCa8F1hH/31hPqMe82ZQivha8Kz
wmbhq0JHobtwnjALm72+iVAXPaexX310eKxIaEqf7doiPCc0FL4nNBJasF8R
Ouags7HwE2Gr0ExoJ5wutGRuPfZrzTrv84bwO2GesB/dbYUz+Pb69uiwjWex
t3WcIxQzf6DQU7hAeEs4W/i68LbwB+FmoaSS7o5I23gu0vt0Za11d6LPPu5G
n3WUC13Y73zWd8LXJZV835GxHox3FuZj89nY2gU7O7OPz9eLPtvSG+n9B7HG
433Zw/v3Q3qfz4SPhFuFI9g4QLgQ+7xmMDqse4jQh/HhzB1IXzfWXMzcPsSj
EbEeyjrbskHoL1wqXMa3dQ1jvB8x9Drn2Qj28ZkuR9qua4VvCGPAZdg1Clu9
53bhRXR/Lnwq3C6MZa51f4ItZcLV7HGFsFEYLUxMUVuuK+fuN1nnedcwd6Qw
Dun9dwo7hCuFb6GnDHsL555UqW8yZ7Bd5gjXvjnlevazXVOQ3nMq0nv+Stgr
jBeuQ4fXmG9mpOAQc4y5pcA55g9zwmy+zTffScFNhfp3/dXDlpqs81htxmug
w+2ZzPFezmPnWHfG6qPLuey6cD6bJ1zTDRj3d4FjLIvQXRjfzLdtdU45t1zz
c1NwivvMDfvZx3FwLg4hPoNpW685wfzg/GqJrib0tWT/1szbyrftq8u8xvil
iLbtMD+0RYdrs32q4I4SdJ3F2E18W+/CFHXeIVXwS0fmuc47sd61VeAVy67Y
3Y59WrJnO+woYW57dFivuc1814UYWIe5YwF72aYbU9xnVVnXg1jeJqxKUUe2
xbXsGl+cguNK0WvO6YneXrQL3OS2c6Iv67uho3eq4Ka+9A0hXuYnc1N/9JoH
BqDLMR1EfF0LV6PrYsYWobMHdgxivfceyh63caZ+rBuJPu/nGr2U/YbT9voR
tAt85PZTKXjtEs4wrNIeo9B7OTa6Nl+kfyh7mAPK2GMMbe8xlvYI1rltDjNn
mVPuFW4hfgUOsi82peCvCawzj1zHGvPRRPabRNv7XUvb+02mbXunsH4sOian
Cg7ymDnBvGE++ItwUJgurBXuTJFPD6XILefVDuz0+dcJS1i/F50e+34KTjGf
PC7cTXt1Cp6qTp/5y7xTh2+/Z5aleAe5Xn9Iu8ARlq7fNSm4w31/TPHuMacd
SPF2cU0/KtyToj4t/e4wtxymzzXkPLuC2L6ZorZd18tT1JVr6gni5PbDjHne
ihRvDdfNk8J9xLK/iH+PsBLf2Ye+C44Ke1LcX8dS1F1P1jnXneePpKjJUny6
BJ9/LLyQ4q6fgX+r4Y9l+Mr+W4oP7Y+78PNMfG0/vyL8mDVz8e8cfPYD/Hl/
irrqV8l3xZx5OT7xXfxAinopxxddOP99qeJ9spKzLEKvdb4qPM8a++ZB/GN7
V6eK3FjPmRbg/8744yF88hg6yrF9DfY7T9fie+faOny5Ev+WYmcPdC5MkSs+
6zb8fJHwTIo6nABcj6674ym4wnX/dArusB/e4dtr32XtVfjpaebcgV7r853o
d3xDYuZ2HWL7I+K2jHi5Hhowx/MXc/5y2s8x7n33YGtT+psht/C9gTOaI30/
+h3fhtj+FH+vIEY34/uf4bM3WdMGHfaXc9J8aU4svNl+keLt1Iz5TZn7c+a/
w3rbMoq1nv8S661vFe2C7u3MMXawbhzf45E7+f5TCl74ivBFino7gm/eJS7O
/VfwsX35Kud2Lvw6Rd77zv0wxb1rmDvMG67Hj/DhYeb4DWDu9L+i34DzGevA
PO8/gHUf4wf76TecabfwW+zfiK3m+5f5vgrptjnEOeF3bV3g963fNU/h3w34
Yzc6ve6XrD2Ef/ax/y5sMIf7PTqNNXvx8VS+3f/3FHeY8/ko36OB77Uy/OC7
xP/Zf0vxlq2CX/xt7tpELDbS53kzsOsQsdvFGWxbdZHEihw8cqPkqhxnLfzD
+51brL4pOfimneT0HFx2kuS9ObjpNfTvI1YHsW063xl7PqDf79L3U7xNvyB+
pfjhOGd+gZg6zgeY35zvP6fg1/20W2Dre/jhIN8Zm3z+Wkjn8Sx0HEDnIc5g
/6zWonNy+Mm1+fsUPO26de6ak3drvG8Ojtwl2SsH1x7nDI6j76sB3FkbGLuE
s/rMzt2dGu+Zg4M/Ze2Js6uvWg5OekmyWw5eP9P6ctT8J+g0Z25W3z9S8LRj
NZV4WefnqeJOOYafSzS+Jkced5B8MEfdbJfsnINTe0g2zJE/syQb5IjnA+h0
zo9X3wTmDJUcluPuOcJeJ9696qvP2mOc3TZsU9/AHJz0suTgHLqdXzeQY0sl
2+Tw/aOS63PUUjGxb0teHKA9j9wqRr5BfN+n3RyfHMX+rcS4NXH2t3n4Q2Ld
gbx4ndxw39v0e4656C1y1fzge2oP+kcT68847+myvXmOvN0i2SfH22KOZNMc
3DNCsnWO+/NcyUdy8Mvzkpn+0ySb5MjhZyX/leJOvknf83Lcf7dL3prjHloi
2TKHb1Zij3lyq/r+m+LNUm4f57jPunAm/6/cr74aOc41KEecTty9jk+Ou8i2
98b+xjlssj1zfdYcd22jHDnq/LSNC7HT+TWe/Flg7slx9w7xuhzcvVFybI64
OP6PkwPNcpzB9v8Hn9qfIyXPz8Ez10vWzfGWfFJyfo53wWOST+TgXu95C/vW
lDw1x73gfO9O3taSLMqRA2MkL6T2/yfUzpFXEyX/meKtMS0Ht5pXnfuz0FNF
sk6O/Lkmx7vWMblS8gI45N/s573s+3r43/u0YC/b2BE7Pd6eOcMlT8nxpp4p
uS7HndApR227rmdInkzdjcsRV8f0HsnlOd4l5+Xwo33ovFhMbtyRIx6OhXOq
H3m1NofvbM9k+zjHG3+Sz5Hjf6U0B9+Z61zTF1HXrXLkqPVsknwmx1vB+Xsn
ObzM/s7xfprtXMvxnmubgyvNk4ty5KVzcnSOeDvWXXNwqPnTPt6Fnx3D3cTR
/tiGT1yXZeSS8+7/cMJd+r47x3vONeqadD1+CbK+cyk=
          "]], PolygonBox[CompressedData["
1:eJwtlFWLVWEYhb/XuBGMGxMDxW6xCwUVxXZUbOzG7u7uGmvGGDswUFEHxxbF
BEEEL0QQf4Mdz3Kdi4fz7HPO/vbe37vWrjpmRtb0QimlsVAE6kRK2XAH7yLw
fPiAr4J9eG3YgB+A7zCI4zw+58E4fDxsxWdBHn4chuCXoBw+GLbh86Ejfh3e
4gthEj4ZzuIrYA4+Gy7gF6Eefgju4fehKT4PLuOboAE+Rv/BNyb/Njd8bf2n
MX4UnibfU2f8JrzDl0JDPAce4Y+hEj4CduFLYAo+Fc7hq6F7+B51b7rmEnxR
+FmuQuAj4RS+ErbiVcPX2q1nxifoHvEr8EP3xfEJPrfDeXxxeK0X8BuGc3yS
z8UwDZ8ensVaXQNfAaXxa/ANFoTX1kx0rYlwJvmaRfFRcBpfB7Xw0bAfXw8H
tXY4C5pBa/wBfMZnwAC8ZvjcY7AXrxG+l2yYic+Cg8mZ6YOX0UzxHOiLlw1n
Jxf2hPdYe5sPnfB+cCR5BiXxwrA3OSMntbfwPJPhM3oW7Unyd9vDmVKWbiVn
uRDUT850UhbDv+3Rf/BqsBx/n5yNP8pBckb07K20RvIePMTbhrP+Be7iVcJZ
+QQFeIVw1j9qxvhOuI2/gjbhNXSu1lT36kJBcgeVxUbwJDmTu/Ad4S5qDXWh
vmaS3Alluwk8S874sXAn1AV91y3cIXXn/0z0mzqAV1Sm8TVwIzlD6uZPPosl
d3Qzx5ugevI5msXu8Kw0k/3hDCk7eoby4T34mFlD2VWmlWVl+HK4E+rCSxiG
D4WS+I5MF35lXJ3Qu6YdbEl+51QO7/mnzIyKhTuk7ijjmmWWOp88068wkOPj
yRksHs6AZq//lMKLhLOrjit7FcNdUwb/ZjKibGgPSuD9w91WprqGO6EuqEM9
8Nzwu+Q1XA1nVll9o86pK+G9157rXXEpvBd6ZxwOr6FzNWN1VRlSdtTZI3jP
8FrKyDJlN9x97WGHcMfULb1zm+HNw93Vo/cOfyc/DO3DHVU3tcct8V7h3zZn
9q5F2LWH/wAs7sml
          "]]}]}, {}, {}, {}, {}}, 
     {RGBColor[0.24, 0.6, 0.8], AbsoluteThickness[2.], LineBox[CompressedData["
1:eJwl03VTFVEYwOF7FTtQsRPs7gbF7gQTERSRDru7UcEuVFTs7u7+Fn4NA1Gf
O/7xzG9md989e87MRqXkx+UFA4HANwpIZTFppJNBJllkk0MueVwzeIWrXOQy
l7jPJErowRm6c5aJnKYrxXRhHK+oylKWkE9HjlGZ0EfmkkM7jhJGHbLJ4giH
qUg4mWRQRGFok9QijtY846/LSXqbAvayiz3s5hY72MlWtrONm2xmCxvYxEau
k8A8hvOY39aYq7+0uqaTxhpW8yN05prKIhoQzQcGM4uBvGcQ9VlFBP3oyxQm
M4B39Gcm3737gTZkKkP4SAyz+en+Q23ENGL5xFDm0JimvKYJNSgz80iH0Yy1
rGcdN0ik3DNPtDnTGclnRjCfFrTiDS2pyR8zT3UUkewjiv3c5Q7JBHlOG+Kp
TQVeMJq2HOAQB7nHAirxkvbMYCxfGMNCOnCCzhynE3WpwklOsYzlTOAr40mh
G+fpxTl6Uo9qXKCUFaykD2/pHfz/z/0DLLZffg==
       "]]}}], {}},
  AspectRatio->1,
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{0, 0},
  DefaultBaseStyle->{"PlotGraphics", "Graphics"},
  DisplayFunction->Identity,
  Frame->{{False, False}, {False, False}},
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImagePadding->All,
  Method->{
   "DefaultGraphicsInteraction" -> {
     "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
      "Effects" -> {
       "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
        "Droplines" -> {
         "freeformCursorMode" -> True, 
          "placement" -> {"x" -> "All", "y" -> "None"}}}}, "ScalingFunctions" -> 
    None, "TransparentPolygonMesh" -> True, "AxesInFront" -> True},
  PlotInteractivity:>True,
  PlotRange->{{-8, 6}, {-1, 7}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.02], 
     Scaled[0.02]}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{
  3.967629008225564*^9, {3.9676290772471848`*^9, 3.967629103030829*^9}, {
   3.967629162007592*^9, 3.96762917931151*^9}, {3.967629232698831*^9, 
   3.967629244202837*^9}, {3.967629714458035*^9, 3.96762976613586*^9}, 
   3.9676350529212713`*^9, 3.967635329724709*^9},
 CellLabel->
  "Out[1983]=",ExpressionUUID->"b40fca1d-969e-4169-b444-d35f3a9b2204"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TemplateBox[{"\"grid=\"", "True"},
    "RowDefault"], ",", 
   TemplateBox[{"\"estilos=\"", 
     RowBox[{"{", 
       RowBox[{
         RowBox[{"{", 
           RowBox[{"\"dotted\"", ",", "\"yellow\""}], "}"}], ",", 
         RowBox[{"{", 
           RowBox[{"\"dashed\"", ",", "\"cyan\""}], "}"}]}], "}"}]},
    "RowDefault"], ",", 
   TemplateBox[{"\"ejes=\"", "True"},
    "RowDefault"], ",", 
   TemplateBox[{"\"texto=\"", 
     RowBox[{"{", 
       RowBox[{"{", 
         RowBox[{"\"Regi\[OAcute]n parab\[OAcute]lica rotada\"", ",", 
           RowBox[{"{", 
             RowBox[{"0", ",", "0"}], "}"}], ",", 
           RowBox[{"{", 
             RowBox[{
               RowBox[{"{", 
                 RowBox[{"\"color\"", ",", "\"yellow\""}], "}"}], ",", 
               RowBox[{"{", 
                 RowBox[{"\"size\"", ",", "\"\\\\Large\""}], "}"}], ",", 
               RowBox[{"{", 
                 RowBox[{"\"anchor\"", ",", "\"center\""}], "}"}], ",", 
               RowBox[{"{", 
                 RowBox[{"\"rotate\"", ",", "344.9389792182463`"}], "}"}]}], 
             "}"}]}], "}"}], "}"}]},
    "RowDefault"], ",", 
   TemplateBox[{"\"muestras=\"", "70"},
    "RowDefault"], ",", 
   TemplateBox[{"\"tolerancia=\"", "0.01`"},
    "RowDefault"], ",", 
   TemplateBox[{"\"opacidad=\"", "0.8`"},
    "RowDefault"], ",", 
   TemplateBox[{"\"densidad=\"", "2"},
    "RowDefault"], ",", 
   TemplateBox[{"\"xmin=\"", "Automatic"},
    "RowDefault"], ",", 
   TemplateBox[{"\"xmax=\"", "Automatic"},
    "RowDefault"], ",", 
   TemplateBox[{"\"ymin=\"", "Automatic"},
    "RowDefault"], ",", 
   TemplateBox[{"\"ymax=\"", "Automatic"},
    "RowDefault"]}], "}"}]], "Output",
 CellChangeTimes->{
  3.967629008225564*^9, {3.9676290772471848`*^9, 3.967629103030829*^9}, {
   3.967629162007592*^9, 3.96762917931151*^9}, {3.967629232698831*^9, 
   3.967629244202837*^9}, {3.967629714458035*^9, 3.96762976613586*^9}, 
   3.9676350529212713`*^9, 3.967635329727083*^9},
 CellLabel->
  "Out[1991]=",ExpressionUUID->"35723bf6-eecf-4ebd-aae9-1b7b807f7945"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Usando editores ya detectados: \"\>", "\[InvisibleSpace]", "4",
    "\[InvisibleSpace]", "\<\" disponibles\"\>"}],
  SequenceForm["Usando editores ya detectados: ", 4, " disponibles"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.967629008532714*^9, {3.967629077551416*^9, 3.967629103335095*^9}, {
   3.96762916231161*^9, 3.967629179616035*^9}, {3.967629233004272*^9, 
   3.9676292445110207`*^9}, {3.967629714763579*^9, 3.9676297664425287`*^9}, 
   3.967635053229311*^9, 3.9676353300334806`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[1983]:=",ExpressionUUID->"20e39a01-0657-48cc-bd64-72a0dabfa743"],

Cell[BoxData["\<\"Buscando pdflatex...\"\>"], "Print",
 CellChangeTimes->{
  3.967629008532714*^9, {3.967629077551416*^9, 3.967629103335095*^9}, {
   3.96762916231161*^9, 3.967629179616035*^9}, {3.967629233004272*^9, 
   3.9676292445110207`*^9}, {3.967629714763579*^9, 3.9676297664425287`*^9}, 
   3.967635053229311*^9, 3.96763533003428*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[1983]:=",ExpressionUUID->"ae7d784c-09db-4028-9e0e-d5a81706c280"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"pdflatex encontrado: \"\>", 
   "\[InvisibleSpace]", "\<\"/Library/TeX/texbin/pdflatex\"\>"}],
  SequenceForm["pdflatex encontrado: ", "/Library/TeX/texbin/pdflatex"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.967629008532714*^9, {3.967629077551416*^9, 3.967629103335095*^9}, {
   3.96762916231161*^9, 3.967629179616035*^9}, {3.967629233004272*^9, 
   3.9676292445110207`*^9}, {3.967629714763579*^9, 3.9676297664425287`*^9}, 
   3.967635053229311*^9, 3.9676353300349627`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[1983]:=",ExpressionUUID->"44d06dfe-355a-4395-b7f3-9206b03f8337"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Editor '\"\>", "\[InvisibleSpace]", "\<\"TeXstudio\"\>", 
   "\[InvisibleSpace]", "\<\"' encontrado (match exacto)\"\>"}],
  SequenceForm["Editor '", "TeXstudio", "' encontrado (match exacto)"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.967629008532714*^9, {3.967629077551416*^9, 3.967629103335095*^9}, {
   3.96762916231161*^9, 3.967629179616035*^9}, {3.967629233004272*^9, 
   3.9676292445110207`*^9}, {3.967629714763579*^9, 3.9676297664425287`*^9}, 
   3.967635053229311*^9, 3.967635330035375*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[1983]:=",ExpressionUUID->"0d392529-2366-474e-88ea-205e91ac33e0"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Abriendo archivo en \"\>", 
   "\[InvisibleSpace]", "\<\"TeXstudio\"\>", 
   "\[InvisibleSpace]", "\<\"...\"\>"}],
  SequenceForm["Abriendo archivo en ", "TeXstudio", "..."],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.967629008532714*^9, {3.967629077551416*^9, 3.967629103335095*^9}, {
   3.96762916231161*^9, 3.967629179616035*^9}, {3.967629233004272*^9, 
   3.9676292445110207`*^9}, {3.967629714763579*^9, 3.9676297664425287`*^9}, 
   3.967635053229311*^9, 3.967635330035774*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[1983]:=",ExpressionUUID->"7925459f-4ca5-4b84-aa5d-0823ec742a21"],

Cell[BoxData["\<\"Editor abierto correctamente\"\>"], "Print",
 CellChangeTimes->{
  3.967629008532714*^9, {3.967629077551416*^9, 3.967629103335095*^9}, {
   3.96762916231161*^9, 3.967629179616035*^9}, {3.967629233004272*^9, 
   3.9676292445110207`*^9}, {3.967629714763579*^9, 3.9676297664425287`*^9}, 
   3.967635053229311*^9, 3.967635330102013*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[1983]:=",ExpressionUUID->"3df5d5a7-c3a8-48d2-8474-ed6065465f7a"],

Cell[BoxData["\<\"Compilando documento LaTeX...\"\>"], "Print",
 CellChangeTimes->{
  3.967629008532714*^9, {3.967629077551416*^9, 3.967629103335095*^9}, {
   3.96762916231161*^9, 3.967629179616035*^9}, {3.967629233004272*^9, 
   3.9676292445110207`*^9}, {3.967629714763579*^9, 3.9676297664425287`*^9}, 
   3.967635053229311*^9, 3.967635331105961*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[1983]:=",ExpressionUUID->"0b156518-caea-40e7-82da-e87173961df9"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Directorio de trabajo: \"\>", 
   "\[InvisibleSpace]", \
"\<\"/Users/enriquevilchezquesada/Downloads/Contour2D7/\"\>"}],
  SequenceForm[
  "Directorio de trabajo: ", 
   "/Users/enriquevilchezquesada/Downloads/Contour2D7/"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.967629008532714*^9, {3.967629077551416*^9, 3.967629103335095*^9}, {
   3.96762916231161*^9, 3.967629179616035*^9}, {3.967629233004272*^9, 
   3.9676292445110207`*^9}, {3.967629714763579*^9, 3.9676297664425287`*^9}, 
   3.967635053229311*^9, 3.9676353311107397`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[1983]:=",ExpressionUUID->"207b5d44-bc7f-4390-83a8-65a03a725da2"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Archivo: \"\>", "\[InvisibleSpace]", "\<\"Contour2D7\"\>"}],
  SequenceForm["Archivo: ", "Contour2D7"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.967629008532714*^9, {3.967629077551416*^9, 3.967629103335095*^9}, {
   3.96762916231161*^9, 3.967629179616035*^9}, {3.967629233004272*^9, 
   3.9676292445110207`*^9}, {3.967629714763579*^9, 3.9676297664425287`*^9}, 
   3.967635053229311*^9, 3.967635331114212*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[1983]:=",ExpressionUUID->"b9837e3f-59be-472b-b56f-dac608e70a79"],

Cell[BoxData["\<\"Compilaci\[OAcute]n exitosa\"\>"], "Print",
 CellChangeTimes->{
  3.967629008532714*^9, {3.967629077551416*^9, 3.967629103335095*^9}, {
   3.96762916231161*^9, 3.967629179616035*^9}, {3.967629233004272*^9, 
   3.9676292445110207`*^9}, {3.967629714763579*^9, 3.9676297664425287`*^9}, 
   3.967635053229311*^9, 3.967635332831678*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[1983]:=",ExpressionUUID->"283602e8-29f9-4caf-9fcb-4fda3e390b4a"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"PDF generado: \"\>", 
   "\[InvisibleSpace]", \
"\<\"/Users/enriquevilchezquesada/Downloads/Contour2D7/Contour2D7.pdf\"\>"}],
  SequenceForm[
  "PDF generado: ", 
   "/Users/enriquevilchezquesada/Downloads/Contour2D7/Contour2D7.pdf"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.967629008532714*^9, {3.967629077551416*^9, 3.967629103335095*^9}, {
   3.96762916231161*^9, 3.967629179616035*^9}, {3.967629233004272*^9, 
   3.9676292445110207`*^9}, {3.967629714763579*^9, 3.9676297664425287`*^9}, 
   3.967635053229311*^9, 3.967635332832443*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[1983]:=",ExpressionUUID->"6f2942ae-255f-4f5a-a0e6-85cd0d8cbf99"]
}, Open  ]],

Cell[BoxData["\<\"/Users/enriquevilchezquesada/Downloads/Contour2D7/\
Contour2D7.pdf\"\>"], "Output",
 CellChangeTimes->{
  3.967629008225564*^9, {3.9676290772471848`*^9, 3.967629103030829*^9}, {
   3.967629162007592*^9, 3.96762917931151*^9}, {3.967629232698831*^9, 
   3.967629244202837*^9}, {3.967629714458035*^9, 3.96762976613586*^9}, 
   3.9676350529212713`*^9, 3.967635332845611*^9},
 CellLabel->
  "Out[1993]=",ExpressionUUID->"ff56d3b2-80d8-4c26-b8df-36b16e32426c"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Ejemplo 8: regi\[OAcute]n el\[IAcute]ptica rotada 60\[Degree] (con \
xy)", "Subsection",
 CellChangeTimes->{{3.9675372440640697`*^9, 3.9675372735117645`*^9}, {
  3.967537657491804*^9, 3.9675376607440357`*^9}, {3.967629332862384*^9, 
  3.96762934028808*^9}},ExpressionUUID->"cabfbef6-898f-da4e-ae3f-\
8721490ebb7b"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"RegionPlot", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"0.145833", " ", 
       RowBox[{"x", "^", "2"}]}], "+", 
      RowBox[{"0.120281", " ", "x", " ", "y"}], "-", 
      RowBox[{"0.875000", " ", "x"}], "+", 
      RowBox[{"0.215278", " ", 
       RowBox[{"y", "^", "2"}]}], "-", 
      RowBox[{"0.360844", " ", "y"}], "+", "0.312500"}], ">=", "0"}], ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", 
      RowBox[{"-", "1"}], ",", "7"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"y", ",", 
      RowBox[{"-", "5"}], ",", "5"}], "}"}]}], "]"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"line", "[", "]"}], ":=", 
  RowBox[{"RandomChoice", "[", 
   RowBox[{"{", 
    RowBox[{"\"\<solid\>\"", ",", "\"\<dashed\>\"", ",", "\"\<dotted\>\"", 
     ",", "\"\<thick\>\"", ",", "\"\<thin\>\""}], "}"}], "]"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"color", "[", "]"}], ":=", 
  RowBox[{"RandomChoice", "[", 
   RowBox[{"{", 
    RowBox[{"\"\<blue\>\"", ",", "\"\<red\>\"", ",", "\"\<green\>\"", 
     ",", "\"\<purple\>\"", ",", "\"\<yellow\>\"", ",", "\"\<orange\>\"", 
     ",", "\"\<cyan\>\"", ",", "\"\<magenta\>\"", ",", "\"\<black\>\""}], 
    "}"}], "]"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"sizetexto", "[", "]"}], ":=", 
  RowBox[{"RandomChoice", "[", 
   RowBox[{"{", 
    RowBox[{"\"\<\\\\tiny\>\"", ",", "\"\<\\\\scriptsize\>\"", 
     ",", "\"\<\\\\footnotesize\>\"", ",", "\"\<\\\\small\>\"", 
     ",", "\"\<\\\\normalsize\>\"", ",", "\"\<\\\\large\>\"", 
     ",", "\"\<\\\\Large\>\"", ",", "\"\<\\\\huge\>\"", 
     ",", "\"\<\\\\Huge\>\""}], "}"}], "]"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"anclajetexto", "[", "]"}], ":=", 
  RowBox[{"RandomChoice", "[", 
   RowBox[{"{", 
    RowBox[{"\"\<north\>\"", ",", "\"\<south\>\"", ",", "\"\<east\>\"", 
     ",", "\"\<west\>\"", ",", "\"\<north east\>\"", ",", "\"\<north west\>\"",
      ",", "\"\<south east\>\"", ",", "\"\<south west\>\"", 
     ",", "\"\<center\>\""}], "}"}], "]"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"rotatexto", "[", "]"}], ":=", 
  RowBox[{"RandomReal", "[", 
   RowBox[{"{", 
    RowBox[{"0", ",", "360"}], "}"}], "]"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"estilotext", "[", "n_", "]"}], ":=", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"\"\<color\>\"", ",", 
        RowBox[{"color", "[", "]"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"\"\<size\>\"", ",", 
        RowBox[{"sizetexto", "[", "]"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"\"\<anchor\>\"", ",", 
        RowBox[{"anclajetexto", "[", "]"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"\"\<rotate\>\"", ",", 
        RowBox[{"rotatexto", "[", "]"}]}], "}"}]}], "}"}], ",", "n"}], 
   "]"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"vectorestilos", "=", 
   RowBox[{"estilotext", "[", "1", "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Row", "[", 
    RowBox[{"{", 
     RowBox[{"\"\<grid=\>\"", ",", 
      RowBox[{"grid", "=", "False"}]}], "}"}], "]"}], ",", 
   RowBox[{"Row", "[", 
    RowBox[{"{", 
     RowBox[{"\"\<estilos=\>\"", ",", 
      RowBox[{"estilos", "=", 
       RowBox[{"Table", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"line", "[", "]"}], ",", 
           RowBox[{"color", "[", "]"}]}], "}"}], ",", "1"}], "]"}]}]}], "}"}],
     "]"}], ",", 
   RowBox[{"Row", "[", 
    RowBox[{"{", 
     RowBox[{"\"\<ejes=\>\"", ",", 
      RowBox[{"ejes", "=", "True"}]}], "}"}], "]"}], ",", 
   RowBox[{"Row", "[", 
    RowBox[{"{", 
     RowBox[{"\"\<texto=\>\"", ",", 
      RowBox[{"texto", "=", 
       RowBox[{"{", 
        RowBox[{"{", 
         RowBox[{"\"\<Regi\[OAcute]n el\[IAcute]ptica\>\"", ",", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"-", "1"}], ",", 
            RowBox[{"-", "1"}]}], "}"}], ",", 
          RowBox[{"vectorestilos", "[", 
           RowBox[{"[", "1", "]"}], "]"}]}], "}"}], "}"}]}]}], "}"}], "]"}], ",", 
   RowBox[{"Row", "[", 
    RowBox[{"{", 
     RowBox[{"\"\<muestras=\>\"", ",", 
      RowBox[{"muestras", "=", "60"}]}], "}"}], "]"}], ",", 
   RowBox[{"Row", "[", 
    RowBox[{"{", 
     RowBox[{"\"\<tolerancia=\>\"", ",", 
      RowBox[{"tolerancia", "=", "0.01"}]}], "}"}], "]"}], ",", 
   RowBox[{"Row", "[", 
    RowBox[{"{", 
     RowBox[{"\"\<opacidad=\>\"", ",", 
      RowBox[{"opacidad", "=", "0.8"}]}], "}"}], "]"}], ",", 
   RowBox[{"Row", "[", 
    RowBox[{"{", 
     RowBox[{"\"\<densidad=\>\"", ",", 
      RowBox[{"densidad", "=", "1.5"}]}], "}"}], "]"}], ",", 
   RowBox[{"Row", "[", 
    RowBox[{"{", 
     RowBox[{"\"\<xmin=\>\"", ",", 
      RowBox[{"xmin", "=", 
       RowBox[{"-", "1"}]}]}], "}"}], "]"}], ",", 
   RowBox[{"Row", "[", 
    RowBox[{"{", 
     RowBox[{"\"\<xmax=\>\"", ",", 
      RowBox[{"xmax", "=", "7"}]}], "}"}], "]"}], ",", 
   RowBox[{"Row", "[", 
    RowBox[{"{", 
     RowBox[{"\"\<ymin=\>\"", ",", 
      RowBox[{"ymin", "=", 
       RowBox[{"-", "5"}]}]}], "}"}], "]"}], ",", 
   RowBox[{"Row", "[", 
    RowBox[{"{", 
     RowBox[{"\"\<ymax=\>\"", ",", 
      RowBox[{"ymax", "=", "5"}]}], "}"}], "]"}]}], "}"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ExportContour2DToTikZ", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"0.145833", " ", 
       RowBox[{"x", "^", "2"}]}], "+", 
      RowBox[{"0.120281", " ", "x", " ", "y"}], "-", 
      RowBox[{"0.875000", " ", "x"}], "+", 
      RowBox[{"0.215278", " ", 
       RowBox[{"y", "^", "2"}]}], "-", 
      RowBox[{"0.360844", " ", "y"}], "+", "0.312500"}], ">=", "0"}], 
    ",", "\"\<Contour2D8.tex\>\"", ",", "grid", ",", "estilos", ",", "ejes", ",",
     "texto", ",", "muestras", ",", "tolerancia", ",", "opacidad", ",", 
    "densidad", ",", "xmin", ",", "xmax", ",", "ymin", ",", "ymax"}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"CompiladorTex", "[", 
  RowBox[{"%", ",", 
   RowBox[{"\"\<PreferredEditor\>\"", " ", "->", "\"\<TeXstudio\>\""}]}], 
  "]"}]}], "Input",
 CellChangeTimes->{{3.9675376557114677`*^9, 3.9675376639000072`*^9}, {
   3.967538264562275*^9, 3.9675382649183407`*^9}, {3.967545217105652*^9, 
   3.967545219194132*^9}, {3.967573800059595*^9, 3.967573800468648*^9}, {
   3.967573990395282*^9, 3.967573990740746*^9}, {3.967629279098003*^9, 
   3.967629389931383*^9}, {3.9676294364779987`*^9, 3.9676294644407997`*^9}, 
   3.9676341869285316`*^9, {3.967635023975669*^9, 3.967635041087451*^9}},
 CellLabel->
  "In[1994]:=",ExpressionUUID->"00904959-10c4-694e-b077-f9262317b8c9"],

Cell[BoxData[
 GraphicsBox[{GraphicsComplexBox[CompressedData["
1:eJxlmXt8jEfbgDcJkmBDIgni0JSW/ZRKq2lTWjOsY+lreWlRTdGqfraKKp9o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    "], {{
      {RGBColor[0.24, 0.6, 0.8], AbsoluteThickness[2.], Opacity[0.3], 
       EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxNmgfUlsWxx599VDCK3YiKIoqoCFJiAwtCEMQOiNhQEAsSFRUVY0GKBQsY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          "]], PolygonBox[CompressedData["
1:eJwtlfmPTmcYhr/3oSJoEUtsVUsEiX0vVTqmKBKMvWMdu8EYW1PLmNhGo0Xt
rX1fa5tgZDK2BtHqj/4MklpKqqHXnXt+uHKu95zzfec97/s892mZV5CzODKZ
zFKoCkMZtIYRKZOZD6vw76GQazsYV8PfcpwCc+E1zOTcdxy3ck8ePgNWJp/7
CH/JMRfmQEfG5VCKD4Bi/CScxb+F56AJ/cCxgP/L1eRgJuNCGIhvh2P4H1wa
i/eAqfodvIB1jHdzXMb1LHwvHGd8Geria2Fn8j1T8YWwCf8S2uJzYE3yM06E
30Fz1xyP40dhEn4GWuH99M74EeiF34e7+HBohy+Ajclz+ARfBCXJ7/gx3gEm
4FvgEH4wPBed24f/CifwMdAVfwQP8EFwAK8Cs/GTcEm/hTx8KXyB94eReAXr
0Rx/CL8zPs/4X473GFdofoyH48OgGB/PuVv4IJiFX4Gv8ezws7PhFzxgbPIc
++Cn4Tx+EVriW+AQfhgm4i3Ca6Ma+wp/DE/xHNiPtw+/q575SvNmfCN5Ts3w
HK2h3h0a4I3Cc8lPXotnyXPXmlxg/DlMx5fAN3iN8FpojZrg62Gfng1v4I5q
lOMu7mmq2tAe6HmMP8PHhWttKHTDb0OZ1kbvhB/RGuALoDE+ONwrQzQnraV6
Sr0Fn+JDYJ7mBivVS7AtuecO49PCvXJKNYifC6/lNa53Dq9BfmWP9Qw/Q/+t
nijFa8IT7i1i3Ck8R81NNXwdrwV/cb2Y8ajwO+ldFkJ1/B3H5clz1F5PDteW
9rwE3xxeG73TaHwKLEveI/nI8H/p3Af1eXgvRidnRT3Yk5wZG/EN4VrUnqhX
1CPqDfVMoZ4NW7Wf3LMCXx52rdmScIYoO37kWD+cMcqWLJ3Ha4ev6T+UBXVg
V3ImdA/XhGpBGae9V82p1lQDRfjfyXmp36xWVoSzUee0VuMZF1Su2fvkDFN2
KSPUC8oMZYV6Ygf+c3hv/uT3OzWX8F5oz/LDPa7eVkZt09zDvXIUdmvtVMPJ
e6is/Cl8TZmpWqwarh3V5IRwj6o3NUf1am+4kNyzZ/BJ4drSub66N/wtUA+p
1v9Jzvqyyl5Rjau2yyt7tWF4rdWzZeEMVvZegvn4zbBrzm20l+FaUEZdw6+G
1+K35Cy+HHZlsrJUmaQsUqbqW6LMV9brm6IsU0+pl5Rpqq1j4axWjSmb/0vO
PmW0srRLuNeVqcpG9bh6WxmpbNI3R98aZdT/W7nbfg==
          "]]}]}, {}, {}, {}, {}}, 
     {RGBColor[0.24, 0.6, 0.8], AbsoluteThickness[2.], LineBox[CompressedData["
1:eJwt0DtOAgEUBdAZfoKCIg4LsJvBv/hBhSWYiEsw2kqrvbTYYaeddNhqD3uQ
PcgePBMoTu6rbm7e9l3v9jEMguCaDOldJ6FDlwee6fPKGx+M+OKHKTPmaYeS
OgkNdthlj30OOOSIY5qccMoZ57S44JIr2sRE4WLkn/hlwjdjPnlnyIAXnrjn
hjYxEVvU2KTKButUKLPGKiWKrFAgT47s8l//Wp4YKg==
       "]], LineBox[CompressedData["
1:eJwl01VTVQEYhtHNsbtbVCxExe4O7MZGRUXFBru7BRNbMVDsFrs7/oT/wG7F
WDNerHlm3v3tPXMuTkRCcmxSWBAEr4kPBcE0pnKAHLzx8LbWphc9+Wy7p6VZ
yRhKsoJMjpGLT+7uan1KUZYydCGGhrygAX355v6BlqMruflue6iNKc8q1rCa
4wzkp5tHGk438vLLNkSH0oITNOckwznFaTYSwQaq0pqn/PH+CA3YzBY2UZOO
vKIDW4kkkYtc4gqX2cZ2JpJFAa6Sxg4mcY2CXGcnu5jMDW7Sid3UYgq36Mwz
wthLFHvYzz5CjOQC7ThPe3qQnza0pTop1CCVv35znJ6lJWdoxTm6U40n/HY3
TKvQjMdk2/JpJZ5TmcEMogkvacoExrOedfzwXh6twFoqEssARtGP/jTiPl/d
99EvOk4TGEsJMjjKEerRm8Pk5BCjKU40d/joG8u1GEspyjI+2BfrEhawiIW8
t8/T+cxmLnN4Z5+ps0imCDN4a0/SwkynEHWpw0HSQ///c/8AFFVmKA==
       "]]}}], {}},
  AspectRatio->1,
  Axes->{False, False},
  AxesLabel->{None, None},
  AxesOrigin->{0, 0},
  DefaultBaseStyle->{"PlotGraphics", "Graphics"},
  DisplayFunction->Identity,
  Frame->{{True, True}, {True, True}},
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImagePadding->All,
  Method->{
   "DefaultGraphicsInteraction" -> {
     "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
      "Effects" -> {
       "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
        "Droplines" -> {
         "freeformCursorMode" -> True, 
          "placement" -> {"x" -> "All", "y" -> "None"}}}}, "ScalingFunctions" -> 
    None, "TransparentPolygonMesh" -> True, "AxesInFront" -> True},
  PlotInteractivity:>True,
  PlotRange->{{-1, 7}, {-5, 5}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.02], 
     Scaled[0.02]}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{{3.967629390862062*^9, 3.967629465196456*^9}, 
   3.967629803361252*^9, {3.967635028250807*^9, 3.9676350414988194`*^9}, 
   3.96763534423792*^9},
 CellLabel->
  "Out[1994]=",ExpressionUUID->"12043add-9850-4ad6-98e4-4be19f7cc46e"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TemplateBox[{"\"grid=\"", "False"},
    "RowDefault"], ",", 
   TemplateBox[{"\"estilos=\"", 
     RowBox[{"{", 
       RowBox[{"{", 
         RowBox[{"\"solid\"", ",", "\"red\""}], "}"}], "}"}]},
    "RowDefault"], ",", 
   TemplateBox[{"\"ejes=\"", "True"},
    "RowDefault"], ",", 
   TemplateBox[{"\"texto=\"", 
     RowBox[{"{", 
       RowBox[{"{", 
         RowBox[{"\"Regi\[OAcute]n el\[IAcute]ptica\"", ",", 
           RowBox[{"{", 
             RowBox[{
               RowBox[{"-", "1"}], ",", 
               RowBox[{"-", "1"}]}], "}"}], ",", 
           RowBox[{"{", 
             RowBox[{
               RowBox[{"{", 
                 RowBox[{"\"color\"", ",", "\"purple\""}], "}"}], ",", 
               RowBox[{"{", 
                 RowBox[{"\"size\"", ",", "\"\\\\normalsize\""}], "}"}], ",", 
               
               RowBox[{"{", 
                 RowBox[{"\"anchor\"", ",", "\"east\""}], "}"}], ",", 
               RowBox[{"{", 
                 RowBox[{"\"rotate\"", ",", "278.10247723607296`"}], "}"}]}], 
             "}"}]}], "}"}], "}"}]},
    "RowDefault"], ",", 
   TemplateBox[{"\"muestras=\"", "60"},
    "RowDefault"], ",", 
   TemplateBox[{"\"tolerancia=\"", "0.01`"},
    "RowDefault"], ",", 
   TemplateBox[{"\"opacidad=\"", "0.8`"},
    "RowDefault"], ",", 
   TemplateBox[{"\"densidad=\"", "1.5`"},
    "RowDefault"], ",", 
   TemplateBox[{"\"xmin=\"", 
     RowBox[{"-", "1"}]},
    "RowDefault"], ",", 
   TemplateBox[{"\"xmax=\"", "7"},
    "RowDefault"], ",", 
   TemplateBox[{"\"ymin=\"", 
     RowBox[{"-", "5"}]},
    "RowDefault"], ",", 
   TemplateBox[{"\"ymax=\"", "5"},
    "RowDefault"]}], "}"}]], "Output",
 CellChangeTimes->{{3.967629390862062*^9, 3.967629465196456*^9}, 
   3.967629803361252*^9, {3.967635028250807*^9, 3.9676350414988194`*^9}, 
   3.967635344240662*^9},
 CellLabel->
  "Out[2002]=",ExpressionUUID->"f809d59d-a218-45bf-bddf-116851ef5f2c"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Usando editores ya detectados: \"\>", "\[InvisibleSpace]", "4",
    "\[InvisibleSpace]", "\<\" disponibles\"\>"}],
  SequenceForm["Usando editores ya detectados: ", 4, " disponibles"],
  Editable->False]], "Print",
 CellChangeTimes->{{3.967629391116887*^9, 3.9676294654352922`*^9}, 
   3.967629803599279*^9, {3.967635028488912*^9, 3.9676350417374897`*^9}, 
   3.967635344476863*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[1994]:=",ExpressionUUID->"81502221-a2e3-410a-be73-9e957d5a7480"],

Cell[BoxData["\<\"Buscando pdflatex...\"\>"], "Print",
 CellChangeTimes->{{3.967629391116887*^9, 3.9676294654352922`*^9}, 
   3.967629803599279*^9, {3.967635028488912*^9, 3.9676350417374897`*^9}, 
   3.967635344477654*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[1994]:=",ExpressionUUID->"6be31495-3447-43bd-b00c-41b5ce7c7504"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"pdflatex encontrado: \"\>", 
   "\[InvisibleSpace]", "\<\"/Library/TeX/texbin/pdflatex\"\>"}],
  SequenceForm["pdflatex encontrado: ", "/Library/TeX/texbin/pdflatex"],
  Editable->False]], "Print",
 CellChangeTimes->{{3.967629391116887*^9, 3.9676294654352922`*^9}, 
   3.967629803599279*^9, {3.967635028488912*^9, 3.9676350417374897`*^9}, 
   3.967635344478322*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[1994]:=",ExpressionUUID->"d056038f-0c97-40d1-897e-ac863c65bef5"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Editor '\"\>", "\[InvisibleSpace]", "\<\"TeXstudio\"\>", 
   "\[InvisibleSpace]", "\<\"' encontrado (match exacto)\"\>"}],
  SequenceForm["Editor '", "TeXstudio", "' encontrado (match exacto)"],
  Editable->False]], "Print",
 CellChangeTimes->{{3.967629391116887*^9, 3.9676294654352922`*^9}, 
   3.967629803599279*^9, {3.967635028488912*^9, 3.9676350417374897`*^9}, 
   3.967635344478731*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[1994]:=",ExpressionUUID->"8fdc2247-0a5e-44ec-9f0c-29812f9907d6"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Abriendo archivo en \"\>", 
   "\[InvisibleSpace]", "\<\"TeXstudio\"\>", 
   "\[InvisibleSpace]", "\<\"...\"\>"}],
  SequenceForm["Abriendo archivo en ", "TeXstudio", "..."],
  Editable->False]], "Print",
 CellChangeTimes->{{3.967629391116887*^9, 3.9676294654352922`*^9}, 
   3.967629803599279*^9, {3.967635028488912*^9, 3.9676350417374897`*^9}, 
   3.967635344479129*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[1994]:=",ExpressionUUID->"03901fe6-552d-4bb8-91a8-def39bf7eb62"],

Cell[BoxData["\<\"Editor abierto correctamente\"\>"], "Print",
 CellChangeTimes->{{3.967629391116887*^9, 3.9676294654352922`*^9}, 
   3.967629803599279*^9, {3.967635028488912*^9, 3.9676350417374897`*^9}, 
   3.9676353445762653`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[1994]:=",ExpressionUUID->"59067cd5-ea10-4f41-b467-8cd6b0892a05"],

Cell[BoxData["\<\"Compilando documento LaTeX...\"\>"], "Print",
 CellChangeTimes->{{3.967629391116887*^9, 3.9676294654352922`*^9}, 
   3.967629803599279*^9, {3.967635028488912*^9, 3.9676350417374897`*^9}, 
   3.967635345578134*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[1994]:=",ExpressionUUID->"10cff325-4f6a-4ba6-b15b-eb5917f360b1"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Directorio de trabajo: \"\>", 
   "\[InvisibleSpace]", \
"\<\"/Users/enriquevilchezquesada/Downloads/Contour2D8/\"\>"}],
  SequenceForm[
  "Directorio de trabajo: ", 
   "/Users/enriquevilchezquesada/Downloads/Contour2D8/"],
  Editable->False]], "Print",
 CellChangeTimes->{{3.967629391116887*^9, 3.9676294654352922`*^9}, 
   3.967629803599279*^9, {3.967635028488912*^9, 3.9676350417374897`*^9}, 
   3.967635345583253*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[1994]:=",ExpressionUUID->"3866023b-cc9f-4c6b-85d3-75907c08733c"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Archivo: \"\>", "\[InvisibleSpace]", "\<\"Contour2D8\"\>"}],
  SequenceForm["Archivo: ", "Contour2D8"],
  Editable->False]], "Print",
 CellChangeTimes->{{3.967629391116887*^9, 3.9676294654352922`*^9}, 
   3.967629803599279*^9, {3.967635028488912*^9, 3.9676350417374897`*^9}, 
   3.967635345585372*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[1994]:=",ExpressionUUID->"6ddb9cc4-1b74-4d06-8242-86896e344021"],

Cell[BoxData["\<\"Compilaci\[OAcute]n exitosa\"\>"], "Print",
 CellChangeTimes->{{3.967629391116887*^9, 3.9676294654352922`*^9}, 
   3.967629803599279*^9, {3.967635028488912*^9, 3.9676350417374897`*^9}, 
   3.967635349063334*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[1994]:=",ExpressionUUID->"1b603fc2-90b0-4e4a-ba19-780afe597684"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"PDF generado: \"\>", 
   "\[InvisibleSpace]", \
"\<\"/Users/enriquevilchezquesada/Downloads/Contour2D8/Contour2D8.pdf\"\>"}],
  SequenceForm[
  "PDF generado: ", 
   "/Users/enriquevilchezquesada/Downloads/Contour2D8/Contour2D8.pdf"],
  Editable->False]], "Print",
 CellChangeTimes->{{3.967629391116887*^9, 3.9676294654352922`*^9}, 
   3.967629803599279*^9, {3.967635028488912*^9, 3.9676350417374897`*^9}, 
   3.967635349064106*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[1994]:=",ExpressionUUID->"7e93178b-ecae-4607-b84a-f55827a3d84a"]
}, Open  ]],

Cell[BoxData["\<\"/Users/enriquevilchezquesada/Downloads/Contour2D8/\
Contour2D8.pdf\"\>"], "Output",
 CellChangeTimes->{{3.967629390862062*^9, 3.967629465196456*^9}, 
   3.967629803361252*^9, {3.967635028250807*^9, 3.9676350414988194`*^9}, 
   3.967635349077784*^9},
 CellLabel->
  "Out[2004]=",ExpressionUUID->"3eff10cf-d18e-4923-a0cd-26c74aff2519"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
Ejemplo 9: regi\[OAcute]n hiperb\[OAcute]lica rotada 22.5\[Degree] (con xy), \
no se visualiza perfecta\
\>", "Subsection",
 CellChangeTimes->{{3.9675372440640697`*^9, 3.967537275790016*^9}, {
  3.967537667897585*^9, 3.967537685495941*^9}, {3.967629496539385*^9, 
  3.967629504997499*^9}, {3.967629822362825*^9, 
  3.967629825154022*^9}},ExpressionUUID->"a285f98d-bd3d-1443-b779-\
3f7d9697bdaa"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"RegionPlot", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"0.780330", " ", 
       RowBox[{"x", "^", "2"}]}], "+", 
      RowBox[{"1.060660", " ", "x", " ", "y"}], "-", 
      RowBox[{"0.560660", " ", "x"}], "-", 
      RowBox[{"0.280330", " ", 
       RowBox[{"y", "^", "2"}]}], "+", 
      RowBox[{"2.181980", " ", "y"}], "-", "3.462310"}], "<=", "0"}], ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", 
      RowBox[{"-", "7"}], ",", "7"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"y", ",", 
      RowBox[{"-", "7"}], ",", "7"}], "}"}], ",", 
    RowBox[{"Frame", "->", "False"}], ",", 
    RowBox[{"Axes", "->", "True"}]}], "]"}], "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"line", "[", "]"}], ":=", 
  RowBox[{"RandomChoice", "[", 
   RowBox[{"{", 
    RowBox[{"\"\<solid\>\"", ",", "\"\<dashed\>\"", ",", "\"\<dotted\>\"", 
     ",", "\"\<thick\>\"", ",", "\"\<thin\>\""}], "}"}], "]"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"color", "[", "]"}], ":=", 
  RowBox[{"RandomChoice", "[", 
   RowBox[{"{", 
    RowBox[{"\"\<blue\>\"", ",", "\"\<red\>\"", ",", "\"\<green\>\"", 
     ",", "\"\<purple\>\"", ",", "\"\<yellow\>\"", ",", "\"\<orange\>\"", 
     ",", "\"\<cyan\>\"", ",", "\"\<magenta\>\"", ",", "\"\<black\>\""}], 
    "}"}], "]"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"sizetexto", "[", "]"}], ":=", 
  RowBox[{"RandomChoice", "[", 
   RowBox[{"{", 
    RowBox[{"\"\<\\\\tiny\>\"", ",", "\"\<\\\\scriptsize\>\"", 
     ",", "\"\<\\\\footnotesize\>\"", ",", "\"\<\\\\small\>\"", 
     ",", "\"\<\\\\normalsize\>\"", ",", "\"\<\\\\large\>\"", 
     ",", "\"\<\\\\Large\>\"", ",", "\"\<\\\\huge\>\"", 
     ",", "\"\<\\\\Huge\>\""}], "}"}], "]"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"anclajetexto", "[", "]"}], ":=", 
  RowBox[{"RandomChoice", "[", 
   RowBox[{"{", 
    RowBox[{"\"\<north\>\"", ",", "\"\<south\>\"", ",", "\"\<east\>\"", 
     ",", "\"\<west\>\"", ",", "\"\<north east\>\"", ",", "\"\<north west\>\"",
      ",", "\"\<south east\>\"", ",", "\"\<south west\>\"", 
     ",", "\"\<center\>\""}], "}"}], "]"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"rotatexto", "[", "]"}], ":=", 
  RowBox[{"RandomReal", "[", 
   RowBox[{"{", 
    RowBox[{"0", ",", "360"}], "}"}], "]"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"estilotext", "[", "n_", "]"}], ":=", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"\"\<color\>\"", ",", 
        RowBox[{"color", "[", "]"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"\"\<size\>\"", ",", 
        RowBox[{"sizetexto", "[", "]"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"\"\<anchor\>\"", ",", 
        RowBox[{"anclajetexto", "[", "]"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"\"\<rotate\>\"", ",", 
        RowBox[{"rotatexto", "[", "]"}]}], "}"}]}], "}"}], ",", "n"}], 
   "]"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"vectorestilos", "=", 
   RowBox[{"estilotext", "[", "1", "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Row", "[", 
    RowBox[{"{", 
     RowBox[{"\"\<grid=\>\"", ",", 
      RowBox[{"grid", "=", 
       RowBox[{"RandomChoice", "[", 
        RowBox[{"{", 
         RowBox[{"True", ",", "False"}], "}"}], "]"}]}]}], "}"}], "]"}], ",", 
   
   RowBox[{"Row", "[", 
    RowBox[{"{", 
     RowBox[{"\"\<estilos=\>\"", ",", 
      RowBox[{"estilos", "=", 
       RowBox[{"Table", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"line", "[", "]"}], ",", 
           RowBox[{"color", "[", "]"}]}], "}"}], ",", "2"}], "]"}]}]}], "}"}],
     "]"}], ",", 
   RowBox[{"Row", "[", 
    RowBox[{"{", 
     RowBox[{"\"\<ejes=\>\"", ",", 
      RowBox[{"ejes", "=", "True"}]}], "}"}], "]"}], ",", 
   RowBox[{"Row", "[", 
    RowBox[{"{", 
     RowBox[{"\"\<texto=\>\"", ",", 
      RowBox[{"texto", "=", 
       RowBox[{"{", 
        RowBox[{"{", 
         RowBox[{"\"\<Regi\[OAcute]n hiperb\[OAcute]lica\>\"", ",", 
          RowBox[{"{", 
           RowBox[{"1", ",", "2"}], "}"}], ",", 
          RowBox[{"vectorestilos", "[", 
           RowBox[{"[", "1", "]"}], "]"}]}], "}"}], "}"}]}]}], "}"}], "]"}], ",", 
   RowBox[{"Row", "[", 
    RowBox[{"{", 
     RowBox[{"\"\<muestras=\>\"", ",", 
      RowBox[{"muestras", "=", "50"}]}], "}"}], "]"}], ",", 
   RowBox[{"Row", "[", 
    RowBox[{"{", 
     RowBox[{"\"\<tolerancia=\>\"", ",", 
      RowBox[{"tolerancia", "=", "0.01"}]}], "}"}], "]"}], ",", 
   RowBox[{"Row", "[", 
    RowBox[{"{", 
     RowBox[{"\"\<opacidad=\>\"", ",", 
      RowBox[{"opacidad", "=", "0.8"}]}], "}"}], "]"}], ",", 
   RowBox[{"Row", "[", 
    RowBox[{"{", 
     RowBox[{"\"\<densidad=\>\"", ",", 
      RowBox[{"densidad", "=", "2.5"}]}], "}"}], "]"}], ",", 
   RowBox[{"Row", "[", 
    RowBox[{"{", 
     RowBox[{"\"\<xmin=\>\"", ",", 
      RowBox[{"xmin", "=", 
       RowBox[{"-", "7"}]}]}], "}"}], "]"}], ",", 
   RowBox[{"Row", "[", 
    RowBox[{"{", 
     RowBox[{"\"\<xmax=\>\"", ",", 
      RowBox[{"xmax", "=", "7"}]}], "}"}], "]"}], ",", 
   RowBox[{"Row", "[", 
    RowBox[{"{", 
     RowBox[{"\"\<ymin=\>\"", ",", 
      RowBox[{"ymin", "=", 
       RowBox[{"-", "7"}]}]}], "}"}], "]"}], ",", 
   RowBox[{"Row", "[", 
    RowBox[{"{", 
     RowBox[{"\"\<ymax=\>\"", ",", 
      RowBox[{"ymax", "=", "7"}]}], "}"}], "]"}]}], "}"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ExportContour2DToTikZ", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"0.780330", " ", 
         RowBox[{"x", "^", "2"}]}], "+", 
        RowBox[{"1.060660", " ", "x", " ", "y"}], "-", 
        RowBox[{"0.560660", " ", "x"}], "-", 
        RowBox[{"0.280330", " ", 
         RowBox[{"y", "^", "2"}]}], "+", 
        RowBox[{"2.181980", " ", "y"}], "-", "3.462310"}], "<=", "0"}], ",", 
      RowBox[{
       RowBox[{
        RowBox[{"0.780330", " ", 
         RowBox[{"x", "^", "2"}]}], "+", 
        RowBox[{"1.060660", " ", "x", " ", "y"}], "-", 
        RowBox[{"0.560660", " ", "x"}], "-", 
        RowBox[{"0.280330", " ", 
         RowBox[{"y", "^", "2"}]}], "+", 
        RowBox[{"2.181980", " ", "y"}], "-", "3.462310"}], "==", "0"}]}], 
     "}"}], ",", "\"\<Contour2D9.tex\>\"", ",", "grid", ",", "estilos", ",", 
    "ejes", ",", "texto", ",", "muestras", ",", "tolerancia", ",", "opacidad",
     ",", "densidad", ",", "xmin", ",", "xmax", ",", "ymin", ",", "ymax"}], 
   "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"CompiladorTex", "[", 
  RowBox[{"%", ",", 
   RowBox[{"\"\<PreferredEditor\>\"", " ", "->", "\"\<TeXstudio\>\""}]}], 
  "]"}], "\[IndentingNewLine]"}], "Input",
 CellChangeTimes->{{3.967537673384226*^9, 3.967537682995632*^9}, {
   3.967538260589676*^9, 3.9675382608813*^9}, {3.9675452230847874`*^9, 
   3.9675452246557064`*^9}, {3.9675738045474586`*^9, 3.967573804955262*^9}, {
   3.967573997538301*^9, 3.967573997754735*^9}, {3.9676295136086082`*^9, 
   3.967629524613944*^9}, {3.967629833468062*^9, 3.9676300205291243`*^9}, 
   3.967634179543591*^9, {3.967634981437573*^9, 3.967635006078204*^9}},
 CellLabel->
  "In[2005]:=",ExpressionUUID->"c979eafa-7060-814a-ad84-7c4df9f0ce94"],

Cell[BoxData[
 GraphicsBox[{GraphicsComplexBox[CompressedData["
1:eJx1mXlcU8cWxxOWAELY10CVYqspda/Utd6pQYtKaYTnTqNPxSrRqlWxsVpQ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    "], {{
      {RGBColor[0.24, 0.6, 0.8], AbsoluteThickness[2.], Opacity[0.3], 
       EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxNmAe01cURxndWEQuIqAiC9N6RIh0EHk0pCtIheYIUUUDEhygaFQUBAZFg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          "]], PolygonBox[CompressedData["
1:eJwtlX2s11Mcx885XfQodFmpq27FLffq9sAisXLpSSaltkxda22VKcvabBYy
llRYj8w8VBSlNmWR7iqx7m73qlD0iJ5UQlRED5rXe+/zx3vv9/t8v7/zPb9z
Pp/3KR71+OAJKYTwNCgAzTBXg3oxhM/wd6O/RH+L/hkkfATn0RdANc9G4rvA
a/D/wRfAGfQ/4D30V2AX+jJ4OSjl/SvhZuAn8Ci+H7yFd3bAg/Fl8E1gNxiL
r4Bred4ZvRK9GX0Q1KL7MNYevh7sA+PwfeA6nu+Cx+B7wdX4a9AL8n/bCa7A
v43/FP0dWIxuxdilcH1QJdYGaRxsBQPwJXAHsBc8gR+S1/QOvCl6rgS/Bo5p
DD8FrEB34v1C+CR+jdaS1zoTTEOXJe/NZPwH2nv9L3QTeB54AfyAPwpWo8fz
/kD4Rfwq+DH8APh5/Emx9hD9O9iOXgr+CJ5jEO/+jT+B7ghfh28DGqA3MLYF
XhL9293Bc43ieY8854fw92A/+ir4fp5tg/cEz3kafUpnEjz2OXpjPus3wBz0
lOi5j6gO0ZXMcTM8BP8M/Ai+u+oCPxUejb8DfhLfC71O54Iugp8F9ZJrsxLc
gO4ALtd38evh3vjWcBvtQ3QNq3Z/A2eiv6G5tUc/on8Bx9GHwPHoM9NZaawu
+j9o7arx+ToHcAB9DHyEfl1zoGtUY9Hv6Jn27Ch6aHKtf4H/Jp+xzlZnfgR9
X3KtrVMPwv2Ta70Kfw/6RPTa28KHwCTGhsGLGDurWole+ykwO6owGYdKdWbq
RVAUPLYzukZVm/oP59HnwGn0X+DV6Dk1l/b8JfS/4M/gGn+YuQ7gDwf/Zj/6
ruS9Ltc6o2tAZ/9r8N7MiO5l7dFz6KLk3huJb4xuosyJzqCn4IvR2aI1v4Vu
yvMdwT3cEN0oOau+Ds4i9aR6UZnUXnsHGuMn4hfCzZOzYG1wtr3LWEF0xikL
lGHKLmXCA/hi0BB9I2ib3DPqFY21S+5Z9aq+0SK5plXLBbn2NsDF0TXYA38b
mMXz5vhh6I6gqXJC30iuYdWuxspVK8m1pAxRlqoH1XvK1FvUO2CGsg7fFd0t
WU9lrKd6B1wb/c3b0WvRLaPHlHXqKfWSMq87+tbktWnON/U7sD34TCqSa061
Vpyz4f1cq8qIwuQaVW3qTumH7pt8tsrsgeh7k8+iJNeS9qBTrqkHla3JWag7
oXVyZimrlFEt9V+Se/0imMvYJclamVOSfGY6K2XAcPRDyVk+OzhLluXeU6bc
mVyz5XlPlKUfR98dylTddZOje0d33kEwIrmWVfPKqs25N5VZyrKa6NpSpuku
mh59F+hO0l31cnR2687SXfhKXpvuRGX7J9F3nzJed82efJa6c3Q3zozO+orc
+4eja18Z8D8TivuA
          "]]}]}, {}, {}, {}, {}}, 
     {RGBColor[0.24, 0.6, 0.8], AbsoluteThickness[2.], LineBox[CompressedData["
1:eJwl1Gd0jwcUwOEQJIjRqr2VGkVtsUdF1ShitLRo7R1VX+y9a6uWmo1NBrFp
7VF7xN5ao9Te25Pjw5Pfvfc97//Le05yt44I754oICAgpz+JNWGOp7chjcMs
Ta2zNa3u0O66U+fwite8oQ8fePYhbxN+SCdrX27Tj5Zuu/Qudwizf0R60jHX
LYPu1kw6TzPqH7qHVub+mlkjNZEmJpCB9iyalSQkZarbEB7wkMN85X5I6+tj
baA5yUUO8pCbhuSnAJ9QiII05Zn3RtPeHK03+JUxdHA7pTHE0dW+UqfzMx3t
p3UVa+hmX60zGEcn+zldy3rWcZP/uMBPnp/X50ygi/1PrarBbDRX0eY043f7
eDqbL+omtrKF/7lFC8+u6Ld6Wb/TF/qSRz7lESKJIpoYYlnBSuJYxWrWcIxJ
3p1JKr8VwnZzDZ2oKTUFydlm/5de5n/0c92s1fQvra6XtLJu0ApaiYp8QznK
U4ZQyvI1pShNcUpSgjPe76lnNUiTscJcTMfqb8RSxP4ZRYmyn6SdeaRO4zg/
2k/oMj41L9fCOkqf0sjcmHDi7U30ui6lrXmEPmEJx2jjNkx/4Qg97Ed1MR+b
85GX4QnfhDrmutTmoL2eXtNFtDYP1fss5AA/uA3SKewjwr5f55PNvECz62C9
xxfmWtRkr/1Lvap/8715gIb7zmGEUohspCYVIaQkBckJJohkJCUJge//TQS8
A/tgjWk=
       "]]}}], {}},
  AspectRatio->1,
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{0, 0},
  DefaultBaseStyle->{"PlotGraphics", "Graphics"},
  DisplayFunction->Identity,
  Frame->{{False, False}, {False, False}},
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImagePadding->All,
  Method->{
   "DefaultGraphicsInteraction" -> {
     "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
      "Effects" -> {
       "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
        "Droplines" -> {
         "freeformCursorMode" -> True, 
          "placement" -> {"x" -> "All", "y" -> "None"}}}}, "ScalingFunctions" -> 
    None, "TransparentPolygonMesh" -> True, "AxesInFront" -> True},
  PlotInteractivity:>True,
  PlotRange->{{-7, 7}, {-7, 7}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.02], 
     Scaled[0.02]}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{
  3.967629929612171*^9, 3.967629976058716*^9, {3.9676300210275383`*^9, 
   3.967630036615323*^9}, 3.9676301356788816`*^9, {3.9676349830504007`*^9, 
   3.967635010408739*^9}, 3.967635358487062*^9},
 CellLabel->
  "Out[2005]=",ExpressionUUID->"453a00fd-6b36-46d5-b331-b336f429055e"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TemplateBox[{"\"grid=\"", "True"},
    "RowDefault"], ",", 
   TemplateBox[{"\"estilos=\"", 
     RowBox[{"{", 
       RowBox[{
         RowBox[{"{", 
           RowBox[{"\"dotted\"", ",", "\"yellow\""}], "}"}], ",", 
         RowBox[{"{", 
           RowBox[{"\"solid\"", ",", "\"green\""}], "}"}]}], "}"}]},
    "RowDefault"], ",", 
   TemplateBox[{"\"ejes=\"", "True"},
    "RowDefault"], ",", 
   TemplateBox[{"\"texto=\"", 
     RowBox[{"{", 
       RowBox[{"{", 
         RowBox[{"\"Regi\[OAcute]n hiperb\[OAcute]lica\"", ",", 
           RowBox[{"{", 
             RowBox[{"1", ",", "2"}], "}"}], ",", 
           RowBox[{"{", 
             RowBox[{
               RowBox[{"{", 
                 RowBox[{"\"color\"", ",", "\"blue\""}], "}"}], ",", 
               RowBox[{"{", 
                 RowBox[{"\"size\"", ",", "\"\\\\normalsize\""}], "}"}], ",", 
               
               RowBox[{"{", 
                 RowBox[{"\"anchor\"", ",", "\"south\""}], "}"}], ",", 
               RowBox[{"{", 
                 RowBox[{"\"rotate\"", ",", "349.7641960353607`"}], "}"}]}], 
             "}"}]}], "}"}], "}"}]},
    "RowDefault"], ",", 
   TemplateBox[{"\"muestras=\"", "50"},
    "RowDefault"], ",", 
   TemplateBox[{"\"tolerancia=\"", "0.01`"},
    "RowDefault"], ",", 
   TemplateBox[{"\"opacidad=\"", "0.8`"},
    "RowDefault"], ",", 
   TemplateBox[{"\"densidad=\"", "2.5`"},
    "RowDefault"], ",", 
   TemplateBox[{"\"xmin=\"", 
     RowBox[{"-", "7"}]},
    "RowDefault"], ",", 
   TemplateBox[{"\"xmax=\"", "7"},
    "RowDefault"], ",", 
   TemplateBox[{"\"ymin=\"", 
     RowBox[{"-", "7"}]},
    "RowDefault"], ",", 
   TemplateBox[{"\"ymax=\"", "7"},
    "RowDefault"]}], "}"}]], "Output",
 CellChangeTimes->{
  3.967629929612171*^9, 3.967629976058716*^9, {3.9676300210275383`*^9, 
   3.967630036615323*^9}, 3.9676301356788816`*^9, {3.9676349830504007`*^9, 
   3.967635010408739*^9}, 3.967635358489768*^9},
 CellLabel->
  "Out[2013]=",ExpressionUUID->"729dfb96-a40c-422f-ba77-544681259bcb"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Usando editores ya detectados: \"\>", "\[InvisibleSpace]", "4",
    "\[InvisibleSpace]", "\<\" disponibles\"\>"}],
  SequenceForm["Usando editores ya detectados: ", 4, " disponibles"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.967629930062911*^9, 3.967629976479241*^9, {3.967630021447341*^9, 
   3.9676300370361433`*^9}, 3.967630136098234*^9, {3.9676349834725723`*^9, 
   3.9676350108280687`*^9}, 3.967635358909116*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[2005]:=",ExpressionUUID->"4fdfd91f-3032-41cd-a858-a98b524f1027"],

Cell[BoxData["\<\"Buscando pdflatex...\"\>"], "Print",
 CellChangeTimes->{
  3.967629930062911*^9, 3.967629976479241*^9, {3.967630021447341*^9, 
   3.9676300370361433`*^9}, 3.967630136098234*^9, {3.9676349834725723`*^9, 
   3.9676350108280687`*^9}, 3.967635358909881*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[2005]:=",ExpressionUUID->"455466e4-9c67-4e67-bd61-e7d10d4829b0"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"pdflatex encontrado: \"\>", 
   "\[InvisibleSpace]", "\<\"/Library/TeX/texbin/pdflatex\"\>"}],
  SequenceForm["pdflatex encontrado: ", "/Library/TeX/texbin/pdflatex"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.967629930062911*^9, 3.967629976479241*^9, {3.967630021447341*^9, 
   3.9676300370361433`*^9}, 3.967630136098234*^9, {3.9676349834725723`*^9, 
   3.9676350108280687`*^9}, 3.967635358910528*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[2005]:=",ExpressionUUID->"255f3bda-ada3-4b93-8333-b576b5a9ab87"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Editor '\"\>", "\[InvisibleSpace]", "\<\"TeXstudio\"\>", 
   "\[InvisibleSpace]", "\<\"' encontrado (match exacto)\"\>"}],
  SequenceForm["Editor '", "TeXstudio", "' encontrado (match exacto)"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.967629930062911*^9, 3.967629976479241*^9, {3.967630021447341*^9, 
   3.9676300370361433`*^9}, 3.967630136098234*^9, {3.9676349834725723`*^9, 
   3.9676350108280687`*^9}, 3.967635358910922*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[2005]:=",ExpressionUUID->"f37a355b-5ff6-4b8e-8322-3bf5e68fcf5f"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Abriendo archivo en \"\>", 
   "\[InvisibleSpace]", "\<\"TeXstudio\"\>", 
   "\[InvisibleSpace]", "\<\"...\"\>"}],
  SequenceForm["Abriendo archivo en ", "TeXstudio", "..."],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.967629930062911*^9, 3.967629976479241*^9, {3.967630021447341*^9, 
   3.9676300370361433`*^9}, 3.967630136098234*^9, {3.9676349834725723`*^9, 
   3.9676350108280687`*^9}, 3.9676353589113407`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[2005]:=",ExpressionUUID->"743979a4-220b-457f-94b5-e572fba1c89d"],

Cell[BoxData["\<\"Editor abierto correctamente\"\>"], "Print",
 CellChangeTimes->{
  3.967629930062911*^9, 3.967629976479241*^9, {3.967630021447341*^9, 
   3.9676300370361433`*^9}, 3.967630136098234*^9, {3.9676349834725723`*^9, 
   3.9676350108280687`*^9}, 3.967635358991589*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[2005]:=",ExpressionUUID->"0ce4b6d0-56b9-46eb-a689-d579d7809448"],

Cell[BoxData["\<\"Compilando documento LaTeX...\"\>"], "Print",
 CellChangeTimes->{
  3.967629930062911*^9, 3.967629976479241*^9, {3.967630021447341*^9, 
   3.9676300370361433`*^9}, 3.967630136098234*^9, {3.9676349834725723`*^9, 
   3.9676350108280687`*^9}, 3.9676353599977303`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[2005]:=",ExpressionUUID->"46554cfd-540a-43b0-aa5b-e37c069008ba"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Directorio de trabajo: \"\>", 
   "\[InvisibleSpace]", \
"\<\"/Users/enriquevilchezquesada/Downloads/Contour2D9/\"\>"}],
  SequenceForm[
  "Directorio de trabajo: ", 
   "/Users/enriquevilchezquesada/Downloads/Contour2D9/"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.967629930062911*^9, 3.967629976479241*^9, {3.967630021447341*^9, 
   3.9676300370361433`*^9}, 3.967630136098234*^9, {3.9676349834725723`*^9, 
   3.9676350108280687`*^9}, 3.9676353599997463`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[2005]:=",ExpressionUUID->"5629d4ff-6a54-4af3-844b-fbaa4d4dae66"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Archivo: \"\>", "\[InvisibleSpace]", "\<\"Contour2D9\"\>"}],
  SequenceForm["Archivo: ", "Contour2D9"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.967629930062911*^9, 3.967629976479241*^9, {3.967630021447341*^9, 
   3.9676300370361433`*^9}, 3.967630136098234*^9, {3.9676349834725723`*^9, 
   3.9676350108280687`*^9}, 3.967635360001335*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[2005]:=",ExpressionUUID->"139b54b2-ed09-4303-abc1-3728b5827999"],

Cell[BoxData["\<\"Compilaci\[OAcute]n exitosa\"\>"], "Print",
 CellChangeTimes->{
  3.967629930062911*^9, 3.967629976479241*^9, {3.967630021447341*^9, 
   3.9676300370361433`*^9}, 3.967630136098234*^9, {3.9676349834725723`*^9, 
   3.9676350108280687`*^9}, 3.967635362998178*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[2005]:=",ExpressionUUID->"03ca8715-539b-426c-b6de-e3733cbbbc3e"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"PDF generado: \"\>", 
   "\[InvisibleSpace]", \
"\<\"/Users/enriquevilchezquesada/Downloads/Contour2D9/Contour2D9.pdf\"\>"}],
  SequenceForm[
  "PDF generado: ", 
   "/Users/enriquevilchezquesada/Downloads/Contour2D9/Contour2D9.pdf"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.967629930062911*^9, 3.967629976479241*^9, {3.967630021447341*^9, 
   3.9676300370361433`*^9}, 3.967630136098234*^9, {3.9676349834725723`*^9, 
   3.9676350108280687`*^9}, 3.9676353629989367`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[2005]:=",ExpressionUUID->"4e4d0355-bd93-4a25-ae3a-546f3fd99342"]
}, Open  ]],

Cell[BoxData["\<\"/Users/enriquevilchezquesada/Downloads/Contour2D9/\
Contour2D9.pdf\"\>"], "Output",
 CellChangeTimes->{
  3.967629929612171*^9, 3.967629976058716*^9, {3.9676300210275383`*^9, 
   3.967630036615323*^9}, 3.9676301356788816`*^9, {3.9676349830504007`*^9, 
   3.967635010408739*^9}, 3.9676353630126553`*^9},
 CellLabel->
  "Out[2015]=",ExpressionUUID->"4219908f-1b29-4a7c-9aeb-ad869513184a"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Ejemplo 10: regi\[OAcute]n de coraz\[OAcute]n", "Subsection",
 CellChangeTimes->{{3.9675372440640697`*^9, 3.967537246104553*^9}, 
   3.967537277408373*^9, {3.9675376935417385`*^9, 
   3.9675376966870766`*^9}},ExpressionUUID->"964bf9f0-4c5c-664a-940a-\
b4892ab7aa39"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"RegionPlot", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"x", "^", "2"}], "+", 
         RowBox[{"y", "^", "2"}], "-", "1"}], ")"}], "^", "3"}], "-", 
      RowBox[{
       RowBox[{"x", "^", "2"}], " ", 
       RowBox[{"y", "^", "3"}]}]}], "<=", "0"}], ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", 
      RowBox[{"-", "1.5"}], ",", "1.5"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"y", ",", 
      RowBox[{"-", "1.2"}], ",", "1.5"}], "}"}]}], "]"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"line", "[", "]"}], ":=", 
  RowBox[{"RandomChoice", "[", 
   RowBox[{"{", 
    RowBox[{"\"\<solid\>\"", ",", "\"\<dashed\>\"", ",", "\"\<dotted\>\"", 
     ",", "\"\<thick\>\"", ",", "\"\<thin\>\""}], "}"}], "]"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"color", "[", "]"}], ":=", 
  RowBox[{"RandomChoice", "[", 
   RowBox[{"{", 
    RowBox[{"\"\<blue\>\"", ",", "\"\<red\>\"", ",", "\"\<green\>\"", 
     ",", "\"\<purple\>\"", ",", "\"\<yellow\>\"", ",", "\"\<orange\>\"", 
     ",", "\"\<cyan\>\"", ",", "\"\<magenta\>\"", ",", "\"\<black\>\""}], 
    "}"}], "]"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"sizetexto", "[", "]"}], ":=", 
  RowBox[{"RandomChoice", "[", 
   RowBox[{"{", 
    RowBox[{"\"\<\\\\tiny\>\"", ",", "\"\<\\\\scriptsize\>\"", 
     ",", "\"\<\\\\footnotesize\>\"", ",", "\"\<\\\\small\>\"", 
     ",", "\"\<\\\\normalsize\>\"", ",", "\"\<\\\\large\>\"", 
     ",", "\"\<\\\\Large\>\"", ",", "\"\<\\\\huge\>\"", 
     ",", "\"\<\\\\Huge\>\""}], "}"}], "]"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"anclajetexto", "[", "]"}], ":=", 
  RowBox[{"RandomChoice", "[", 
   RowBox[{"{", 
    RowBox[{"\"\<north\>\"", ",", "\"\<south\>\"", ",", "\"\<east\>\"", 
     ",", "\"\<west\>\"", ",", "\"\<north east\>\"", ",", "\"\<north west\>\"",
      ",", "\"\<south east\>\"", ",", "\"\<south west\>\"", 
     ",", "\"\<center\>\""}], "}"}], "]"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"rotatexto", "[", "]"}], ":=", 
  RowBox[{"RandomReal", "[", 
   RowBox[{"{", 
    RowBox[{"0", ",", "360"}], "}"}], "]"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"estilotext", "[", "n_", "]"}], ":=", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"\"\<color\>\"", ",", 
        RowBox[{"color", "[", "]"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"\"\<size\>\"", ",", 
        RowBox[{"sizetexto", "[", "]"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"\"\<anchor\>\"", ",", 
        RowBox[{"anclajetexto", "[", "]"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"\"\<rotate\>\"", ",", 
        RowBox[{"rotatexto", "[", "]"}]}], "}"}]}], "}"}], ",", "n"}], 
   "]"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"vectorestilos", "=", 
   RowBox[{"estilotext", "[", "1", "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Row", "[", 
    RowBox[{"{", 
     RowBox[{"\"\<grid=\>\"", ",", 
      RowBox[{"grid", "=", 
       RowBox[{"RandomChoice", "[", 
        RowBox[{"{", 
         RowBox[{"True", ",", "False"}], "}"}], "]"}]}]}], "}"}], "]"}], ",", 
   
   RowBox[{"Row", "[", 
    RowBox[{"{", 
     RowBox[{"\"\<estilos=\>\"", ",", 
      RowBox[{"estilos", "=", 
       RowBox[{"Table", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"line", "[", "]"}], ",", 
           RowBox[{"color", "[", "]"}]}], "}"}], ",", "1"}], "]"}]}]}], "}"}],
     "]"}], ",", 
   RowBox[{"Row", "[", 
    RowBox[{"{", 
     RowBox[{"\"\<ejes=\>\"", ",", 
      RowBox[{"ejes", "=", 
       RowBox[{"RandomChoice", "[", 
        RowBox[{"{", 
         RowBox[{"True", ",", "False"}], "}"}], "]"}]}]}], "}"}], "]"}], ",", 
   
   RowBox[{"Row", "[", 
    RowBox[{"{", 
     RowBox[{"\"\<texto=\>\"", ",", 
      RowBox[{"texto", "=", 
       RowBox[{"{", 
        RowBox[{"{", 
         RowBox[{"\"\<Coraz\[OAcute]n\>\"", ",", 
          RowBox[{"{", 
           RowBox[{"0", ",", "0"}], "}"}], ",", 
          RowBox[{"vectorestilos", "[", 
           RowBox[{"[", "1", "]"}], "]"}]}], "}"}], "}"}]}]}], "}"}], "]"}], ",", 
   RowBox[{"Row", "[", 
    RowBox[{"{", 
     RowBox[{"\"\<muestras=\>\"", ",", 
      RowBox[{"muestras", "=", "80"}]}], "}"}], "]"}], ",", 
   RowBox[{"Row", "[", 
    RowBox[{"{", 
     RowBox[{"\"\<tolerancia=\>\"", ",", 
      RowBox[{"tolerancia", "=", "0.01"}]}], "}"}], "]"}], ",", 
   RowBox[{"Row", "[", 
    RowBox[{"{", 
     RowBox[{"\"\<opacidad=\>\"", ",", 
      RowBox[{"opacidad", "=", "0.8"}]}], "}"}], "]"}], ",", 
   RowBox[{"Row", "[", 
    RowBox[{"{", 
     RowBox[{"\"\<densidad=\>\"", ",", 
      RowBox[{"densidad", "=", "2.5"}]}], "}"}], "]"}], ",", 
   RowBox[{"Row", "[", 
    RowBox[{"{", 
     RowBox[{"\"\<xmin=\>\"", ",", 
      RowBox[{"xmin", "=", "Automatic"}]}], "}"}], "]"}], ",", 
   RowBox[{"Row", "[", 
    RowBox[{"{", 
     RowBox[{"\"\<xmax=\>\"", ",", 
      RowBox[{"xmax", "=", "Automatic"}]}], "}"}], "]"}], ",", 
   RowBox[{"Row", "[", 
    RowBox[{"{", 
     RowBox[{"\"\<ymin=\>\"", ",", 
      RowBox[{"ymin", "=", "Automatic"}]}], "}"}], "]"}], ",", 
   RowBox[{"Row", "[", 
    RowBox[{"{", 
     RowBox[{"\"\<ymax=\>\"", ",", 
      RowBox[{"ymax", "=", "Automatic"}]}], "}"}], "]"}]}], "}"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ExportContour2DToTikZ", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"x", "^", "2"}], "+", 
         RowBox[{"y", "^", "2"}], "-", "1"}], ")"}], "^", "3"}], "-", 
      RowBox[{
       RowBox[{"x", "^", "2"}], " ", 
       RowBox[{"y", "^", "3"}]}]}], "<=", "0"}], 
    ",", "\"\<Contour2D10.tex\>\"", ",", "grid", ",", "estilos", ",", "ejes", 
    ",", "texto", ",", "muestras", ",", "tolerancia", ",", "opacidad", ",", 
    "densidad", ",", "xmin", ",", "xmax", ",", "ymin", ",", "ymax"}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"CompiladorTex", "[", 
  RowBox[{"%", ",", 
   RowBox[{"\"\<PreferredEditor\>\"", " ", "->", "\"\<TeXstudio\>\""}]}], 
  "]"}]}], "Input",
 CellChangeTimes->{{3.9675376921346874`*^9, 3.967537699824682*^9}, {
   3.96753825803817*^9, 3.9675382584108124`*^9}, {3.9675452287108727`*^9, 
   3.967545230023569*^9}, {3.9675738095267773`*^9, 3.967573809986495*^9}, {
   3.96757400490005*^9, 3.967574005154427*^9}, {3.967630065362718*^9, 
   3.96763008957933*^9}, {3.9676301198799553`*^9, 3.967630237742179*^9}, 
   3.967634172260573*^9},
 CellLabel->
  "In[2027]:=",ExpressionUUID->"d315f8ff-1575-d44e-a4db-b2477598c097"],

Cell[BoxData[
 GraphicsBox[{GraphicsComplexBox[CompressedData["
1:eJxlmXtcz9cfxwnTIqxhW2O2iNxDtbb9OGjMlkvk0obcE/kZauxrGOP3Tea+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    "], {{
      {RGBColor[0.24, 0.6, 0.8], AbsoluteThickness[2.], Opacity[0.3], 
       EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxNmQW41sUSxnf+ICLSIl2HBpFuJJSOAyJxSGlpUBAVlLILCUHBQLgqV70m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          "]], PolygonBox[CompressedData["
1:eJwtlQmwj2UYxd/3xRhLoqxFRHeQUFyVW11jmyxlS3eMasYy1CC3mmrEHUq2
shYuY2wRFSLZQwbXvg+yRFSTlIRiKKLf8Twz/zPPOd/7/b/lfc5zvvt75Hbq
n0IIo0Bh0BqxOobwDXwfaIVehV4D3w+uwj8Bi+FHQSbrDUEV+ClwjLWP0M2o
ldFN4UvhK+C7wRPoLNAI/hNYz1o79FX4NTAXfRjsgH8PFsBPgl3wP8Ei+Buc
X5y6HH2Cejf6NHwnqAN/EJyB/wrOsj4MXZ26Ht0Cvhy+Cr4XvAcfwbGa1Hz0
FWop9En4Jl0DPQndiroOPYd6E2yDLwH94HVZ/83v1x/9EPosfAu4F1452V6u
DramZ7z9bOA85xdDn4AfBM/A1/q9DoD70FWTcfXkY9ZqoH+BfwDGRHsGXU/v
PBVeM9m9PwOz0f+B7fAvwXb4INbLUj9HV4RXAnvgK8EejuehK1AXoS9QJ4Nj
8EMgg7WXQORYAfoL6sPoc8E8cBQ9Fd2F+lWw3tyVzBvq0TyOj0Fnqm/oH6i5
6GLRelocXiLZXswF5fSsybzyMxgIz+e84/Ay1EPRPCOv3H5H+OOcczGYx87p
+dFtqN+i/6IOQJeilgZd4Zupt1i7qR5E87i8rR4/z3pnMB4+AbwLf9Of/R7q
++oFdS26GnW4vOBey6B+qF74XtVzr23wZ5HnhqIHUJtr/6gj0UOpU9C1qaOS
eVJerEPtje4F5qGLuLcHR/OCPD4WvS1a7x/1WTxO/TrYTE5E/xit1y29F/Oj
eTnTvX4mWh7I81PQe9UXdA51NHqme6eB7+3v1DnB9jgfvSNalnSmjkPvpi5E
Z1GX6V2TZYFmcCX66WSzqIxplGzmNevnwVPobPC3nh90h3dL5o1C3uvF1EvB
et4YvVD3CXZMvcsB04P18AX4MNZnBOv5GnjbZNmmHjZRlnCsA/wymBjNA+q9
/vMsPE8zpKwAG+EXo83GdfAk60ui/VfPrFk44lmomeiB7pns2T9Vj+CPJXvX
WqAjvEOyLFImVoevi3YvzXynZPfUvf5VD9EromWLZni8siLarGf7LL9GLRJs
pgvc8/J6gO/0nqlXCzj0h3tQ3tuA3uqekpf4hZHu6Xre8/rwaf7frcGyMDca
Vybucg9kuSdOuwdb+h5fp87yrNE3ZZ97Lsc9UyhZ5ivr9Q24pX3zbNE34rto
M6lZXIreH20Pst2zp3zGNFv6Bs1wDzfwPdHslU+WLZrBTdH2WHt7Qx6HP5Ls
2sq4y76H2ozDlDvkTef6ZihbX/W9Usa+mCyzlFXKzH+iZZCyR5naT+eDoj6j
feF9knlBx96Bl0zmlTvRr6ufyWZBmfky/JVkWTA/WDaOAEeCZaSy7lK0/yrz
3kZPopYAJZVf4Llk76oZGe6Zo6xRxpSBl052bV1T2dA+2bdaGZHnGVjNZ0Lf
Mt1D19Y37S34A8m8pHsO8YzM8IzTrKZk327N7P8c1icR
          "]]}]}, {}, {}, {}, {}}, 
     {RGBColor[0.24, 0.6, 0.8], AbsoluteThickness[2.], LineBox[CompressedData["
1:eJwl1HWUVGUYwOFhBZFSSmkUaUFppBEF6RSklEaQWrpj6UbpUDpUSkkp6VYk
JZWSVjqUUHi+wx+/fd7325lz7uzOvRmaRNdoFysSieTyI0dUJPKWsim7Rjlr
o7fN0czFaXyHX3GvJpn38JF+1hj7L/xa+zXZ/iuf6IC+sB/kLP2njurr7Ajn
6jf1s3fiU83TcU1xdixcKE9wLE/y23CN5rb6XK3VSrHUTgX1rgpoodf+of7m
rnyBi8M18DSj2UHtFTtcg4qrhIrpe68pybMcz3NcrhTmlEqlHvYyXMXUTKO0
6mkvzzVMx/R6Xb3slbiebzCDLpsn8BKr8idWYXVVU2e9qP7Oh3AT/9Vfmmi/
xpc4lCO4gw2YWZ/qk3A9mhTer+HmB0zCxBppbsGWaqbP1FwjnL/CwRzG+3yZ
iXTXPJX3uF31zNtYn4NYlzHh76Za5pr6WLVVRwOdf8StrMEtvKWb4TPpoe6o
u9/dZg8m1HBzEzZVQzVWIw1zHp8JdMPcjdcZL/zvNcHchZm02fy3hpoHMC77
cTCvcqOuaJC9L+OwD8cpo/lNbTBXZm8O5EWuUwXzWlbkBZbjj/yQq1mWf7I0
V/J9ruAHPM9SXMb3+APPaIC5O1/jq0quoiqibuHe0BIVsi9lYS5iFE+F6+bv
TMakyq986uLsS32n3Pa8yqNv7EcVE7574R7WfI2yL+Ac/a9D4f3ODvMfzVaf
cE/xsWZqn3qHeyw8KzRdI+0zwvdHu9XL3pajtTNo38XJymKewqwMD66cUc+f
W88Amk+azA==
       "]]}}], {}},
  AspectRatio->1,
  Axes->{False, False},
  AxesLabel->{None, None},
  AxesOrigin->{0, 0},
  DefaultBaseStyle->{"PlotGraphics", "Graphics"},
  DisplayFunction->Identity,
  Frame->{{True, True}, {True, True}},
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImagePadding->All,
  Method->{
   "DefaultGraphicsInteraction" -> {
     "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
      "Effects" -> {
       "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
        "Droplines" -> {
         "freeformCursorMode" -> True, 
          "placement" -> {"x" -> "All", "y" -> "None"}}}}, "ScalingFunctions" -> 
    None, "TransparentPolygonMesh" -> True, "AxesInFront" -> True},
  PlotInteractivity:>True,
  PlotRange->{{-1.5, 1.5}, {-1.2, 1.5}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.02], 
     Scaled[0.02]}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{
  3.9676301749289722`*^9, {3.967630204970584*^9, 3.967630274454474*^9}, {
   3.967635376700444*^9, 3.967635387687291*^9}},
 CellLabel->
  "Out[2027]=",ExpressionUUID->"9dd68d9f-7515-4425-8a11-301973735a30"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TemplateBox[{"\"grid=\"", "False"},
    "RowDefault"], ",", 
   TemplateBox[{"\"estilos=\"", 
     RowBox[{"{", 
       RowBox[{"{", 
         RowBox[{"\"thin\"", ",", "\"purple\""}], "}"}], "}"}]},
    "RowDefault"], ",", 
   TemplateBox[{"\"ejes=\"", "True"},
    "RowDefault"], ",", 
   TemplateBox[{"\"texto=\"", 
     RowBox[{"{", 
       RowBox[{"{", 
         RowBox[{"\"Coraz\[OAcute]n\"", ",", 
           RowBox[{"{", 
             RowBox[{"0", ",", "0"}], "}"}], ",", 
           RowBox[{"{", 
             RowBox[{
               RowBox[{"{", 
                 RowBox[{"\"color\"", ",", "\"red\""}], "}"}], ",", 
               RowBox[{"{", 
                 RowBox[{"\"size\"", ",", "\"\\\\small\""}], "}"}], ",", 
               RowBox[{"{", 
                 RowBox[{"\"anchor\"", ",", "\"north east\""}], "}"}], ",", 
               RowBox[{"{", 
                 RowBox[{"\"rotate\"", ",", "98.79839970972644`"}], "}"}]}], 
             "}"}]}], "}"}], "}"}]},
    "RowDefault"], ",", 
   TemplateBox[{"\"muestras=\"", "80"},
    "RowDefault"], ",", 
   TemplateBox[{"\"tolerancia=\"", "0.01`"},
    "RowDefault"], ",", 
   TemplateBox[{"\"opacidad=\"", "0.8`"},
    "RowDefault"], ",", 
   TemplateBox[{"\"densidad=\"", "2.5`"},
    "RowDefault"], ",", 
   TemplateBox[{"\"xmin=\"", "Automatic"},
    "RowDefault"], ",", 
   TemplateBox[{"\"xmax=\"", "Automatic"},
    "RowDefault"], ",", 
   TemplateBox[{"\"ymin=\"", "Automatic"},
    "RowDefault"], ",", 
   TemplateBox[{"\"ymax=\"", "Automatic"},
    "RowDefault"]}], "}"}]], "Output",
 CellChangeTimes->{
  3.9676301749289722`*^9, {3.967630204970584*^9, 3.967630274454474*^9}, {
   3.967635376700444*^9, 3.967635387690843*^9}},
 CellLabel->
  "Out[2035]=",ExpressionUUID->"66ec0983-76b8-4bb5-9e38-b8f451c93c4b"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Usando editores ya detectados: \"\>", "\[InvisibleSpace]", "4",
    "\[InvisibleSpace]", "\<\" disponibles\"\>"}],
  SequenceForm["Usando editores ya detectados: ", 4, " disponibles"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.96763017533899*^9, {3.967630205379036*^9, 3.967630274865634*^9}, {
   3.9676353771145563`*^9, 3.9676353881022387`*^9}},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[2027]:=",ExpressionUUID->"09255284-f69b-4c3f-97f1-dd0bcfdd845b"],

Cell[BoxData["\<\"Buscando pdflatex...\"\>"], "Print",
 CellChangeTimes->{
  3.96763017533899*^9, {3.967630205379036*^9, 3.967630274865634*^9}, {
   3.9676353771145563`*^9, 3.9676353881030188`*^9}},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[2027]:=",ExpressionUUID->"52abf9c2-473e-49ef-b1d0-3c14d526c5f5"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"pdflatex encontrado: \"\>", 
   "\[InvisibleSpace]", "\<\"/Library/TeX/texbin/pdflatex\"\>"}],
  SequenceForm["pdflatex encontrado: ", "/Library/TeX/texbin/pdflatex"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.96763017533899*^9, {3.967630205379036*^9, 3.967630274865634*^9}, {
   3.9676353771145563`*^9, 3.9676353881036873`*^9}},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[2027]:=",ExpressionUUID->"b2ff9e19-1391-4d7a-9f9f-170186fa6ed7"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Editor '\"\>", "\[InvisibleSpace]", "\<\"TeXstudio\"\>", 
   "\[InvisibleSpace]", "\<\"' encontrado (match exacto)\"\>"}],
  SequenceForm["Editor '", "TeXstudio", "' encontrado (match exacto)"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.96763017533899*^9, {3.967630205379036*^9, 3.967630274865634*^9}, {
   3.9676353771145563`*^9, 3.967635388104093*^9}},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[2027]:=",ExpressionUUID->"31e61cb4-c5d3-4a6e-a174-871f6c40a1b5"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Abriendo archivo en \"\>", 
   "\[InvisibleSpace]", "\<\"TeXstudio\"\>", 
   "\[InvisibleSpace]", "\<\"...\"\>"}],
  SequenceForm["Abriendo archivo en ", "TeXstudio", "..."],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.96763017533899*^9, {3.967630205379036*^9, 3.967630274865634*^9}, {
   3.9676353771145563`*^9, 3.967635388104484*^9}},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[2027]:=",ExpressionUUID->"c77a9611-1512-4989-abfe-1eb37873fdbb"],

Cell[BoxData["\<\"Editor abierto correctamente\"\>"], "Print",
 CellChangeTimes->{
  3.96763017533899*^9, {3.967630205379036*^9, 3.967630274865634*^9}, {
   3.9676353771145563`*^9, 3.967635388206983*^9}},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[2027]:=",ExpressionUUID->"38e5a00e-2614-40a4-8cfa-bc856ce87f6f"],

Cell[BoxData["\<\"Compilando documento LaTeX...\"\>"], "Print",
 CellChangeTimes->{
  3.96763017533899*^9, {3.967630205379036*^9, 3.967630274865634*^9}, {
   3.9676353771145563`*^9, 3.967635389214056*^9}},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[2027]:=",ExpressionUUID->"8f3ffb00-6522-4d2e-bd3c-bf03c6c04c9b"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Directorio de trabajo: \"\>", 
   "\[InvisibleSpace]", \
"\<\"/Users/enriquevilchezquesada/Downloads/Contour2D10/\"\>"}],
  SequenceForm[
  "Directorio de trabajo: ", 
   "/Users/enriquevilchezquesada/Downloads/Contour2D10/"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.96763017533899*^9, {3.967630205379036*^9, 3.967630274865634*^9}, {
   3.9676353771145563`*^9, 3.967635389218235*^9}},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[2027]:=",ExpressionUUID->"ce728d1a-0099-4039-8c7d-8c4e666dbee4"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Archivo: \"\>", "\[InvisibleSpace]", "\<\"Contour2D10\"\>"}],
  SequenceForm["Archivo: ", "Contour2D10"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.96763017533899*^9, {3.967630205379036*^9, 3.967630274865634*^9}, {
   3.9676353771145563`*^9, 3.967635389221778*^9}},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[2027]:=",ExpressionUUID->"bbbc69b0-f9c8-4c33-accd-629f5b97a37a"],

Cell[BoxData["\<\"Compilaci\[OAcute]n exitosa\"\>"], "Print",
 CellChangeTimes->{
  3.96763017533899*^9, {3.967630205379036*^9, 3.967630274865634*^9}, {
   3.9676353771145563`*^9, 3.967635390515684*^9}},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[2027]:=",ExpressionUUID->"398c63d0-e4a8-4ee1-b2f2-3c187be7c74e"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"PDF generado: \"\>", 
   "\[InvisibleSpace]", \
"\<\"/Users/enriquevilchezquesada/Downloads/Contour2D10/Contour2D10.pdf\"\>"}],
  SequenceForm[
  "PDF generado: ", 
   "/Users/enriquevilchezquesada/Downloads/Contour2D10/Contour2D10.pdf"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.96763017533899*^9, {3.967630205379036*^9, 3.967630274865634*^9}, {
   3.9676353771145563`*^9, 3.9676353905164347`*^9}},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[2027]:=",ExpressionUUID->"44c8b017-a77f-407b-85d8-31f7dd8f3820"]
}, Open  ]],

Cell[BoxData["\<\"/Users/enriquevilchezquesada/Downloads/Contour2D10/\
Contour2D10.pdf\"\>"], "Output",
 CellChangeTimes->{
  3.9676301749289722`*^9, {3.967630204970584*^9, 3.967630274454474*^9}, {
   3.967635376700444*^9, 3.9676353905290937`*^9}},
 CellLabel->
  "Out[2037]=",ExpressionUUID->"3b86e112-add2-4661-b704-d2ff2e6bf268"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
Ejemplo 11: varias ecuaciones (c\[IAcute]rculo, elipse, hip\[EAcute]rbola, \
par\[AAcute]bola, c\[IAcute]rculo peque\[NTilde]o, seno y coseno)\
\>", "Subsection",
 CellChangeTimes->{{3.9675372440640697`*^9, 3.967537246104553*^9}, 
   3.9675372785180416`*^9, {3.967537707684908*^9, 3.9675377588366776`*^9}, {
   3.9676304027911997`*^9, 
   3.9676304039469423`*^9}},ExpressionUUID->"8f101341-0673-3448-ae73-\
3448b5dd33f2"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"eq1", "=", 
   RowBox[{
    RowBox[{
     RowBox[{"x", "^", "2"}], "+", 
     RowBox[{"y", "^", "2"}]}], "==", "4"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"eq2", "=", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"x", "^", "2"}], "/", "4"}], "+", 
     RowBox[{
      RowBox[{"y", "^", "2"}], "/", "9"}]}], "==", "1"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"eq3", "=", 
   RowBox[{
    RowBox[{
     RowBox[{"x", "^", "2"}], "-", 
     RowBox[{"y", "^", "2"}]}], "==", "1"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"eq4", "=", 
   RowBox[{"y", "==", 
    RowBox[{"x", "^", "2"}]}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"eq5", "=", 
   RowBox[{
    RowBox[{
     RowBox[{"x", "^", "2"}], "+", 
     RowBox[{"y", "^", "2"}]}], "==", "1"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"eq6", "=", 
   RowBox[{"y", "==", 
    RowBox[{"Sin", "[", "x", "]"}]}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"eq7", "=", 
   RowBox[{"x", "==", 
    RowBox[{"Cos", "[", 
     RowBox[{"y", "^", "2"}], "]"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Show", "[", 
   RowBox[{
    RowBox[{"ContourPlot", "[", 
     RowBox[{"eq1", ",", 
      RowBox[{"{", 
       RowBox[{"x", ",", 
        RowBox[{"-", "10"}], ",", "10"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"y", ",", 
        RowBox[{"-", "10"}], ",", "10"}], "}"}]}], "]"}], ",", 
    RowBox[{"ContourPlot", "[", 
     RowBox[{"eq2", ",", 
      RowBox[{"{", 
       RowBox[{"x", ",", 
        RowBox[{"-", "10"}], ",", "10"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"y", ",", 
        RowBox[{"-", "10"}], ",", "10"}], "}"}]}], "]"}], ",", 
    RowBox[{"ContourPlot", "[", 
     RowBox[{"eq3", ",", 
      RowBox[{"{", 
       RowBox[{"x", ",", 
        RowBox[{"-", "10"}], ",", "10"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"y", ",", 
        RowBox[{"-", "10"}], ",", "10"}], "}"}]}], "]"}], ",", 
    RowBox[{"ContourPlot", "[", 
     RowBox[{"eq4", ",", 
      RowBox[{"{", 
       RowBox[{"x", ",", 
        RowBox[{"-", "10"}], ",", "10"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"y", ",", 
        RowBox[{"-", "10"}], ",", "10"}], "}"}]}], "]"}], ",", 
    RowBox[{"ContourPlot", "[", 
     RowBox[{"eq5", ",", 
      RowBox[{"{", 
       RowBox[{"x", ",", 
        RowBox[{"-", "10"}], ",", "10"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"y", ",", 
        RowBox[{"-", "10"}], ",", "10"}], "}"}]}], "]"}], ",", 
    RowBox[{"ContourPlot", "[", 
     RowBox[{"eq6", ",", 
      RowBox[{"{", 
       RowBox[{"x", ",", 
        RowBox[{"-", "10"}], ",", "10"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"y", ",", 
        RowBox[{"-", "10"}], ",", "10"}], "}"}]}], "]"}], ",", 
    RowBox[{"ContourPlot", "[", 
     RowBox[{"eq7", ",", 
      RowBox[{"{", 
       RowBox[{"x", ",", 
        RowBox[{"-", "10"}], ",", "10"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"y", ",", 
        RowBox[{"-", "10"}], ",", "10"}], "}"}]}], "]"}], ",", 
    RowBox[{"Frame", "->", "False"}], ",", 
    RowBox[{"Axes", "->", "True"}]}], "]"}], "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"line", "[", "]"}], ":=", 
  RowBox[{"RandomChoice", "[", 
   RowBox[{"{", 
    RowBox[{"\"\<solid\>\"", ",", "\"\<dashed\>\"", ",", "\"\<dotted\>\"", 
     ",", "\"\<thick\>\"", ",", "\"\<thin\>\""}], "}"}], "]"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"color", "[", "]"}], ":=", 
  RowBox[{"RandomChoice", "[", 
   RowBox[{"{", 
    RowBox[{"\"\<blue\>\"", ",", "\"\<red\>\"", ",", "\"\<green\>\"", 
     ",", "\"\<purple\>\"", ",", "\"\<yellow\>\"", ",", "\"\<orange\>\"", 
     ",", "\"\<cyan\>\"", ",", "\"\<magenta\>\"", ",", "\"\<black\>\""}], 
    "}"}], "]"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"sizetexto", "[", "]"}], ":=", 
  RowBox[{"RandomChoice", "[", 
   RowBox[{"{", 
    RowBox[{"\"\<\\\\tiny\>\"", ",", "\"\<\\\\scriptsize\>\"", 
     ",", "\"\<\\\\footnotesize\>\"", ",", "\"\<\\\\small\>\"", 
     ",", "\"\<\\\\normalsize\>\"", ",", "\"\<\\\\large\>\"", 
     ",", "\"\<\\\\Large\>\"", ",", "\"\<\\\\huge\>\"", 
     ",", "\"\<\\\\Huge\>\""}], "}"}], "]"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"anclajetexto", "[", "]"}], ":=", 
  RowBox[{"RandomChoice", "[", 
   RowBox[{"{", 
    RowBox[{"\"\<north\>\"", ",", "\"\<south\>\"", ",", "\"\<east\>\"", 
     ",", "\"\<west\>\"", ",", "\"\<north east\>\"", ",", "\"\<north west\>\"",
      ",", "\"\<south east\>\"", ",", "\"\<south west\>\"", 
     ",", "\"\<center\>\""}], "}"}], "]"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"rotatexto", "[", "]"}], ":=", 
  RowBox[{"RandomReal", "[", 
   RowBox[{"{", 
    RowBox[{"0", ",", "360"}], "}"}], "]"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"estilotext", "[", "n_", "]"}], ":=", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"\"\<color\>\"", ",", 
        RowBox[{"color", "[", "]"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"\"\<size\>\"", ",", 
        RowBox[{"sizetexto", "[", "]"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"\"\<anchor\>\"", ",", 
        RowBox[{"anclajetexto", "[", "]"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"\"\<rotate\>\"", ",", 
        RowBox[{"rotatexto", "[", "]"}]}], "}"}]}], "}"}], ",", "n"}], 
   "]"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"vectorestilos", "=", 
   RowBox[{"estilotext", "[", "1", "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Row", "[", 
    RowBox[{"{", 
     RowBox[{"\"\<grid=\>\"", ",", 
      RowBox[{"grid", "=", "False"}]}], "}"}], "]"}], ",", 
   RowBox[{"Row", "[", 
    RowBox[{"{", 
     RowBox[{"\"\<estilos=\>\"", ",", 
      RowBox[{"estilos", "=", 
       RowBox[{"Table", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"line", "[", "]"}], ",", 
           RowBox[{"color", "[", "]"}]}], "}"}], ",", "7"}], "]"}]}]}], "}"}],
     "]"}], ",", 
   RowBox[{"Row", "[", 
    RowBox[{"{", 
     RowBox[{"\"\<ejes=\>\"", ",", 
      RowBox[{"ejes", "=", "True"}]}], "}"}], "]"}], ",", 
   RowBox[{"Row", "[", 
    RowBox[{"{", 
     RowBox[{"\"\<texto=\>\"", ",", 
      RowBox[{"texto", "=", 
       RowBox[{"{", 
        RowBox[{"{", 
         RowBox[{"\"\<Varias ecuaciones\>\"", ",", 
          RowBox[{"{", 
           RowBox[{"1", ",", "1"}], "}"}], ",", 
          RowBox[{"vectorestilos", "[", 
           RowBox[{"[", "1", "]"}], "]"}]}], "}"}], "}"}]}]}], "}"}], "]"}], ",", 
   RowBox[{"Row", "[", 
    RowBox[{"{", 
     RowBox[{"\"\<muestras=\>\"", ",", 
      RowBox[{"muestras", "=", "200"}]}], "}"}], "]"}], ",", 
   RowBox[{"Row", "[", 
    RowBox[{"{", 
     RowBox[{"\"\<tolerancia=\>\"", ",", 
      RowBox[{"tolerancia", "=", "0.01"}]}], "}"}], "]"}], ",", 
   RowBox[{"Row", "[", 
    RowBox[{"{", 
     RowBox[{"\"\<opacidad=\>\"", ",", 
      RowBox[{"opacidad", "=", "0.8"}]}], "}"}], "]"}], ",", 
   RowBox[{"Row", "[", 
    RowBox[{"{", 
     RowBox[{"\"\<densidad=\>\"", ",", 
      RowBox[{"densidad", "=", "3"}]}], "}"}], "]"}], ",", 
   RowBox[{"Row", "[", 
    RowBox[{"{", 
     RowBox[{"\"\<xmin=\>\"", ",", 
      RowBox[{"xmin", "=", 
       RowBox[{"-", "10"}]}]}], "}"}], "]"}], ",", 
   RowBox[{"Row", "[", 
    RowBox[{"{", 
     RowBox[{"\"\<xmax=\>\"", ",", 
      RowBox[{"xmax", "=", "10"}]}], "}"}], "]"}], ",", 
   RowBox[{"Row", "[", 
    RowBox[{"{", 
     RowBox[{"\"\<ymin=\>\"", ",", 
      RowBox[{"ymin", "=", 
       RowBox[{"-", "10"}]}]}], "}"}], "]"}], ",", 
   RowBox[{"Row", "[", 
    RowBox[{"{", 
     RowBox[{"\"\<ymax=\>\"", ",", 
      RowBox[{"ymax", "=", "10"}]}], "}"}], "]"}]}], "}"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ExportContour2DToTikZ", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
     "eq1", ",", "eq2", ",", "eq3", ",", "eq4", ",", "eq5", ",", "eq6", ",", 
      "eq7"}], "}"}], ",", "\"\<Contour2D11.tex\>\"", ",", "grid", ",", 
    "estilos", ",", "ejes", ",", "texto", ",", "muestras", ",", "tolerancia", 
    ",", "opacidad", ",", "densidad", ",", "xmin", ",", "xmax", ",", "ymin", ",",
     "ymax"}], "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"CompiladorTex", "[", 
  RowBox[{"%", ",", 
   RowBox[{"\"\<PreferredEditor\>\"", " ", "->", "\"\<TeXstudio\>\""}]}], 
  "]"}]}], "Input",
 CellChangeTimes->{
  3.9675374280761967`*^9, 3.967537706193693*^9, {3.9675377615886097`*^9, 
   3.9675377828901997`*^9}, {3.9675382549054394`*^9, 3.967538255182741*^9}, {
   3.967545237924261*^9, 3.9675452411035385`*^9}, {3.9675453248127766`*^9, 
   3.967545332555292*^9}, {3.9675738182371807`*^9, 3.967573818590786*^9}, {
   3.967574012253825*^9, 3.967574012358323*^9}, {3.967630332294856*^9, 
   3.9676303944850473`*^9}, {3.967630443889069*^9, 3.967630513625001*^9}, {
   3.967630600239605*^9, 3.967630678347843*^9}, 3.967634165265332*^9, {
   3.967634957254395*^9, 3.967634957735598*^9}},
 CellLabel->
  "In[2038]:=",ExpressionUUID->"7dfe168a-d4c6-0d41-9b96-729f489d1faa"],

Cell[BoxData[
 GraphicsBox[{{GraphicsComplexBox[CompressedData["
1:eJxlln1MVXUYx2+w+CPZWs22CsYkrq3VBGrmX7UHjUJLZJFIL6wZ1SY5wDYX
gSgBbRa6aQ4GJEjXLRhaqK3dWq0eBkophg6T6/WyxnuKF8OLXLi83BP3PM/3
sG5nY+eew/n9nrfP831+8bmFme9H2Gw259Jf6H5rpv/Bln0GfZQX5/6mto8r
L97/11u9BtU/6u2usV3g6dfq0mM9Bu3P9zjzPV3c9ch9e/ePGvTmttnWG7Gd
7Hm3Z+fNOYO+OPZQdGazw3q2mde15/D8wFfm/wnr22U93dX9/5b9qULt+8Q+
3VT/Tot/lGL3+77fY9Al8/s+GnSGfhh08nTr2pF+FyUk+R5L8gXJXbHmWsWa
ARpL979e0xukrCP2TUfsg1TVMf1EzqEgRe5Z2ZY2OEQFx99zPf5ykDyp59vS
q0dofYXz4ErPInWa+4/RMxnj7u2fLNKV4gPxjT/coMmqU7NVpxbo63PZpeey
vTTVPp7b4Fig5E0hA1560rwv0M8XQ5eXrt97trn38DwZW7Z1xyRMUkbiaGbi
6BxlmP7cobTBkiVHAuQ2v5uiX0y7fmpPKSlry/JTw7rLeZGNy3e8x3dYh32w
L+zALvyAX/Dzj2c3l0e3eOlj+qf3RMNyHIgLcSJu5AF5QZ6Qt9KOgn0r7hmm
nmO/L3m6nPeyV0+cH+4J0voIe0qEfYBcBRN9BRNBq26oo3PX9pyYFS46OtOT
erx4uc6oOzgAF+AE3IAjcAXOwB04DOc0rbn22+jg/zkG51iPPkBfoE/QN+gj
9FWT+M8b1H+HxMuIN1HywW7Nx/OSL67QfL0h+eQrms+Tkm9+SfPdIfXgdVqP
IqkXz2u9HpZ6ckDr+ZPUn1H//JL8ybynJnnr057uVfXz9ILww+1Jdl/n/Bzd
LjT8hYaPd4fMOgOUF7ezY0f1FA8H4pNTXwnQnBG6pvjzVt+nrb5ZKjXOxta/
7WfwObSxxRXV5Ofbcqcz8p4/k++oXNZxlFmHu+SWfblI7NAOscuG+EE/il8M
zjeL31wqcVCcxMVjyvlu4Zr7lXOf5IHBeUDyxCXKeZLkkUeUc+WawbnWgbUu
4JrB+Z9SR96qnF+VOnPxGeG8TrjmfuVcuWZwPi7ccLFyXi5c8YsxwrlyzeBc
ueQc5Vy55b0O4Vy55jA95sUm4fw3XT+TJZwr1wzOta/Yq5xPqH8pyrlyzeAc
8e6SeFn1mFWPeVz0mMF5jegx/1pi6jHnix6z6jE4Z3CvusO9yn3kAanfFuV+
VusL7sHDsHKvOsiqi5wtOsngfqPoqH43xeD1kuguN4oOW3e8x3dYh32wL+zA
LvyAX/CzWzhl1WMrDsSFOBE38oC8hOkDr1X9uK7cIu+Vyu0G1R/VY6tuqON3
wil/qdyG6ZnFAbgAJ+AmTC8tzsAdOASX4ZyCYzzn/FfPOUzvrT5B36CP0Fdh
88TqS8R7S88Nq5Rb9LWeI3hIOKVDyu2Enhs+UG7D5qGlI9AV6Ax0BzoEXYJu
gYeoDJnfV5UX6B50ELoInYRuQkehq9BZ6C54hS5Dp6Hb0PG6y6VH79hmqS/X
MVK5etrSeeg+5gDmAuYE5gbmCPoAcwZzB3MIcwlzCtxjjmGuYc5h7mEOgvsP
9Tx3QfXjsJ73BlRfMFfRB6v1vNil+lReXfROQrJB0ab9/uU5XRaoLQu4uEHP
JQe1LzDX0Rfh5+l/AffaprE=
     "], {{}, {}, 
      TagBox[
       TooltipBox[
        {RGBColor[0.24, 0.6, 0.8], AbsoluteThickness[2], 
         LineBox[{1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 
          18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 
          35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 
          52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 64, 65, 66, 67, 68, 
          69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 
          86, 87, 88, 89, 90, 91, 92, 93, 94, 95, 96, 97, 98, 99, 100, 101, 
          102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 
          115, 116, 117, 118, 119, 120, 121, 122, 123, 124, 125, 126, 127, 
          128, 129, 130, 131, 132, 133, 134, 135, 136, 137, 138, 139, 140, 
          141, 142, 143, 144, 145, 146, 147, 148, 149, 150, 151, 152, 153, 
          154, 155, 156, 157, 158, 159, 160, 161, 162, 163, 164, 165, 166, 
          167, 168, 169, 170, 171, 172, 173, 174, 175, 176, 177, 178, 179, 
          180, 181, 182}]},
        RowBox[{
          RowBox[{
            SuperscriptBox[
             TagBox["x", HoldForm], "2"], "+", 
            SuperscriptBox[
             TagBox["y", HoldForm], "2"]}], "\[Equal]", "4"}]],
       Annotation[#, HoldForm[$CellContext`x]^2 + HoldForm[$CellContext`y]^2 == 
        4, "Tooltip"]& ]}], {}}, {GraphicsComplexBox[CompressedData["
1:eJxdlntQ1FUUx3dXdn8TBDr5Qi2ylMxXYj4mndp7URR5OFhI6h8QrWDgZFQa
CqLo+EDzgUCAkmiFykSGiUSK2bnK01AJVNIBEUxIdEchcOW9we+cy4x7Z3fu
7N7fuY9zv9/P+b1mivggVKfRaOL6vv19qUlrGF1sZUucjKalzoWgefrD0Md+
VhbjFH9O01QHjrNeD/+xtZf9tKY6b011I+gnrpieOqaXVYSc37Br9hOYfnb1
0eadPcxb21MwZ9R/MMkrcbxXYjfTXT9SyqOfQvWI971nOHez02q8BWKWjz7k
UdnFPgryn/flt89g68TqyWWpnewr7GHu4+JM+/0dzAXngQsYx9YvTHGpLNSI
IZYrp9wSLOzzD9OL1lo14iqPjs0OsLCF/Y+P1wrfweGmT++0ss0XA1sTM3Ti
uzi3SOORFtZj7W+DRNVeMfe+qYW591xtf/NVO+GnxrUwU/TtP+uYnbhcb1k8
/6SZ9dYUh85apxduOn/nBAczO7hrU21IvF4UYB7YHiU43SvMIPJnhbgoWQ0s
5+iFIcPiDeLs5MGLqs7dY7nqcwZx/f6ISl+/apZcMy+tKVwR5er/VUxX+03f
RxHBcPdwzZlrbMPdBxnpZYr4Vx0vZs8+vnTau0ERbzzc4ZOz4CJbeiWpuvSJ
IioLGjZMG5nBtu8LvVHSrQiN2m69+2vRlJfm9ipi4SV1HOT4tSY1HmR8HM4P
7TT/8aLAOSXGa+BkHdv5uFIR6ekrQ7RbK+HApE7l7wuKOIr7BTF724GYNEVk
43kghc7znpq/enD0iMguf0URv62Y8vDRkn9g4PxD/cK8chvAuOydjGMJBiF1
tJ/y94XxeMWexU1gP3msyWhvELVGn5VJrY9gVRT4hCTrhbOqAzN0+6RASJRe
nNDvtNj/bIau4w/9Pum7n7tX+psZbuX1T6wX8/E+IfXMruxh8+xEZ+aYwKBV
LXDr664XGsfaidi0zKi0zBaQeuhU+1b4ZW2D9nK+TozbOLXeOq4N8gwTh3sd
04mYt0fubu5og/pThrolw3Uizlr48qEgC0i9NRx0+t09yQJ1E/7widFohdR5
Xmrmna5SjTA7uz5wdm2Hm+r+rLCg/LD75jPtkJPlf2rF6l7YlJUXlZXXAVLv
Yf3hfb8n3T6Z2pjQDZvIF7Lfhv4BX/IP+QvkunKeCeS/t9Cf4E/+VNC/kEv+
JX+DvBdrm+p/SCD/Ex/A7Ih8ON/o6jm8zgpSd3LcD/nBeij+BMYzB5pf+saO
1r+O67MptL9A3N+A711x/6yKzic5sJHOH4znZ1GUlx3EkZnIjwEOuVO+8zHf
AxzagjzhBuQJrEee8ELkCfji/XIv5AlsQZ7wZOQJDFLPb8fLkCfgiTzhUn9h
yBN+EnkCg+6oPOE2euYzGep9Geqdm8gPL6IfuLyXePQLLyY/uaOf+D7yWz76
jdv4kS+f1hkbcK8WgnxdD3kuUnjU9rjPLkb3+bf5r6nLIxRu428eSf5PQP/z
UcXIB0fkA7fhB19PfAlAvvCbBc/xh9vwiQcXIb+20Xh503N84zb843txfeZA
6x/B/THiE5c8Bdp/DvE2FfnEAzAfzIHyQfliMl83MJ+M+MRt+M4jif/7kP/8
PNUHLd2nTf3gFVRfPEgPQ6kefU/6IX0xqS8HqmdrSX9S55GkT+IFI16wGVQf
pb6JCwP9Oqqv68gf5B8m55VxWvLXNKrfS8l/WqrvzeRP8i+TeSE+MOIDK6H3
h1zyP/GB2fBh4P3if2uhXdg=
     "], {{}, {}, 
      TagBox[
       TooltipBox[
        {RGBColor[0.24, 0.6, 0.8], AbsoluteThickness[2], 
         LineBox[{1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 
          18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 
          35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 
          52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 64, 65, 66, 67, 68, 
          69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 
          86, 87, 88, 89, 90, 91, 92, 93, 94, 95, 96, 97, 98, 99, 100, 101, 
          102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 
          115, 116, 117, 118, 119, 120, 121, 122, 123, 124, 125, 126, 127, 
          128, 129, 130, 131, 132, 133, 134, 135}]},
        RowBox[{
          RowBox[{
            FractionBox[
             SuperscriptBox[
              TagBox["x", HoldForm], "2"], "4"], "+", 
            FractionBox[
             SuperscriptBox[
              TagBox["y", HoldForm], "2"], "9"]}], "\[Equal]", "1"}]],
       Annotation[#, 
        Rational[1, 4] HoldForm[$CellContext`x]^2 + 
         Rational[1, 9] HoldForm[$CellContext`y]^2 == 1, 
        "Tooltip"]& ]}], {}}, {GraphicsComplexBox[CompressedData["
1:eJxdmAt0jVcWx29eRBKKiMhDkpvHoB61pDEh5Gw1ItMQ412UEK9EqiphSplp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     "], {{}, {}, 
      TagBox[
       TooltipBox[
        {RGBColor[0.24, 0.6, 0.8], AbsoluteThickness[2], 
         LineBox[{1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 
          18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 
          35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 
          52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 64, 65, 66, 67, 68, 
          69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 
          86, 87, 88, 89, 90, 91, 92, 93, 94, 95, 96, 97, 98, 99, 100, 101, 
          102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 
          115, 116, 117, 118, 119, 120, 121, 122, 123, 124, 125, 126, 127, 
          128, 129, 130, 131, 132, 133, 134, 135, 136, 137, 138, 139, 140, 
          141, 142, 143, 144, 145, 146, 147, 148, 149, 150, 151, 152, 153, 
          154, 155, 156, 157, 158, 159, 160, 161, 162, 163, 164, 165, 166, 
          167, 168, 169, 170}], LineBox[CompressedData["
1:eJwN0Oc2FgAAANBPUoqS0hKFKFS0UaSJrMoj9AC8lnOKStpLiLIr7SQzkiQy
W/fHfYEbf7GirDwoEAhUconLVFHNFa5yjRquU8sNbnKL29zhLve4zwMe8og6
HlNPA408oYlmnvKMFlppo50OOuniOS94STeveM0b3vKO93zgIz18opfP9NHP
AIMMMcwXRhjlK2N8Y5zvTPCDSX4yxTS/mGGWOeZZYJHf/OEv/wjIDWIJwSwl
hGUsJ5QVrCSMcFaxmgjWEMla1hHFejawkU1sJpotxBDLVrYRRzwJbCeRJHaw
k2RSSGUXu9lDGunsZR/7OcBBDnGYDDLJ4ghHySaHY+RynBOc5BSnOUMe+RRw
lkKKKKaEUs5xnguU8R9yolaz
          "]]},
        RowBox[{
          RowBox[{
            SuperscriptBox[
             TagBox["x", HoldForm], "2"], "-", 
            SuperscriptBox[
             TagBox["y", HoldForm], "2"]}], "\[Equal]", "1"}]],
       Annotation[#, HoldForm[$CellContext`x]^2 - HoldForm[$CellContext`y]^2 == 
        1, "Tooltip"]& ]}], {}}, {GraphicsComplexBox[CompressedData["
1:eJxFVglU1McZZ0+OeHALcomKeNRIbCMV0PkEbxHrBcaUPMESwWc0lWhQFJQj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     "], {{}, {}, 
      TagBox[
       TooltipBox[
        {RGBColor[0.24, 0.6, 0.8], AbsoluteThickness[2], 
         LineBox[{1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 
          18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 
          35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 
          52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 64, 65, 66, 67, 68, 
          69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 
          86, 87, 88, 89, 90, 91, 92, 93, 94, 95, 96, 97, 98, 99, 100, 101, 
          102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 
          115, 116, 117, 118, 119, 120, 121, 122, 123, 124, 125, 126, 127, 
          128, 129, 130, 131, 132, 133, 134, 135, 136, 137, 138, 139, 140, 
          141, 142, 143, 144, 145, 146, 147, 148, 149, 150, 151, 152, 153, 
          154, 155, 156, 157, 158, 159, 160, 161, 162, 163, 164, 165, 166, 
          167, 168, 169, 170, 171, 172, 173, 174, 175, 176, 177, 178, 179, 
          180, 181, 182, 183}]},
        RowBox[{
          TagBox["y", HoldForm], "\[Equal]", 
          SuperscriptBox[
           TagBox["x", HoldForm], "2"]}]],
       Annotation[#, HoldForm[$CellContext`y] == HoldForm[$CellContext`x]^2, 
        "Tooltip"]& ]}], {}}, {GraphicsComplexBox[CompressedData["
1:eJxdlEFI1FEQh5fMjp5KBSE0t6NLl6RDMoKIrZjK2ha2BiF06CASHUovHrt4
UAMhYxXCkhC0S1FmDGRsB4VVQVlcD4q4UrmuB/FY5n/mu7iwPHjv/2bm981v
XlV3b+zRuVAoFP//P11f9GQ/9WRTurjaMFaeKOjh53SksvajdtX0Dj58U9BQ
8MvcnM9dbbq0VdCFL8G53PfzPbsvP/3+2OVnox9ep6Xxet9m5/cDTQfn67I/
mnx5ZSmvN8Ils9+mMnJ7crryyfO8Xhh+OvGgflPKoyPh6Mi+lrTdXayo3pKV
4h/vVof+aPx0O7wtLZHdWGT3t+4F+ztSt91/cabpl67V9w/MxHMyHeTJ6fva
5cdFyZwM26oLti/z9p3G7J4sWRxNWFypszy6Y3ml0BrUodesLpkcCurUhNUt
R9WBDj02XTJhOrXNdMt54wBXgXOncZOUcdSvxlXgfM/PX80Z55Tfh3Ozx293
znnPD+c7Xl+Zc6b+t1a/bLi+v6ZPml0/nG85nw3nDL8555x0vqzs8x33iENc
8pCXOqiLOtGBLnSiGw5wgRPc4AhXOMOdvtAn+kYf6St9pu/Uhy/wCb7BR/gK
n+E7+OBLfIpv8TG+xuf4Ho7MBXPC3DBHzBkcmUPmkjmFI3PMXDPncOQd4F3g
ncDP3hdtda5Hnh+uHT7npeZHPVOvug/0n3Ptcr1wjTqPrHOFV8a5jjtPVvb5
jnvEIS55yEsd1EWd6EAXOtF99v08AXmc2uI=
     "], {{}, {}, 
      TagBox[
       TooltipBox[
        {RGBColor[0.24, 0.6, 0.8], AbsoluteThickness[2], 
         LineBox[{1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 
          18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 
          35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 
          52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 64, 65, 66, 67, 68, 
          69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 
          85}]},
        RowBox[{
          RowBox[{
            SuperscriptBox[
             TagBox["x", HoldForm], "2"], "+", 
            SuperscriptBox[
             TagBox["y", HoldForm], "2"]}], "\[Equal]", "1"}]],
       Annotation[#, HoldForm[$CellContext`x]^2 + HoldForm[$CellContext`y]^2 == 
        1, "Tooltip"]& ]}], {}}, {GraphicsComplexBox[CompressedData["
1:eJxVWHlYjekbrhQj7drrVKfTQsbIDClTPa81iZoxlrEPIzElpTDWCQ0mmiGR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     "], {{}, {}, 
      TagBox[
       TooltipBox[
        {RGBColor[0.24, 0.6, 0.8], AbsoluteThickness[2], 
         LineBox[CompressedData["
1:eJwl1Gl8CAQYBvCNjdlhbDabOTbHZuwgZxElypEj9y3kCBmVSFEilRK5VW6h
3Ec5y5EzR67cKUpylSuiqP9+Pvyf9/Pz4XmTumQ17RsYEBDwkMi+OchJEMHk
Ijch5CGUMMKJIC+R5CM/UURTgBhiKUgc8RQigcIUoSjFSCSJ4pSgJKVIJoXS
pFKGsqSRTgaZlKN8dg8qUJFKVKYKVXmYR6hGdR6lBjV5jMepxRPUpg5P8hR1
qUd9GvA0DWlEY5rwDE1pRnNa0JJWtKYNbWlHezrQkU48S2e60JXn6EZ3etCT
5+lFb/rwAn3Joh/9eZGXeJkBvMJABvEqg3mN1xnCUN7gTYbxFsMZwduM5B3e
5T1G8T4fMJoPGcNYPmIc45nARCYxmSlM5WM+4VOmMZ0ZzGQWs5nDXD5jHvNZ
wOd8wUIWsZglLGUZy1nBSlbxJV+xmjWsZR3r2cDXfMNGNrGZLXzLVraxnR3s
ZBffsZs97GUf37OfAxzkEIf5gSMc5RjHOcFJTvEjp/mJnznDWX7hV87xG+f5
nQtc5BKXucIf/MlVrnGdG9zkL25xm7+5w13+4V/ucZ//yB5/IDnISRDB5CI3
IeQhlDDCiSAvkeQjP1FEU4AYYilIHPEUIoHCFKEoxUgkieKUoCSlSCaF0qRS
hrKkkU4GmZSjfOCDP/Y/7c+GlQ==
          "]]},
        RowBox[{
          TagBox["y", HoldForm], "\[Equal]", 
          RowBox[{"Sin", "[", 
            TagBox["x", HoldForm], "]"}]}]],
       Annotation[#, HoldForm[$CellContext`y] == Sin[
          HoldForm[$CellContext`x]], "Tooltip"]& ]}], {}}, {
    GraphicsComplexBox[CompressedData["
1:eJxlXHc8lt/7t/feezxESilFu3NaaFCR0dLQjpYkDRKVUElLIpX4VDIqUUbn
ZBRC9k52ZqgoNH6+zu14PX7943V37ueM61zXOdd4v2/N7Qctd3JxcHBY8HBw
/O/v5y27kGpQB+AY+aeNA/bYasupfQFWcKJb6ZAWTneqTnCqbgF5dZYeKf1a
eOZt+bsXA1pAYprzm7XD7X9znu0PT6wHLvrlXfnD7daB2ssDtevBqrlfM650
aGELkcfcth51IMz00cqnfVq4YoPCrm0PKkCQwvntWb1a+ONI/2Ug59pFIYe6
4ee/R4vMakqAT25NBV+PFt4Lgtt+PvkAkniMyt92auEvI++/A8u7tNcYl2rh
W3v5p38VegWm9IZqtX/UwmQdFfOzTPANwRwtnPcvbttQyhvEcXe+4Pk0LQyC
xN5+TMhFP+zNC/8la+EwMj56N9CvEfdCC5+cVb7kVU0d6tvt1ib+WAtbznkU
mbmpHiXl/naXfaSFN2j+WVzvVo9sBS+sXxCmhUXDLG+rR9QhOWddtTshY/29
lZw+SdpfCx+3myixHX1EofbIlctTC18g80c2W4HVTzctbK5g985F5wVKLyk9
ffjg2PzbY8xPVe8eXu/aKzHc4Y9B44ufN95vH1u/x5+NEchaCyvzGVyz214M
RsS+fKz9r0pvfbKuFn4wsL0sKy4JhNmHcKRLj/UPN7Mup/5kYWGLShiqGI7+
96uELhae22p7ofbTK9T36149TwYLl10pX+V4NRONdB/IwjsNP9+1THqHZtkZ
vsq4ysISmYaHW3PSkLh73llVUxa+Vys+fd9/t9Bmh4+s2MUsOt4ljt0tTYdZ
OHbthfu3r1wHsmEX5motYmG8f8A37G4mOOawKzJ/HovOf0LTEeGrq1n4Zzyv
48T1H8BFbz+7IjMW/lzj/bl7YQ54ZiSz01xv7P3Y4qUW2RNY+Ok7m3qo8BYU
ZG1NylcfG//sPlE1KTEW7p+QckFROR5xt7S3hXOz6H5Yc5Z1bejXxL+3tvfG
rilDyv1cEemfNel+Tgy6mxpeq4kPWn7PCvxRhmr0HT8b12jiqPxm54DdFShh
5D1NvOjSUQ6TQ3Vol9OabxMLNPHPMyv+2rjXIpW+MEebu5p4mqf1STf7KhRS
oGWvEDLWv7n5/ECDYE1s6TnTKD+nGG2fJfrbO0gTD2pGFFcb56IiHedXTjc0
6XzLHtlNCUjXxBu4F1T4Tk1Dj91O+L0I1MSRIoPeE86HIv7TaVLplzXp+vPn
TzX2ixn+/WfXj0YZt0F38helBn9NXHh31xHL0gwwv1jSScFHk8rzXQE3OH9b
EzdcN8MPhHNBSPyEEnxdE+dvXF/AOTsXmAkEx17aN/a+0T88Y/9OTSy+d9/E
QwtSgNJuFz3RzWPjpzkXHrywWhN7bOXcznfyFhoMtM5dPW14/akdHYdmZCLB
tWvmG04eW9/GjlT35EnD8m5umP11ZRbSi9NfuW74uVq9ZuimUxkaUUftsfeD
3OsslIU08VlLcYkKpXT0d11Tq06FBvY2MLltqXwdRb2/Mc+wWIPOp86YJR7y
VQPPC1X+xLHmKtj6PDEwt1ADP5nsaTh72jtw59KGPYUfNOj6JnY7fFQZ/n1/
wH7e/swsoLbT60V+gQaOqhm8qlSbDcoja2oVUzXwt9dGq1ueJwILlsgjldCx
8ZIb1u6WOquB5++Rctq96BjSW79RwOOQBnabYvH9WvkzYn9OGpinvbEXTsxA
hrqR5bKqw/O7hj19HjP2JzXWX8/xPHW57+r4eqJ0dlH3a5DIG6hzrFSdzneS
bsyUz2/UcWbNPN3FViWgI3b39Tk31el5u6P08rxHvuq4V6J0wn9LKoDo2s1H
5nqr45fS7nDy9E+AzEcdVwpG5phGlwMl0elzb28d+73uauEpkfbqGDyz4bLA
pUBq/4Q6nk1j49+vc/c4vkQdb/pmU6g/Owb8EvjgaTJdHWeELrxyY2EiODY4
32ZwkxqO6F52T2NzEWi03VvYZKpG+z/kfzjRDqphi8lrD+h5VIGKja7J8+aq
0fvl1JZbfjpT1PBZ9d8LOWwbQWRv0htzEzUcfZl/n+xQE2g8GSwoPF+N3l8X
DFO3/FBUwzds96bY3PoC5qY+0zgtr4anjShSJ7jG2zgjjU8Na3/bEm994ytz
H461c9w4OlNiUBUf+ZE4L3hrJ9jzsomVM6CKF4ZVcNqf/AIK19/r5+xUpeM1
zfovfEabKu7PchX0lmoBu/yschpaVOn8s6oqpWwrVPGXUJmC/fJV4K+joxrM
VcV6PDAiQakS+AYef7EgQYW+/3bPW4+mSBVsc59nEXd+C3jOMnfuv6ZCx7Pr
uhyUPfy8YZdl17nGFjBr4rbJq4afs1ZPadpn8QWQ81sFnxjZ2DbgUJnJP2e7
Cp5eY3fdy78deCv7HQlYq4L3m+eVdtW3AQPReA236Sq4VOb2kiavNhDEcvY5
NW1sPM8kTRuPKyr4SWCb0caQJqD4eIBvjZYK7kq6M+2PSSPItsyRTlYfm39P
lp07n6MKLokV1r8aXQu4l4EuHVkVLJw2f56+TBUYPKsZNiCmQvd/S/mVyEtm
KljO813he61CYDcI3+Ubq1D9ym9+ly8zQQXPnbww8+uKN+D4mtN7VRVVqH0s
+PGn/w6nCj40f6d508F3CKjrcuXUKtPz4imXkbrW8DP3tMhnvNrvUU76s2PP
Pyljh2rBYwuCs5jzXBlP9K376PShFHmg/a+ccpTpeS2udWWvxCFlrJvxFv42
qEDmAgvytd8p42lTgqTWCdYhmXrBHt5Xyrj3dUSvQGUdWuskc5R7qjLOXmNx
wNe0FpmNyEUZi4zsSw3yFRO1381SxmKLaiQkd5cjyXPe0hXKY+OZ/np9/4Gs
Mm4RjSuVzClFq2ok/U5Jj63H/lmARvhfJazldXvxX/EoBLeErTryVYnK4+i+
3WHhX5SwheCcy3GOz4B2TMf5z7VKuOz24vcvOwqAAO/knJuZSjg0oBdIBH0E
mbwT3hfqKlF5B9jNT+TQVMLLjv6rmLEjESyoVFrgKKOEgZOeRf/+BKAracTF
LzM23mOvWqvJ4krYpMZpaYpqPPocmGVvya9E55sWc6bH+o8iNk7papUxLkZe
CTcGp/Uq0vVWV7IunelQxIcTDBa3VFWiQXXH/qIWRbyA6BP6wZOpF1WpiFe+
Td/WtbQFDRSsPx6VrYijiH4i0Wm735W+V8TTDMViT1h+QX9npIqkZg6Pd0jf
U3FVJxp5LUERL66deUX/chvaEB0V6LV17PcPo/VKbYMV8aW6P8HzDzeh8Gcn
tUzMFbGVnYaG//FGlHb881yPFWPzeXXPYdOOU4r4fbKnX+yOWuR3zHGN6UJF
fCDh9p9tO6qQf9P+pVdmj60v91po4yF7ReySwF/f3FKMjszbfNrMQBE7HW92
sY39gGzX/DIP01Gk8qo7X77vNFTEJtuVnWYXpaENHBZPlmso4h71FG/b2OtI
839/ZBSp/H+4SX67yFLEA4szF5avuAoW/e+PpCI+cijhuqfXO9CpK7kNcSnS
/RVwWul2k0cR87zInf9V+z3Q8zXgWTXcrqb5yTppYw5zHipS++yxF0tyyFDA
q+YY9jpqVwCzaxtEDnUo4KXZ7vuVBOtArclKnqs1CtT+eXX/0/h3WgHPsgEf
eg40M/7qWPu/O1uTrOcq4Cb46d3513Vgx1wOVvo8hWF/YqrQ7NMVoPaHdBe/
gQId38rloEWCvgKujv68eGZrCbi2R3CoR08Bx3t92LDo9wfQFK7Xp6qhQNcn
OW+lYpOUAq54IdjzMgmDtzelStQUFPCU0lbvFb+iQJsl+DNDUoHKL9gXm03+
J4+P1CgsikqKR+pvlzbP6ZfHEt7++XtdCtCAUYZVRoM8Nusp/VsWUoj8Mzey
bA3k8R9Z/uTy7U9Q08m1u2ZIyNP+vpV23OATlMc377eDHetCgI2dsnLaTzm8
uCjRZnNHBrjmWzPna7scnW+XZ5HYmTY5XNeL+mJcs0DZ1SK8ulUO1/hlTyrv
KwHkfJLDTQF6pwLvlYEvq6dx43K5sfv9vNW1M3lyeF5coK6aXjm4MvAxNrBM
Dm+us+0qta4DruXbJt98K0flf3efr0mQmxxe1jXkWtDfACJP/xOrspfD23rc
7ygNx3fnTSoXLpKSw8knRSu7nOqAS6xmcqro2HgXtwy8Mfgti6UaNfXd1pSA
kIHjHI1DsnjbSP+FwPOq6ZKyflncmtXYskw+Dxxa/fDCi2+ydL3WDoNhGq2y
WJE1s/P16Tdg2wW19OgvsljAQye+MTgOmP+yStJpkKXy1Ng9dEayRBbLmqlX
HDKJRzqyGeeOF8vitGsndmb8eoUm3+fuul0oS+2nY9/vbVxYFpu+PB+b51OA
0kxizfYgWZzZVZL5sqMQVai5b3ieIkvtc97AtuPCL2SxQU/E9Y7EKsS9ZcVr
9yhZel57GyXN/vyfLJ4fKBSf1FOL/oatdVsQLkvPg7NH/mo13ZLF/jcaUryd
G9BS12a9G8PPG5Q1Cj8PNiNtzQlBWRdl6XljcewfT6mXLF5WsdOw/sQXNIXn
84oIT1msQPwPpHiCoyXz4PD76n7djhO7UNWIAoy1++aFN57dK4v3PT33XwBX
K+I6aHe6yGys/6ntTnuvQFlc9Ox6q31hE/ry3MNU9ZcMjhaIDDXub0BzhUx/
iffK0PkX8c3uviMvi8X4ywN99n9GS/5ET3nZJINfHR1ou/ijAtUmt05zqpCh
8jqmxeXy6KsMPvHEe53VzFJ017RG2rxQBk+OM59uPvAeeTr57s1BMnQ/FGHu
YHymDP5wZ4f+/MFMNHhVaLApVQbvPP7ITVMrFTmOnM8ydL9vPHMp530og3my
BSbsH/IDgrbarz49ksH9mc939c1LB1NuGkV9vi1D9eka66iy23kZnFjE0Rw4
HD+axC1b2h4og7edqIxz6ykGxik2U/R9ZKj+Xr12ZEvnHhl80L/CL9GtCngJ
7i7oPyWD319dH/NrcS1Y2OAae/yYDLWXKzyHw7eslMFptkFFluGNAG332cS9
WwbfKuksTV7RBEwFbk/P3CFD/SV/l4NfiqbIYNVLonoqIm2gfYlJvqyJDN46
te2xl0AHWK9lHTt7ugz1N31bnCabSMjgnzw3+r4mdoN/I/+kabtW7w0Xg2/S
+FxLtd/C4g7wZEbbU7VWaeyw8nqxhVkrWNm0p8ahSJqOn56TNKBYKY1vt+0p
PvO2CZyIveqQliKNCyXfojenGoH4If3Dg/HSdH3bH34+zYOlsdlG/tka4p+A
7qKu8owQaazose7BzZ/VIPIlh+aXYGkqP053Hq7uSGksw5sagpKLgKpwh7O6
nzRONbvhymeXD/Z8t7ATPCdN9+eerd75ykvS+M3mZq43BRhIl7aKn3CTxirm
fE/cucPBpOmhVyYflKb7D6ZbCGUclcYbXE6EKsbdRYJhLVElu6WxASuQZVqW
gboOdLwzXy9N9atWyPlyzEZpLDu0ZF/GqSz0d0+TqYGNNK5a0ekuUleMyP0j
TfWXeznra9Vcaezbm9qww74cWf32Ve+D0nhtov3J/tl1aObeAIVnk6WpfQzM
6nytwCON9fvmPObd1oBmHjfRuakpjecYFkz9OXPYvlNN31rLSFP769FJOGeT
J4X/8sesHTRpRQdCOhOTkBS13xbZM2uv35TCcy9FzvvD08XkW8baG4R9XZ0C
pPAVCYNT+wK+oPclX/wen5Si/S8eePIn6bgUTrWKPTXjXTNqyVz16f5BKew9
tcSkI7YB3bGu4andKkXn/6Dlg5fANincMVNb0l+lFk0e9AjxWD38+6LlRy8f
qEZF25MV5JdLjcmnpFPQZvhZ7WZ8zq19hWhqdajsSUMpfCYjd/Gx3AIUaL82
ev10KSp/h7eiAeHDz952j0LwwxSE/1NnJahL4fSy3S3NOrFo54JHZ5MVpej+
psdMlesdfq6z4G5MfvsIWB69P7VXRArfDd0Z6MabBmar/LNV5ZKi+qMdsjpk
4fDz8+JSsPBFDmiCWvP0ByXxsSDD1TbtpUBkyHqKR7sk1U/vi4dY/sPPORP1
SgR1apn7UxJfuPqjzLOoDoQ43Xg0uVCS6n/T/PitPW8kMbe4yw33O/VAw37t
lIBcSfxzmePjJ5HNIMVninVpvCS1r7frhfvnH5LEl1+IhtQGt4I/2kbBHuGS
eNdg48niE+3gU3gmp0eQJL5z/F6NmHMn2JjLCnSbKImjov/ubVzfCUg8IIlf
GkatDw35Ap7czlnnKDLWP7D/cJQ1/Hzqk5aMVGEzAPfySky4JfHbFaFRcTEN
YO7J0lMW3yXo/JOTTr9L/CaBL8HbvuuFagHf9cdBEXUS+E6m2tAFz2rwYVPd
w2lVElQ+s+SnKZhXSuCHq5V5M/0KQeqri7uepUlgFTtwyOZeAegqSCqpwxJU
/i+cG/Y2IAl87hLnXYnTqUDa/ynf3RgJPD/p3v5Vr54O39dLj+r+J0H3d1rB
9WTXSAksZloS17w3Eu3b8jHSN1gCK1vFPDnflIai1T9KH7gkMRaf6ZuKig4/
r2jfp3vyezbCht9MXM9L4O37WLMDTpYhMdP1L+KdJcbycxcH7B8MP0+3W7mg
zruSuR+H+wv7Y11+qg55VQicRnYSVP85F9VuXLlIAgefSY4qlm5AYpVKsfmr
JbCqC1et4PpmlHXLcuu+BRLUviYIz+J34JfA5jHedxIzWhEnf9A6wVZxap+B
T9R39gWL42b5IzXpeV9R5cj4Y+3Gb6Q41azFseVQUc8cvlZ0sLg7l1tLnPaf
0LbOXVdOHHs9kra3821CAZnzzh2uFMN/2kTkQx41ovZ733fH54rR+RvJ3hqa
Vi6GN02/8jfJ6xPavtDVMDpIDEs6PczNtqxGXeqvz3ZcFqPyeQkrj88dbm+3
OpHlcLIYGWnlLuB0FMNX79V52SrkIgOrgpB8KzEqfyNH5f4l68Vwd2eOtmJL
GhIQ0FxuDcRw18HzXxKe+aDD//ujIEb39+Wtzc7mSmJY1qrpVbHCC/B35L4S
xQfWhQpO0sgEu9T0M1c2iVL9qey9ZqBcJopf6NxQCjbMBod3ZMy5VCWKrXap
PNDxLAFi6ntUE+NFqX4eXVH4TPeyKJ6Ned39BKvAs5dKpvODh/tn7QOzjwzb
s/pDF9Y5Uar/EuFiM2eaiGL/Y1t/NqU0gh6+w+s61oviZd0bvz6c3gTsNery
LlmLUvt6OrQyAf4VwWp8oprHM1vBnFg19EFEFItWTfv5Y18H6HjYbqBWI0Lv
X7N1F2ebJ4jgaxHrunwOdAPWyP+PtSduDUtxXC2Cd69IOMda0Q4Grlb33EkQ
xs9lBL2LC1sB1++DKZMfCNPx3S74Lq/KFsaWatd+bApqBqzIBDcbF2H871N0
8Q/vejC9+V3Hk/nCdH3zYlzKTJcK4wXfDjrcaqkDq5KucknOFMZe+WkRQYGf
gcnIe8JUfvj8Yf/Yn0I4oT1wpduiUtDomZxs1SuEe7dM+zdnWS6YsCTMuy9P
iO7PdIfk4uIUIexQNM/8besbMPha47hmjBBOXDLnleCvODA5a/tQYYgQ3f8H
gFf5l6cQ5m7V81G5mYCiJ/1a679fCAvHZstemZ+IcpYeK4jeJ0T1S0Zl9XYV
UyG8pH2+2Mu6fGT8Xb/RYJYQ1rrzoaPwQjFKKlX4YqEpRPX33K+gx1Bk+P1D
hp1T5lUilLztaDGXEF60U0oQ3qtDT3Yl/+kuF6T20V/S0LOjUBDPO2Dlqv6q
Ee0f8ScFcVbv3BVFU1uQc8rlwHg/QWp/AQ82r86yEsSTP5qdut3WhoS9Np5a
810A73pfuX6eWxfS4rmjXn9WAG+aMss0VbsLeXSEXbygLUDte4WKnn+xkgC+
JdcveHagHXXLP/jwrYEfS4X7bGCx2pBx+ea9ron8dLwLCw9rtr7mx9e3C2V8
U25CJ+KuOK/y48caeo4lOtIVSPvcpaodXPxj968X5yrJX3y4L2T/BQvTMpS9
Ozukt4sPH5+6ROTLiWIUP/IeH261rOPXW5ON7NU/cLLi+ai8l60w65V/wodv
vmzQSLFMR0YNJ0MbHvDhsJabEs8y/kNyUre/bTjFR/fz2aKnVRI7+HCCEpdk
nOIzUL/JyvieJR82RHr/7lUngY88uxuvLeWj+qIyRyJDUI0PW993zvm4pgBM
OGoxoCjEhw1+vjuyaGcReLqsx+HUb16qjxemHY3mquDFqQoTPkXkVQLjTuO6
Px948XvnE5MSt9WBkwsVwp3u8lJ9/65bcXPoKi+WMuv4uSCiHpjuUH9ff4kX
Nw499zZSagIVI+ctL7Unqb6oTW0KvHh/u8snVlEb0A2LXB6dykPtc5mHYTLH
Xh7sPPDI7vRQN/gzcl5x0/ZQC8/igFvc2MsAuWz82AYuiZsG8Czhpv3vzbYU
Dmnlwm7lj6IiBZsY++fCJ4Wjnz54UQ8qJ8UJnzvARedfJsAV1r+TC7fP9VTw
mVcHTJ33BvHZcVF5uL9OV3YT48JHS3e0LJ9UCOSOeT3RruHEUw6VztDULARD
a89VVldzUnnr7DsXNJTAiSX5uNp5tyLwY/biPrNbnFgtRETX5tgDEJ+B7+8/
wDlW/1EylXXfwon1TvgvlZe9hRZERbumWHLiI9M/ZThkv0HkvOCk+pK9fJZP
Oxcn9hFe4ss6X4y4z19tbH3NQfUxmCviUeUdDgx+Rwbszq9BRzQ6RGfs4qD2
tz9ZKjtrJgfO2BPc4RPdgETWrpNTVOSg+u/WylF88M4/dMbs0sFW9VZUOrJ/
/1BadoTXhuftaJLrT190+i8ata/B1BLZ8vw/6Lz1d8mG/m6kNvL/v2n7wN6P
h44FDKLHFrZBX3M6UJhdyQsfpUGEjPc/PsDqQHtG7H8AyR2S79Q2a0WGVQrF
HhwDaHQ+855l3NmCfiGfXP8fKXub0OI3XAomMr+Qc19xSgBnI1ql/qKnM/sn
Gl3f6k11uvjoT2TkJu6/7XcNejbSTz9amM55N/xKBVpeIblg64F+NCqvvhcK
Q5eX9KMvr7nSqniKUTqMGMhq7kNWzXbd61cXINEHdb084X1oVP58PzeHbJzY
h2TaBpfd0MXoooSK2MmyHyhBkGNV2GMXJPS/P7I/0Oj+ys0NXzBR9AdyWSa4
KfTPGTA4os/f0ST1IkUnXQxYZfadHnrf0aj+dCKBnLk53xCftH3bZ1YJ6Gv1
SnlZ1ItG9fH+zYPFm8/1oqbUo2nO38uBWYtQ7rV9vagmOJZ70pIqsGREDr1o
VL//fs+bMjWvG9XdCg6fr9UIwi0EPL4HfEVcA3f/a9zYAkb3adR+Nje+3mEr
3oke6qqmhDi2AX/yF32Uv9ce39kBRvdl1B6b4o37nM41oxPPf1Z0/usCF4Yu
/jEKbEBbbj3V+B73FYzuC588J++3Sd3go8/+wiL5TyiyJveyc2o3GN0Ht5Cn
RsoV3WDd5gd/NgwUooNK02tLh+1/VO5HqxzWrfvbDbrWTOr2tHnOyLcH0Dw6
0x69dqQdjP5+VK6uTP9nSf/gITP+qFw5mPkJXRyZH7Bj5j8qx6PM+m6T9YHR
9deS9YM3jHxG5eikIXbh0702+nf0/22JfEHjLyL/0X6KmP2JJvtDx/1D9g+4
M/u7muwvyGT2fxXZf7qOB0Q/gA2jP11Ef8A4/QLNakT/dIj+ARdjop98I/L8
QeUqT/QXrP3meWPNVIycDCY/DC/9AcbZA0hZE1qv8bsIebf4eQY39oFx9gW2
MvZnTuwPxDL2mUrsE2xMmOxna1+HYqrLZf0W/qR6Y0HsGaxk7H0psXcQxJwH
JuQ8oHo5n5wXoI05X46S8wWkMufPA3L+UL3/Qc4ncJY5vyaR84u2D5HzDcQx
598Ucv6Bpcz5WE/ORzr+KXJ+gpfM+SpGzlfozpzHh8h5DMed13Abc57zkPMc
jso3i5z3cPZUch+sIvcBfOVK7gtA7gs47j6BE4LJffOc3DcwjrmP+sh9BMfd
V9CO/T6DU5j7Tprcd3BUvzzIfQjzmfvShNyXcFRfy8l9Cv2Z+7aK3LewgLmP
J5L7GI7aw25yX8NA5j6/Qu5zOGoX98h9D10Zf4B7ZJ08tN2U+AtwI+NP6BF/
gvYvTvwN6MH4I7XEH4GcjL+ynPgrdP4/iD8DG9n9HXiL8YdmEX+IysOH+EvQ
ifGnnhB/Cuqz+1tU3qrEH4O33xB/rYD4a/CqMvHn6og/R/eT8fdg3hfiDyoQ
fxBOYvzFmcRfpPpiQvxJOMOK+JtbiL8JHQ2IP5pE/FGoFkr81Rzir1J95CT+
LPw4kfi7GsTfhaP2mLn1dcJvO374kPGPTxH/GI7q/0XiP8NE/piKWTc70EKZ
NUBDSADuYPxzL+Kfwz2M/z6J+O9wHePf8xP/nvbnT/x/+Iw9PoCpTiR+OEzi
Bzq/nyS+gJuY+OMxiT+gEhOfYBKf0PWeJ/EL3MzEN69JfAO/tpH4ZxaJf+C4
+AgKxZH4KYvET3DVFxJfxZD4iu5fOIm/4OalJD7TJ/EZ9Cok8dsAid+ofhiS
+A4u2kriPx0S/8EzTHzYQOJDOC5+hLc/kviSnA/C0Jo9/qT6bUziU1jNxK9T
SPwKdzHxrRaJb+G4+BcGMfExJ4mPoSsTPw+R+JnaYyqJr+ERJv4m9i5C21eR
+BxOYuL3dhK/QwH2+J6OH0PifziDyQ9sJfkB+JA9f0DXJ0nyC9CUyT8kkvwD
PMjkJ+JIfoLKz5nkL6Auk98QJ/kNOE2X5D8OkvwH3Z8ykh+B4uz5E6hoTvIr
PCP7Lkb3/wXJv8DNe0h+5iDJz0CTLrb8DdWvmSS/A9WZ/M9Ukv+BMutIfsiY
5IfguPwRrHEk+aVOkl+C3kz+yYHkn6h9zCL5KajQTvJXbSR/BTcy+S1/kt+i
9veK5L+gPZMfO0LyY3D0fpxD8mdQUYHk1z6T/BptDyb5N2jG5Of4SH6O9q9D
8ndQiMnvZZP8HnzN5P9ESf6Pzv8fHMkPwkPs+UNYaEPyi59IfhGOyz/C6+z5
SfirjeQv35L8JRyX34Tn2POfMGkZW36U7i+TP4WnX7HlV6HxZbb8K9WfeJKf
hfW2JH/bSfK3sIg9v0v1czbJ/8KP7PlhaMbkj3lJ/pjqfwrJL8MyJv88j+Sf
4Xb2/DS1L0jy1zCTyW9Hkfw25Ikh+e+VJP8Ns5n8uB3Jj8ONTP68luTP4T32
/DrtP4Pk32Ebk59PJfl5qMTk79VJ/p7Ov4Hk96Ere/4ftumS+sArUh+A4+oH
8AZ7fQF6MPWHZlJ/gOPqE7CevX4BuZn6hhWpb9D9zSD1DxheylYfgYPs9RM4
rr4C1zP1l6uk/gIXsNdn4Lj6Daxjr+/AN0z9ZxKp/1D9Dyf1IXiNvX4En7LX
l6h9LSH1JxjE1KeySH0KjqtfwdNMfUuH1Ldoezupf0FOAVIfO0zqY7T/XlI/
g/rs9TUI2OtvcFx9Di5ir9/BZKa+Z0nqe1Q+HKT+B58sJ/XB66Q+CCsGSf3w
H6kfwnH1RXiSqT92kvoj3OzMVp+k+8vUL2HVSrb6JuS0Z6t/Uv1h6qNwD3v9
FM5i6qtqpL5K9ZOL1F9hpztbfRY6MvXbiaR+S/XfgdR3YQd7/RceY+rDx0l9
eMy+SP0YujD15VWkvgxdmPpzFKk/0/tXh9SnoQwvqV9zjchBhrZfIvVt6MPU
v21J/Rv+8Sf18TZSH6fjXyH1c+jN1NfNSH0dVrLX3+n6Akh9HoYy9XtA6vcw
kqnvnyX1fTiu/g8N2fEB0KiY4AeWEfwA3Z9Agi+A/uz4A9hSyIZPoPt/neAX
4LqzBN9wiOAboHkIG/6B6pccwUdAn1iCnzhD8BMwnsFXhBF8BdVfF4K/gEcY
fMYngs+Aixj8xlKC36D2UULwHTCAHf8BWxl8SBvBh1D7m0HwI3Abgy/hJ/gS
ar+BBH8ClRh8Col/xtqVCX4FGjP4FgOCb6H9ryH4F+jK4GMmEHwMPMLgZ5YR
/AydvzfB18DzDP7mD8HfwG/dbHgdOA7PA9W+ErxPGcH7QE52PBCVfxfBC8H8
QDY8EVywnOCNJhC8Ed1fTYJHgl8ZvJIFwStBXk02PBPVHxuCd4LW2Wx4KDgO
LwWLGtjwVFRffQneCt5lx2NBNwav5UPwWnAbg+eKJngueGKD/V1D1wrwdaHD
nmdv5Wh/mwheDEax48ngr4sEb/Z65D05Or8DltudJerl4GV2fBpdH4Nfgw/Z
8W2QO4zg32wJ/o3Kj8HHwW0yBD/XSPBzcAc7vo7uZ7bto3w0Vx4m5zzouL+6
Gvk16g7GseThtcURW53ufkIVUX16ijryVF/ig/j2h1jJQ+E8f66+Tw0od9HO
PJWN8lT/7lXu4HdzlIe/T8zZpvSwFZ26YHJlxnp5uEdFYes3nw4UwM29Su2w
PNVnf6X0cOtz8rDpfsw5965OJPrmwPGG8/Lw0tkD5m41nci6IFrvyh15mF2/
omeicSeSMFaenBc6Nh7KusFnFicPTbdvULrl14B0uV+/0UPy0OGPk517Xi0K
GjLw4c4ZW2+0XtR/r8vlIQeDPxwk+EOYy45PpPK8Q/CLkK+MDd8Ib7PjH+l+
SRF8JGxlx0/S/RapnZN7S1sBprDjLan+rCN4TDiRHa8Jy9jxnPR85ggZwXvC
dwwelNy3Y+1CBC8KjdnxpNCFHW9Kx+8meFRYK7gv8nh5KUhv+xWDuxWggRrB
r5L7RxG+e86Gb6Xr5yP4V5jC4GM7CD4WCiwi+NnFBD9L5fud4GthqCob/hZ6
s+Nz6XlST/C7UIsd3wtvMPhfZ4L/pfudT/DBcDmDH75E8MPwCzu+mOp3CsEf
Q8jgk9MJPhmGMvjlhwS/TPXvMcE3w9sM/tmS4J/h/YMEH03uJ0WoyeCn/xH8
NP29GMFXww0M/nqQ4K/pfPoIPhsC/rzyxb+H759Q+4uPqxXhKH7yYVHkw4w6
RRiwI2JFcmol+nziuwlH89j6awj+G65j8OHnCD6cyjOd4MfhGu4E2VbZZPSx
Vm7eFk4lePLa6xqeDS8QfqvnuYRHie5XFMGjw5kT496lH3sFxEMKTyUoKI3d
5wTfDnMZ/Pt7gn+HmMHHCxN8PBQUIvj5CQQ/T/t3Ifh6eNmb4O8XEfw9nS+D
z4cBDH5/JcHv0/WaEHw/hAz+X4rg/+E4fgA8YEX4AyT/ogxVkwi/YA3hF0Ap
hn8gS/gH0IPhJ6wi/AQ63l6XgxHns5Rh7UXCb3An/IZh/4rwH0j+Thm2TyX8
iEzCj6DriST8CSiykPArjAm/gspjLuFfQCt9Nn4GlXce4W/A+jNs/A5qz9sI
/wOWvGXjh8B/DH+Eh/BH6HnRR/glsIydfwJTGX6KEuGnUH/yIuGvwDSG33Kb
8FvgSYb/Mo3wX+Aqhh/jS/gxcJQ/s4vwZ2CXBeHX6BJ+DVzB8G9mE/4NHMfP
gT0xhd85i1oAp+f3kGPDz1Y/JwY/vFYP3pc+PzD53th60gjfBwqy84FgL8MX
4nAa4QvR97MJnwh2M3yj3YRvRMdvJnwkaMLwlYoIXwnuY/hMewmfifrnnITv
BA8yfChyfqrR9puELwWDGT7VAsKnouP5Er4VzGH4WPWEjwX3MnytCMLXovN3
J3wuaM7wvaoI34vqwxHCB4NPGL5YE+GLwTCGT+ZK+GTw7Xc2vtlYPEX4aLAy
jvDVxAlfjfavTfhscKIQ4bspEL4b3CpH+HDEn1WHGyQJX06e8OXo7w8QPh1c
wfDt+gnfjo6vT/h4MCyBja9H7aWd8Pmg2h3C99MhfD+4MutWQ0LqO5Rs2/gP
DT+/bHx4P+VBJnpZoyBfskcD2o70n4AyjUoNsKMGdJ9A+IQ1I/PVgDH2bHxD
Ot5f9fMgefhZyA/b15U4g67Lbq7T/9e+vmlG15Z4wBfhXBN9RAPKHxjpH1T1
DqQGHdWAWXdemhptywATLCalhrlq0PX5fnhjNC9BA/JVEz5kLeFDQu38Cdz/
tD+Ca//b5mwNmHeF8CeVCX+S/l6L8Cuhsj7hXwYT/iUMCSb8zC2En0nnn8B1
XeRIkQY8JjVr0uzlAUgV2k9dPtwed3DgwpbuZ+hya2TM76Ix+bzc7tZTXaoB
Ty+RLTJyTEEgyINlUqIBX60WT1+Wko6ErBUM7w+3j55v8Wn2JcsqNeCixKIK
kVkfUBJnodi1Kg14WKRetcKgBIX8lACetRpQukUzYEFeGRJ79/W9hrYm/K1K
+KkrRvRaE04n/hOyyFbS9NHVhIbsfFY6HsN3hc3sfFj4wJ6NL0vXn074tLAr
RO24Ms8dEHS/zkbGUBNevLT9nr5TGsh1cTdfaaxJ5Tub8HPhAYa/u5Lwd2EU
O78XerYNhe3QTgUtLne6tO+PjVdI+MPwixAbvxj6sPOP6XqqCT8ZZrHzl+Fu
ht/sQPjN9D5i+M9QkeFHhxJ+NBTyZONPQ0mGX72T8KvhQA7hX5N8nSacwfCz
PxF+Nu1fi/C3of52wu+WIfxuOl8rwv+GK9n54fCpQalGov9/qM/5sFPKCRbs
vEj48BNGzkEWtBEZdMn190GP38faOgax4AQNzScbTPegbJn0nYadLMi/i/Dr
R+yxi0XluYrw7+Gcn4SfH0H4+XS/uFVH+PtwHL+ftjP8fzju+wBj5wn5fgAc
930BOO57BHDc9xCoPEzvbayueaMFx30/gfbPfF8Bjvv+Ap0f830GOO77DXDc
9x3o+cl8/wGO+z4EHPf9CHpfMN+XgOO+PwHHfZ8Cjvt+BRz3fQs47vsXcNLc
lcIN0iVIYLP0B3lzFt7jsED+hM8HtNRhdtiV5Sy8w+meYAXPezTByPRk+FUW
fvv3wVf7iFIUfW5NTJAPC4//vVK7de0X2RKw5b7S2ftvVHBEAa/RnJ9FYEpk
Q2LKW1XM2bPETvBRPFjUc7dqS7Qq7raZybs4/BlwV/pPv6xijO96Y4uOhVKe
yv/rT4f5/RLyexjE9D+V9A8B8/5W8j7dn5ukP3iDGe8MGQ+O788/7Uq4TdUr
9AMfjrgZoorzVjab5p//iLydC296XFbFzysiHsguL0DOD0ojDgypUPzYHhs/
lTXfVXDtaxfZavwSiWq0BqxqU8Hj+0PM713I72EK0/950j98zbzfR96HXkx/
YqQ/qq/7yHhwfH//B1N59vE=
     "], {{}, {}, 
      TagBox[
       TooltipBox[
        {RGBColor[0.24, 0.6, 0.8], AbsoluteThickness[2], 
         LineBox[CompressedData["
1:eJwl2EMQGMgSANDYtm3b2SQb27Zt2xvbtm3btm3b/i/1D6+65tiH1iRs0LZC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          "]], LineBox[{1074, 1075, 1076, 1077, 1078}], 
         LineBox[{1079, 1080, 1081, 1082, 1083, 1084}], 
         LineBox[{1085, 1086, 1087, 1088, 1089, 1090}], 
         LineBox[{1091, 1092, 1093, 1094, 1095, 1096}], 
         LineBox[{1097, 1098, 1099, 1100, 1101, 1102}]},
        RowBox[{
          TagBox["x", HoldForm], "\[Equal]", 
          RowBox[{"Cos", "[", 
            SuperscriptBox[
             TagBox["y", HoldForm], "2"], "]"}]}]],
       Annotation[#, HoldForm[$CellContext`x] == 
        Cos[HoldForm[$CellContext`y]^2], "Tooltip"]& ]}], {}}},
  AspectRatio->1,
  Axes->True,
  AxesLabel->{None, None},
  AxesOrigin->{0., 0.},
  DefaultBaseStyle->{"PlotGraphics", "Graphics"},
  DisplayFunction->Identity,
  Frame->False,
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  Method->{
   "DefaultBoundaryStyle" -> Automatic, 
    "DefaultGraphicsInteraction" -> {
     "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
      "Effects" -> {
       "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
        "Droplines" -> {
         "freeformCursorMode" -> True, 
          "placement" -> {"x" -> "All", "y" -> "None"}}}}, "GridLinesInFront" -> 
    True},
  PlotInteractivity:>True,
  PlotRange->{{-10, 10}, {-10, 10}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.02], 
     Scaled[0.02]}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{
  3.9676306933374023`*^9, {3.967630779202907*^9, 3.967630791073263*^9}, 
   3.96763495885749*^9, 3.967635403091097*^9},
 CellLabel->
  "Out[2045]=",ExpressionUUID->"53d433ed-6d63-4694-98d8-2a8966912344"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TemplateBox[{"\"grid=\"", "False"},
    "RowDefault"], ",", 
   TemplateBox[{"\"estilos=\"", 
     RowBox[{"{", 
       RowBox[{
         RowBox[{"{", 
           RowBox[{"\"thick\"", ",", "\"red\""}], "}"}], ",", 
         RowBox[{"{", 
           RowBox[{"\"thick\"", ",", "\"cyan\""}], "}"}], ",", 
         RowBox[{"{", 
           RowBox[{"\"thin\"", ",", "\"magenta\""}], "}"}], ",", 
         RowBox[{"{", 
           RowBox[{"\"thick\"", ",", "\"blue\""}], "}"}], ",", 
         RowBox[{"{", 
           RowBox[{"\"dashed\"", ",", "\"magenta\""}], "}"}], ",", 
         RowBox[{"{", 
           RowBox[{"\"dashed\"", ",", "\"cyan\""}], "}"}], ",", 
         RowBox[{"{", 
           RowBox[{"\"dotted\"", ",", "\"yellow\""}], "}"}]}], "}"}]},
    "RowDefault"], ",", 
   TemplateBox[{"\"ejes=\"", "True"},
    "RowDefault"], ",", 
   TemplateBox[{"\"texto=\"", 
     RowBox[{"{", 
       RowBox[{"{", 
         RowBox[{"\"Varias ecuaciones\"", ",", 
           RowBox[{"{", 
             RowBox[{"1", ",", "1"}], "}"}], ",", 
           RowBox[{"{", 
             RowBox[{
               RowBox[{"{", 
                 RowBox[{"\"color\"", ",", "\"orange\""}], "}"}], ",", 
               RowBox[{"{", 
                 RowBox[{"\"size\"", ",", "\"\\\\scriptsize\""}], "}"}], ",", 
               
               RowBox[{"{", 
                 RowBox[{"\"anchor\"", ",", "\"west\""}], "}"}], ",", 
               RowBox[{"{", 
                 RowBox[{"\"rotate\"", ",", "229.28050445334299`"}], "}"}]}], 
             "}"}]}], "}"}], "}"}]},
    "RowDefault"], ",", 
   TemplateBox[{"\"muestras=\"", "200"},
    "RowDefault"], ",", 
   TemplateBox[{"\"tolerancia=\"", "0.01`"},
    "RowDefault"], ",", 
   TemplateBox[{"\"opacidad=\"", "0.8`"},
    "RowDefault"], ",", 
   TemplateBox[{"\"densidad=\"", "3"},
    "RowDefault"], ",", 
   TemplateBox[{"\"xmin=\"", 
     RowBox[{"-", "10"}]},
    "RowDefault"], ",", 
   TemplateBox[{"\"xmax=\"", "10"},
    "RowDefault"], ",", 
   TemplateBox[{"\"ymin=\"", 
     RowBox[{"-", "10"}]},
    "RowDefault"], ",", 
   TemplateBox[{"\"ymax=\"", "10"},
    "RowDefault"]}], "}"}]], "Output",
 CellChangeTimes->{
  3.9676306933374023`*^9, {3.967630779202907*^9, 3.967630791073263*^9}, 
   3.96763495885749*^9, 3.967635403093334*^9},
 CellLabel->
  "Out[2053]=",ExpressionUUID->"4fb2d5a1-3dbc-4320-820d-22fd9486cd72"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Usando editores ya detectados: \"\>", "\[InvisibleSpace]", "4",
    "\[InvisibleSpace]", "\<\" disponibles\"\>"}],
  SequenceForm["Usando editores ya detectados: ", 4, " disponibles"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.967630693681219*^9, {3.967630779539953*^9, 3.967630791410453*^9}, 
   3.967634959198586*^9, 3.9676354034310637`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[2038]:=",ExpressionUUID->"d2cecb22-a346-44ce-971a-36e7710dece7"],

Cell[BoxData["\<\"Buscando pdflatex...\"\>"], "Print",
 CellChangeTimes->{
  3.967630693681219*^9, {3.967630779539953*^9, 3.967630791410453*^9}, 
   3.967634959198586*^9, 3.9676354034318447`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[2038]:=",ExpressionUUID->"c2e86eed-de3e-44b5-8704-9e4e8e2d1d11"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"pdflatex encontrado: \"\>", 
   "\[InvisibleSpace]", "\<\"/Library/TeX/texbin/pdflatex\"\>"}],
  SequenceForm["pdflatex encontrado: ", "/Library/TeX/texbin/pdflatex"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.967630693681219*^9, {3.967630779539953*^9, 3.967630791410453*^9}, 
   3.967634959198586*^9, 3.967635403432487*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[2038]:=",ExpressionUUID->"0075a3f3-2e9d-4e87-8c54-f689c0fe8698"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Editor '\"\>", "\[InvisibleSpace]", "\<\"TeXstudio\"\>", 
   "\[InvisibleSpace]", "\<\"' encontrado (match exacto)\"\>"}],
  SequenceForm["Editor '", "TeXstudio", "' encontrado (match exacto)"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.967630693681219*^9, {3.967630779539953*^9, 3.967630791410453*^9}, 
   3.967634959198586*^9, 3.967635403432884*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[2038]:=",ExpressionUUID->"7039b600-b717-4a53-bb3c-d080cd8f4be4"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Abriendo archivo en \"\>", 
   "\[InvisibleSpace]", "\<\"TeXstudio\"\>", 
   "\[InvisibleSpace]", "\<\"...\"\>"}],
  SequenceForm["Abriendo archivo en ", "TeXstudio", "..."],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.967630693681219*^9, {3.967630779539953*^9, 3.967630791410453*^9}, 
   3.967634959198586*^9, 3.9676354034332743`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[2038]:=",ExpressionUUID->"4c20a466-c3f4-4966-b99a-a4460a83792c"],

Cell[BoxData["\<\"Editor abierto correctamente\"\>"], "Print",
 CellChangeTimes->{
  3.967630693681219*^9, {3.967630779539953*^9, 3.967630791410453*^9}, 
   3.967634959198586*^9, 3.967635403520277*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[2038]:=",ExpressionUUID->"89a7572a-cd06-4266-99ad-046f3978a37e"],

Cell[BoxData["\<\"Compilando documento LaTeX...\"\>"], "Print",
 CellChangeTimes->{
  3.967630693681219*^9, {3.967630779539953*^9, 3.967630791410453*^9}, 
   3.967634959198586*^9, 3.9676354045260153`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[2038]:=",ExpressionUUID->"5ca65f50-f714-4118-818e-2297e82e1292"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Directorio de trabajo: \"\>", 
   "\[InvisibleSpace]", \
"\<\"/Users/enriquevilchezquesada/Downloads/Contour2D11/\"\>"}],
  SequenceForm[
  "Directorio de trabajo: ", 
   "/Users/enriquevilchezquesada/Downloads/Contour2D11/"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.967630693681219*^9, {3.967630779539953*^9, 3.967630791410453*^9}, 
   3.967634959198586*^9, 3.967635404528524*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[2038]:=",ExpressionUUID->"0ec32ce6-2535-4834-9140-dc6f622b7138"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Archivo: \"\>", "\[InvisibleSpace]", "\<\"Contour2D11\"\>"}],
  SequenceForm["Archivo: ", "Contour2D11"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.967630693681219*^9, {3.967630779539953*^9, 3.967630791410453*^9}, 
   3.967634959198586*^9, 3.9676354045300903`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[2038]:=",ExpressionUUID->"2aa696f2-1b83-47c8-bd69-2622501fffd1"],

Cell[BoxData["\<\"Compilaci\[OAcute]n exitosa\"\>"], "Print",
 CellChangeTimes->{
  3.967630693681219*^9, {3.967630779539953*^9, 3.967630791410453*^9}, 
   3.967634959198586*^9, 3.967635407046043*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[2038]:=",ExpressionUUID->"0e0ff860-bfa1-4c40-ad8a-8caad2249eaa"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"PDF generado: \"\>", 
   "\[InvisibleSpace]", \
"\<\"/Users/enriquevilchezquesada/Downloads/Contour2D11/Contour2D11.pdf\"\>"}],
  SequenceForm[
  "PDF generado: ", 
   "/Users/enriquevilchezquesada/Downloads/Contour2D11/Contour2D11.pdf"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.967630693681219*^9, {3.967630779539953*^9, 3.967630791410453*^9}, 
   3.967634959198586*^9, 3.9676354070468197`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[2038]:=",ExpressionUUID->"84b574b2-5358-484a-aa92-a4624baf45df"]
}, Open  ]],

Cell[BoxData["\<\"/Users/enriquevilchezquesada/Downloads/Contour2D11/\
Contour2D11.pdf\"\>"], "Output",
 CellChangeTimes->{
  3.9676306933374023`*^9, {3.967630779202907*^9, 3.967630791073263*^9}, 
   3.96763495885749*^9, 3.967635407059421*^9},
 CellLabel->
  "Out[2055]=",ExpressionUUID->"066cc3c2-99dd-4b56-8fde-16dfbcddde94"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
Ejemplo 12: regiones y uso de && (circular, parab\[OAcute]lica y entre l\
\[IAcute]neas)\
\>", "Subsection",
 CellChangeTimes->{{3.9675372440640697`*^9, 3.967537246104553*^9}, 
   3.9675372803489094`*^9, {3.9675377938175335`*^9, 3.967537794219761*^9}, {
   3.967537847254919*^9, 
   3.9675378725537415`*^9}},ExpressionUUID->"12b578d5-e4bb-cd40-bf0b-\
2a3816b3cf77"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"region1", "=", 
   RowBox[{
    RowBox[{
     RowBox[{"x", "^", "2"}], "+", 
     RowBox[{"y", "^", "2"}]}], "<=", "4"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"region2", "=", 
   RowBox[{"y", ">=", 
    RowBox[{
     RowBox[{"x", "^", "2"}], "-", "2"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"region3", "=", 
   RowBox[{
    RowBox[{"y", "<=", 
     RowBox[{
      RowBox[{"2", "*", "x"}], "+", "1"}]}], "&&", 
    RowBox[{"y", ">=", 
     RowBox[{
      RowBox[{"-", "x"}], "+", "1"}]}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Show", "[", 
   RowBox[{
    RowBox[{"RegionPlot", "[", 
     RowBox[{"region1", ",", 
      RowBox[{"{", 
       RowBox[{"x", ",", 
        RowBox[{"-", "3"}], ",", "6"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"y", ",", 
        RowBox[{"-", "3"}], ",", "5"}], "}"}]}], "]"}], ",", 
    RowBox[{"RegionPlot", "[", 
     RowBox[{"region2", ",", 
      RowBox[{"{", 
       RowBox[{"x", ",", 
        RowBox[{"-", "3"}], ",", "6"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"y", ",", 
        RowBox[{"-", "3"}], ",", "5"}], "}"}]}], "]"}], ",", 
    RowBox[{"RegionPlot", "[", 
     RowBox[{"region3", ",", 
      RowBox[{"{", 
       RowBox[{"x", ",", 
        RowBox[{"-", "3"}], ",", "6"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"y", ",", 
        RowBox[{"-", "3"}], ",", "5"}], "}"}]}], "]"}], ",", 
    RowBox[{"Frame", "->", "False"}], ",", 
    RowBox[{"Axes", "->", "True"}]}], "]"}], "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"line", "[", "]"}], ":=", 
  RowBox[{"RandomChoice", "[", 
   RowBox[{"{", 
    RowBox[{"\"\<solid\>\"", ",", "\"\<dashed\>\"", ",", "\"\<dotted\>\"", 
     ",", "\"\<thick\>\"", ",", "\"\<thin\>\""}], "}"}], "]"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"color", "[", "]"}], ":=", 
  RowBox[{"RandomChoice", "[", 
   RowBox[{"{", 
    RowBox[{"\"\<blue\>\"", ",", "\"\<red\>\"", ",", "\"\<green\>\"", 
     ",", "\"\<purple\>\"", ",", "\"\<yellow\>\"", ",", "\"\<orange\>\"", 
     ",", "\"\<cyan\>\"", ",", "\"\<magenta\>\"", ",", "\"\<black\>\""}], 
    "}"}], "]"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"sizetexto", "[", "]"}], ":=", 
  RowBox[{"RandomChoice", "[", 
   RowBox[{"{", 
    RowBox[{"\"\<\\\\tiny\>\"", ",", "\"\<\\\\scriptsize\>\"", 
     ",", "\"\<\\\\footnotesize\>\"", ",", "\"\<\\\\small\>\"", 
     ",", "\"\<\\\\normalsize\>\"", ",", "\"\<\\\\large\>\"", 
     ",", "\"\<\\\\Large\>\"", ",", "\"\<\\\\huge\>\"", 
     ",", "\"\<\\\\Huge\>\""}], "}"}], "]"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"anclajetexto", "[", "]"}], ":=", 
  RowBox[{"RandomChoice", "[", 
   RowBox[{"{", 
    RowBox[{"\"\<north\>\"", ",", "\"\<south\>\"", ",", "\"\<east\>\"", 
     ",", "\"\<west\>\"", ",", "\"\<north east\>\"", ",", "\"\<north west\>\"",
      ",", "\"\<south east\>\"", ",", "\"\<south west\>\"", 
     ",", "\"\<center\>\""}], "}"}], "]"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"rotatexto", "[", "]"}], ":=", 
  RowBox[{"RandomReal", "[", 
   RowBox[{"{", 
    RowBox[{"0", ",", "360"}], "}"}], "]"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"estilotext", "[", "n_", "]"}], ":=", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"\"\<color\>\"", ",", 
        RowBox[{"color", "[", "]"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"\"\<size\>\"", ",", 
        RowBox[{"sizetexto", "[", "]"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"\"\<anchor\>\"", ",", 
        RowBox[{"anclajetexto", "[", "]"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"\"\<rotate\>\"", ",", 
        RowBox[{"rotatexto", "[", "]"}]}], "}"}]}], "}"}], ",", "n"}], 
   "]"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"vectorestilos", "=", 
   RowBox[{"estilotext", "[", "1", "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Row", "[", 
    RowBox[{"{", 
     RowBox[{"\"\<grid=\>\"", ",", 
      RowBox[{"grid", "=", 
       RowBox[{"RandomChoice", "[", 
        RowBox[{"{", 
         RowBox[{"True", ",", "False"}], "}"}], "]"}]}]}], "}"}], "]"}], ",", 
   
   RowBox[{"Row", "[", 
    RowBox[{"{", 
     RowBox[{"\"\<estilos=\>\"", ",", 
      RowBox[{"estilos", "=", 
       RowBox[{"Table", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"line", "[", "]"}], ",", 
           RowBox[{"color", "[", "]"}]}], "}"}], ",", "3"}], "]"}]}]}], "}"}],
     "]"}], ",", 
   RowBox[{"Row", "[", 
    RowBox[{"{", 
     RowBox[{"\"\<ejes=\>\"", ",", 
      RowBox[{"ejes", "=", 
       RowBox[{"RandomChoice", "[", 
        RowBox[{"{", 
         RowBox[{"True", ",", "False"}], "}"}], "]"}]}]}], "}"}], "]"}], ",", 
   
   RowBox[{"Row", "[", 
    RowBox[{"{", 
     RowBox[{"\"\<texto=\>\"", ",", 
      RowBox[{"texto", "=", 
       RowBox[{"{", 
        RowBox[{"{", 
         RowBox[{"\"\<Regiones\>\"", ",", 
          RowBox[{"{", 
           RowBox[{"1", ",", "0.5"}], "}"}], ",", 
          RowBox[{"vectorestilos", "[", 
           RowBox[{"[", "1", "]"}], "]"}]}], "}"}], "}"}]}]}], "}"}], "]"}], ",", 
   RowBox[{"Row", "[", 
    RowBox[{"{", 
     RowBox[{"\"\<muestras=\>\"", ",", 
      RowBox[{"muestras", "=", "80"}]}], "}"}], "]"}], ",", 
   RowBox[{"Row", "[", 
    RowBox[{"{", 
     RowBox[{"\"\<tolerancia=\>\"", ",", 
      RowBox[{"tolerancia", "=", "0.01"}]}], "}"}], "]"}], ",", 
   RowBox[{"Row", "[", 
    RowBox[{"{", 
     RowBox[{"\"\<opacidad=\>\"", ",", 
      RowBox[{"opacidad", "=", "0.8"}]}], "}"}], "]"}], ",", 
   RowBox[{"Row", "[", 
    RowBox[{"{", 
     RowBox[{"\"\<densidad=\>\"", ",", 
      RowBox[{"densidad", "=", "1"}]}], "}"}], "]"}], ",", 
   RowBox[{"Row", "[", 
    RowBox[{"{", 
     RowBox[{"\"\<xmin=\>\"", ",", 
      RowBox[{"xmin", "=", 
       RowBox[{"-", "3"}]}]}], "}"}], "]"}], ",", 
   RowBox[{"Row", "[", 
    RowBox[{"{", 
     RowBox[{"\"\<xmax=\>\"", ",", 
      RowBox[{"xmax", "=", "6"}]}], "}"}], "]"}], ",", 
   RowBox[{"Row", "[", 
    RowBox[{"{", 
     RowBox[{"\"\<ymin=\>\"", ",", 
      RowBox[{"ymin", "=", 
       RowBox[{"-", "3"}]}]}], "}"}], "]"}], ",", 
   RowBox[{"Row", "[", 
    RowBox[{"{", 
     RowBox[{"\"\<ymax=\>\"", ",", 
      RowBox[{"ymax", "=", "5"}]}], "}"}], "]"}]}], "}"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ExportContour2DToTikZ", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"region1", ",", "region2", ",", "region3"}], "}"}], 
    ",", "\"\<Contour2D12.tex\>\"", ",", "grid", ",", "estilos", ",", "ejes", 
    ",", "texto", ",", "muestras", ",", "tolerancia", ",", "opacidad", ",", 
    "densidad", ",", "xmin", ",", "xmax", ",", "ymin", ",", "ymax"}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"CompiladorTex", "[", 
  RowBox[{"%", ",", 
   RowBox[{"\"\<PreferredEditor\>\"", " ", "->", "\"\<TeXstudio\>\""}]}], 
  "]"}]}], "Input",
 CellChangeTimes->{
  3.9675377995860233`*^9, {3.967537875530306*^9, 3.967537888835047*^9}, {
   3.9675382511991024`*^9, 3.967538251517462*^9}, {3.9675452471297016`*^9, 
   3.9675452485722523`*^9}, {3.9675453123136425`*^9, 3.967545320295864*^9}, {
   3.96757382301103*^9, 3.967573823329381*^9}, {3.9675740206832857`*^9, 
   3.967574020933609*^9}, {3.967630821449807*^9, 3.9676308772754087`*^9}, {
   3.9676309414979267`*^9, 3.9676309935496893`*^9}, {3.967631037190413*^9, 
   3.967631098963209*^9}, 3.967634158380478*^9, {3.9676349416842813`*^9, 
   3.967634942251896*^9}},
 CellLabel->
  "In[2056]:=",ExpressionUUID->"e315d588-3d93-8d4e-b2ec-e1bfb055495f"],

Cell[BoxData[
 GraphicsBox[{{GraphicsComplexBox[CompressedData["
1:eJxlmHt8y9cbx0sNK+mKogszzCXm9hsLRufQmNH9Skqn1rVRnU4npUbpBa3p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     "], {{
       {RGBColor[0.24, 0.6, 0.8], AbsoluteThickness[2.], Opacity[0.3], 
        EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxNl3eM10UQxWfRAwEBKSJIPapwCJ40BQELKOBJOQsoIAgqqOhZsPeOooIF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           "]], PolygonBox[CompressedData["
1:eJwtlOdvjmEUxu/bXrE+EE2MRoi9Z21V1PYqHRGUKjoQYgeNGWKTSNM06SdJ
/wlCYs+gRohVsfee4XflnA+/nOvc7/s893Ofc507ef6yxNIaIYQsqAX1Ygi3
iKmwED5DE9YKiLvhCfyDOVACT+E5TINi6MN/+8E69AS4Du3JZxJHQGf0feJq
WAWRfAGUoadAF3TXaL81h27oX8Qkf+aV3sPaFuI2aIR+T8yAJdCdvCesQY+H
DugbxFHBvuEHzGPtKHEcfIKJ5Lv8/DehI/ksf2YQOgU2oCdBffRd4ljIh59a
Z20PcS8ko9NgB3qGQPeCtej90Ax9h5gG2fARqmBlsD0vQRv+s4LYF9qhU2E7
OgEt0BeJw2EpDCR/oDPAbGhK/oWYCYXQO1pNVAt9Q030C392Hgwhf+hnU09b
kSdFe1d6sL3yySt8z7fwznvJcjgNuYhS9R4uwxmYC4ugGhpG05OD9bKA/Jj3
NA9dI1rvy6ElehzsRC8P5o2zXosy36va31Xq3/bGa13hvT2lPYP1WHv99rNo
z0LyP/IZVMqj5OnReq89s9BXiQfhEAwmz4ADwTwgr2gmNAvyzGv5hLVc4nT1
UF6PVovNMBT92PVGqB3Nw/KunkmQd4Ic9D6Ygp4czfvylLz+krg1mOdbR5vB
kmAeGUl+gZji/+lBPj3auzQDf/3Mle6RTHTbaN+qM+agrxEPwxGoG63H6m0e
nPMelfseqt0w8k1ewytw3r20GAZEuwM0++vhNnwP5vUieOQ1US30Dm2kO6TY
PaNa3As2m6rJB6gT7Vs046Oj9Ui90Ux8DXZn6a6S5zVbU6PNomasb7QZ1Ozp
TsqONlMJP3OVe05e0wyOiVYT1UIzrN73j3YWeaAx+kSw+1J34slgM6dZ053w
zGuiWuhOPB7sjtLdpDv1m9ekyN8hrzaIdpfIs/8BV5id5Q==
           "]]}]}, {}, {}, {}, {}}, 
      {RGBColor[0.24, 0.6, 0.8], AbsoluteThickness[2.], 
       LineBox[CompressedData["
1:eJwt0vdXzXEAx+Erm6zMjEhkhpDKKGVmlShaxm0S+eP6VRSSzBZllESUQrYQ
PZ3TD6/zvD+fe88993zPNzJ4JbNiTCAQqFSZMcAJnKgP9kc1arlzE6N4lSvZ
zBVsYTSrmMfPfKz59gEd1CGlaZq++Owwv3IGp+u6XcAfbNVPnXGu5iy2MZ2D
PMJjOqowZWit1mmNXvjOev7mRf5huxbY4Vqom87x7OAiLtaQXc6/3MVO7uQr
JjFbWZqtWnfn+ZpT+YC3FRx5mHqDdyq13/Kh6lXsPFY99jzeYwn7uZ+R2qe9
ylWD+xwu0x6l6rQeuT/FpeqzUzhOlzVe790ls5e7eZdzeYdFDFH3yF9loers
ObzF+4qwl6jL/q9L9j/u4EsmcLsSdVJx2qbN2qotOqFNilWMNmqDjitTq/Xc
b63iM/7SOfsGp3CyntpnWcOZ/MYL/M5JfMJ8XmMoP42+x8O3DFV/
        "]]}}], {}}, {GraphicsComplexBox[CompressedData["
1:eJxlmXdYk9cXx7MAB2Gp1UaKo464EEfEUb1XY6360xqUVkWIe2Bw1FpqoCou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     "], {{
       {RGBColor[0.24, 0.6, 0.8], AbsoluteThickness[2.], Opacity[0.3], 
        EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxdmHm8z2UWx59zw3UviTuWa3cRGWEsYylJREWTEpeQ4QpFqJSUUWJmKtMi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           "]], PolygonBox[CompressedData["
1:eJwtlWesj2cYh5/bEZH41A+++SJSQWNESKSUmCFGQ63Q1mzNGCWITe3ZxmhV
xTlW7XVsB62jxrH3qt3aW0utxPXL7//hynv93/Oe93mee70lO/dt0adQSqk/
FIaPI6VxsAEfD/XxB/AEHwd98J8hD8+Br/HrcBu/A0vxJfAnvh+G4P/CG/wt
TMEnQ3F8ETTFd8JJ/BTMw3+BXfh0PYPnwF48HxrivWEhfhSq4D/AVnwFXMav
wC38J2iG99ee8NPwKz4f9uC/wyT8k/BecmGH3gVT8eMwEH+qM+AvoTI+E7bg
s2Ehnh1eexasxevCWK0Fm/FGMCl5z7n4JjiCF4GN4TPpLLqn2DyGZ8kx+g1f
DmsVG6iIT4PNijUMDcdcsV4J5bV3rYHPgH/wvxUz/CCUC59ZZ81WjPDGcAzf
CVvwslAs+d5R7RWqJ+egJ/4eEkzg0obrYO0R/ws64CNgDX5XMca/UI7wZdAa
PwSXlCsog0+EjTo7nMO/hLn4KniEr4cC/ClswNdl1ta92vjK8NkGQzftnYL+
KJODN1yvKgb4e7iJdwzHUnu8j98L5+Jx8tlKQ1byGe/AKtUkPx8qhqpt+BG/
AC/wA2H/XzUQXlNrbYNL+HB4p7WhKHvrEe6lolyrqXfC71aOVWsD4L/kmlNs
FAOdXTFSbp/A8+QcZ/G+SvwuJc/EVjlRLhTjZ/gMKJf8zlaqlXAudAb1nnpE
vaEeVO+2Uw8l9/AtvDM8UKxUE3hVqJf8zGn8lNbEryXPAtWAcq+ZcC3ck+pF
5WA3XgFK4GfgBH4y/L9NVWN4PpxL3vMF/CLcSF7jPP5VOJa61x4/G6591Yx6
u3n43erxP/CWcD75nSPxLuHeXKcYhGeUZpNmiHpbOVUu1eNzVIuwPbmHa4R7
SL2je4rN7HCuFSPVzmjVbHINqXZWKy/JNaTZqZ5Tr2mG1gz3tHpZM28U3iA8
e/WOfnheeDZqJvRSbMO1qpn8XbgGsjI9dphr2/AsUk/uwj8Pz1LNwDr4pzA/
eU8vVWvh2GtGa/Z3hQXJ3wDV1oLwrFSNqfa2h2ejarCJzh7+FmhmdgrXjGpF
M2d6eIZqdmpm7cMHwavknKiWFodnu2pKfysIzwY98xofFp4FmunfhHOo3GmP
1fEx4dmhmfUZPjY8+1RjtfDvw7NaM0y9eCP8rVJPdg/3pHpR30HNjm8zrhny
AZCgFn4=
           "]]}]}, {}, {}, {}, {}}, 
      {RGBColor[0.24, 0.6, 0.8], AbsoluteThickness[2.], 
       LineBox[CompressedData["
1:eJwl02NzGFEYgNEkdfsrOlPbto3UblMzddigtpsitW3btm1bqXUy/XDm2Z15
7947s7sZQ0KDewUGBAQkUdxFmIYTQSRRRDOIGGKJI55ESlhTgdWs4hlPKcZy
lrGUtjykCKmDPE/bcJ/WPCCam7TiGje4zjcucolzXOA8X5lMEl/4TDiTmEgh
5jOPuTTlFPlJ6Qxh2oQTNOYkAzlMQw5wiIN8ZDwf6Md7+jOOseSlDLOYSV32
kItAe/XROuyiNrvpzVtGMZrQ5BdhNqeOJAelSGAa1dlCVv7Qg2psZDObeM1w
XvCS53TnFZXpSlp7dNFhdCKD+85aiTVUZC2Z+El7YuhIGrMddCiZ+UUVYokj
C7/pRlXWsYH1vGEE2fhLDeIpSXa2UpPpzCD5w0xnv566nVpsYyc7eMcYchNk
rp4OpjR52Et9EpnNHPKRwmxfDWYfDdjPAI7SiCMc5xifmEABUlnbTIdQloKc
5gwLWMgiCnOW5ixmCZGktz5Cr9CCy7TkKlF85zZ3uMU97vKDKUwlhEe0oxxF
ecwTVrCS8oH//+d/9UaHEg==
        "]]}}], {}}, {GraphicsComplexBox[CompressedData["
1:eJxtmHtczOkex6ea7k0qsnYKFctgJcuETvU8miUcMdJaLJO7NFaty65hrZZV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     "], {{
       {RGBColor[0.24, 0.6, 0.8], AbsoluteThickness[2.], Opacity[0.3], 
        EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxNmHv81/MVxz/vlEu5pB+VUnShpFJK6eaecleIiqLLWpKQu5CwWFPKJSKU
IoTSQsbGzC2Mmc0Mm8tms7kPY2Pbee48v49ff5zf+bzf7/M+r/M+7/M+53x/
7cZNG35qg6qqRsSfjYK3LlXVKuiZ+G4atGnQZkGNq1xvGLT1BnPbhWwD5Zq4
3ihoq6BNNtjfwP0bIR/0bHw3Uwf7tlMvc9sGbRG0ZdDHfm8T9FxQHTYGtXEO
2RbiYW9LObqaq4O1UtIexturh/1t1YFsZ8c7BD0f1CqoQ9Auzu0otRCnozLY
00mb2N/Odc7UxT3M7a4cOD2DdnbcyzlwugW1F/dFv7uK31zs7q6Dv2ec697g
Dwb1CNpJvbu5zri3urGlb9Cu6jw66MCgIUH91cu+PV3Hlr21Dx39nENuL8/D
2kCxOdMAdTDeOGxrFPSr+G4YvE/w/YIOcs+goAO0Ccz9q5RhfIgY4A92vZ/2
9tPeQWJix1CxB25wngGev7V3frB70PuSfgBvmNjYckTQvto5Qr3Ye6RzyB0j
BmtHaR92DVcH42PdB+Zxcs40VjxkG4dPDgs+Kmjz+G4S9Ov43qSkDYcHja5S
hu/j5di4WchsGvRKfI/RPvSe4PqRxgHnJi5PFBN7T5Jz/6e4H7s+05ZJQVOd
Y98EfcGZvq8Mdk0Rj/0TXeesp7oPnLPcMzmoW8nvM4N6xPclwX8UdFrQuKDx
QdPcx/g3QTOD5gSd7voEdY3WH69q7/SgM1zHlquq1D8r6GRlsfUcx9g+Qzzw
z/fM2H6efmF8gXPT1HemZ7pIm8C8UB2ni8f62UGXiXdu0A+Vu8jxFDFmiw3O
5a6B/wM5a1e4PkO9kz3Dlc6h91LXwHuoypxwX9BcbWL9rqBbgm4N+lLfLwya
LzaYNziP/+a5j3MscB17rxObM13tOvtvdB+YtwVdqyx41zjmXok73tBNYqBj
kfsY71HSjqVBN7s+Xx2z9cct2sTcYtcZ3y1eDf8Kbb3ds2Fjs5K6VwbdKcZi
fbZU2eXahI0rXAdzp9hbF/RafN/h+s36mn3Lgn6n7rVBP9bv2DXec/OWVomB
jvvdt1x+o9irXcfG33pXS4LWaBN6H3Cd8T+qjM+ZQQ9rE7qJFeKC+HjUPeh4
RDvAeaLKuGHfT5xD7vEqawtrO8e5mwe9Ht+PqYPzbVtS5mdBP1fHuip7AWo7
Nf4X4qGbOkxNphY/qSxrT2sfuukX6BvoHzZSB2N6k+2s5fQR1PUtlGuqXnIe
uY/czxr1fRt10F/QG6yvsp+gfn9SZZ9R5xp1u6W6qLe1PqK5uurEaK3eNhuM
weyoLDW71l+0VW4zMZqqe0flwGvn+Cn99Kj2oY96/0KVfQk9AbWFfDtCvZ08
M7qo9Z3V1cXxL6vsJ3Z1P3W8q3q7OwZnN8eco4dj9PZ0DM7ujsHo5RiM3o5f
rrK+7uEa9XaQeNTxvuL1cwxef8c9la31FPBaTzFAuVqf10K8vcWgPlP3qH/U
9f2dA+8Ax+ANdlzrJward4hjcIY6Hqivh2rXwY7BO8QxdXgTa/m+4lOn6X0a
WsvBHqZ9YA93DPZRjtvq005ikytqPdrRyg31zo+p6nsL4uDCwFkf9AfxqXXU
PGyiVo5SB/n3pKq+nxhd1fcEJ2oTdb/WU4xRF3jj3Q/+BMesU8eoZ59X2UN8
T5smKodeauhU7aAHmCT2ZMfDlRsrHvpqdftk5eiP6JlGKjdVbHIbNYhaRY8x
Xf3YR00+TTnq6bnadIZrU5w7RwxyZK1ngZ8pzvnu5xwXOD5bzFliUIdrPcUM
5ca5Nk28i5T7osp8fbG+n6bus9RX6zXgM6vMkeTyVdp7uWemVlAzblcvNflK
sal9s5Wjhs7Tritdu9S5ueJQu6n99GZzxAVnvvup/wscs2eR+Oii1tbq8zXK
sYfaeJOY1yn3VZX9x/Weda7YV6mv1oPAF+rr2eLPU9+iqr5PwsYPg96usk6C
Tw9wi7LU0OVi3+baoqq+3t6g/6j99B5LxMX2O91P/V/heLn3cL+6qO213uou
5RY4Zh/9Aj3HPWLQZ6zUj4vFWaa+Wh9xn3JgrxYP7Accg7HGMXLUZ2rwR0Hv
VtmDsEYNoZbwO3GtuKude0RMYqvWLzysrlWurxPnMXVB1OmnxHu8yrrfJfTv
EvR1lT0CPcFP1UdP8IT66AOeFP8px+ucQ25H//dAff9L0O+rrNMrPRM+pH5R
B6ldf6qyllMn/xb0VpW1569Bbyj3fpX1j9r3QdCbVdbCP1dZU9G3a8l91I3t
/c1K3n6nypgiJraK+S1L/uZo62+vw8TGRuo/+Zd1ctDWIdO05O+Yh/QB/lqo
TuL/j1Wu897IXd3NX+953rXqxg91nucNMV/0LO0981ue8d/agZ5vxZgj5tvi
/qfKN8P56Gnf8Yxgvqufq5LxhC30fu9pD/r+rt1v6sf24r+vDeu9P2x/2bt5
yXv4QNtf8J6edw9zXbXpQ+3dPXB7lswXLY2vWq8Gp//6tMoerk4ZvjfXZ586
3znmO5WsT1vKJzlP3aKm7Kb/yctN5TOd/6Kqv5eP9BN+/NL7/GeVee16bf5K
n3/nnte1F/vpSb/xGzt5O4z5nxi2/Et7vvAuwW1f8m0U7+S/3lPXkrFLn/Gd
dwYevTH/a9u4ynfZwD4ZQgf9LPHNPnok4r2RvQr9DP9f2Mc5/o+zh1iN/O7v
bwHioUPJN1PrgeCHa3MDbejg/yvQ+YoYyKKjhb8pOpZ8V9T4LUrWe/wA5/8j
h/rNGv8nqd0l/carfk+Sb+V87S4vNl75nilWE3Uyt7UyxD25mnxD3t6m5G89
eJ05vK/fS/RDP/Md833M9Z08B/1OC31FPoSQJWfyjslfrYwFYpd4YG9nz04u
5DcP+bB38F4lf//g7zbmKdaY21Tfb+89so//5xb3tvJ7B/3M2Rv7zV2wr4N3
1M544+5Y38F8x3dH9xZlwIezB3vbaMM+xmH7Ui/bXp2feN6PjYUOxg/v5lvf
Ti3vEBvvVJmnXlMnMf2s8bOzcfi57/kzY6OT/m/sfYzUz7v4FuBd1MO7J//S
c/3/f4PG+Te+z6+Nh528d94NMn2U7ap8E/0DJj1kN2OykTLso0fgd/Ma47O7
uLx3cg1z5DzyyBzvlnvnNzH+YZ68Q9z19+x7Godr9Ul/Y/JLddFPXVJlb0f8
0/PQ6yx0vYcyxEhvY4y5ntrQy3niZ0L8ubNknpoa/CjvfUrwk72v44I/WLIO
zAp+Tcna80DwNSXz17XB7yuZ6y8Lfn3JnLYq+P0laxR1gd9v+Pn8mBtf8u0/
i89K1p+ng59WMt8/E/yMkm/rueBnl6xLlwafbPzgJ/xF/3JJ8Hu17V79yNvn
Hff1rscEP77kW3s4+N4l69gVwUeXrG8ruG/1ryP2nR8cfFjJXPRQ8L1K1j0w
Z4l7U/BFJeP3pOBjS761O4KP87yLg99cMkZWl/QXvjow+FXq5/ffjJK1f0jw
4SVzGvfcx7MQa8TYdM/IGj1pM2WWmp/66R/ucJD3OCD4oSXf78Dgh5XMV0OD
zxPr6uDzS/YH+wc/smSu2C/4ESVzwr7BDy/5Xur0czNj527j53n0lew1ZpYc
841vztU/nHuwZ+d+zvGObgt+a8mavCT47SXf8dLgR5d879zbOu+ImLpDP+Pv
8/xeVvKcnBHbT9D+lcHvKVlv8cGxyqD7VPXfEHx5yTx3VslYJA55KyNKvhd8
c6L+mV4ypolnfHyKfp5WMr6JbeJ3hTF2eslYJ85Hlowt4or7n2sMjCoZr8Tq
guAHlexPrgt+cMlaxr0N8e4mBr+gZC39H12a/oA=
           "]], PolygonBox[CompressedData["
1:eJwtlOmLTnEUx88xemrq0aSmvJg0zR/hlTCWJsukTBlLEWIozFjHFkMy1mQd
+9gTo7EMb+xrJMmaMNbsQzSJ7D7H9/fi0/n87tO999yzPEWjqsoq25hZCbSF
7W5WD1/xb7AMnwyP8LewAp8Oj/H3MA8/C+3hHuca4ipowZ/CIXwdfMD/wBz8
DOTBXc5LiVXwEH8D0/BaeIU3wwT8MhRBhvMI4iUohFLOw4gXoSMUm+4dAtdN
zziAH4Tf+ANY7co5co0cj+Eb4CNuxEmwCT6bclqOT3Xl8g724nsgi3+CXvhp
aBfv5TyAuAVa8Qoow7fBl6gN7MZ3wVX8O/TDz0OHqAvnxcShcAN/DVPwRfDS
1IPwwXDNdK2bK8fILe7pi5+DfGjgvJa4BurwZ9AH3+HqbVyL2g2HW6YaRq0n
whVTzS/AQP9fGitIuY531TJyXgljUi+fmHozEm6betQIC1zvjhlowo/AC/wv
7HPVMGr3Azbjo10eNdyKV8BPUw3H4fvhOX4fjuOd02zkpG9f6PotP/X2qOtd
0eMGV88tzUR5+saC9M2VrmfmpB6dJPZIs5VL7OKa2ZjV6EFX147EbsTMFbt2
JHbjJvTHl7i8E1S7ehy9jR2KXShxzUpe+rbDrl2Jb6zD16deRs1iNje6Zi9m
NGZvNtwxzeAp6Jl2I0scC/Ndu/jLVMu5rl5FTWele7LpGSeI3V25ZogzXNcy
aUZi13u7Zjl2fhDsdM1y7MRMV81y0wzUpxzi3fGf8g9lXqbV
           "]]}]}, {}, {}, {}, {}}, 
      {RGBColor[0.24, 0.6, 0.8], AbsoluteThickness[2.], 
       LineBox[CompressedData["
1:eJwt0jdXEwAUBeDYJjc3x6ysslmwoKCICjbsEI0NAQ1IU7G32JVQBbEDdkJR
NAZSEOFP+eUch++du9zhnXODobry2gWBQCDOCiGXdzsp9rCTGrKcYSsrGSNX
3MUrXvOSvZSyije8pYtuzjJDHXdZzTgV3CTCH84RZQ0T7OMWDcxSzz0K+M5+
btPIX85zn7X84AB32MY6JmniIIdJc4jtrOcnzRyhigyV7GADv2ghxDuO0kqC
Qt5zjB56KWMjD9jEby4Q5iEXmeMSx3lOH+UU8YhikrTxhMdcZp4rnKCfFwyw
mac84xqfuMpn2vnCV4Y4ySCnuM4UW4jRwQ2+EWeETkb5wEeGOU0105TkfrSj
JFNMkyJNhiwzJBhlmAFiRGkjQpgKSiggnzyCLGcZS1nCYhax8P+O/wH0u1s6

        "]]}}], {}}},
  AspectRatio->1,
  Axes->True,
  AxesLabel->{None, None},
  AxesOrigin->{0, 0},
  DefaultBaseStyle->{"PlotGraphics", "Graphics"},
  DisplayFunction->Identity,
  Frame->False,
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImagePadding->All,
  Method->{
   "DefaultGraphicsInteraction" -> {
     "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
      "Effects" -> {
       "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
        "Droplines" -> {
         "freeformCursorMode" -> True, 
          "placement" -> {"x" -> "All", "y" -> "None"}}}}, "ScalingFunctions" -> 
    None, "TransparentPolygonMesh" -> True, "AxesInFront" -> True},
  PlotInteractivity:>True,
  PlotRange->{{-3, 6}, {-3, 5}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.02], 
     Scaled[0.02]}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{{3.967631102408497*^9, 3.9676311288698797`*^9}, 
   3.9676349427534037`*^9, 3.9676354239516*^9},
 CellLabel->
  "Out[2059]=",ExpressionUUID->"2fd1e03e-c637-4439-93f9-b4ac95872d12"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TemplateBox[{"\"grid=\"", "False"},
    "RowDefault"], ",", 
   TemplateBox[{"\"estilos=\"", 
     RowBox[{"{", 
       RowBox[{
         RowBox[{"{", 
           RowBox[{"\"thick\"", ",", "\"red\""}], "}"}], ",", 
         RowBox[{"{", 
           RowBox[{"\"dotted\"", ",", "\"orange\""}], "}"}], ",", 
         RowBox[{"{", 
           RowBox[{"\"dashed\"", ",", "\"orange\""}], "}"}]}], "}"}]},
    "RowDefault"], ",", 
   TemplateBox[{"\"ejes=\"", "False"},
    "RowDefault"], ",", 
   TemplateBox[{"\"texto=\"", 
     RowBox[{"{", 
       RowBox[{"{", 
         RowBox[{"\"Regiones\"", ",", 
           RowBox[{"{", 
             RowBox[{"1", ",", "0.5`"}], "}"}], ",", 
           RowBox[{"{", 
             RowBox[{
               RowBox[{"{", 
                 RowBox[{"\"color\"", ",", "\"black\""}], "}"}], ",", 
               RowBox[{"{", 
                 RowBox[{"\"size\"", ",", "\"\\\\Large\""}], "}"}], ",", 
               RowBox[{"{", 
                 RowBox[{"\"anchor\"", ",", "\"north\""}], "}"}], ",", 
               RowBox[{"{", 
                 RowBox[{"\"rotate\"", ",", "41.37882943972643`"}], "}"}]}], 
             "}"}]}], "}"}], "}"}]},
    "RowDefault"], ",", 
   TemplateBox[{"\"muestras=\"", "80"},
    "RowDefault"], ",", 
   TemplateBox[{"\"tolerancia=\"", "0.01`"},
    "RowDefault"], ",", 
   TemplateBox[{"\"opacidad=\"", "0.8`"},
    "RowDefault"], ",", 
   TemplateBox[{"\"densidad=\"", "1"},
    "RowDefault"], ",", 
   TemplateBox[{"\"xmin=\"", 
     RowBox[{"-", "3"}]},
    "RowDefault"], ",", 
   TemplateBox[{"\"xmax=\"", "6"},
    "RowDefault"], ",", 
   TemplateBox[{"\"ymin=\"", 
     RowBox[{"-", "3"}]},
    "RowDefault"], ",", 
   TemplateBox[{"\"ymax=\"", "5"},
    "RowDefault"]}], "}"}]], "Output",
 CellChangeTimes->{{3.967631102408497*^9, 3.9676311288698797`*^9}, 
   3.9676349427534037`*^9, 3.9676354239542627`*^9},
 CellLabel->
  "Out[2067]=",ExpressionUUID->"1c31ca09-9bbe-4c87-a1dc-390b90d09a8e"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Usando editores ya detectados: \"\>", "\[InvisibleSpace]", "4",
    "\[InvisibleSpace]", "\<\" disponibles\"\>"}],
  SequenceForm["Usando editores ya detectados: ", 4, " disponibles"],
  Editable->False]], "Print",
 CellChangeTimes->{{3.967631102744813*^9, 3.967631129210085*^9}, 
   3.967634943094857*^9, 3.967635424289748*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[2056]:=",ExpressionUUID->"e51950b7-9689-4313-a11a-2b77f4fc2967"],

Cell[BoxData["\<\"Buscando pdflatex...\"\>"], "Print",
 CellChangeTimes->{{3.967631102744813*^9, 3.967631129210085*^9}, 
   3.967634943094857*^9, 3.967635424290506*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[2056]:=",ExpressionUUID->"1663dcae-a118-4b3d-a9ba-299b67161471"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"pdflatex encontrado: \"\>", 
   "\[InvisibleSpace]", "\<\"/Library/TeX/texbin/pdflatex\"\>"}],
  SequenceForm["pdflatex encontrado: ", "/Library/TeX/texbin/pdflatex"],
  Editable->False]], "Print",
 CellChangeTimes->{{3.967631102744813*^9, 3.967631129210085*^9}, 
   3.967634943094857*^9, 3.96763542429115*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[2056]:=",ExpressionUUID->"13046f30-8511-442d-ba04-53f5f7f2490d"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Editor '\"\>", "\[InvisibleSpace]", "\<\"TeXstudio\"\>", 
   "\[InvisibleSpace]", "\<\"' encontrado (match exacto)\"\>"}],
  SequenceForm["Editor '", "TeXstudio", "' encontrado (match exacto)"],
  Editable->False]], "Print",
 CellChangeTimes->{{3.967631102744813*^9, 3.967631129210085*^9}, 
   3.967634943094857*^9, 3.967635424291552*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[2056]:=",ExpressionUUID->"f473afd3-c5d2-4f63-8020-60db1517fb78"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Abriendo archivo en \"\>", 
   "\[InvisibleSpace]", "\<\"TeXstudio\"\>", 
   "\[InvisibleSpace]", "\<\"...\"\>"}],
  SequenceForm["Abriendo archivo en ", "TeXstudio", "..."],
  Editable->False]], "Print",
 CellChangeTimes->{{3.967631102744813*^9, 3.967631129210085*^9}, 
   3.967634943094857*^9, 3.967635424291938*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[2056]:=",ExpressionUUID->"7b5aef71-09ad-4fd0-8b53-c23d53dc88a3"],

Cell[BoxData["\<\"Editor abierto correctamente\"\>"], "Print",
 CellChangeTimes->{{3.967631102744813*^9, 3.967631129210085*^9}, 
   3.967634943094857*^9, 3.967635424375861*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[2056]:=",ExpressionUUID->"e1ac411b-89ce-4714-8dbf-29ef561810e2"],

Cell[BoxData["\<\"Compilando documento LaTeX...\"\>"], "Print",
 CellChangeTimes->{{3.967631102744813*^9, 3.967631129210085*^9}, 
   3.967634943094857*^9, 3.967635425382124*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[2056]:=",ExpressionUUID->"bc7a1eae-fb62-4bc3-bf4d-bc548c1486a0"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Directorio de trabajo: \"\>", 
   "\[InvisibleSpace]", \
"\<\"/Users/enriquevilchezquesada/Downloads/Contour2D12/\"\>"}],
  SequenceForm[
  "Directorio de trabajo: ", 
   "/Users/enriquevilchezquesada/Downloads/Contour2D12/"],
  Editable->False]], "Print",
 CellChangeTimes->{{3.967631102744813*^9, 3.967631129210085*^9}, 
   3.967634943094857*^9, 3.9676354253853693`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[2056]:=",ExpressionUUID->"fc2909cc-0682-415a-8853-c507c3c83bb7"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Archivo: \"\>", "\[InvisibleSpace]", "\<\"Contour2D12\"\>"}],
  SequenceForm["Archivo: ", "Contour2D12"],
  Editable->False]], "Print",
 CellChangeTimes->{{3.967631102744813*^9, 3.967631129210085*^9}, 
   3.967634943094857*^9, 3.967635425388351*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[2056]:=",ExpressionUUID->"c6432cbf-619b-448c-83dc-027c1cb87e0c"],

Cell[BoxData["\<\"Compilaci\[OAcute]n exitosa\"\>"], "Print",
 CellChangeTimes->{{3.967631102744813*^9, 3.967631129210085*^9}, 
   3.967634943094857*^9, 3.967635427812984*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[2056]:=",ExpressionUUID->"72539cad-e1e6-429c-88c7-463e20350dd6"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"PDF generado: \"\>", 
   "\[InvisibleSpace]", \
"\<\"/Users/enriquevilchezquesada/Downloads/Contour2D12/Contour2D12.pdf\"\>"}],
  SequenceForm[
  "PDF generado: ", 
   "/Users/enriquevilchezquesada/Downloads/Contour2D12/Contour2D12.pdf"],
  Editable->False]], "Print",
 CellChangeTimes->{{3.967631102744813*^9, 3.967631129210085*^9}, 
   3.967634943094857*^9, 3.967635427813743*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[2056]:=",ExpressionUUID->"7f384fbf-c9b7-4742-9e89-91760619d0de"]
}, Open  ]],

Cell[BoxData["\<\"/Users/enriquevilchezquesada/Downloads/Contour2D12/\
Contour2D12.pdf\"\>"], "Output",
 CellChangeTimes->{{3.967631102408497*^9, 3.9676311288698797`*^9}, 
   3.9676349427534037`*^9, 3.967635427827506*^9},
 CellLabel->
  "Out[2069]=",ExpressionUUID->"ea0b67c3-4a6a-48e4-96e7-e542614ce0e7"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
Ejemplo 13: funciones expl\[IAcute]citas y curvas param\[EAcute]tricas (cuadr\
\[AAcute]tica, trigonom\[EAcute]trica, c\[IAcute]rculo y e\.08spiral)\
\>", "Subsection",
 CellChangeTimes->{{3.9675372440640697`*^9, 3.967537246104553*^9}, 
   3.9675372814716606`*^9, {3.9675378972281837`*^9, 
   3.9675379389162006`*^9}},ExpressionUUID->"a64b941c-989d-4248-899d-\
01217334c069"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"func1", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "^", "2"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", 
       RowBox[{"-", "4"}], ",", "4"}], "}"}]}], "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"func2", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Sin", "[", "x", "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", 
       RowBox[{
        RowBox[{"-", "4"}], "*", "Pi"}], ",", 
       RowBox[{"4", "*", "Pi"}]}], "}"}]}], "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Show", "[", 
   RowBox[{
    RowBox[{"ParametricPlot", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"t", "*", 
         RowBox[{"Cos", "[", "t", "]"}]}], ",", 
        RowBox[{"t", "*", 
         RowBox[{"Sin", "[", "t", "]"}]}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"t", ",", "0", ",", 
        RowBox[{"4", "*", "Pi"}]}], "}"}]}], "]"}], ",", 
    RowBox[{"Plot", "[", 
     RowBox[{
      RowBox[{"func1", "[", 
       RowBox[{"[", "1", "]"}], "]"}], ",", 
      RowBox[{"func1", "[", 
       RowBox[{"[", "2", "]"}], "]"}]}], "]"}], ",", 
    RowBox[{"Plot", "[", 
     RowBox[{
      RowBox[{"func2", "[", 
       RowBox[{"[", "1", "]"}], "]"}], ",", 
      RowBox[{"func2", "[", 
       RowBox[{"[", "2", "]"}], "]"}]}], "]"}], ",", 
    RowBox[{"ParametricPlot", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"Cos", "[", "t", "]"}], ",", 
        RowBox[{"Sin", "[", "t", "]"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"t", ",", "0", ",", 
        RowBox[{"2", "*", "Pi"}]}], "}"}]}], "]"}]}], "]"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"param1", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Cos", "[", "t", "]"}], ",", 
       RowBox[{"Sin", "[", "t", "]"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"t", ",", "0", ",", 
       RowBox[{"2", "*", "Pi"}]}], "}"}]}], "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"param2", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"t", "*", 
        RowBox[{"Cos", "[", "t", "]"}]}], ",", 
       RowBox[{"t", "*", 
        RowBox[{"Sin", "[", "t", "]"}]}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"t", ",", "0", ",", 
       RowBox[{"4", "*", "Pi"}]}], "}"}]}], "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"line", "[", "]"}], ":=", 
  RowBox[{"RandomChoice", "[", 
   RowBox[{"{", 
    RowBox[{"\"\<solid\>\"", ",", "\"\<dashed\>\"", ",", "\"\<dotted\>\"", 
     ",", "\"\<thick\>\"", ",", "\"\<thin\>\""}], "}"}], "]"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"color", "[", "]"}], ":=", 
  RowBox[{"RandomChoice", "[", 
   RowBox[{"{", 
    RowBox[{"\"\<blue\>\"", ",", "\"\<red\>\"", ",", "\"\<green\>\"", 
     ",", "\"\<purple\>\"", ",", "\"\<yellow\>\"", ",", "\"\<orange\>\"", 
     ",", "\"\<cyan\>\"", ",", "\"\<magenta\>\"", ",", "\"\<black\>\""}], 
    "}"}], "]"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"sizetexto", "[", "]"}], ":=", 
  RowBox[{"RandomChoice", "[", 
   RowBox[{"{", 
    RowBox[{"\"\<\\\\tiny\>\"", ",", "\"\<\\\\scriptsize\>\"", 
     ",", "\"\<\\\\footnotesize\>\"", ",", "\"\<\\\\small\>\"", 
     ",", "\"\<\\\\normalsize\>\"", ",", "\"\<\\\\large\>\"", 
     ",", "\"\<\\\\Large\>\"", ",", "\"\<\\\\huge\>\"", 
     ",", "\"\<\\\\Huge\>\""}], "}"}], "]"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"anclajetexto", "[", "]"}], ":=", 
  RowBox[{"RandomChoice", "[", 
   RowBox[{"{", 
    RowBox[{"\"\<north\>\"", ",", "\"\<south\>\"", ",", "\"\<east\>\"", 
     ",", "\"\<west\>\"", ",", "\"\<north east\>\"", ",", "\"\<north west\>\"",
      ",", "\"\<south east\>\"", ",", "\"\<south west\>\"", 
     ",", "\"\<center\>\""}], "}"}], "]"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"rotatexto", "[", "]"}], ":=", 
  RowBox[{"RandomReal", "[", 
   RowBox[{"{", 
    RowBox[{"0", ",", "360"}], "}"}], "]"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"estilotext", "[", "n_", "]"}], ":=", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"\"\<color\>\"", ",", 
        RowBox[{"color", "[", "]"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"\"\<size\>\"", ",", 
        RowBox[{"sizetexto", "[", "]"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"\"\<anchor\>\"", ",", 
        RowBox[{"anclajetexto", "[", "]"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"\"\<rotate\>\"", ",", 
        RowBox[{"rotatexto", "[", "]"}]}], "}"}]}], "}"}], ",", "n"}], 
   "]"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"vectorestilos", "=", 
   RowBox[{"estilotext", "[", "1", "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Row", "[", 
    RowBox[{"{", 
     RowBox[{"\"\<grid=\>\"", ",", 
      RowBox[{"grid", "=", 
       RowBox[{"RandomChoice", "[", 
        RowBox[{"{", 
         RowBox[{"True", ",", "False"}], "}"}], "]"}]}]}], "}"}], "]"}], ",", 
   
   RowBox[{"Row", "[", 
    RowBox[{"{", 
     RowBox[{"\"\<estilos=\>\"", ",", 
      RowBox[{"estilos", "=", 
       RowBox[{"Table", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"line", "[", "]"}], ",", 
           RowBox[{"color", "[", "]"}]}], "}"}], ",", "4"}], "]"}]}]}], "}"}],
     "]"}], ",", 
   RowBox[{"Row", "[", 
    RowBox[{"{", 
     RowBox[{"\"\<ejes=\>\"", ",", 
      RowBox[{"ejes", "=", 
       RowBox[{"RandomChoice", "[", 
        RowBox[{"{", 
         RowBox[{"True", ",", "False"}], "}"}], "]"}]}]}], "}"}], "]"}], ",", 
   
   RowBox[{"Row", "[", 
    RowBox[{"{", 
     RowBox[{"\"\<texto=\>\"", ",", 
      RowBox[{"texto", "=", 
       RowBox[{"{", 
        RowBox[{"{", 
         RowBox[{"\"\<Funciones y curvas\>\"", ",", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"-", "1"}], ",", "0"}], "}"}], ",", 
          RowBox[{"vectorestilos", "[", 
           RowBox[{"[", "1", "]"}], "]"}]}], "}"}], "}"}]}]}], "}"}], "]"}], ",", 
   RowBox[{"Row", "[", 
    RowBox[{"{", 
     RowBox[{"\"\<muestras=\>\"", ",", 
      RowBox[{"muestras", "=", "200"}]}], "}"}], "]"}], ",", 
   RowBox[{"Row", "[", 
    RowBox[{"{", 
     RowBox[{"\"\<tolerancia=\>\"", ",", 
      RowBox[{"tolerancia", "=", "0.01"}]}], "}"}], "]"}], ",", 
   RowBox[{"Row", "[", 
    RowBox[{"{", 
     RowBox[{"\"\<opacidad=\>\"", ",", 
      RowBox[{"opacidad", "=", "0.8"}]}], "}"}], "]"}], ",", 
   RowBox[{"Row", "[", 
    RowBox[{"{", 
     RowBox[{"\"\<densidad=\>\"", ",", 
      RowBox[{"densidad", "=", "3"}]}], "}"}], "]"}], ",", 
   RowBox[{"Row", "[", 
    RowBox[{"{", 
     RowBox[{"\"\<xmin=\>\"", ",", 
      RowBox[{"xmin", "=", "Automatic"}]}], "}"}], "]"}], ",", 
   RowBox[{"Row", "[", 
    RowBox[{"{", 
     RowBox[{"\"\<xmax=\>\"", ",", 
      RowBox[{"xmax", "=", "Automatic"}]}], "}"}], "]"}], ",", 
   RowBox[{"Row", "[", 
    RowBox[{"{", 
     RowBox[{"\"\<ymin=\>\"", ",", 
      RowBox[{"ymin", "=", "Automatic"}]}], "}"}], "]"}], ",", 
   RowBox[{"Row", "[", 
    RowBox[{"{", 
     RowBox[{"\"\<ymax=\>\"", ",", 
      RowBox[{"ymax", "=", "Automatic"}]}], "}"}], "]"}]}], "}"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ExportContour2DToTikZ", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"func1", ",", "func2", ",", "param1", ",", "param2"}], "}"}], 
    ",", "\"\<Contour2D13.tex\>\"", ",", "grid", ",", "estilos", ",", "ejes", 
    ",", "texto", ",", "muestras", ",", "tolerancia", ",", "opacidad", ",", 
    "densidad", ",", "xmin", ",", "xmax", ",", "ymin", ",", "ymax"}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"CompiladorTex", "[", 
  RowBox[{"%", ",", 
   RowBox[{"\"\<PreferredEditor\>\"", " ", "->", "\"\<TeXstudio\>\""}]}], 
  "]"}]}], "Input",
 CellChangeTimes->{
  3.9675378959185085`*^9, {3.9675379515992985`*^9, 3.96753796467243*^9}, {
   3.9675382478823357`*^9, 3.967538248233179*^9}, {3.9675452529726295`*^9, 
   3.967545254602625*^9}, {3.96754530181398*^9, 3.967545307700531*^9}, 
   3.967573827879408*^9, {3.967574027745125*^9, 3.967574027888159*^9}, {
   3.9676311558240757`*^9, 3.9676312178464117`*^9}, {3.967631295234727*^9, 
   3.967631395576977*^9}, {3.967631439321416*^9, 3.967631498572153*^9}, {
   3.967631542090879*^9, 3.967631594899498*^9}, {3.967631705621458*^9, 
   3.9676317113780193`*^9}, {3.9676317563529997`*^9, 3.967631775388492*^9}, {
   3.967631813876873*^9, 3.967631883683607*^9}, {3.967631924197481*^9, 
   3.9676320081715612`*^9}, {3.967632121311741*^9, 3.967632125315876*^9}, 
   3.967634150462173*^9},
 CellLabel->
  "In[2070]:=",ExpressionUUID->"a902c6bb-b9e9-c84f-9057-0eed6d79019f"],

Cell[BoxData[
 GraphicsBox[{
   InterpretationBox[{
     TagBox[{{{}, {}, 
        TagBox[
         {RGBColor[0.24, 0.6, 0.8], AbsoluteThickness[2], Opacity[1.], 
          FaceForm[Opacity[0.3]], LineBox[CompressedData["
1:eJxcmXc81t/7x+09b3vnLjQVUaKcQ5JQVERmiGQVPlZFZTQoipJVlArZkSI6
JyMj2dnktvfebvze339//vF4Pm73Odf1ul7XOdd5kLa9ccGejoaGZj8jDc3/
fv//n/D9L+RDIm+AX+Kth+JkZ9RvnAjgN4m8C1hVTZnDZLmBVtpo1sPMh4Be
RmMzMUQa6A4xZb55HgEeLj+xOSd7EFxJPFqcURQFnl9Wzqs2VgFU81+Bhhmv
APVMtdrFEA3Q+7F0V/breJCanH+hpf00kM88KFESnggem+/6Yy5jAMZKqj2/
orcglPdWkeuXi+BvG8O97q/JgE79xau3RqYghJQ+V5n9AVyTpA+ANy3Bzubb
zP+lpAC9I79P7Ai2AR/0X9N0vUkDEV2TxnrhVwFT6wfxlZfp4OUuUkJ86zWQ
ukf+x9GgbPBEoirlufQNgD5l26YW54AmE5TAH+kOxAK814K+5oL0vNqqq589
QcP0o6GEjDwAYu/50xr6Aj/r3QEtH/OBpWQCy6k/t0AxQ0pOfdIXoFbXt3Hr
uj/AatuujC++ArBEKTO6ex8w/z4OVJ9+A+ArY9LvjUBg0Lr3qNyDQhAoNFOf
8zAYjL4r3S/p8x3sb7PeLvzzEPCb82kfMkZgzsav1ZkUAT4+u31oQgaDoscl
8pvBzwCzUtwY11sMFsvyx1wfPQdvZS1zSqN/Arenv+tPfowCCk9Od+fdLQMh
dAHmD07EgA4Pu+dX18pARsqDUivvWGAmUfC606Mc3OoVPFRfEAfGc3yFee0r
wIedonpu516DPzOxh+9pVwKTmojv8i5vgY0EywmlH5XAbe6pSpvsO6Aky2Lz
TrkKFCVq79IYege2y2/bpuysBqqR4u4XXd+DmVzVMweoNeDBRPDV059SgLBk
u8L86zqQ0Xq8jKY1CxQeDH+nKVoPjDUWinv6skFMGneNbHQ9MMljiaLzzQEn
Qmk/nNduAN617368eJoLEqp360qqNoKPpJ4q2JQHAg6rSfp7N4ILyKX+i2M+
uK19bujN50bgZWlddor2C/jbnd4nt7cJCDnZz+aoFADzRLr8o4LNgKJ14OsT
/A3czs/VijZsBsoakcm51wrBg70KmzmhzUDXW3R1iKcI9Bk5PxbaagapfYFF
3te/A8zt8/E5pQV8UhAv4Tj8A4yGn/G+F9cKtObn+8/ylYITN6MbTzS0gjvC
6w3r3qXAipF+5yfGNjA9GCP1rqsUXNlivvnkRhvIDpI62p1SBq4n8erbgHaw
329BZVCvAphf856669EOVksKZXS/VgBfR8qu0x/awRGl9ZF3O3+Br2eWFWpZ
O0DAzZKN3du/QMR2yUxcXQdYz+M94/yzCgwHXL82utUB9h7y7NRTqgZLpbSg
Xb4ThIkp7BJKrQZ5+Zw0CU87wYufcSnXI2vAxyzVZ2+0u4DZ5m7bPvdaoHx4
7MHoh24gcS8vLPxAAzi5xDit+qcbJCywCldfbwDjik22CovdIM0u+bDtxwbA
jmalWDR6QI1C4u6sHY0gV6Y9T7+1B3jEKZ9NFCF0v1RnkL3eA3bJowRs2gRu
SbtZ5Ur2Aq8Pyw+OxzQBr1a+yOf2vaDzASRrCjeDoWsD6Z+ne4Fc8S8Wb/EW
sGD0QYGW5x/o+VZcaWnVAsxCir+OH/oHCiw4NuKTWoAoVSPmifs/4NUl9VpE
9i+oF6x6RZ36BwI0xIrYlFvBL5HGhLDrfaCNcU3rjG07OFjmuDbu3Qc+swg2
XUprB95TP97zBfeB4wmbK7mz7aB8O30Eve4DnTsO/zh3rwOox+0+7F/XB8yM
nvbwJncCxeI/Qjs6+4D2ac1/tyc7Qbb+b6PQoT7ww6WvUv5IF/iVmT2Qt9EH
0nzWR1xquoBsy+0SIxkKUOg763VsuRv0TiXX7DtIAeXdOeUdhG5bmnXnq1Qo
4KAdl+SPpz3g0Y8Lw4Z6FOBy85+noWwvyGAvvnfciAKqjc4qbHr0gif52tmT
FhRQYZtxawL1ArN/yiOxrhRQYwH3h5r9AwtzzfeivSigY+81w2Op/wCDIXP9
JX8KONJ81Vdu+R/4bMSWJf2EAqL23SNbn+kDaPJoROdHCmB21BiwGekDfbvM
FhsyKMBTRdTxKhcFjD16+TvsMwXk8e8qClSmgJkJMte5Egq4p6T3iDeYWPex
oYhxKQW8+rZ59X46EfcJg1apSgrgzuNoYG+mgL1HCtO26yngW2gw9w1yP+B5
IWrH30IB7ubXNU/r9oPBoWP8k20UYOKdjFU8+oHQ3qcRD7ooQPNNrcrJuH6w
22QmZaCXApaKT1x2KO0HQ1lJh+j7ifzMuBvejvcDMu/pzcFBCpATEtVbIg2A
kbPTlEcjFHBnx4rPFbUBwO3Dkjc9RgE/M2kYBuwGgK2C2ynBSSJ+nwsJd54M
AAlGa7ftKQp4qVAztf/LAFjKvE//aYYCzjOyfFjoGQAPnAY7BeYoYJD9hlsD
0yBQ0dus0Zwn4quWWS49OAje3Pv06dACBVxKERytMR0ER9IUz/8j+IX77MzI
/UGQJXkq+twiBaw3yBaKpA+CMM318wEEW1fNT1u3DIJzNc0WbgSTFS4eL9oc
BFS2kghJgrVUOPV3yw0BSS328nBivfKujKo0wyGgNO7f/IPY380xxEL91hB4
Oqsek0XEt7GSmzuUPARekQYmLWcpIGxGwCPxzxB4Ie6UUTtNAb4BlqedV4bA
78Pg8zqR/2OJrU4d6WEgJHmsc2ScAry5jrYe1RsGk4/iaF6MEnp18fYf9RoG
VQYkuu0hCphrt03RSRwG3KXfv+8eoADR5Oq669XDwHBUkp23jwJK3ubSxC8M
g9CMiwPiHRQAWnN27dcZATNXTPbAvxTQbP7GIcxjBLy/43dXupECrhQWXVhL
GAHT35W7JKoIP7xnqtyeGwEaZzzeqpRRQJL03devxEfB3ijSGs8PCvhiUVh0
/PQoIHM+7F8j/Cjpv2SXmTAK/gp6q7BlEvqYlx33rRwFNzm3U9oIP7MvTiyd
mx8FEtIDV9JiifVeTCZJ6owBC9MO98xIClBU2NUr6DkGRPYk7XMLo4Cr370j
Rd6MgaO9WQdk7lAAZtRdOr44BrTfimiI/UcBcRl1UxZS4yBOPj7qjzMFqIj7
zIXojoPL/7E/dzCjgNLwmxlzSeMAxCOta0oUgBYpIzLnJsDGvvgRiz0UEM3X
fFvBfwI09UxM00pSQOMbtTNaGRNAI49SfJmJAlZpT3/1Z5sE87+WvE8094E7
35WHFCsnwXLe/OX0ij5wueiEnvPyJDg9lPK38ivRt4oeh1NkpoCuk+UJjvg+
wNWonS4XPAXMDULuYMs+8G/xloC6xjQQlHSoTzrbB5gV6ZxDbk6DnW1/hQ6e
6APW747dq02cBjdEl08ai/WBgtwgRtOtaaB/PS38Sco/kMNJOmLyfQYYRPMJ
WDn1gq/3Qc2puFnQe1u4pR70gmqm/Jma3FlQob0xGs/fC1yU2GT0q2fBgcW3
3ZrFPeBzg321xuosqLMeyqqh7wFfjF8fXzCeA/cbPVyKPbuA1HB3tQrPPCgV
qCmqV+8CIVVzDLZy8+CAXI/wCdYuEFT1yjNIfR4UJK7skE3oBLn3/BYyXebB
3Yn0/xSLOsCWDs6Lq5oHFcaOMhptbeDQUY6ehIAFoLA8+P5YQhvQefSfXHrU
Amhb/Bvy7kobUHJnOJOdSnz+ULuqYqQVuIhFno5pWgDnAgM5jWf+gv+cgjNG
ZBbB4wNGvdkDxP2/FDRjULMImEVMLb4nNgOvXXYM73sXQaaZKvmYeTO4bRZZ
PT6/CC6k5pGfNDSBx/TV8QZiS+CI/uytF/mNgDnajnLTeQmcnWLfSi+vAxwz
2cLDLMugM/TtmtK+OvDkFUfuWfFlcP9Xmmnqsz8gQnmw/f3BZeI++0E1MK0F
yZaiPNKXloHv22c3sjurQfJaeZbeu2VwU41WXjSjHJSM2lxTP7oCatOpGmVs
eYDfZSVC88Iq4Ii6Hbr6Xy7Y5+Qek3J1FfgExtdHF2aD925NO+a9VwGaqMp4
q5sGhjlcfxyJXwW0FnmJCo4xgLHaK8KnfxU88tL1tct5jdZZ9tElO6+BaRer
Motz71C8VmnTyTtroDCLXZin+gPSpWza/3qyBqxsWPi2f2cgJs7MsRuZa8DC
pXiuLOgL2qlNQ39uag0UdBk2mPOXokp0foD+2jqQZr81H0Jfhop+q6V/8FoH
et+f2OKFMqT20SpBJngdqAsWX7Fpq0DXox6IoKR1kLfJ+EUhvRpZPvG2u9C+
DtSC96oUv6tB9aoCpv+G1oG27fjBs/G/kRJP5zedhXUQ8OX7Ff+IP0h34tNA
NucGCLXSU1372YBcroaOV8MNoO0XfuCXRiNykFfVUzq7AZIDLkryljYi95EI
B7/LGyBiIkJTsrwJ5Xiyr0a6b4A+oVpTuroWtKPdtmQzcQN8/rmn9+JqO/oa
FKsUvLQBPLjMJg77dyC92FrHi9sbwEeD2SOQrhN5DdtHbrBQwSzvLj5Hri50
9Hk2S6sYFXgMH7utsa8H2RV72GQBKtCbQIr383pQqCyUgjpUoCISEL3neC/6
Op5imWZIBeW0rddyz/1D9uWjH2htqGD72winVnEfcllv8Sy/SwUVJvv5qLQU
xHsoXovzIRVUu6k4DJ2mIP+ZJfn94VRAKs67pttCQaVHdr2diKeC/4wGz1aI
9iNb45HGsHdUwHXsytwNm3601SXpRptGBYa6ip0XZvoR1z6jEy5fqOA326mL
oUcGEBoVE7P5TgU0lyTmZvwHkEDKZOHen1SQoCCzeZJzECVP/Y1Uq6WCueVL
Y/TyQ4glznm3QR8VfKJvkXzrPYRUWPyChgapgOfDrUPX0RASSDxwyWCMCj5y
Nqv6nh9GNwbulSbMUUHtudfmP+KG0RXDQo57S1RA1ipLPTA4jDTZ/xw8skYF
oVP7+B74jCAh74CrojSbIPxNjZHbzxHU2la0W4d+E6wdDGAPYB9FxeE8+3SY
NsHvgHNV+cajyJ7b85Qo6yZ411YnRkoaRWRG4Qs/2DdBRaRk9MvxUfTsnc8+
Ja5NwJQ79ktdeQw1zuln3ObZBF5+109w3htDjruis1+QNsGokP0jmt9j6Ef/
C567/JsAHlc8Iiw4jrTj6z6pCm6CqKIvLRdtxtGpRg6zSqFNILP/6tznjHF0
wtlyfZfIJhB+rimivDqOVmn4HC+KEvHOD7d3nJxAqnsq7l4Q2wRCLH7FSRET
iL3SUJIsvgnetH02eNw1gT5dat9RSvADK4pElNwkElUtv6oosQk0lIdySzwn
kTFjWaUHwUeOHI5mwZOIu6ZaLohgWpm/Rp4cU0jBjt/OjuC7l5x8Nk2n0F8k
Y8pHcMzl3Q8/fphCKweqhiKJ9euSujjc5qdQ7nvOCQoRz4v9o88ugmkkx2V4
moZgpyO68ZeeTKOVZwqdU0Q+i1dgs3bLNLpeMVn5U3gT7KoemjUQn0GaHBMc
zkT+LYDy3P3qDIrMi4wYE9gEeOvJxfSMGdTx9P6RE4R+YztXmqiLMyhq19NR
e0JfJOje+llyFt0bL31iR+jP2zE8e+LaLBJ7vKHTQ9SLscBN9UXYLLKPVjx0
majnm5/a15eyZ1HdG2pKGlFvZ3fbzLbVWcRtRh6vJPxxm/axpanEHJI75Rfy
cpMKDIR+7R7QmEMO1MsXj65TgcY1rCUYNoe+98vtW5mngraGkwd/ZM8huks9
zAIzVOCa5OR4o2UO7byTWcw0QQU73uWsTkrMoyn57Ev2/VRw2OL+6DfNeVQ2
e5unqYcKLLkvmz69No969sXpkTqooPUe5+i53HnkfjB0jqOeCt6cj0hUa51H
Bv/qFSurqcC8wpbp0MY8YlYweGdUTnz/EIX74KkFhLc9vo9+o4LYV2769zoW
EOU9zl5IpIIrwS8L328tILcryaqnYqmgzCRevn7nIvrS1GB6PZIKNspOmCm7
LaJoJSGmPcFUQCnd1wbpl5CcEd/hYHsqEMpxS47YvYS09G3tHS2p4LpecFX/
2SWU8Mg4UdKYCtSa/U++jFlCb7ZmR2m0qOBX5wqdjPwyuh54QDheigruBQ4l
PLu4jKxsxH9zClJBzEJox5bvMuKQTma9wEEFjazLlv1ly2ju467Zc6sbgCvm
cSC6vII6xlP/CddtgAPaNFffhqyi1+x2tP03N8ARevJ97axV9HGF+ZmJ3QbY
89Xj5XjrKpr+1Bb50pj4/DAMlN+9hiwqi7DTsQ3AVppw53XNGlpKpdj5bq2D
X9+hWDvXBpLQqJETClgHLH0Fj3SPbqC311ZfcbmuA/09MeZfrTfQpUKuv3/M
14HI/lrWuzkb6Gdra0yyyjqQPPrc5cd5KhI9FhuRPrMGXNOAfHHkJnIeXvqy
++IaeD70XuJz0Saql392Lk59DZhfVql53b+J1H3+c2reswacrt2SN1bcQqlO
hbIJ26vg3EvNMbXGLTTjEpH0MHUVBKV7RF9kosG64ciwcmYFdNmoPp5To8VC
tVGn6I2WwekpfovvZ2lxetoHBg3VZbAzayTmjjUtfhk4QH9uxzK40VzeMhhI
i4cB3fDfiSVgFhq3oFNNi9P+MhNvjyWQtOt5qZYRHSb9FHMRfbsI/C/UfPW2
p8O5G6XDhsGLYII/c/cbbzpif05Dk2uLoOqcFN2fGDqcOua2q2X/IvCLVVJO
6abD+oX0VhFfFsD8vEi+oi09VvFRNBX5MQ9U6btXMj3o8bH/jqQZv5kHcQ4l
v8WD6HGlqE+/bcA8WNqVlNaSTI8zZ80uzZ6YB81k/5G0QXr8hrXBsKNoDrxz
9P5Tb8eAb1S+mllMnwV/aY93K5swYi+jbp3OtkkAl7RfvrFnxC6+FmOm4ZNg
emCoeMWTEWf18P8XqDUJGPIzR289Y8QOqSeF2rIngOmq8aefVYz4qO60+ZPA
cfBToLFQ5QgTdnegbb0kPAqiH/Q5xZ9kwm9uXPd5XU28L2armiYNmfDetdI7
kbdGgJdUh5m5MxMmpe58/6hrGASUItOriUzYSeGXcEbsEKhmN3jDxcCMq/bd
HWFiHgDbcn/lDHmYMSXooMD5vH6wKqJYEiDOjF3FPT6etSbYLu3dOyVm3OyT
yGhdQAFBtQEBdFeZ8XtUajh+pQ/ECXzuYUfMWNO+bW+ZQReozd2xxVvDjGk6
TU4Pv+kEQe+fhdP/ZcbTGpyHfKY6QJXtn7jUcWYcc8CvZvBRO2B7wPt+hZ8F
5x32E6Ep/Au49AobouxZMC6eFgzerAcxvhZHhW6y4ON/X+70daoDF3MDou/d
YsHLbqWf9rXWgryVijKGCBb8tl9ouC2tGtw8tP9hfQEL/qz7t+k/zTIQzdFi
eRez4O4oCbsXH34CneFhVf4aFvwgyvTAfWYMun87Pp/sZsHaK8fooiIKgXvq
Dm8jWlY8sZOmXHwsFZBiX53aw8aKHVgHZNkM34Fo0ZJD/SRW/NWrg1R79RXo
Vd0Y3t7Jij1me09GXruODnPezh/RYsVCQ0uHSi0z0PFJpG14nxV7bzy3Wsoq
Rw6n/aIvP2LFXWGl+187/EKlPFJapyJY8f2nr9N1papQhpfBubIEVlwNWwuz
on4jiTtFx0wKWPG7ahktBa1GZEK2jrpZzIpDhUyytnc2odX2Yl/nUlb88/Pd
Bh2GZtQRtf8eYx0r/vTvsODpXy3I90lEceUAK+64+M+01aAdRZXlZ46PsuLd
Y5+PWx7uQLXp5jbTU6xYvCrS9ZJQJ+JSv5j1aoUVT1tcd47v60IhSfxCJ6is
OHeRg2eoohtVhByjlNKw4VAFkdyE9B509Z2i6g1WNlz+KjLsvO8/5HA/LfYl
Jxu+KDZ+5uPBPtTxvHojnpcNP2YSiDdN7kMPZZeddETYcICJjevlMApilT7s
ISHHhtuiUhSKLQeQU7lrAsdeNuzSsGW7VjOAaGKvGPzbz4YDb3zLvKIyiER6
GpkPKrLhLJXt/HS+IdT4r24sXYkNB3tcCwq/P4R8b93n5DjKhh/Kj4XHzgwh
w6tmLV5qbFhHJu2ObO0wkvVbNbp7gg0Pa6a5pqiOIJ9ZtSZnwIb1M08Xnksb
QR6hB9XUNNjw20dzQ2LCoyjo92bAlCYbrryS58f1cBR5i809CdRiw68yj63L
LI+iwEFPo/VTbJhs2jhpYz+G9nzmqTA6zYZjoWPrz5YxRG/oUfdchw2rlz9V
O6U1joxG7a7kniH00/JMmsgbR0/IjU55umw4ImvyUf7OCfRW41fPKz02zEXv
7psYNYHUNW+mWemzYb5/ovPp9JOod1X8B/NZNqzCmObbQcxFWQfVOKIIth0J
CJcbnERXys2Cac6xYVGFD19eGk2h6or9QoYE512oubGzYgo5PA/6cp/g2xwn
1RuUp1Hh7AXDlwRPrbO9i/84je4cyWkPJfjpzgqxEKEZ9NW8CdgSXHy/eN+T
RzMoU5zkI0ZwwYvB8zlrM+i9wPiNAmL/qeXJB77Ks+jRv2WxwwSXWrvPyLrN
Isf9Ky7PifhPFKxID3ycRfUDv40aifwWwv70ZPybRcvqvhXzRP5zooL9QcJz
qG5QOneJ0AeG10xdOz+Hhhh52ToJ/b7qFiHT0Dm01zenNJHQl0slTPBS2RwK
bHr6R1ubDSuyFeVYU+fQOYaR9yon2XDKgElqtNs8el2+3ySIqGfzyOL9spR5
1Pqfllw2Ue9VK/1XG33EXNNBM51G+OOqbr3zk4vEXPL98W/fY2w4LH/8w+CT
BSQmkfliN+GnPfxveU//WkAJ6XyFewn/DSnxe+w5toh+x5hS7xxkw2cMnvSl
eiwivkK1jWzCr1c+Cf6nkLGIcm65bH6VZcP5gWpUC6klJJbWPfZkJxvOOe1w
fdt0Ce0zOXRVcwcbfuFTPpkWuYRKOUxbzxH98SI2XUaQaRlZvPD49kGADSu7
Jl9oA8uoo3aT2k30kzV7ZnCi3zK6cPZR0CTRfy61hkMnp5YRSdznevgqK14u
+Mv1t2UFyc6GVd9fYMVfava8es+3iqxMtt4bTLPi1ZWsOr8Lq4iqVPDmFnE+
rDjxjx5uWEUvJ5YsOWpZ8cWxfQw9v9fQIUce06YKVnzpt8zpBrZ1dM743H8e
iDiPZG67/Tqzjp4V3huHn1nx1uts2qLKdfTltV+xQDQrfrBYZpxftoGeR63k
p4ez4jVu2J5PR0VmjQlBYg9ZsasNo9MXDSrq5zS//8iHFe8M4jr3BVFRmK27
+KtLrHisMJ308fsmmh8/5XGPkxVvPHw8t/55G7FYZWnk0LPiorfhBo1z26hK
Yd6ncI0F8yqubhgK0+DBh2UMpkMs2GOv9GVhExr8S7paoqKIBfuUyVbdaaHB
3kV+K+ZWxN+zRZp51tFijYWDOjsusGDztuGeuClaHH5NsKrkFAsWw74vizno
sKCTjkHwfhbcwxo4MKVLhy3oXliAVWZMDjlTRVdJh+Wqx465PmLGyV+NaWpL
6HG2Cqsy6y1mzLkv889sFz1+rP2t6q4zM/aCp2U51+nxFbWnP6lnmbFKQFXZ
viMMWKHHRu0ILzN+shDybSOTAR9cuMD/6RkTdlVjRD/iGTHnxf3zs3eZsKrb
33ntQkZMSTufRLrBhNksxTvLWhmx/J3BwGF9Jlx4uZAjnpcJJ+EhukYmJnw5
J5Gx6AET/qZ0OaeAmDeaBL5fiXRjxvXc5x9kXmHEZ5RZXQ3DmLHtJ5b4u2cZ
8dAB14s0qcyYjaEr+YssIz50SXdVicKM/6mLKju1MWBNvd8pk4ROXIGfxLYU
GLCZP12r62FWbFTx9ja5lg5/V2/QvzXChlkfK745UECH1Sonhwxp2DGPxT5h
0SQ6rNdVpSMowo4b+mVPvfKkw273CjtddNnxrIPE7E4ROhwoe0D1VAY7bmtT
84u0osVzIalmQS4cePPXtkWhNi3ezxuSrBzMgV990fEulSfmy2RF75Z4Duz+
Kf7B7S0aLCB8fW9bDQdePJzRHJpAg9mOJYxPynFiYZ1nyaYft5GkuWaLai8n
li3llqR6bCMa5kXxD4ucOF3Cm+QAtlFp24uiNTYuvPCxf+Vp2xYS9Va+bnOU
C49m+GYrMG4hwzbuStkILqzmWpo5ZkxF+WjjnLMqN6b7VqZ/uG4VfZH9GeUN
ePCe73JbNBHE/H98s5VWlwd7V9puPTNYRUy6hV3+Rjx488x8y2r9CoqTPNR6
+joPNkgVMZ7+s4zEReLPSEfy4N/Rsq0ffiyiivlbB9r7eDAtw+3P+bcX0UkZ
ph77cR6c/sAj/7HKIuJuimIaWODBN8O8DjzMXUBZEyM+6Uy8+Oezcrm2pHm0
1qaX6rGPF794VX6IyWsWnf8YK17tzovFI3qLouVnUe7LlsOnbvFi2X45o4H6
GXSLzeBpdiAv/hekls6dP43CbZ2+n4vixQeNjCNu+Uyi47T0K/l5vPjCWpW0
6MQIklN1+cEzx4vbaVpv1pqMoJ8Hik46rvJit9cHmsTLh1GMk85QxjYvZpSw
UYmLH0IWh7WObHKS8P1Wxi/C2gOIh2Zq57c9JMxlQ/1rzdeD+Jo9SI8sSTju
orn9o6UuZDMyrathR3C9X5FQWycKL3mxY8yRhAvznebdYtqRd9WEK8N/JAwq
We9I8LegSyy6ko6PSTjq5C/+uLkmlBi+68+LcBJ2j69iflDXiJrPL2dnR5Hw
LbkvX65w1qNIdrne7NckfGjqLmNXXwX6kSrg155DwtriVdeYo8pQb0KYndcX
ErayJR3YpfUT/c1llaApIuFfaoolN7QLkdudhd+9pSS860bYyrHUOMRy+lgF
aiZhvbdBUT9776Kdnw81V7eRsI1IjsLj+yHAvjPD4GcXCf82WfOK2pUK9I/p
2vsOkHB36zl296kf4Nfu0h+M8yTsGnVW+L+Wn2B1gIXqt0TCjj1MLqKHy8GL
qQG9rlUSDvAJ6ZZYqAKeH0qXr26T8NypI8971RvB9Jj6qSh2PnzZtZZR270J
jMTifjcuPjwnW6wj8r4ZvFJNVDvKy4d5pTWtt9hawfNE7aWngnxY+NPR90k9
nYDlpoH9hR18OP4hvKbF1w2Sz2kWRZL5MItD437dMz0AIxVftIsPl4RxV3sX
/AMUS3/m3t18uG7jwPM/3n1A32JXRf1ePnzm9TeNcBIFVH++V565nw+3hf+X
EaPbD6p6xmzkD/FhC59XuyjD/YBjbG6yQYEP8+gEJRgHDQC67g9R1of58N74
3R5LUoMgIK5Av1OJD0uFctPj4kEg8mmMS+MIH/5qbJqRf3kIUDVFGqOO8uF2
ruKapuUh8OCKUmiTCh/ui/7W9khhBKToni/hUyO+X2/QrN89AqTYbrTsPc6H
3723dFR/OAqOqPWo7j3Bh/nDo8otFMfAvYT4IV51Psx9U1QgpWcMnBSqrKYQ
bJIY9UD88TjwaYvtjgVEPoMip4qVJsBrO2c+VciH3QM174T0TYC7+Tl2pQTX
q0ia+DyZBN/1qaWKGnxY8ZwqzXOVKXDUcEs2jOBD0W/fNg5OAcf44JDfBCfe
6rmq8nwa3Om81bJAcArDikf5iRlgnDTOyqDJh6+M+iz+Nz4DnPw3xKjE59TK
L4/e682CO4ILNN0Ej/DlrEq9mwVyasrZyQR7t+ZZZqzOgnPUkxIXCXb159A7
YzAHbEuRxjgRX7Rr1cXlD3Pgvt01vusE04YVsuVR54DXMeHH9UR+xj+96O5e
nAdBR+tiJQi2fmry5/KneSBB8/74RUIP6wcBm5q0C8BpvcnxJqFf/Uj9LlXT
BZB6LU/Ai9D3vPhKi3r2ArDzLVa1IfQ/qeOQaMi0CMJtguuVVIn8/14SuGG5
CG66498zRL0yNqsrY/MXgf2uU3KRRD21Lz8+3cC+BIKPMXWKEfXOuC4nQ7Jb
AqRKwe4nhB9C5GjmrIqWQNO5NJkhRT6soVgeJXR9GcDh7zf1DvJhD2QeGoiX
QXSlut3lA3z4+6uHWctCK2DF9czdc/v4cLnX1+LVXytglfGy0LQsHzYqqC4P
kVwFourWITGEv93anx4R9V4Fr6ZnaPYS/i8s2/ncRGYNDE/yMdFJ8GHGWp/o
7TtrwNcsLVBHlA9/NglSz2xZA4Pv/8x7CRF+4yrKFApeB9fH9r4MIfqNIcfm
rvjABuAfkj/hw0D0z547pCFVKgBJBjmLNIRelOTc7Egq+OokNWa6ScLJk8Gn
zmhuAspNvVd/if4vSLHjv/92CygpPbFMHCLhHyGTl8+ubQHpQ8v/XaCQcKDb
YTbh89ugLNJ5/2Q3Cf/kK3C+SEMDvQqknJuJ80i5vTatLpsG6t9+VXwTk/Dj
fJa8rk4ayKIFbG9+J9bXfKw8zEgLq/L2e5sUkPD5eLbKeXNaWPnf5Z6udBL2
D8rZHGCmg610ztYlL0nYKEU6r1WRDiqdbdm/GkHCqRZl0hWWdHDZrNhINJSE
J18/PvMijw4ymd3P4A8g4Uv712OWrOihuOjec5SrJEy1l51Gj+nhZMkSvmRF
wvYecseC8+lh6EGPwDwTEk47saNujZUB9uqtTZF1SVjKehlF5jNA1JRv3HGA
hN/FVTPosjDBw+aLp97P8mLW/kChWEUm6PP4mn/4KC+mTlQ977VggvdXDzJc
6ePFPlxW7Xq5TPDbuSsMhfW8OLJ/p0vaZWYIFP8sa2by4hae65HqqSzwxWkn
/W92xP0YefZMRyMLFCwX0BE248WvB040O2ywwOPOIfnWhry4eajo1uVzrHC3
ddTk++O8eJBVszF6gRWqRPWqsvLzYpqKUHugxg5jBkSrj//gwQdObQJFG3Z4
aV/j1N88HqzPf/Gh4EN2eHfVavJyGg/u7w1597mJHf7bkn9EfsFDzJNfFw9f
54DzeS7fChx58M+fL2wUozjhsWMzx2c4eXDBnZMast844bPU1SMqdDzYnmnj
I0sPJ7x1WLygfZIbB9331YuR5YJba2Xu+0u4cbhk8XjPNy545GfROMWcG2ve
mt3T2cENF/2z9j97zoXpfq1XJW1yw4D/3M899eHCpKjwB2k8PHBa/8YrG0su
/D6iavi4Eg/ceN/YGbGbCz9L+Ptq6BYPlNpSbWEo4cS8Yhb1e5l44cuE9ESr
Xg7MI5BuO8xHgsZfGSz16dnxYv78eqEMCdo4q6vlUoh3mWSkbsBRErxsN1Q4
itjwM66Lie1mJHi85zNDw202LKSMORuTSLDnQE1L4BwrHlrbSvi2hw/KpCXY
RrawYNMLQ1Ghqnww1tM/SD6HBReuRYbo6fHBTy6h/IlhLJhednQi1oUP6p43
Y9jSYMGXeDhq7LP44OuQjpcFGczYaqVi9zt5frh/s+jwwVtM2FzIUsREnR8W
vY9+Kn2RCcePLxuvneWH052JTuP7mPDmgXdnGF354RYd83GaHkZ8lvOhmson
fvhtD/s+eIIRawoef7iwQwC+0jV+oLBMj2Uy5W04twWg6LAvHtOlxTNTbrNm
7IJwca7kNkWaFmt1sbm/FBKEps8Tzxeu0hDzFmm14aAgbLxo3sn6kQaXfBPb
tLYWhAYmz8Oubm2jL5whQn+KBKG0TsCreyab6PKz0c99FYKQtkJN6SXtJvr9
dj9XX4MgVBFuinFLp6LUtxeL3g4LwsGfYeM3tzaQY8PysDyvEBTuSREtfruO
RuRNiq/YCsG61welc3tW0MgF8Xo5FyHov28i+0jwClKaYAzs8BKCbHFq8yF7
V1Ba50Qg9ZEQzOM83x7ovYx8Yuu4QZYQ/EWfv2+bfQlFn7zxNGVRCNZ6/mLX
OzCPJq3/fOLZFIJypjQ1kQ1zqL9o3NyOURia2+vfSfOcQzdu8B+rEBCGIkWW
wqcKZxFueSXtpywMP2bt9vcPnkaMgJPxxU1heMbtVRjp1Shi6dbc6eIjDPNH
Im+97BpBfyubfx0IEIYOfeMN5VIjqDT7oYNrmDAU77d02JcyhN4BrUfd74Xh
+KdtpX2f+1EHa6Ph9idh6HSzzHzXIgUxU9sU2HOF4YGXJMt6ZQp6qvUfS2+x
MBScqLa/ffMf+nD5vzi3ZmHIxXJZU9KzA62Sa7+1twvD81wT4sbzbUg4jePR
vl5h6Hn81t/1m61o00GMOWxUGBZ4Kj2KcWlGftdZDhyiCsPhs2P3HxfVoNvm
H316aUQg7H/0TimnEnE5kHi9GEUgvcAfw5b35ejm4jSNOZcIrL77u3JNoAQ1
O/Q/ZZESgWkJim7SZpFoa+wO8ypZBO4JEeCxGfAFk87XPOtlRWCdeo+cZ/Mb
8PZP4pKyvAjkvfw6/DdzPnCUoyyVK4hA0s7tSmalImD16nKxmrIILG6NN2JT
wOCOa+vNPjUReHwpWq/c5hcI+/joDBcQgZS/oZ3ut6vBmR9/SnZqisCcwdi6
jZe1wHHKzYBRRwSeOUPjUevQCD6KN66+vSAC73fVfzqf3AaevT4WwW4sAp+I
ZP29cbgDoCHzmxYmInBHyozobFknaDu7ezLPXAQmpX5s5xnuAUvSxZ5FliLQ
31lII8vnH9DX7pFKtSbifTrf2BzcB2I0PmIVOxGo5tolZCTUDxTC1991XRWB
wuy7pVv7+oHIEeUQewcReKf2GG/QpwFwqOG6Ves1EThIuiNt9t8g6Iorl5G/
LgL/pKyEmqkPgRdhoU0uTiKw497FB0Esw8DeSsQi0lkEWgf/1WtpGganPowU
vnERgY/P2fHpvx4B19qCB567EvuvBPKPXxsFuvO1u/zdRGByy67MgZNj4FgU
OVX3hghUjJExZtkxDpIld9qtE7xxUJjdhDoOrH6H6z25KQKbv3P/qWufAJ3f
dExo3An9ipJi3L5MggOMJncuEex6pN9JOXIKrPX354QTbL/qBsk3pgE5W2Ui
lWCuLw4CSvoz4CpTlfQHgk0Tv87n88+Cr5079YIILuzqNLYJmgXhj+isThJs
3O+TKzk/C+YmTpwfIvYXtskKnLwyB6y8msWuE2x22067pn4OPFMfzK8j4q2+
qun3VX0eCEp94RMkuIta/Covcx4gnHUQEPkecOKQ/CG+ADrzLGl0CT1sCxQe
tYYtAIMgD/8jhF7VTsvnqesLILzq5xsGQk+/A1PL8k6L4DzQssgn9Hew8ph3
7VgEhzoEs045isDR/Az0TWcJ8DTeevKNqB9b79MOrm9L4GxqboMmUW97CmNv
Z/QycBIukTOzEYEXfe6UGDCtgPwDv6cuEP6wizZr/uO1AnwkFj6NmolA9wsD
jweMVkHhL6cXIaaEX2GvxK3yVUDbltRIf4nI/3V/nZDSGkh5G3vgvaEIZDSK
c3HgWwfBmRTw66wIZCkk6wkGrQOj4fkn1boisHTYeu/v+XUgYcWPPbVE4N30
nFqNpg3QldgcJ6ohAunMFe/RaVLBa+Wi2HcnRGCbnrbAr1wq2COzMm18RAQy
6+wru/h8E8jp7Va7rygC924K/Ran3QIZ/kdePSX60ziyPnL45hY4uFfd5QzR
v++ghPotw21gORLOfZZfBJrrv7lf/ZAGtrApW9/jFoHP3JqC0xANjFRXff2C
TQRi3XulD1doYNwe71Zr4jzZp6/eceIaLXRUSx68Ny4Md5ddGnykTQczOR/K
THwTho8up/+wZGCA3S4dtkmfheGYbGDiGRUGKOJ4+6ZqBnGerbUrHHJhgGGH
9qyJJwrDNy9rH042M8CTRxmy4oOEocDRS1gsmRFqv6PxvntaGLZKlj4gQ2bY
ZXH4yX0gDLl9ztW98WSGGyZiHo5HhaERzdYRUgozrLZYzxmUFYZPaJoe9HCy
wDNPSRKvGITh6Qsx3dudLPC5kxt5qEgITnwDRzQ82aDo1vlRpVwhaPtw8jP/
RzZozWAQfz1FCEYyqn3vameDKg95Wu5HCcGEGZbHJ9XZocx/n0dcnYSgZbRR
oycLB7TaLZ93lE8IXj1u17IrjhMKwgcrOYaCkD4i8U68KQ+xn/Cup5qC8L85
nRZeTx5I/rF4WFdJEIZeY06+85QH6pR/lLpG3MfOMUH8B0t54IvBAckD3QLw
Q1K7Af0+XvjmQzjTvLUAdI375X9mnRcub4v96DMQgOlNrfrLxJzjYua5mAME
oHRHsuHLAyQotSDFtiwpAPUpdQ5pV0hQo35TlL+bH7YmZ1BkfpEgOSzX8ZMh
P7yg4NtgGM4HuaVs3xQQ8wdXZYscTwofvNR4SfjDfn4Yp2fjhxAflPq8g2cP
Cz9Mkin1n5rlgybXumLrSvggV4iUQtAFflhlLbOQsJMP1nivv/AmCUDZd7Fi
BR28MEBY/XlosCBk+aYY/rSciLu3ryohThDuFXiir5vNC/MMpB3icwSh303q
gmcwL/S67nTBslsQup+wH398gBea3t59Z1ZRCKKClOYGYt5jGl2NU+km6rBR
l814lZgHef2d6OaEIOeiF5P0WR6o/XHkUwFxz++zWfNkl+KBZrGp9L3ywlBs
OVTELogburjeKdl1TxiWbfyT/cTABd0ZY1p9JEXg/P6P2cvNnHA4MdO3k7i3
xr3qm0nJnHCNjnjgnRKBofUf3xZBTjj1zBx6EedMquA53T9+HPAIfxjvcgFx
z3BPOMsNsMHwofnhq2dEoZpI1hztC2YYzhyhqWAuBl+bm9Lp2DBDaxj2n4mT
GLwW90Hnujwz3H30p5KDnxhsjiLvVK9iguE+9awnXonB03cO/lVeZ4Ruc8E5
fxrF4MQL1rUgEwbY0noxyFFTHN51ruaMJDPAVuubmZyG4lDdj44cMEUP7y80
CsZZisPsmHbauUB6GBQceMnRVxxq8vF8086gg8wBcqbtGeLwlEa+ZdcqDSxf
m9qxxCMBxTh/ef/7SQODOPbMM0hIQA155kfloTQw2VK0en23BDz+7IaJojgN
9JtuOB4DJWCnE9qpdZs4R+7fUohxI7il7uHG0jrIKDfXT6iQgPIcjb7nifcn
c825VvoGCSiYdOj9DdI6mPJwPWnYKQH1ksR1mOTXwO/s1vuvpiXg1Muje1Jt
V8DQH5vsHgFJqM22FCBaugA+h9ZLqVpLwpQ/uVc1Ty4A033PzrxzlIQeqjtC
DpXPg8e+mpfG3CVhuVNDok3FHJDTPVrFFywJb8k5z+iHzgAFJ7fBto+S8D+v
F62Sj6fBFG3dulK2JLxNYzwT8nAKfJDXMbn5VRK+4qSShYMmQCVdV/T9Skl4
TeFGsbPXCHD5r1qWY1gS7rTXMWJyHwacx3XtLk9JwoXkbxzAZQjMSRheCF6U
hIz9TvYRNgPApmeKxpNOCortt+B/FdELWKn9X3PFpeD7EtaJqXvdwGxq8c04
WQp69ERoRLl3gvM9Plk0e6TgzDOBtCbDVnDW4yNDuZIUpN2nFF/DVQvErEiV
H3Sl4IXjPKz9w5XAU4pl7y8DKWizKZX+vaQMWJ8UUS4zkoL8e/zyn9UXAG01
I6aLVlJQ1uq1Ed9kBmDyOJU1ZCsFV2u/bn92jAEKrJSfRtekoPrfs48adT6g
vfQ2c5U3pKBZlpYpF3MearppMPvbUwoqRt3/OeD8HfmHUXdk+EjBdFuh0Q2J
X+hPgMM/mrtSkHG5LPn5xRrk4+t53itQCm4OLIjtD61Db6L/lVSESME4KQvq
Af9mpI6PGa6HSUHtfyYdC7F/0e/LP817w6Vg2sjmdcWvbWjuWtf+N8+lILdd
Fhxp6UCe/xUXHHtB6AHfTHMvdCHdb6WTOdFSsJ22k/4Tby9aU/IupY+Vgtma
7x9eFu5DGX8e7VOMl4KDzCZSDCr9CPVcfSidKAUfMjqWyOkMoDt2V237k6Tg
wAE87W86iKYuHHwb8E4KOrKx+TJeH0I7nHRVlpOJ/ZvtJUr8hlFm11XxMx8I
vbud3iWHjqCHDqaaPh+lIC/Tnpqv8aMowXVP4r0UKfhr316T1YwxdJybebd9
qhQ0feHJfvXHOLp0XK9pV5oUnHsTPFJRMoFiOGZdCwjuNpY5pVcyidaF9drk
PknB/E+3dywUT6E7JsJMfgSLyp71Ki6eRsdClObTCE6e2Vb/WDyD5I68jioi
WGHibLGJ1SyqGbzZ/4lg2Sz7cOfeWVRCO9N6i2Cq9TQp3GoOCdD7Xt9LsF8Q
5deP3jmU5vk0spDY/04Iu9ym1TxSoWvS3U1wviZHjs6/eWT3jDXMm4g/9qlJ
b5L1AorXENF/T+QXUKAsz9i3gP48Zn6YS+S/zFMu5nVlEfEdpyq9IfRpv71E
nu1bRCKx0MDpvRRMGotEXjZLKNgS1AsQehYPq7ky9i8hiYbgrKS3UtCHfC3l
je0ymqr/McxG1GPXqu0YHFhGO/uL3Y3eSMGzy8ZZE3YraAzcPOOfIAUdHIH7
m8EVxDE4cS0kTgo29a1kmNqvouCYq5UuMVLwWJmfH8VhDTkWVCt2REnB/gdH
t7NG1tCto9WHrQg//RHKGrnvuI70SZPWpYTf/jsiWa3stIG+2KrI7H4sBZn7
J74ITGygC14h+XseSEGZDLGpVWcq+qV0wpwtiPBHUuOOStdNZH0no9vxjhTU
IEnw5E5vos2C2KxhXymoonfpYMKNLaQtZvngpJcU/HK7mOLpvo3+s9Y/GudK
+DPGUfZpEQ1WGniv/N1CCub88/DbXqfBrm/31h4yJfR0Fjl9U40W36j7qxdy
UQpy/burqV9Miys829ZrzkhBFFqgM1xChw3GK2qriPMgLZmF5tQWHR5p+HlF
+aAUzO1X4k1Sp8eO/EPV94jzg5Wz7aAuosf9ksf58yWk4CwD/YADZsAFB4Us
nzBIwTDPANkHP5mw+/F3TXS1kvD4snL+aRpmbB6ozhpULglHPf6+owXMeFFb
8OJAsSQsdNBKtCxmxhukJmmtTEnY8nR4PauABXdTdxY/eCIJsYS0ZUAaG74q
3viX55QkbEzCwSn/+79b4UZGpJokrLqySS2XYceBh3H6ooIkPB1d0dn1lh07
yxbsuSwpCa0t/fZ5xHJgBt1V9/dLEtCvUV+S5QEXljU7tKz9huCjZRUmZVx4
48KLjNpICfjkvnv6KxpunDQuhxUfSsCY2+v7R25x45iIZp6kGxJQ+MP6otVR
Hiz1VKtnW10C6v/0yHm0hxdnHY3+1t4mDmtnjLe1mPhwRV03k9i8GJTryDqj
KMuHUZgNxYEiBvXat4J5tflwlpWce3iDGHQkaez9EMKHfR36u29miUHwWjFP
nIEfa7Pukw12FIMhLGNru7cI9rHdMfNXFI46HpQhSwhgKwXbgY1SUeglfTaf
7bgATi7QIg9li8JneWIWaX4CWEU6Ve/sY1Foot/gILwogPtgVq+XqigUqHyh
HDckiC22NPYqR4tAnuqx7970Qjj80IFYnvvEO+Jx9k4oLYQTBqN8q4n5g2lX
0WqMhRAePHWkthmKQBqzvVetmoSwxG+nVP0xYfji66dagSJhrBVd8Lf3sDCU
U1+Nk/UTxXt/FkN2Yt46pdOuHRgpik84LMw6xwhCI+5x4ep0UXzgeXpazj1B
yHs++YtQryiu0bX1HybmWO+tnoAvGmI41cz5M+OsADzEMjDbziCOp0FEP3mP
APwUxv+3XVwc099/PFTLLUDMhY1bP5XE8RvnAbLFMj98Ii6QaXBVHDvnv369
t4wfRpj8AMal4vhQVVDDY3N+6OB1v3HGTwJ/prO9a/eQD9K9y7nq/UwCr6GH
Q04ufJB/zMJt8KMEPvdIsN30PB/cLGD8z7tZAhs5ge+jonwwynZE6cY+SZyj
cmy6M4MEC0xcFONbJbGcbx63RC0vZEv9ej6CYwdmGlUO9J/jhuKuIj2bgjvw
jwv+rf453NB2SpzGQnoH3hprcz5zgxveTlr7Pay8A0dKmNmenOSCJ5w0vypZ
7cCDRS2/qwc4Ifrsu5ScvgNPnji/bl7NDrf3igYwfNmB46cq6A6FsMOwLy1v
L/7YgT8eaXneDNlhi1ybf0nDDmy5/sQ69CsbvGfa2l+yuAMH81558uMdK2w+
ccTz6jFp/MmClH/vJjMkveb/kqIhjRUPz9Pc2MMMm+CNlPYz0vglV9dVhX4m
GHvroT29mTSe5c1JPHyRCSorspbd8pPG3xvWFI4cZoTD9pA8lC+Ng9Lfy/tM
0MH7Ox7QbX6Xxs9xeVfNWzr4ZH3lO22ZNKbrfuy9YkIHpb8YPGxskMZuTb/y
ustoocXTEcnHE9JYP/U2qS+WBnqNOEWclSDjU6XC38gBVLBqXK1aQybjQw4/
gk/NbgDmbNFQ5d1k3HLQmumA7QZIPmYw06ZIxjx2xTr6p9bB6vCXJt3TZHzj
X/KPTpZVMC09Ha+mT8YcCXYyin4rYHxQHYueJ+ML9HdCL4wtg77YzeVkMzJW
/zh0a7ZqCbxf99pLcSFj0ZQo5ZyQBfBaILDjpDsZy+/I/mO1OA8yS9gTX3iR
cSevZFmn7TwYDIzUpwkgYyf59xvHwRzw1xE/t/2UjDlXP17+b2IKuLed+dP4
nIznSyJdf1VMAg2Hz+TIl2Tsz3tsZ3HiBGj+bqvQnUDG4U7U+egLY8Da2Jnt
5ScyDk0Zw3vyB8HOBalrfzPJOIJl4ta3sAGQd/2EFX0uGVfUZA4u2PaDePkd
23JfyTjA/tllL54+4BDofzqqlIxHvE7UhdS3goU/859BBaFXzrBHll8LOM3/
4H5HJRnX/nnZrbmzCWzz/Djwt5aMsziPPL05VgO67B5wTf4l45nY8GgzrRyQ
rOzfS9dOxpni6vljrvGgUnGwl6mTjJ1VBZasbwej91Ncl1t7yHjn+NyajPMX
dOEfc+Xbf2Sc63o2a7jrB6Lz7TprRiFj1gHllZNy5aiE7mxE5CAZf4rVF05O
+INsXn9VJw2TsfEecS6j/Y3I7mT0bMAIGTNmTChXhDaj2+MBie2jZPwkfent
u7G/qPSjqLbUOBmHHcmeGdNpR2t5Mv8uTJCx7Ury95jUTvQ74Ia95yQZH33j
+zaDpQc92Gcpc3uajPds3SBtDvYhgeLpDcsZMo6BTO5vuPvRUPQeJ/lZYv1/
4XXOqgPonlyw8yTByv0+LFftB1FFxYONV3NE/XV+b4Q8G0K1Jb8FFObJeEn2
UEjD92H01WT7y1eCeSom7mmOjCDff//a9i2QsUFBf00naQz5Z5zweUrwl9VY
9Rj1cWS0ZyOim+BRXpWvfk4T6HAXh6TIIhkfO/CAOyB6Enlf95M4SXDasTnp
96VTiOXD5VAzgr3Zw6rGp6dRUUT7FWuCJYtD3FI5Z9ETu8OvzxP8qNgxYTx5
FvXGFqopEPxM1sNMTXUOPZ+vVdki9vuht84f1zCHdtymPPtGcOFPeRWma/Po
+Ut/eIVg5QXSobub8+jG9jGtJSIfudx7jgwviDmt/WeMD8GoYvfZl3sXkeCn
JtURQo/k4KgzCj8X0XeX43JaBJOtpKvbTJZQXwTFLJzQL92D/eij6SU0sl3Q
VEHo/Xvn1S2NkGWE9peHjRP18EwVCmUQX0EXeHYGUafImCFpUqv+8wrqVaIp
2CDq9+RDcOzbM6tI/Xuc9ChR39pBi/lbfauIbKNV9pOo/72MukIznzV08KFN
zKMxMn5Oz2MGudbRgz1DTT2EnyIi9/8RPb6BDtW6H3YZIuOP6VWeXM0bKPT0
j5KRATKO1/gax+hERT8Uc7U/9pGx5t0P3NRXm2jvHz6NsV6iP/ntDq3Lb6HY
pCwLEcLfPftnvdcqttBzy5YZ2EHGc9YfRdYWttHo7s92Km1knBJXt/POKRrs
u+E6J070z4rwPamNZzSYfHvpYmYDGWfXqwguy9ESvnnHPvGLjPmlgwvajOnw
vIjuLr1yMrbhEdyj+5YO31VK04v5SfRrgdfbwkk6nClsV7r2nYxfSGh5hgfR
/1/DZRpP5RaFcfNBZo5jdqb3OLokuRnLu1GGqDRL3ZI0GSqiRIroRsNNZaxU
ilLmokS8y1zmlCkSypx55pT7fvx/2Pu3hr2e9WzI2Vhv2JZJ6qOAjTUlWwha
cnJSE9OYEJpScmcvTwg2K4xx97xggn2KdegzG2Eob0gwjXjCBMH0Gg29TmGw
LX/zSiyKCVv883smxSkQ6Jre13eLCfn7eT4n91NAfztRmX6dCb+O2H3rSqfA
fjr1zvxlJmy+XJqX4igK2bZhOy6fZsLxC4nN76LF4ObKmKU0DyZ82D14ubtP
DDzt1+0qPsqEnlMTCzwjcbi4cInxfD8TeAxSE7+Kw+iuwxbHSH22McSmrqtL
QKlzW9x3CzKe9XlmNicloGAHNd1iHRPsUlzNp4okQNDXX750NdnfKN9BVRdJ
WOgSli9QYoJZb4JKcqIU8K1okrr8kwFqjs1XHkfKwAa/R1tivzHAmKq55Jkn
A8fiW/ximhmwVBr7flWXDITsGgvf/oEBvBl1l9t6snCqGNcpecmA4zXOdbW1
stCs8q9CqAcDdm76EjhPkQdFd7dXxocZYJBUVCagJw/4kG9QK7kPeW+a7Jd3
yUOkyo6sZnJfVt/8sK3uqTwoXeFj1XEYsI4QGC4yVwAHvh63jA468B++0kl4
U+FylH57xmc6RMasO7M5mgq3NESfPqiig8fJWI+aPCpwdk+sR3l0+KH7ZChh
mQpHIsAq5Q4dMkIK26/dUITvQrlDfBvogCqMfN2f0uDqPSf7NhM6+M27LS2V
02BMxOXQIz06FO/vPHdhgAbPP+/9OK1C+of5M2/sdJWgfa/No2vdmjDTX6gg
+0YJkitcnSlrNKHcqbhev0wZNpjkP/BT1YSHzpsyH/cqQ4sc0xSENIE36kDn
iahAzp6cyiHS73SqBmr626lAXF48f+x5DVj0ivYJrlUBOfUimX156rDy+d17
2Z9UQWXGPl+O9GvPQpOD7nxUh65WiUcjf1ShXqfMpmNIHQiHVPfEblVIttf4
JCahAeFXRVhRz1Rh/7K+h/QWDbCUcFd9sUoVCpaNK4gGDTAyLhh/YaQCpxyl
8m82aML26NpjdCUVuNnX5PhnTBPeVUfd8p5XBif5pl/PKaTvulzvnpSnDGk7
+SKqOHRY603J2GqkDEre1anb3OhwuKboTwtZl/PxBbk7yT6dB6q2qIQSyJ57
fVx8mA5pQzv5qUM0UNB9sS5zgQ6OFq8sypNpIFz6ZqpckQFlV96/DVWlAbFC
ZQ/myIAq+kJlDJ8i1PHnjccTDEh66PdR9pU8LFpV8WojmXCpM/9x7Q15kLYO
uiuSwISAmZA6j2PyMPCXR4gOObdPg76VbFWTh947SA2ROjD5slknP0wOXGJ6
XcNIXf2lPnvB1FEWdL5NqPjYs8DBRjBSl/x/WKbwBPx3s6BCwvKQsIAsMKuF
VrsfYoGsftG3w69loOc7lyZ/jgXSD1lPuxRkQCd/yNEvkQVhM+WCi8mSIDWf
ddJrkgXOjLUjCTsl4YDLAm01jwUKuIm3jKAkpNjPUjqF2cAOar7nelACkuuc
Li0psUHtsGFxGXUFsL+GaZmZs4HV8iOt+rwoFCrphkIYG8x7JT1DMFEI9rr9
fPVNNowU3tdd8YkC8W1F2tej2ZBMc1F9oEUBnXfWMsvJbDB9kH28sFEYQoor
BrrK2XD9YlKHA0MQ2Ham2iH8GGyqlx62ahCA307P/lISxeBqSvl95UsCcPFM
QtJ9KQwYpzNlXTv4gbGP1nhMFYNu08W4U9F8gPQfiyj8jUE4jPC7WfGBjItD
iqQpBmEFq7/69CwT9rMGPlM4BtOb6hdl4v8Q/seHnULtMbjPaxu5JMgjAgrD
vV4fwkAmNK8k4p8lwkJXzUHyGAa/b1v5OL9dJCyb1ont8MRghWBf43b3BYLK
zllKPIvB7KGjlVm1s8S2yqu1DtcwiNvSP5l6bYIoLllRVpeOAZeCeXh1jxNV
0e+u92Rj4PVO98Wy0TjxXaIrrTuXjJdcgvofRwjO1EJHYiEGmXd1Thw6N0B4
rD7O1K7B4GSYEF2B2U+wfJx+xNRjEOp1+apPTS+xqiOiZKwRg3tYxhUj+g9i
8dJ/hGsbBv+ua9shEd5OPHWJnXLoJetz4Og939ZWYiIuqFduAAP21NrPttxm
IiDXkygdwsApRMofr2gg1hV9lO0bw+BAfq52HbeGEEp+ELRnEgO+9mZx8bIK
Avwt815PY+Bb+I/Ju9G3RGhWdojOApkvVWVpdv1LwqY0VMhuiay3fle2iPtl
ItDA1NzxNwaf71vY8+9/jYsI2BIa/ByQbDMrO2NQhOtPOSz1CnCgdnHN3f3/
luH152+3xApxYAWjeL2daz2eH6i0r4DCgYuKZte9njbinlXbMXsxDvT1aFMM
Yppwy23FOcXiHBgsNXzlHdGKe9t2CGhKcMDTuWAlJ6gdL2kxFjssyYEX0z8l
N3t34p6siOKbUhzoN+4InHjVhdc5PcAeSXNAW/66hY9uDy5ecEAvVoYDGt2d
bK2UH7hfZlurnywHytS0faRYvfjYRwM1MzkObGhZ5cd52IfT2rKm+kiuzlx5
3kt5AD8wmb33vDwHpirrPnRHDeJTQbm2kyRLg3VGiMwwHmO5p2CbAgd0MkzO
2N/4hZt7O6bFkkxVrHFZLzqKp2WdUywj+cJAIrErbAz/yC2ebiZZwXzcwy54
HF+8aW7ZQHLlxjj/8+YT+FodzcVMkp8pu2jn8yZwqclM2lmS5c49SRQvmMQj
A/fFMEl2qbko5H5+CudTf+mdS8ajaPzVt8VoGvcZsUheRfJ/4S7U7bPTuM2n
Pp3/yHxM8SuibTkzeEBYgNAXMv/ayLDTHmdm8c4knhYfyQnH3E6JrpnDsffX
7sqR9XI7OsPJHJ/DG+1crFaQ9Swa/Jx3IHMeF6xtNhgi639R8oS14skFnFp3
5FAm2R+nzOHxLzqLuN7Akw/OKzhgX/qI7vZyCZdzVzByE+VAXJdD/5oTPLzk
nbhxiQgHrrZ3bRbm/sadhQyOighzgG/pfWB28h+c/n3Q3IJ8T+kPaaERbst4
rZPOT6NlDKwUUVOWLB+yzxZNUyDfX0zqkMfVBj60WL/hXvA8BuJS1lITevwo
I9L+vfQsBibRZ5adbvEj5bWm82FTGFTfQhLMLQJIMMjzDWMUA4eFV0E3qgVR
tzBTk92DQQpj7caOlULo4eVbPT86yfngr27iXBNCX5TMciLaMTCL1/3vpa0w
+nqy6OLVLxhUdX/kHSwXQUJHtjy0L8dg3HRzxnk2BW0+kAFmxRhE1995dC2U
glLVt43IkvPf6dYXGGkhivoKU4+czsHAMAK91iwUQzqZUe0ziRhEZCquekAV
RxLWY7wTCRh4PH40J3lSHB3eLh1SGYeB/2l+4QaNFejWyEKO+S0MRi/kDZde
kkCufSoD6oEYyL1fLOpqkUBWxQlm3/wwOCYn9ntMTxJN1PAtXTmNAY572Pz8
LokiD7wpvXsEA4Wt1rPKuDSCj4YZj7dgoDgxywcx0ij+k+ftVFsMFpZW3dk1
Ko1m9CPGHlli8CRSZvjZFhnEaczHNhqS+nKc//Dfv2WQ6A41CFHDgMkLzQp0
kkORtGd/Vfxkw9kYG/PcUDnkcvyxkPs3NkjqCqT9yJBDLxv3h881seFvpbGT
GsLyqJpvx6P6CjYYZcSGi2TLI9vswQDf5+R+4Quq8hehIv+BYzlRbmw4bRxb
NrSaiiSaVhk07WNDtOQaYss+KlqjtzdpeTsbWrW+/RnOpCK3jGUfOQvyfrtN
KWedFJG0ZqvzajU23LjqRyQ9o6GFuP88t9exoHycUehYT0OK3K/tx8pYEHk9
4PqvORra96rJ93g+C97kFI5N2iqhgp696/96xoK1dsF6hkNKSCmy7PvbCyxo
ulHi662tgnQvfHCfwljwI/54nMg2FXRwz6uHRSosWFS+3R/ur4ImzKieftIs
2NGQ5LKzUgV5D+lMJs+T/2ob7koBN1U0cvd5uHwVE8SDDz6PildDHYYbJbkn
SB9uc3F6gFBDCprGSVmkD/9TOvJZq08NCZjM7MUcmeAd7JTstkYdqT+WsP5s
yITunHbF5o/qqHWfKMtSkAlhJwqv+05roHIFPVvfOAZcyhIdL7lPR2GGuzZ5
59DhaZbgm9EMOrohyjnrkESHheWlQfESOvrq2gGyUXS4/uW6scIAHeVVxI46
n6FDA7Op4JgBA9UtFm0fXE2He+ZWA7wKBpL+tfiC4qgJPj7JFHYbA02W8jbJ
6GpCHGWjlOkwA8l8mdMcE9ME/5an3mukmegdZ3RIr1QDoqrM5rbtZqKi15tz
ig00QHtF91GjbiZaZ+VmsUFSHWRVTQYsJpnoHnP9SuhXA+O7420mgix0/+qH
MwolalDOo7+eYLOQ1T/uBdZn1SCpawwuHmOh0X5v7eYOVTjC/flicYCFtmce
uFX8RAU6+vTjuzrYqDVd2+ObnBKs6sBr/IbYaC3+akPoMA28Yw8GzM+xkdBr
91/iZTRIXL4tXCGHIeJ1tj740iD14b8rgm0wFO7g6l7xRREaBRxfHkrH0Fn/
rYTLLSo4l839qniHIcnhftrfR6mQO2XwQqkCQ2WynYHD66jgv/KgY0gnhgaJ
iQWRIQUoG5VKPSLFQU7G4T3TlgoQa//Qycudg8QTJX1qx+Tg5DJF4a4fB6Uy
P2tOlcmBlPu4U1IwB/3t6WS8HC8HA5zcjRExHBQxMr2x2koOiGR3tX3FHCTi
lU43ipEFm9ETV+XktVCKdGVSsKEMIJdqqyE1LRTw6eBtTXEZcHfWTEvjaKEn
0f80bCmQhgca3+0nTLTQHuHJ8Z+i0nD/Y4Oz/0Et9MBo1GEmURLyOy5H+jzT
Ql6Czs5j1eLg4zaKhjK1kDdtOafqiDgE9lBcrN9poQPZtrQzy2JAjfrzPLVa
C8kqmdbrrBGDuErVGO6YFjrbReFsi6bA2vvGk8VzWqhx5a8viboU6K4gzHA+
LhJpq3EoLReB+L5mp14ZLrrw0PJiwIwwBHzulepczUUb0xNtK7cLAbdFVzva
mIu+bmlMSB0UBJ7xp7d6iIv2nA+57RYsCBfV1OeltnKRsGD7ht3pAnDoQ6Of
rwcXEYOHLlkL80Opbes/9Q+56NB7w2eR+5aIfqn3hm+TuGjNSZ1M17BFgj8Y
Tw15yUXeVOWCkbQF4rT0q7VFuVyUPXq4a83vOWLxr8agL1VcdOv11oToe9NE
1LdNXfX1XPSjtGPWvniKOOUpdyn9Cxc5CKSeKO2fJISSwjdId3KRoVhM5oLB
BNH2taTAY4yL3u5QqEN3h4nSIPeac1NctKNY7/B8xyBRepVXcmSOi6qcXKIt
OQNEwIn9Jv1/uChfOZEW+/YnYRVrlRwgoI1aTQxuJi/3ECm/berHhLUR8mob
2mLTTZRbeRldktBGPjeyjsy8bCeuba5xjZfWRjueiN0VMG4leJRyTrQceX5P
g8Xusi/EN2b0Tn0lbYQdWKgtza0mxIo/pX1S0UbjR5T+3VBVRkym+wTsUCfP
J9hn9ucXEHl2lNw3mtoog+0FxwtTCSXdDTuXGNoorF/wHu3d0vv/ARU7pkE=

           "]]},
         Annotation[#, "Charting`Private`Tag#1"]& ]}, {}},
      {"WolframDynamicHighlight", <|
       "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>}], 
     StyleBox[
      DynamicBox[(Charting`HighlightActionBox["DynamicHighlight", {}, 
        Slot["HighlightElements"], 
        Slot["LayoutOptions"], 
        Slot["Meta"], 
        Charting`HighlightActionFunction["DynamicHighlight", {{{{}, {}, 
            Annotation[{
              Directive[
               Opacity[1.], 
               AbsoluteThickness[2], 
               FaceForm[
                Opacity[0.3]], 
               RGBColor[0.24, 0.6, 0.8]], 
              Line[CompressedData["
1:eJxcmXc81t/7x+09b3vnLjQVUaKcQ5JQVERmiGQVPlZFZTQoipJVlArZkSI6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               "]]}, "Charting`Private`Tag#1"]}}, {}}, <|
         "HighlightElements" -> <|
           "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>, 
          "LayoutOptions" -> <|
           "PanelPlotLayout" -> <||>, 
            "PlotRange" -> {{-9.477290178714487, 
             12.566370614359172`}, {-11.040702484683054`, 7.916727358313017}},
             "Frame" -> {{False, False}, {False, False}}, 
            "AxesOrigin" -> {0, 0}, "ImageSize" -> {360, 432}, 
            "Axes" -> {True, True}, "LabelStyle" -> {}, "AspectRatio" -> 
            Automatic, "DefaultStyle" -> {
              Directive[
               Opacity[1.], 
               AbsoluteThickness[2], 
               FaceForm[
                Opacity[0.3]], 
               RGBColor[0.24, 0.6, 0.8]]}, 
            "HighlightLabelingFunctions" -> <|
             "CoordinatesToolOptions" -> Identity, 
              "ScalingFunctions" -> {{Identity, Identity}, {
                Identity, Identity}}|>, "Primitives" -> {}, "GCFlag" -> 
            False|>, 
          "Meta" -> <|
           "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, "Function" -> 
            ParametricPlot, "GroupHighlight" -> False|>|>]]& )[<|
        "HighlightElements" -> <|
          "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>, 
         "LayoutOptions" -> <|
          "PanelPlotLayout" -> <||>, 
           "PlotRange" -> {{-9.477290178714487, 
            12.566370614359172`}, {-11.040702484683054`, 7.916727358313017}}, 
           "Frame" -> {{False, False}, {False, False}}, 
           "AxesOrigin" -> {0, 0}, "ImageSize" -> {360, 432}, 
           "Axes" -> {True, True}, "LabelStyle" -> {}, "AspectRatio" -> 
           Automatic, "DefaultStyle" -> {
             Directive[
              Opacity[1.], 
              AbsoluteThickness[2], 
              FaceForm[
               Opacity[0.3]], 
              RGBColor[0.24, 0.6, 0.8]]}, 
           "HighlightLabelingFunctions" -> <|
            "CoordinatesToolOptions" -> Identity, 
             "ScalingFunctions" -> {{Identity, Identity}, {
               Identity, Identity}}|>, "Primitives" -> {}, "GCFlag" -> 
           False|>, 
         "Meta" -> <|
          "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, "Function" -> 
           ParametricPlot, "GroupHighlight" -> False|>|>],
       ImageSizeCache->{{4.503599627370496*^15, -4.503599627370496*^15}, {
        4.503599627370496*^15, -4.503599627370496*^15}}],
      Selectable->False]},
    Annotation[{{{{}, {}, 
        Annotation[{
          Directive[
           Opacity[1.], 
           AbsoluteThickness[2], 
           FaceForm[
            Opacity[0.3]], 
           RGBColor[0.24, 0.6, 0.8]], 
          Line[CompressedData["
1:eJxcmXc81t/7x+09b3vnLjQVUaKcQ5JQVERmiGQVPlZFZTQoipJVlArZkSI6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           "]]}, "Charting`Private`Tag#1"]}}, {}}, <|
     "HighlightElements" -> <|
       "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>, 
      "LayoutOptions" -> <|
       "PanelPlotLayout" -> <||>, 
        "PlotRange" -> {{-9.477290178714487, 
         12.566370614359172`}, {-11.040702484683054`, 7.916727358313017}}, 
        "Frame" -> {{False, False}, {False, False}}, "AxesOrigin" -> {0, 0}, 
        "ImageSize" -> {360, 432}, "Axes" -> {True, True}, "LabelStyle" -> {},
         "AspectRatio" -> Automatic, "DefaultStyle" -> {
          Directive[
           Opacity[1.], 
           AbsoluteThickness[2], 
           FaceForm[
            Opacity[0.3]], 
           RGBColor[0.24, 0.6, 0.8]]}, 
        "HighlightLabelingFunctions" -> <|
         "CoordinatesToolOptions" -> Identity, 
          "ScalingFunctions" -> {{Identity, Identity}, {
            Identity, Identity}}|>, "Primitives" -> {}, "GCFlag" -> False|>, 
      "Meta" -> <|
       "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, "Function" -> 
        ParametricPlot, "GroupHighlight" -> False|>|>, "DynamicHighlight"]], 
   InterpretationBox[{
     TagBox[{{{}, {}, 
        TagBox[
         {RGBColor[0.24, 0.6, 0.8], AbsoluteThickness[2], Opacity[1.], 
          LineBox[CompressedData["
1:eJw12Ok/FGzfgHH72AdRl5IsJcYySErF76wkKURIke1KipIkS4QmScoSClFE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           "]]},
         Annotation[#, "Charting`Private`Tag#1"]& ]}, {}},
      {"WolframDynamicHighlight", <|
       "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>}], 
     StyleBox[
      DynamicBox[(Charting`HighlightActionBox["DynamicHighlight", {}, 
        Slot["HighlightElements"], 
        Slot["LayoutOptions"], 
        Slot["Meta"], 
        Charting`HighlightActionFunction["DynamicHighlight", {{{{}, {}, 
            Annotation[{
              Directive[
               Opacity[1.], 
               RGBColor[0.24, 0.6, 0.8], 
               AbsoluteThickness[2]], 
              Line[CompressedData["
1:eJw12Ok/FGzfgHH72AdRl5IsJcYySErF76wkKURIke1KipIkS4QmScoSClFE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               "]]}, "Charting`Private`Tag#1"]}}, {}}, <|
         "HighlightElements" -> <|
           "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>, 
          "LayoutOptions" -> <|
           "PanelPlotLayout" -> <||>, 
            "PlotRange" -> {{-4, 4}, {0., 15.999998693877577`}}, 
            "Frame" -> {{False, False}, {False, False}}, 
            "AxesOrigin" -> {0, 0}, "ImageSize" -> {360, 360/GoldenRatio}, 
            "Axes" -> {True, True}, "LabelStyle" -> {}, "AspectRatio" -> 
            GoldenRatio^(-1), "DefaultStyle" -> {
              Directive[
               Opacity[1.], 
               RGBColor[0.24, 0.6, 0.8], 
               AbsoluteThickness[2]]}, 
            "HighlightLabelingFunctions" -> <|"CoordinatesToolOptions" -> ({
                (Identity[#]& )[
                 Part[#, 1]], 
                (Identity[#]& )[
                 Part[#, 2]]}& ), 
              "ScalingFunctions" -> {{Identity, Identity}, {
                Identity, Identity}}|>, "Primitives" -> {}, "GCFlag" -> 
            False|>, 
          "Meta" -> <|
           "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, "Function" -> 
            Plot, "GroupHighlight" -> False|>|>]]& )[<|
        "HighlightElements" -> <|
          "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>, 
         "LayoutOptions" -> <|
          "PanelPlotLayout" -> <||>, 
           "PlotRange" -> {{-4, 4}, {0., 15.999998693877577`}}, 
           "Frame" -> {{False, False}, {False, False}}, 
           "AxesOrigin" -> {0, 0}, "ImageSize" -> {360, 360/GoldenRatio}, 
           "Axes" -> {True, True}, "LabelStyle" -> {}, "AspectRatio" -> 
           GoldenRatio^(-1), "DefaultStyle" -> {
             Directive[
              Opacity[1.], 
              RGBColor[0.24, 0.6, 0.8], 
              AbsoluteThickness[2]]}, 
           "HighlightLabelingFunctions" -> <|"CoordinatesToolOptions" -> ({
               (Identity[#]& )[
                Part[#, 1]], 
               (Identity[#]& )[
                Part[#, 2]]}& ), 
             "ScalingFunctions" -> {{Identity, Identity}, {
               Identity, Identity}}|>, "Primitives" -> {}, "GCFlag" -> 
           False|>, 
         "Meta" -> <|
          "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, "Function" -> 
           Plot, "GroupHighlight" -> False|>|>],
       ImageSizeCache->{{4.503599627370496*^15, -4.503599627370496*^15}, {
        4.503599627370496*^15, -4.503599627370496*^15}}],
      Selectable->False]},
    Annotation[{{{{}, {}, 
        Annotation[{
          Directive[
           Opacity[1.], 
           RGBColor[0.24, 0.6, 0.8], 
           AbsoluteThickness[2]], 
          Line[CompressedData["
1:eJw12Ok/FGzfgHH72AdRl5IsJcYySErF76wkKURIke1KipIkS4QmScoSClFE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           "]]}, "Charting`Private`Tag#1"]}}, {}}, <|
     "HighlightElements" -> <|
       "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>, 
      "LayoutOptions" -> <|
       "PanelPlotLayout" -> <||>, 
        "PlotRange" -> {{-4, 4}, {0., 15.999998693877577`}}, 
        "Frame" -> {{False, False}, {False, False}}, "AxesOrigin" -> {0, 0}, 
        "ImageSize" -> {360, 360/GoldenRatio}, "Axes" -> {True, True}, 
        "LabelStyle" -> {}, "AspectRatio" -> GoldenRatio^(-1), "DefaultStyle" -> {
          Directive[
           Opacity[1.], 
           RGBColor[0.24, 0.6, 0.8], 
           AbsoluteThickness[2]]}, 
        "HighlightLabelingFunctions" -> <|"CoordinatesToolOptions" -> ({
            (Identity[#]& )[
             Part[#, 1]], 
            (Identity[#]& )[
             Part[#, 2]]}& ), 
          "ScalingFunctions" -> {{Identity, Identity}, {
            Identity, Identity}}|>, "Primitives" -> {}, "GCFlag" -> False|>, 
      "Meta" -> <|
       "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, "Function" -> 
        Plot, "GroupHighlight" -> False|>|>, "DynamicHighlight"]], 
   InterpretationBox[{
     TagBox[{{{}, {}, 
        TagBox[
         {RGBColor[0.24, 0.6, 0.8], AbsoluteThickness[2], Opacity[1.], 
          LineBox[CompressedData["
1:eJwUm3c81d8fxxGSZNxrZF/jXquMNCQ5R1PxjVBZCaWhopAGlRWaViUjyYqS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           "]]},
         Annotation[#, "Charting`Private`Tag#1"]& ]}, {}},
      {"WolframDynamicHighlight", <|
       "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>}], 
     StyleBox[
      DynamicBox[(Charting`HighlightActionBox["DynamicHighlight", {}, 
        Slot["HighlightElements"], 
        Slot["LayoutOptions"], 
        Slot["Meta"], 
        Charting`HighlightActionFunction["DynamicHighlight", {{{{}, {}, 
            Annotation[{
              Directive[
               Opacity[1.], 
               RGBColor[0.24, 0.6, 0.8], 
               AbsoluteThickness[2]], 
              Line[CompressedData["
1:eJwUm3c81d8fxxGSZNxrZF/jXquMNCQ5R1PxjVBZCaWhopAGlRWaViUjyYqS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               "]]}, "Charting`Private`Tag#1"]}}, {}}, <|
         "HighlightElements" -> <|
           "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>, 
          "LayoutOptions" -> <|
           "PanelPlotLayout" -> <||>, 
            "PlotRange" -> {{(-4) Pi, 4 Pi}, {-0.9999968914310025, 
              0.9999975297451876}}, 
            "Frame" -> {{False, False}, {False, False}}, 
            "AxesOrigin" -> {0, 0}, "ImageSize" -> {360, 360/GoldenRatio}, 
            "Axes" -> {True, True}, "LabelStyle" -> {}, "AspectRatio" -> 
            GoldenRatio^(-1), "DefaultStyle" -> {
              Directive[
               Opacity[1.], 
               RGBColor[0.24, 0.6, 0.8], 
               AbsoluteThickness[2]]}, 
            "HighlightLabelingFunctions" -> <|"CoordinatesToolOptions" -> ({
                (Identity[#]& )[
                 Part[#, 1]], 
                (Identity[#]& )[
                 Part[#, 2]]}& ), 
              "ScalingFunctions" -> {{Identity, Identity}, {
                Identity, Identity}}|>, "Primitives" -> {}, "GCFlag" -> 
            False|>, 
          "Meta" -> <|
           "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, "Function" -> 
            Plot, "GroupHighlight" -> False|>|>]]& )[<|
        "HighlightElements" -> <|
          "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>, 
         "LayoutOptions" -> <|
          "PanelPlotLayout" -> <||>, 
           "PlotRange" -> {{(-4) Pi, 4 Pi}, {-0.9999968914310025, 
             0.9999975297451876}}, 
           "Frame" -> {{False, False}, {False, False}}, 
           "AxesOrigin" -> {0, 0}, "ImageSize" -> {360, 360/GoldenRatio}, 
           "Axes" -> {True, True}, "LabelStyle" -> {}, "AspectRatio" -> 
           GoldenRatio^(-1), "DefaultStyle" -> {
             Directive[
              Opacity[1.], 
              RGBColor[0.24, 0.6, 0.8], 
              AbsoluteThickness[2]]}, 
           "HighlightLabelingFunctions" -> <|"CoordinatesToolOptions" -> ({
               (Identity[#]& )[
                Part[#, 1]], 
               (Identity[#]& )[
                Part[#, 2]]}& ), 
             "ScalingFunctions" -> {{Identity, Identity}, {
               Identity, Identity}}|>, "Primitives" -> {}, "GCFlag" -> 
           False|>, 
         "Meta" -> <|
          "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, "Function" -> 
           Plot, "GroupHighlight" -> False|>|>],
       ImageSizeCache->{{4.503599627370496*^15, -4.503599627370496*^15}, {
        4.503599627370496*^15, -4.503599627370496*^15}}],
      Selectable->False]},
    Annotation[{{{{}, {}, 
        Annotation[{
          Directive[
           Opacity[1.], 
           RGBColor[0.24, 0.6, 0.8], 
           AbsoluteThickness[2]], 
          Line[CompressedData["
1:eJwUm3c81d8fxxGSZNxrZF/jXquMNCQ5R1PxjVBZCaWhopAGlRWaViUjyYqS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           "]]}, "Charting`Private`Tag#1"]}}, {}}, <|
     "HighlightElements" -> <|
       "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>, 
      "LayoutOptions" -> <|
       "PanelPlotLayout" -> <||>, 
        "PlotRange" -> {{(-4) Pi, 4 Pi}, {-0.9999968914310025, 
          0.9999975297451876}}, "Frame" -> {{False, False}, {False, False}}, 
        "AxesOrigin" -> {0, 0}, "ImageSize" -> {360, 360/GoldenRatio}, 
        "Axes" -> {True, True}, "LabelStyle" -> {}, "AspectRatio" -> 
        GoldenRatio^(-1), "DefaultStyle" -> {
          Directive[
           Opacity[1.], 
           RGBColor[0.24, 0.6, 0.8], 
           AbsoluteThickness[2]]}, 
        "HighlightLabelingFunctions" -> <|"CoordinatesToolOptions" -> ({
            (Identity[#]& )[
             Part[#, 1]], 
            (Identity[#]& )[
             Part[#, 2]]}& ), 
          "ScalingFunctions" -> {{Identity, Identity}, {
            Identity, Identity}}|>, "Primitives" -> {}, "GCFlag" -> False|>, 
      "Meta" -> <|
       "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, "Function" -> 
        Plot, "GroupHighlight" -> False|>|>, "DynamicHighlight"]], 
   InterpretationBox[{
     TagBox[{{{}, {}, 
        TagBox[
         {RGBColor[0.24, 0.6, 0.8], AbsoluteThickness[2], Opacity[1.], 
          FaceForm[Opacity[0.3]], LineBox[CompressedData["
1:eJw1m3c41f/7x42KyCiiUtGiFBWl3V3RMDIiGspKCZlFZKWkUPbITGTLzOa2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           "]]},
         Annotation[#, "Charting`Private`Tag#1"]& ]}, {}},
      {"WolframDynamicHighlight", <|
       "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>}], 
     StyleBox[
      DynamicBox[(Charting`HighlightActionBox["DynamicHighlight", {}, 
        Slot["HighlightElements"], 
        Slot["LayoutOptions"], 
        Slot["Meta"], 
        Charting`HighlightActionFunction["DynamicHighlight", {{{{}, {}, 
            Annotation[{
              Directive[
               Opacity[1.], 
               AbsoluteThickness[2], 
               FaceForm[
                Opacity[0.3]], 
               RGBColor[0.24, 0.6, 0.8]], 
              Line[CompressedData["
1:eJw1m3c41f/7x42KyCiiUtGiFBWl3V3RMDIiGspKCZlFZKWkUPbITGTLzOa2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               "]]}, "Charting`Private`Tag#1"]}}, {}}, <|
         "HighlightElements" -> <|
           "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>, 
          "LayoutOptions" -> <|
           "PanelPlotLayout" -> <||>, 
            "PlotRange" -> {{-0.9999998831351729, 1.}, {-0.9999998592812047, 
             0.9999998782744886}}, 
            "Frame" -> {{False, False}, {False, False}}, 
            "AxesOrigin" -> {0, 0}, "ImageSize" -> {360, 432}, 
            "Axes" -> {True, True}, "LabelStyle" -> {}, "AspectRatio" -> 
            Automatic, "DefaultStyle" -> {
              Directive[
               Opacity[1.], 
               AbsoluteThickness[2], 
               FaceForm[
                Opacity[0.3]], 
               RGBColor[0.24, 0.6, 0.8]]}, 
            "HighlightLabelingFunctions" -> <|
             "CoordinatesToolOptions" -> Identity, 
              "ScalingFunctions" -> {{Identity, Identity}, {
                Identity, Identity}}|>, "Primitives" -> {}, "GCFlag" -> 
            False|>, 
          "Meta" -> <|
           "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, "Function" -> 
            ParametricPlot, "GroupHighlight" -> False|>|>]]& )[<|
        "HighlightElements" -> <|
          "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>, 
         "LayoutOptions" -> <|
          "PanelPlotLayout" -> <||>, 
           "PlotRange" -> {{-0.9999998831351729, 1.}, {-0.9999998592812047, 
            0.9999998782744886}}, "Frame" -> {{False, False}, {False, False}},
            "AxesOrigin" -> {0, 0}, "ImageSize" -> {360, 432}, 
           "Axes" -> {True, True}, "LabelStyle" -> {}, "AspectRatio" -> 
           Automatic, "DefaultStyle" -> {
             Directive[
              Opacity[1.], 
              AbsoluteThickness[2], 
              FaceForm[
               Opacity[0.3]], 
              RGBColor[0.24, 0.6, 0.8]]}, 
           "HighlightLabelingFunctions" -> <|
            "CoordinatesToolOptions" -> Identity, 
             "ScalingFunctions" -> {{Identity, Identity}, {
               Identity, Identity}}|>, "Primitives" -> {}, "GCFlag" -> 
           False|>, 
         "Meta" -> <|
          "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, "Function" -> 
           ParametricPlot, "GroupHighlight" -> False|>|>],
       ImageSizeCache->{{4.503599627370496*^15, -4.503599627370496*^15}, {
        4.503599627370496*^15, -4.503599627370496*^15}}],
      Selectable->False]},
    Annotation[{{{{}, {}, 
        Annotation[{
          Directive[
           Opacity[1.], 
           AbsoluteThickness[2], 
           FaceForm[
            Opacity[0.3]], 
           RGBColor[0.24, 0.6, 0.8]], 
          Line[CompressedData["
1:eJw1m3c41f/7x42KyCiiUtGiFBWl3V3RMDIiGspKCZlFZKWkUPbITGTLzOa2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           "]]}, "Charting`Private`Tag#1"]}}, {}}, <|
     "HighlightElements" -> <|
       "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>, 
      "LayoutOptions" -> <|
       "PanelPlotLayout" -> <||>, 
        "PlotRange" -> {{-0.9999998831351729, 1.}, {-0.9999998592812047, 
         0.9999998782744886}}, "Frame" -> {{False, False}, {False, False}}, 
        "AxesOrigin" -> {0, 0}, "ImageSize" -> {360, 432}, 
        "Axes" -> {True, True}, "LabelStyle" -> {}, "AspectRatio" -> 
        Automatic, "DefaultStyle" -> {
          Directive[
           Opacity[1.], 
           AbsoluteThickness[2], 
           FaceForm[
            Opacity[0.3]], 
           RGBColor[0.24, 0.6, 0.8]]}, 
        "HighlightLabelingFunctions" -> <|
         "CoordinatesToolOptions" -> Identity, 
          "ScalingFunctions" -> {{Identity, Identity}, {
            Identity, Identity}}|>, "Primitives" -> {}, "GCFlag" -> False|>, 
      "Meta" -> <|
       "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, "Function" -> 
        ParametricPlot, "GroupHighlight" -> False|>|>, "DynamicHighlight"]]},
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{0, 0},
  DefaultBaseStyle->{"PlotGraphics", "Graphics"},
  DisplayFunction->Identity,
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImagePadding->All,
  Method->{
   "DefaultGraphicsInteraction" -> {
     "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
      "Effects" -> {
       "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
        "Droplines" -> {
         "freeformCursorMode" -> True, 
          "placement" -> {"x" -> "All", "y" -> "None"}}}}, "ScalingFunctions" -> 
    None},
  PlotInteractivity:>True,
  PlotRange->{{-9.477290178714487, 
   12.566370614359172`}, {-11.040702484683054`, 7.916727358313017}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.05], 
     Scaled[0.05]}, {
     Scaled[0.05], 
     Scaled[0.05]}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{
  3.96763140550158*^9, 3.967631508757606*^9, 3.967631565664674*^9, 
   3.967631712581811*^9, 3.967631776754632*^9, {3.967631815436593*^9, 
   3.967631885888852*^9}, {3.967631930083453*^9, 3.967632048655793*^9}, 
   3.96763492918814*^9, 3.967635464136284*^9},
 CellLabel->
  "Out[2072]=",ExpressionUUID->"5d4043b0-b0b8-4dc5-865c-f900ec1889cc"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TemplateBox[{"\"grid=\"", "True"},
    "RowDefault"], ",", 
   TemplateBox[{"\"estilos=\"", 
     RowBox[{"{", 
       RowBox[{
         RowBox[{"{", 
           RowBox[{"\"thick\"", ",", "\"purple\""}], "}"}], ",", 
         RowBox[{"{", 
           RowBox[{"\"thin\"", ",", "\"orange\""}], "}"}], ",", 
         RowBox[{"{", 
           RowBox[{"\"solid\"", ",", "\"green\""}], "}"}], ",", 
         RowBox[{"{", 
           RowBox[{"\"solid\"", ",", "\"black\""}], "}"}]}], "}"}]},
    "RowDefault"], ",", 
   TemplateBox[{"\"ejes=\"", "True"},
    "RowDefault"], ",", 
   TemplateBox[{"\"texto=\"", 
     RowBox[{"{", 
       RowBox[{"{", 
         RowBox[{"\"Funciones y curvas\"", ",", 
           RowBox[{"{", 
             RowBox[{
               RowBox[{"-", "1"}], ",", "0"}], "}"}], ",", 
           RowBox[{"{", 
             RowBox[{
               RowBox[{"{", 
                 RowBox[{"\"color\"", ",", "\"red\""}], "}"}], ",", 
               RowBox[{"{", 
                 RowBox[{"\"size\"", ",", "\"\\\\Large\""}], "}"}], ",", 
               RowBox[{"{", 
                 RowBox[{"\"anchor\"", ",", "\"north\""}], "}"}], ",", 
               RowBox[{"{", 
                 RowBox[{"\"rotate\"", ",", "102.86165550180547`"}], "}"}]}], 
             "}"}]}], "}"}], "}"}]},
    "RowDefault"], ",", 
   TemplateBox[{"\"muestras=\"", "200"},
    "RowDefault"], ",", 
   TemplateBox[{"\"tolerancia=\"", "0.01`"},
    "RowDefault"], ",", 
   TemplateBox[{"\"opacidad=\"", "0.8`"},
    "RowDefault"], ",", 
   TemplateBox[{"\"densidad=\"", "3"},
    "RowDefault"], ",", 
   TemplateBox[{"\"xmin=\"", "Automatic"},
    "RowDefault"], ",", 
   TemplateBox[{"\"xmax=\"", "Automatic"},
    "RowDefault"], ",", 
   TemplateBox[{"\"ymin=\"", "Automatic"},
    "RowDefault"], ",", 
   TemplateBox[{"\"ymax=\"", "Automatic"},
    "RowDefault"]}], "}"}]], "Output",
 CellChangeTimes->{
  3.96763140550158*^9, 3.967631508757606*^9, 3.967631565664674*^9, 
   3.967631712581811*^9, 3.967631776754632*^9, {3.967631815436593*^9, 
   3.967631885888852*^9}, {3.967631930083453*^9, 3.967632048655793*^9}, 
   3.96763492918814*^9, 3.967635464166758*^9},
 CellLabel->
  "Out[2082]=",ExpressionUUID->"9e83bbc3-4039-4b82-b6f2-9ef1d63d2560"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Usando editores ya detectados: \"\>", "\[InvisibleSpace]", "4",
    "\[InvisibleSpace]", "\<\" disponibles\"\>"}],
  SequenceForm["Usando editores ya detectados: ", 4, " disponibles"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.967631405598249*^9, 3.96763150884382*^9, 3.9676315657482777`*^9, 
   3.967631712668109*^9, 3.967631776853202*^9, 3.967631815535186*^9, {
   3.967631845695389*^9, 3.9676318859987173`*^9}, {3.967631930259461*^9, 
   3.9676320487705097`*^9}, 3.967634929303361*^9, 3.967635464247336*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[2070]:=",ExpressionUUID->"015ee84e-da3d-46cc-9ca3-6c64b086c767"],

Cell[BoxData["\<\"Buscando pdflatex...\"\>"], "Print",
 CellChangeTimes->{
  3.967631405598249*^9, 3.96763150884382*^9, 3.9676315657482777`*^9, 
   3.967631712668109*^9, 3.967631776853202*^9, 3.967631815535186*^9, {
   3.967631845695389*^9, 3.9676318859987173`*^9}, {3.967631930259461*^9, 
   3.9676320487705097`*^9}, 3.967634929303361*^9, 3.967635464248081*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[2070]:=",ExpressionUUID->"605b81be-57f9-4ef0-8d43-d01472624d94"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"pdflatex encontrado: \"\>", 
   "\[InvisibleSpace]", "\<\"/Library/TeX/texbin/pdflatex\"\>"}],
  SequenceForm["pdflatex encontrado: ", "/Library/TeX/texbin/pdflatex"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.967631405598249*^9, 3.96763150884382*^9, 3.9676315657482777`*^9, 
   3.967631712668109*^9, 3.967631776853202*^9, 3.967631815535186*^9, {
   3.967631845695389*^9, 3.9676318859987173`*^9}, {3.967631930259461*^9, 
   3.9676320487705097`*^9}, 3.967634929303361*^9, 3.967635464248754*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[2070]:=",ExpressionUUID->"2be7109c-2108-4222-b7f5-5eca9b9848cd"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Editor '\"\>", "\[InvisibleSpace]", "\<\"TeXstudio\"\>", 
   "\[InvisibleSpace]", "\<\"' encontrado (match exacto)\"\>"}],
  SequenceForm["Editor '", "TeXstudio", "' encontrado (match exacto)"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.967631405598249*^9, 3.96763150884382*^9, 3.9676315657482777`*^9, 
   3.967631712668109*^9, 3.967631776853202*^9, 3.967631815535186*^9, {
   3.967631845695389*^9, 3.9676318859987173`*^9}, {3.967631930259461*^9, 
   3.9676320487705097`*^9}, 3.967634929303361*^9, 3.967635464249145*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[2070]:=",ExpressionUUID->"85348a81-667e-499a-ab9a-0012485ea704"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Abriendo archivo en \"\>", 
   "\[InvisibleSpace]", "\<\"TeXstudio\"\>", 
   "\[InvisibleSpace]", "\<\"...\"\>"}],
  SequenceForm["Abriendo archivo en ", "TeXstudio", "..."],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.967631405598249*^9, 3.96763150884382*^9, 3.9676315657482777`*^9, 
   3.967631712668109*^9, 3.967631776853202*^9, 3.967631815535186*^9, {
   3.967631845695389*^9, 3.9676318859987173`*^9}, {3.967631930259461*^9, 
   3.9676320487705097`*^9}, 3.967634929303361*^9, 3.967635464249522*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[2070]:=",ExpressionUUID->"ca1d4aae-44e8-483a-ab59-69077651828b"],

Cell[BoxData["\<\"Editor abierto correctamente\"\>"], "Print",
 CellChangeTimes->{
  3.967631405598249*^9, 3.96763150884382*^9, 3.9676315657482777`*^9, 
   3.967631712668109*^9, 3.967631776853202*^9, 3.967631815535186*^9, {
   3.967631845695389*^9, 3.9676318859987173`*^9}, {3.967631930259461*^9, 
   3.9676320487705097`*^9}, 3.967634929303361*^9, 3.967635464341632*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[2070]:=",ExpressionUUID->"b1f363ec-da5c-4e03-b572-171969adec18"],

Cell[BoxData["\<\"Compilando documento LaTeX...\"\>"], "Print",
 CellChangeTimes->{
  3.967631405598249*^9, 3.96763150884382*^9, 3.9676315657482777`*^9, 
   3.967631712668109*^9, 3.967631776853202*^9, 3.967631815535186*^9, {
   3.967631845695389*^9, 3.9676318859987173`*^9}, {3.967631930259461*^9, 
   3.9676320487705097`*^9}, 3.967634929303361*^9, 3.9676354653484364`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[2070]:=",ExpressionUUID->"7d7994cf-e4dd-4416-9147-f9bb5ee6c37f"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Directorio de trabajo: \"\>", 
   "\[InvisibleSpace]", \
"\<\"/Users/enriquevilchezquesada/Downloads/Contour2D13/\"\>"}],
  SequenceForm[
  "Directorio de trabajo: ", 
   "/Users/enriquevilchezquesada/Downloads/Contour2D13/"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.967631405598249*^9, 3.96763150884382*^9, 3.9676315657482777`*^9, 
   3.967631712668109*^9, 3.967631776853202*^9, 3.967631815535186*^9, {
   3.967631845695389*^9, 3.9676318859987173`*^9}, {3.967631930259461*^9, 
   3.9676320487705097`*^9}, 3.967634929303361*^9, 3.967635465352384*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[2070]:=",ExpressionUUID->"be6d84e5-fac4-47c4-be49-1b7ab7c49d28"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Archivo: \"\>", "\[InvisibleSpace]", "\<\"Contour2D13\"\>"}],
  SequenceForm["Archivo: ", "Contour2D13"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.967631405598249*^9, 3.96763150884382*^9, 3.9676315657482777`*^9, 
   3.967631712668109*^9, 3.967631776853202*^9, 3.967631815535186*^9, {
   3.967631845695389*^9, 3.9676318859987173`*^9}, {3.967631930259461*^9, 
   3.9676320487705097`*^9}, 3.967634929303361*^9, 3.967635465354999*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[2070]:=",ExpressionUUID->"98a3082c-fda0-4828-af8e-9445ee66cd7e"],

Cell[BoxData["\<\"Compilaci\[OAcute]n exitosa\"\>"], "Print",
 CellChangeTimes->{
  3.967631405598249*^9, 3.96763150884382*^9, 3.9676315657482777`*^9, 
   3.967631712668109*^9, 3.967631776853202*^9, 3.967631815535186*^9, {
   3.967631845695389*^9, 3.9676318859987173`*^9}, {3.967631930259461*^9, 
   3.9676320487705097`*^9}, 3.967634929303361*^9, 3.9676354663434467`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[2070]:=",ExpressionUUID->"a98e1b08-8d6c-4ec1-9f6a-3a8117250e31"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"PDF generado: \"\>", 
   "\[InvisibleSpace]", \
"\<\"/Users/enriquevilchezquesada/Downloads/Contour2D13/Contour2D13.pdf\"\>"}],
  SequenceForm[
  "PDF generado: ", 
   "/Users/enriquevilchezquesada/Downloads/Contour2D13/Contour2D13.pdf"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.967631405598249*^9, 3.96763150884382*^9, 3.9676315657482777`*^9, 
   3.967631712668109*^9, 3.967631776853202*^9, 3.967631815535186*^9, {
   3.967631845695389*^9, 3.9676318859987173`*^9}, {3.967631930259461*^9, 
   3.9676320487705097`*^9}, 3.967634929303361*^9, 3.967635466344211*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[2070]:=",ExpressionUUID->"6c2070ea-e311-4da8-859e-10c5a8c1f43a"]
}, Open  ]],

Cell[BoxData["\<\"/Users/enriquevilchezquesada/Downloads/Contour2D13/\
Contour2D13.pdf\"\>"], "Output",
 CellChangeTimes->{
  3.96763140550158*^9, 3.967631508757606*^9, 3.967631565664674*^9, 
   3.967631712581811*^9, 3.967631776754632*^9, {3.967631815436593*^9, 
   3.967631885888852*^9}, {3.967631930083453*^9, 3.967632048655793*^9}, 
   3.96763492918814*^9, 3.967635466358295*^9},
 CellLabel->
  "Out[2084]=",ExpressionUUID->"c1794e17-b4e6-4c25-b94f-2955d5b2cad8"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
Ejemplo 14: ecuaciones mixtas con anotaciones de texto (c\[IAcute]rculo, regi\
\[OAcute]n parab\[OAcute]lica, funci\[OAcute]n seno y elipse \
param\[EAcute]trica)\
\>", "Subsection",
 CellChangeTimes->{{3.9675372440640697`*^9, 3.967537246104553*^9}, 
   3.967537282702442*^9, {3.9675379700592365`*^9, 
   3.9675380270623074`*^9}},ExpressionUUID->"044bc403-9c4c-0a45-898f-\
0198a265f788"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"Show", "[", 
   RowBox[{
    RowBox[{"ContourPlot", "[", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"x", "^", "2"}], "+", 
        RowBox[{"y", "^", "2"}]}], "==", "4"}], ",", 
      RowBox[{"{", 
       RowBox[{"x", ",", 
        RowBox[{"-", "4"}], ",", "4"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"y", ",", 
        RowBox[{"-", "3"}], ",", "3"}], "}"}]}], "]"}], ",", 
    RowBox[{"RegionPlot", "[", 
     RowBox[{
      RowBox[{"y", ">=", 
       RowBox[{
        RowBox[{"x", "^", "2"}], "-", "3"}]}], ",", 
      RowBox[{"{", 
       RowBox[{"x", ",", 
        RowBox[{"-", "4"}], ",", "4"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"y", ",", 
        RowBox[{"-", "3"}], ",", "3"}], "}"}]}], "]"}], ",", 
    RowBox[{"Plot", "[", 
     RowBox[{
      RowBox[{"Sin", "[", "x", "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"x", ",", 
        RowBox[{"-", "4"}], ",", "4"}], "}"}]}], "]"}], ",", " ", 
    RowBox[{"ParametricPlot", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"2", "*", 
         RowBox[{"Cos", "[", "t", "]"}]}], ",", 
        RowBox[{"Sin", "[", "t", "]"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"t", ",", "0", ",", 
        RowBox[{"2", "*", "Pi"}]}], "}"}]}], "]"}], ",", 
    RowBox[{"Frame", "->", "False"}], ",", 
    RowBox[{"Axes", "->", "True"}]}], "]"}], "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"mixtas", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"x", "^", "2"}], "+", 
       RowBox[{"y", "^", "2"}]}], "==", "4"}], ",", 
     RowBox[{"y", ">=", 
      RowBox[{
       RowBox[{"x", "^", "2"}], "-", "3"}]}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Sin", "[", "x", "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"x", ",", 
         RowBox[{"-", "4"}], ",", "4"}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"2", "*", 
          RowBox[{"Cos", "[", "t", "]"}]}], ",", 
         RowBox[{"Sin", "[", "t", "]"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"t", ",", "0", ",", 
         RowBox[{"2", "*", "Pi"}]}], "}"}]}], "}"}]}], "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"line", "[", "]"}], ":=", 
  RowBox[{"RandomChoice", "[", 
   RowBox[{"{", 
    RowBox[{"\"\<solid\>\"", ",", "\"\<dashed\>\"", ",", "\"\<dotted\>\"", 
     ",", "\"\<thick\>\"", ",", "\"\<thin\>\""}], "}"}], "]"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"color", "[", "]"}], ":=", 
  RowBox[{"RandomChoice", "[", 
   RowBox[{"{", 
    RowBox[{"\"\<blue\>\"", ",", "\"\<red\>\"", ",", "\"\<green\>\"", 
     ",", "\"\<purple\>\"", ",", "\"\<yellow\>\"", ",", "\"\<orange\>\"", 
     ",", "\"\<cyan\>\"", ",", "\"\<magenta\>\"", ",", "\"\<black\>\""}], 
    "}"}], "]"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"sizetexto", "[", "]"}], ":=", 
  RowBox[{"RandomChoice", "[", 
   RowBox[{"{", 
    RowBox[{"\"\<\\\\tiny\>\"", ",", "\"\<\\\\scriptsize\>\"", 
     ",", "\"\<\\\\footnotesize\>\"", ",", "\"\<\\\\small\>\"", 
     ",", "\"\<\\\\normalsize\>\"", ",", "\"\<\\\\large\>\"", 
     ",", "\"\<\\\\Large\>\"", ",", "\"\<\\\\huge\>\"", 
     ",", "\"\<\\\\Huge\>\""}], "}"}], "]"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"anclajetexto", "[", "]"}], ":=", 
  RowBox[{"RandomChoice", "[", 
   RowBox[{"{", 
    RowBox[{"\"\<north\>\"", ",", "\"\<south\>\"", ",", "\"\<east\>\"", 
     ",", "\"\<west\>\"", ",", "\"\<north east\>\"", ",", "\"\<north west\>\"",
      ",", "\"\<south east\>\"", ",", "\"\<south west\>\"", 
     ",", "\"\<center\>\""}], "}"}], "]"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"rotatexto", "[", "]"}], ":=", 
  RowBox[{"RandomReal", "[", 
   RowBox[{"{", 
    RowBox[{"0", ",", "360"}], "}"}], "]"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"estilotext", "[", "n_", "]"}], ":=", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"\"\<color\>\"", ",", 
        RowBox[{"color", "[", "]"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"\"\<size\>\"", ",", 
        RowBox[{"sizetexto", "[", "]"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"\"\<anchor\>\"", ",", 
        RowBox[{"anclajetexto", "[", "]"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"\"\<rotate\>\"", ",", 
        RowBox[{"rotatexto", "[", "]"}]}], "}"}]}], "}"}], ",", "n"}], 
   "]"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"vectorestilos", "=", 
   RowBox[{"estilotext", "[", "4", "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Row", "[", 
    RowBox[{"{", 
     RowBox[{"\"\<grid=\>\"", ",", 
      RowBox[{"grid", "=", "False"}]}], "}"}], "]"}], ",", 
   RowBox[{"Row", "[", 
    RowBox[{"{", 
     RowBox[{"\"\<estilos=\>\"", ",", 
      RowBox[{"estilos", "=", 
       RowBox[{"Table", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"line", "[", "]"}], ",", 
           RowBox[{"color", "[", "]"}]}], "}"}], ",", "4"}], "]"}]}]}], "}"}],
     "]"}], ",", 
   RowBox[{"Row", "[", 
    RowBox[{"{", 
     RowBox[{"\"\<ejes=\>\"", ",", 
      RowBox[{"ejes", "=", "True"}]}], "}"}], "]"}], ",", 
   RowBox[{"Row", "[", 
    RowBox[{"{", 
     RowBox[{"\"\<texto=\>\"", ",", 
      RowBox[{"texto", "=", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"\"\<C\[IAcute]rculo\>\"", ",", 
           RowBox[{"{", 
            RowBox[{"2", ",", "2"}], "}"}], ",", 
           RowBox[{"vectorestilos", "[", 
            RowBox[{"[", "1", "]"}], "]"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"\"\<Par\[AAcute]bola\>\"", ",", 
           RowBox[{"{", 
            RowBox[{"0", ",", 
             RowBox[{"-", "2"}]}], "}"}], ",", 
           RowBox[{"vectorestilos", "[", 
            RowBox[{"[", "2", "]"}], "]"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"\"\<Seno\>\"", ",", 
           RowBox[{"{", 
            RowBox[{"0", ",", "1"}], "}"}], ",", 
           RowBox[{"vectorestilos", "[", 
            RowBox[{"[", "3", "]"}], "]"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"\"\<Elipse\>\"", ",", 
           RowBox[{"{", 
            RowBox[{"1.5", ",", "0"}], "}"}], ",", 
           RowBox[{"vectorestilos", "[", 
            RowBox[{"[", "4", "]"}], "]"}]}], "}"}]}], "}"}]}]}], "}"}], 
    "]"}], ",", 
   RowBox[{"Row", "[", 
    RowBox[{"{", 
     RowBox[{"\"\<muestras=\>\"", ",", 
      RowBox[{"muestras", "=", "100"}]}], "}"}], "]"}], ",", 
   RowBox[{"Row", "[", 
    RowBox[{"{", 
     RowBox[{"\"\<tolerancia=\>\"", ",", 
      RowBox[{"tolerancia", "=", "0.1"}]}], "}"}], "]"}], ",", 
   RowBox[{"Row", "[", 
    RowBox[{"{", 
     RowBox[{"\"\<opacidad=\>\"", ",", 
      RowBox[{"opacidad", "=", "0.3"}]}], "}"}], "]"}], ",", 
   RowBox[{"Row", "[", 
    RowBox[{"{", 
     RowBox[{"\"\<densidad=\>\"", ",", 
      RowBox[{"densidad", "=", "1"}]}], "}"}], "]"}], ",", 
   RowBox[{"Row", "[", 
    RowBox[{"{", 
     RowBox[{"\"\<xmin=\>\"", ",", 
      RowBox[{"xmin", "=", 
       RowBox[{"-", "4"}]}]}], "}"}], "]"}], ",", 
   RowBox[{"Row", "[", 
    RowBox[{"{", 
     RowBox[{"\"\<xmax=\>\"", ",", 
      RowBox[{"xmax", "=", "4"}]}], "}"}], "]"}], ",", 
   RowBox[{"Row", "[", 
    RowBox[{"{", 
     RowBox[{"\"\<ymin=\>\"", ",", 
      RowBox[{"ymin", "=", 
       RowBox[{"-", "3"}]}]}], "}"}], "]"}], ",", 
   RowBox[{"Row", "[", 
    RowBox[{"{", 
     RowBox[{"\"\<ymax=\>\"", ",", 
      RowBox[{"ymax", "=", "3"}]}], "}"}], "]"}]}], "}"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ExportContour2DToTikZ", "[", 
   RowBox[{
   "mixtas", ",", "\"\<Contour2D14.tex\>\"", ",", "grid", ",", "estilos", ",",
     "ejes", ",", "texto", ",", "muestras", ",", "tolerancia", ",", 
    "opacidad", ",", "densidad", ",", "xmin", ",", "xmax", ",", "ymin", ",", 
    "ymax"}], "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"CompiladorTex", "[", 
  RowBox[{"%", ",", 
   RowBox[{"\"\<PreferredEditor\>\"", " ", "->", "\"\<TeXstudio\>\""}]}], 
  "]"}]}], "Input",
 CellChangeTimes->{{3.9675380351690407`*^9, 3.9675380557464905`*^9}, {
   3.9675382441498737`*^9, 3.9675382444549313`*^9}, {3.9675452654179*^9, 
   3.967545266871002*^9}, {3.967573834203136*^9, 3.967573834600864*^9}, {
   3.96757403623742*^9, 3.967574036487266*^9}, {3.967632071093924*^9, 
   3.967632336056733*^9}, {3.9676323674247932`*^9, 3.967632505164412*^9}, 
   3.9676341421344624`*^9, {3.967634917115643*^9, 3.9676349176502523`*^9}, {
   3.967635537489381*^9, 3.967635560044388*^9}, {3.967635597445146*^9, 
   3.9676356002798367`*^9}},
 CellLabel->
  "In[2121]:=",ExpressionUUID->"d171c284-b04c-f948-b857-ad6f8b034dbe"],

Cell[BoxData[
 GraphicsBox[{{GraphicsComplexBox[CompressedData["
1:eJxdVwtQVGUUBtrAR2DKGAWo+UqHccRQUMfHMREFHxhp5gsrHkqMhS9sABVD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     "], {{}, {}, 
      TagBox[
       TooltipBox[
        {RGBColor[0.24, 0.6, 0.8], AbsoluteThickness[2], 
         LineBox[{1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 
          18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 
          35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 
          52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 64, 65, 66, 67, 68, 
          69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 
          86, 87, 88, 89, 90, 91, 92, 93, 94, 95, 96, 97, 98, 99, 100, 101, 
          102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 
          115, 116, 117, 118, 119, 120, 121, 122, 123, 124, 125, 126, 127, 
          128, 129, 130, 131, 132, 133, 134, 135, 136, 137, 138, 139, 140, 
          141, 142, 143, 144, 145, 146, 147, 148, 149, 150, 151, 152, 153, 
          154, 155, 156, 157, 158, 159, 160, 161, 162, 163, 164, 165, 166, 
          167, 168, 169, 170, 171, 172, 173, 174, 175, 176, 177, 178, 179, 
          180, 181, 182, 183, 184, 185, 186, 187, 188, 189, 190, 191, 192, 
          193, 194, 195, 196, 197, 198, 199, 200, 201}]},
        RowBox[{
          RowBox[{
            SuperscriptBox[
             TagBox["x", HoldForm], "2"], "+", 
            SuperscriptBox[
             TagBox["y", HoldForm], "2"]}], "\[Equal]", "4"}]],
       Annotation[#, HoldForm[$CellContext`x]^2 + HoldForm[$CellContext`y]^2 == 
        4, "Tooltip"]& ]}], {}}, {GraphicsComplexBox[CompressedData["
1:eJxlmntclVXWx885oCSFt7fMeF+tbDDe0sTymONo+zE+2aSOwzB20YpsHC1F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     "], {{
       {RGBColor[0.24, 0.6, 0.8], AbsoluteThickness[2.], Opacity[0.3], 
        EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxNmHe8VsURhncOioIIUlSKIEjv7YIgvXe5l0uHS1chICjGLgpRQVTsxIq9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           "]], PolygonBox[CompressedData["
1:eJwtlXmw0FMUx++5L0mvRjWt9OK1EOU1kaXsS8iSymAs/8iIkhoTE2OmGTEY
RjHGVqYy0UYpvIpSUUmiUtFmS5SaSNIq8vnO9/7xmfs9d/39zj3n3Or+Q/sN
ySmlJ6EOLI+U7oO56C/hI/Qe+Bn9MQxCfwbL0RXwI3oAfIteD4PRX8EqrYWZ
6IEccC5tXexttNvDYxNgH3o/bEVPg4PoA/Cr5sIP6J9gQ/IZv2guzEZvgkfR
m+Eb9DL9B7qC83ahH4eu6In0zUAvgUuwL84e+wNmMHYndifa8dgPaS9Yg54O
3Rk7D4Yn7zmEsZ3wPbqx+tC/w3z0m3ASc6sh0zc12Xd/wpZkH94d9pl8tRHe
RT8rnyX7/EH5EtaiP4XP0W9DLfoL2KK7CK/9AK7irKewV6Bb0t4bvkPd3RwY
GN5Da8fBS+hGrDmErtIc7L7YJ9NWQz30M8UXH8Je9N+wCD0FXkZ/DavRh5PP
nh4+S9/wKroVexxFJ/RjsFv/jNkBmjDWOPts9f3H2FFYKl/oztDLwr7vCaP0
L7AS/Zd8EI4pxZJ8pti4JxwLipEd6N/gu+Q7eh99LeedSFsFQ3W3+ofkO3sO
fRzje9CV8Dx2JfY+9H44FX1K9rcoJm9Fd4OGzOsAx6NfpJ3I2Dy4A/t2GKm1
+g5YDB1LjG4M76G167DPR18ATcJrWqIfCPvq3+TYeSWsFUMXMX4hjEpe0wm9
gLY9HFti9xb62pUYVmwrZ5WrivErsKfRNodmsAR60tdCccKcK7NjTLGlvruy
Y16xXiNfYz+if1Bulbt+jTbCd65cnxXObeX8IOzZ4dzoQXsp9tRydlMYA62z
a8tkaIpuBkfQ7aFddk4plyqY2wW9iLY/dgPaYfp3+uqUGNW/t82eKx+8BWdl
5/5MfRN6inJAdyc/Z9cg1R7tcRr26VAX3Zu+juhxxbfqOwP7jfDZ9aEFdnPo
nPzNDdG18i/6QHIsvRDWiqkJZQ+trYTDyjXlneI2ea+b9A/hPZWryjnlmnK2
M/bD2Dckr6nCHhv23UK4DPvybN8qRlbQ9sJuVXLoGPkqu/btVg0pd1xTYrgN
+vVwri+Af8o36tt2JMdaTfa3K+Z0F4MVk+VOasud9yg+WFhiRrGiGnwOehJ6
VnLOTw7fie5CNXaE/Jz9baOTY2te+FsUY7q7TSV3dIeJuQE7k/dUrt2WnXvK
uSfCb4TeBs1Zin46XAv1huktuTq7dupNuSa7Bqr2yWdno8/Mjh3lvGL/SNgX
yoHrGeudXSsawcpwzVGt0RvYJ7tGqDa0oW+17i4XTd/acA2uLjXpOsZWhfdq
TXsjdr/sXFCNVi17LzymmlYf+/5w7dqbXPtGh7VqoGLlUPgtVcxsQK8vsb0Y
5qJPyK7Virmb0fPDsaQ3TG/R8PBcvUnvlJqhWqE3SbVTNVq1WTV0ZPgN09ul
N12x8Um4titG/gcvJhcg
           "]]}]}, {}, {}, {}, {}}, 
      {RGBColor[0.24, 0.6, 0.8], AbsoluteThickness[2.], 
       LineBox[CompressedData["
1:eJwl1HeczwUYwPGfMxJF5qnM7L23QiKUdfbW4YzLJiQZJVTccMsoe4/sTSGj
7FGRVajMMiul8f6+/PG+z/M839/dve5397oCkQMi+qcKhULhPrxLjDmWOOKZ
RgKJJJFMCtOZQU6fs4xXwkKhpVpX6/EyXXiRl6hBLWrSmfNe21E70YE99nOc
ZRTvk8o9xCJzFX1b/+Nf/mEBu3jTsy+0rM7V0jpHy+hOLamfajEtQXHa8Z3b
aXYQZR+u3zKU8fzOAwp7Vogh5vvc4y6zyOs+WHvoNp3Os+YUfU43a2vNSTjZ
yEF2WnHK8whtSQs22U9yggHc4iY3SGAjfb1ugz6tcZpRY/UpbUoTjtpf17X6
mq7TIxwO3i9+4Wd+4mPW0MfrVuvXfMRnRLpF61f0pqt9pU7kVXNDLpuv0Isf
uBC8j351UXqRnlziRxp4fX2+NK8IvqZ5uR4Ivj/d7JN0L/uCn5U33FbpZJ4w
f6jptTGNOGg/xFSetE/RMfQjgz1Gr3KN6wR/8N3d12s8mczTNLM2pxnH7MdJ
4hl7oo5lIFnsWfnV/BvjGEQut2S9zR22Eu22RXPrDH1eZ2oe3a5tND8FyEdB
XqAt33g+LHj/zJ/oft7jLYq4FeUP8588ZASl3GbrX/zNI0YGvxv3z3Ue5czz
tbzu1oq6UCtoZSrRnjNu37OEqvbFOoF3qGavThip+cBtNLXNdUhDWtKFPf6/
8j9n1I5n
        "]]}}], {}}, 
   InterpretationBox[{
     TagBox[{{{}, {}, 
        TagBox[
         {RGBColor[0.24, 0.6, 0.8], AbsoluteThickness[2], Opacity[1.], 
          LineBox[CompressedData["
1:eJwtmXk4Vd/3x6+pZLpUKkUhRZFQIR9aV8ZESYaQqZKShAaaiBIhohkhU1Kk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           "]]},
         Annotation[#, "Charting`Private`Tag#1"]& ]}, {}},
      {"WolframDynamicHighlight", <|
       "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>}], 
     StyleBox[
      DynamicBox[(Charting`HighlightActionBox["DynamicHighlight", {}, 
        Slot["HighlightElements"], 
        Slot["LayoutOptions"], 
        Slot["Meta"], 
        Charting`HighlightActionFunction["DynamicHighlight", {{{{}, {}, 
            Annotation[{
              Directive[
               Opacity[1.], 
               RGBColor[0.24, 0.6, 0.8], 
               AbsoluteThickness[2]], 
              Line[CompressedData["
1:eJwtmXk4Vd/3x6+pZLpUKkUhRZFQIR9aV8ZESYaQqZKShAaaiBIhohkhU1Kk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               "]]}, "Charting`Private`Tag#1"]}}, {}}, <|
         "HighlightElements" -> <|
           "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>, 
          "LayoutOptions" -> <|
           "PanelPlotLayout" -> <||>, 
            "PlotRange" -> {{-4, 4}, {-0.9999996591487361, 
              0.9999999743031677}}, 
            "Frame" -> {{False, False}, {False, False}}, 
            "AxesOrigin" -> {0, 0}, "ImageSize" -> {360, 360/GoldenRatio}, 
            "Axes" -> {True, True}, "LabelStyle" -> {}, "AspectRatio" -> 
            GoldenRatio^(-1), "DefaultStyle" -> {
              Directive[
               Opacity[1.], 
               RGBColor[0.24, 0.6, 0.8], 
               AbsoluteThickness[2]]}, 
            "HighlightLabelingFunctions" -> <|"CoordinatesToolOptions" -> ({
                (Identity[#]& )[
                 Part[#, 1]], 
                (Identity[#]& )[
                 Part[#, 2]]}& ), 
              "ScalingFunctions" -> {{Identity, Identity}, {
                Identity, Identity}}|>, "Primitives" -> {}, "GCFlag" -> 
            False|>, 
          "Meta" -> <|
           "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, "Function" -> 
            Plot, "GroupHighlight" -> False|>|>]]& )[<|
        "HighlightElements" -> <|
          "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>, 
         "LayoutOptions" -> <|
          "PanelPlotLayout" -> <||>, 
           "PlotRange" -> {{-4, 4}, {-0.9999996591487361, 
             0.9999999743031677}}, 
           "Frame" -> {{False, False}, {False, False}}, 
           "AxesOrigin" -> {0, 0}, "ImageSize" -> {360, 360/GoldenRatio}, 
           "Axes" -> {True, True}, "LabelStyle" -> {}, "AspectRatio" -> 
           GoldenRatio^(-1), "DefaultStyle" -> {
             Directive[
              Opacity[1.], 
              RGBColor[0.24, 0.6, 0.8], 
              AbsoluteThickness[2]]}, 
           "HighlightLabelingFunctions" -> <|"CoordinatesToolOptions" -> ({
               (Identity[#]& )[
                Part[#, 1]], 
               (Identity[#]& )[
                Part[#, 2]]}& ), 
             "ScalingFunctions" -> {{Identity, Identity}, {
               Identity, Identity}}|>, "Primitives" -> {}, "GCFlag" -> 
           False|>, 
         "Meta" -> <|
          "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, "Function" -> 
           Plot, "GroupHighlight" -> False|>|>],
       ImageSizeCache->{{4.503599627370496*^15, -4.503599627370496*^15}, {
        4.503599627370496*^15, -4.503599627370496*^15}}],
      Selectable->False]},
    Annotation[{{{{}, {}, 
        Annotation[{
          Directive[
           Opacity[1.], 
           RGBColor[0.24, 0.6, 0.8], 
           AbsoluteThickness[2]], 
          Line[CompressedData["
1:eJwtmXk4Vd/3x6+pZLpUKkUhRZFQIR9aV8ZESYaQqZKShAaaiBIhohkhU1Kk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           "]]}, "Charting`Private`Tag#1"]}}, {}}, <|
     "HighlightElements" -> <|
       "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>, 
      "LayoutOptions" -> <|
       "PanelPlotLayout" -> <||>, 
        "PlotRange" -> {{-4, 4}, {-0.9999996591487361, 0.9999999743031677}}, 
        "Frame" -> {{False, False}, {False, False}}, "AxesOrigin" -> {0, 0}, 
        "ImageSize" -> {360, 360/GoldenRatio}, "Axes" -> {True, True}, 
        "LabelStyle" -> {}, "AspectRatio" -> GoldenRatio^(-1), "DefaultStyle" -> {
          Directive[
           Opacity[1.], 
           RGBColor[0.24, 0.6, 0.8], 
           AbsoluteThickness[2]]}, 
        "HighlightLabelingFunctions" -> <|"CoordinatesToolOptions" -> ({
            (Identity[#]& )[
             Part[#, 1]], 
            (Identity[#]& )[
             Part[#, 2]]}& ), 
          "ScalingFunctions" -> {{Identity, Identity}, {
            Identity, Identity}}|>, "Primitives" -> {}, "GCFlag" -> False|>, 
      "Meta" -> <|
       "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, "Function" -> 
        Plot, "GroupHighlight" -> False|>|>, "DynamicHighlight"]], 
   InterpretationBox[{
     TagBox[{{{}, {}, 
        TagBox[
         {RGBColor[0.24, 0.6, 0.8], AbsoluteThickness[2], Opacity[1.], 
          FaceForm[Opacity[0.3]], LineBox[CompressedData["
1:eJw123c8lX/YB3CjIjKKqFS0aFFR2l0VDSMjouGXlRIySyUkJYWyR2Yiu8xs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           "]]},
         Annotation[#, "Charting`Private`Tag#1"]& ]}, {}},
      {"WolframDynamicHighlight", <|
       "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>}], 
     StyleBox[
      DynamicBox[(Charting`HighlightActionBox["DynamicHighlight", {}, 
        Slot["HighlightElements"], 
        Slot["LayoutOptions"], 
        Slot["Meta"], 
        Charting`HighlightActionFunction["DynamicHighlight", {{{{}, {}, 
            Annotation[{
              Directive[
               Opacity[1.], 
               AbsoluteThickness[2], 
               FaceForm[
                Opacity[0.3]], 
               RGBColor[0.24, 0.6, 0.8]], 
              Line[CompressedData["
1:eJw123c8lX/YB3CjIjKKqFS0aFFR2l0VDSMjouGXlRIySyUkJYWyR2Yiu8xs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               "]]}, "Charting`Private`Tag#1"]}}, {}}, <|
         "HighlightElements" -> <|
           "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>, 
          "LayoutOptions" -> <|
           "PanelPlotLayout" -> <||>, 
            "PlotRange" -> {{-1.9999997662703457`, 2.}, {-0.9999998592812047, 
             0.9999998782744886}}, 
            "Frame" -> {{False, False}, {False, False}}, 
            "AxesOrigin" -> {0, 0}, "ImageSize" -> {360, 432}, 
            "Axes" -> {True, True}, "LabelStyle" -> {}, "AspectRatio" -> 
            Automatic, "DefaultStyle" -> {
              Directive[
               Opacity[1.], 
               AbsoluteThickness[2], 
               FaceForm[
                Opacity[0.3]], 
               RGBColor[0.24, 0.6, 0.8]]}, 
            "HighlightLabelingFunctions" -> <|
             "CoordinatesToolOptions" -> Identity, 
              "ScalingFunctions" -> {{Identity, Identity}, {
                Identity, Identity}}|>, "Primitives" -> {}, "GCFlag" -> 
            False|>, 
          "Meta" -> <|
           "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, "Function" -> 
            ParametricPlot, "GroupHighlight" -> False|>|>]]& )[<|
        "HighlightElements" -> <|
          "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>, 
         "LayoutOptions" -> <|
          "PanelPlotLayout" -> <||>, 
           "PlotRange" -> {{-1.9999997662703457`, 2.}, {-0.9999998592812047, 
            0.9999998782744886}}, "Frame" -> {{False, False}, {False, False}},
            "AxesOrigin" -> {0, 0}, "ImageSize" -> {360, 432}, 
           "Axes" -> {True, True}, "LabelStyle" -> {}, "AspectRatio" -> 
           Automatic, "DefaultStyle" -> {
             Directive[
              Opacity[1.], 
              AbsoluteThickness[2], 
              FaceForm[
               Opacity[0.3]], 
              RGBColor[0.24, 0.6, 0.8]]}, 
           "HighlightLabelingFunctions" -> <|
            "CoordinatesToolOptions" -> Identity, 
             "ScalingFunctions" -> {{Identity, Identity}, {
               Identity, Identity}}|>, "Primitives" -> {}, "GCFlag" -> 
           False|>, 
         "Meta" -> <|
          "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, "Function" -> 
           ParametricPlot, "GroupHighlight" -> False|>|>],
       ImageSizeCache->{{4.503599627370496*^15, -4.503599627370496*^15}, {
        4.503599627370496*^15, -4.503599627370496*^15}}],
      Selectable->False]},
    Annotation[{{{{}, {}, 
        Annotation[{
          Directive[
           Opacity[1.], 
           AbsoluteThickness[2], 
           FaceForm[
            Opacity[0.3]], 
           RGBColor[0.24, 0.6, 0.8]], 
          Line[CompressedData["
1:eJw123c8lX/YB3CjIjKKqFS0aFFR2l0VDSMjouGXlRIySyUkJYWyR2Yiu8xs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           "]]}, "Charting`Private`Tag#1"]}}, {}}, <|
     "HighlightElements" -> <|
       "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>, 
      "LayoutOptions" -> <|
       "PanelPlotLayout" -> <||>, 
        "PlotRange" -> {{-1.9999997662703457`, 2.}, {-0.9999998592812047, 
         0.9999998782744886}}, "Frame" -> {{False, False}, {False, False}}, 
        "AxesOrigin" -> {0, 0}, "ImageSize" -> {360, 432}, 
        "Axes" -> {True, True}, "LabelStyle" -> {}, "AspectRatio" -> 
        Automatic, "DefaultStyle" -> {
          Directive[
           Opacity[1.], 
           AbsoluteThickness[2], 
           FaceForm[
            Opacity[0.3]], 
           RGBColor[0.24, 0.6, 0.8]]}, 
        "HighlightLabelingFunctions" -> <|
         "CoordinatesToolOptions" -> Identity, 
          "ScalingFunctions" -> {{Identity, Identity}, {
            Identity, Identity}}|>, "Primitives" -> {}, "GCFlag" -> False|>, 
      "Meta" -> <|
       "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, "Function" -> 
        ParametricPlot, "GroupHighlight" -> False|>|>, "DynamicHighlight"]]},
  AspectRatio->1,
  Axes->True,
  AxesLabel->{None, None},
  AxesOrigin->{0., 0.},
  DefaultBaseStyle->{"PlotGraphics", "Graphics"},
  DisplayFunction->Identity,
  Frame->False,
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  Method->{
   "DefaultBoundaryStyle" -> Automatic, 
    "DefaultGraphicsInteraction" -> {
     "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
      "Effects" -> {
       "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
        "Droplines" -> {
         "freeformCursorMode" -> True, 
          "placement" -> {"x" -> "All", "y" -> "None"}}}}, "GridLinesInFront" -> 
    True},
  PlotInteractivity:>True,
  PlotRange->{{-4, 4}, {-3, 3}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.02], 
     Scaled[0.02]}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{
  3.96763251036043*^9, 3.9676325459143877`*^9, 3.96763491862582*^9, 
   3.9676354825230103`*^9, {3.967635544899334*^9, 3.967635560615699*^9}, 
   3.967635602200694*^9},
 CellLabel->
  "Out[2121]=",ExpressionUUID->"f511fe2b-660e-4a20-b3da-acd6a66100a1"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TemplateBox[{"\"grid=\"", "False"},
    "RowDefault"], ",", 
   TemplateBox[{"\"estilos=\"", 
     RowBox[{"{", 
       RowBox[{
         RowBox[{"{", 
           RowBox[{"\"solid\"", ",", "\"green\""}], "}"}], ",", 
         RowBox[{"{", 
           RowBox[{"\"thick\"", ",", "\"red\""}], "}"}], ",", 
         RowBox[{"{", 
           RowBox[{"\"dotted\"", ",", "\"red\""}], "}"}], ",", 
         RowBox[{"{", 
           RowBox[{"\"solid\"", ",", "\"orange\""}], "}"}]}], "}"}]},
    "RowDefault"], ",", 
   TemplateBox[{"\"ejes=\"", "True"},
    "RowDefault"], ",", 
   TemplateBox[{"\"texto=\"", 
     RowBox[{"{", 
       RowBox[{
         RowBox[{"{", 
           RowBox[{"\"C\[IAcute]rculo\"", ",", 
             RowBox[{"{", 
               RowBox[{"2", ",", "2"}], "}"}], ",", 
             RowBox[{"{", 
               RowBox[{
                 RowBox[{"{", 
                   RowBox[{"\"color\"", ",", "\"orange\""}], "}"}], ",", 
                 RowBox[{"{", 
                   RowBox[{"\"size\"", ",", "\"\\\\large\""}], "}"}], ",", 
                 RowBox[{"{", 
                   RowBox[{"\"anchor\"", ",", "\"south\""}], "}"}], ",", 
                 RowBox[{"{", 
                   RowBox[{"\"rotate\"", ",", "215.25129869646517`"}], 
                   "}"}]}], "}"}]}], "}"}], ",", 
         RowBox[{"{", 
           RowBox[{"\"Par\[AAcute]bola\"", ",", 
             RowBox[{"{", 
               RowBox[{"0", ",", 
                 RowBox[{"-", "2"}]}], "}"}], ",", 
             RowBox[{"{", 
               RowBox[{
                 RowBox[{"{", 
                   RowBox[{"\"color\"", ",", "\"cyan\""}], "}"}], ",", 
                 RowBox[{"{", 
                   RowBox[{"\"size\"", ",", "\"\\\\footnotesize\""}], "}"}], 
                 ",", 
                 RowBox[{"{", 
                   RowBox[{"\"anchor\"", ",", "\"south east\""}], "}"}], ",", 
                 
                 RowBox[{"{", 
                   RowBox[{"\"rotate\"", ",", "350.89746557599517`"}], 
                   "}"}]}], "}"}]}], "}"}], ",", 
         RowBox[{"{", 
           RowBox[{"\"Seno\"", ",", 
             RowBox[{"{", 
               RowBox[{"0", ",", "1"}], "}"}], ",", 
             RowBox[{"{", 
               RowBox[{
                 RowBox[{"{", 
                   RowBox[{"\"color\"", ",", "\"black\""}], "}"}], ",", 
                 RowBox[{"{", 
                   RowBox[{"\"size\"", ",", "\"\\\\footnotesize\""}], "}"}], 
                 ",", 
                 RowBox[{"{", 
                   RowBox[{"\"anchor\"", ",", "\"south\""}], "}"}], ",", 
                 RowBox[{"{", 
                   RowBox[{"\"rotate\"", ",", "359.15207426889674`"}], 
                   "}"}]}], "}"}]}], "}"}], ",", 
         RowBox[{"{", 
           RowBox[{"\"Elipse\"", ",", 
             RowBox[{"{", 
               RowBox[{"1.5`", ",", "0"}], "}"}], ",", 
             RowBox[{"{", 
               RowBox[{
                 RowBox[{"{", 
                   RowBox[{"\"color\"", ",", "\"magenta\""}], "}"}], ",", 
                 RowBox[{"{", 
                   RowBox[{"\"size\"", ",", "\"\\\\huge\""}], "}"}], ",", 
                 RowBox[{"{", 
                   RowBox[{"\"anchor\"", ",", "\"east\""}], "}"}], ",", 
                 RowBox[{"{", 
                   RowBox[{"\"rotate\"", ",", "0.571589534541328`"}], "}"}]}],
                "}"}]}], "}"}]}], "}"}]},
    "RowDefault"], ",", 
   TemplateBox[{"\"muestras=\"", "100"},
    "RowDefault"], ",", 
   TemplateBox[{"\"tolerancia=\"", "0.1`"},
    "RowDefault"], ",", 
   TemplateBox[{"\"opacidad=\"", "0.3`"},
    "RowDefault"], ",", 
   TemplateBox[{"\"densidad=\"", "1"},
    "RowDefault"], ",", 
   TemplateBox[{"\"xmin=\"", 
     RowBox[{"-", "4"}]},
    "RowDefault"], ",", 
   TemplateBox[{"\"xmax=\"", "4"},
    "RowDefault"], ",", 
   TemplateBox[{"\"ymin=\"", 
     RowBox[{"-", "3"}]},
    "RowDefault"], ",", 
   TemplateBox[{"\"ymax=\"", "3"},
    "RowDefault"]}], "}"}]], "Output",
 CellChangeTimes->{
  3.96763251036043*^9, 3.9676325459143877`*^9, 3.96763491862582*^9, 
   3.9676354825230103`*^9, {3.967635544899334*^9, 3.967635560615699*^9}, 
   3.967635602215556*^9},
 CellLabel->
  "Out[2130]=",ExpressionUUID->"c5c2a561-2309-499f-9dc6-1db73dd3ba1c"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Usando editores ya detectados: \"\>", "\[InvisibleSpace]", "4",
    "\[InvisibleSpace]", "\<\" disponibles\"\>"}],
  SequenceForm["Usando editores ya detectados: ", 4, " disponibles"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.9676325106030083`*^9, 3.967632546156571*^9, 3.967634918870508*^9, 
   3.9676354827679377`*^9, {3.967635545114188*^9, 3.9676355608632317`*^9}, 
   3.967635602444909*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[2121]:=",ExpressionUUID->"d943dcac-b236-4a26-82ed-729f29791a82"],

Cell[BoxData["\<\"Buscando pdflatex...\"\>"], "Print",
 CellChangeTimes->{
  3.9676325106030083`*^9, 3.967632546156571*^9, 3.967634918870508*^9, 
   3.9676354827679377`*^9, {3.967635545114188*^9, 3.9676355608632317`*^9}, 
   3.9676356024456663`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[2121]:=",ExpressionUUID->"dd19c46f-bb19-4919-a52e-8b97af89f0e4"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"pdflatex encontrado: \"\>", 
   "\[InvisibleSpace]", "\<\"/Library/TeX/texbin/pdflatex\"\>"}],
  SequenceForm["pdflatex encontrado: ", "/Library/TeX/texbin/pdflatex"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.9676325106030083`*^9, 3.967632546156571*^9, 3.967634918870508*^9, 
   3.9676354827679377`*^9, {3.967635545114188*^9, 3.9676355608632317`*^9}, 
   3.9676356024463*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[2121]:=",ExpressionUUID->"944b320c-98de-4270-a03d-938b57445c9c"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Editor '\"\>", "\[InvisibleSpace]", "\<\"TeXstudio\"\>", 
   "\[InvisibleSpace]", "\<\"' encontrado (match exacto)\"\>"}],
  SequenceForm["Editor '", "TeXstudio", "' encontrado (match exacto)"],
  Editable->False]], "Print",
 CellChan